SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Sequence structure for "tb_categories_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_categories_fld_id_seq;
CREATE SEQUENCE tb_categories_fld_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_categories_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_categories_seq;
CREATE SEQUENCE tb_categories_seq START WITH 7 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_doc_comments_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_doc_comments_fld_id_seq;
CREATE SEQUENCE tb_doc_comments_fld_id_seq START WITH 1 INCREMENT BY 1;


-- ----------------------------
-- Sequence structure for "tb_doc_comments_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_doc_comments_seq;
CREATE SEQUENCE tb_doc_comments_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_doc_types_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_doc_types_fld_id_seq;
CREATE SEQUENCE tb_doc_types_fld_id_seq START WITH 1 INCREMENT BY 1;


-- ----------------------------
-- Sequence structure for "tb_doc_types_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_doc_types_seq;
CREATE SEQUENCE tb_doc_types_seq START WITH 11 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_doc_updates_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_doc_updates_fld_id_seq;
CREATE SEQUENCE tb_doc_updates_fld_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_doc_updates_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_doc_updates_seq;
CREATE SEQUENCE tb_doc_updates_seq START WITH 2 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_documents_active_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_documents_active_fld_id_seq;
CREATE SEQUENCE tb_documents_active_fld_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_documents_active_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_documents_active_seq;
CREATE SEQUENCE tb_documents_active_seq START WITH 41 INCREMENT BY 1;


-- ----------------------------
-- Sequence structure for "tb_documents_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_documents_fld_id_seq;
CREATE SEQUENCE tb_documents_fld_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_documents_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_documents_seq;
CREATE SEQUENCE tb_documents_seq START WITH 11 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_roles_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_roles_fld_id_seq;
CREATE SEQUENCE tb_roles_fld_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_roles_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_roles_seq;
CREATE SEQUENCE tb_roles_seq START WITH 6 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_status_fld_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_status_fld_id_seq;
CREATE SEQUENCE tb_status_fld_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "tb_status_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_status_seq;
CREATE SEQUENCE tb_status_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Table structure for `tb_authors`
-- ----------------------------
DROP TABLE IF EXISTS `tb_authors`;
CREATE TABLE `tb_authors` (
  `fld_username` varchar(50) NOT NULL,
  `fld_fullname` varchar(250) NOT NULL,
  `fld_password` varchar(100) NOT NULL,
  `fld_email` varchar(150) NOT NULL,
  `fld_role_id` int(11) NOT NULL,
  `fld_status_id` int(11) NOT NULL,
  `fld_active` text,
  `fld_activation_code` text,
  `fld_priv_admin` text,
	`fld_mfa` VARCHAR(255),
	`fld_picture` LONGBLOB,
  PRIMARY KEY (`fld_username`),
  KEY `fk_tb_authors_tb_roles_idx` (`fld_role_id`),
  KEY `fk_tb_authors_tb_status1_idx` (`fld_status_id`),
  CONSTRAINT `fk_tb_authors_tb_roles` FOREIGN KEY (`fld_role_id`) REFERENCES `tb_roles` (`fld_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tb_authors_tb_status1` FOREIGN KEY (`fld_status_id`) REFERENCES `tb_status` (`fld_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tb_authors
-- ----------------------------
INSERT INTO `tb_authors` VALUES ('admin', 'Administrator', 'admin', 'admin@scriptcase.net', '5', '1', '', '', '', '', '');
INSERT INTO `tb_authors` VALUES ('hellen', 'Hellen Moore', 'hellen', 'hellen@scriptcase.net', '2', '1', '', '', '', '', '');
INSERT INTO `tb_authors` VALUES ('matthew', 'Matthew Hendrix', 'matthew', 'matthew@scriptcase.net', '4', '1', '', '', '', '', '');
INSERT INTO `tb_authors` VALUES ('paul', 'Paul Simon', 'paul', 'paul@scriptcase.net', '2', '1', '', '', '', '', '');
INSERT INTO `tb_authors` VALUES ('stewart', 'Sid Stewart ', 'stewart', 'stewart@scriptcase.net', '4', '1', '', '', '', '', '');
INSERT INTO `tb_authors` VALUES ('viewer', 'Viewer User', 'viewer', '', '1', '1', '', '', '', '', '');

-- ----------------------------
-- Table structure for `tb_categories`
-- ----------------------------
DROP TABLE IF EXISTS `tb_categories`;
CREATE TABLE `tb_categories` (
  `fld_id` int(11) NOT NULL AUTO_INCREMENT,
  `fld_description` varchar(100) NOT NULL,
  PRIMARY KEY (`fld_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tb_categories
-- ----------------------------
INSERT INTO `tb_categories` VALUES ('1', 'Call Center');
INSERT INTO `tb_categories` VALUES ('2', 'Financial');
INSERT INTO `tb_categories` VALUES ('3', 'Marketing');
INSERT INTO `tb_categories` VALUES ('4', 'Presentations');
INSERT INTO `tb_categories` VALUES ('5', 'Website Design');
INSERT INTO `tb_categories` VALUES ('6', 'Website Technical');

-- ----------------------------
-- Table structure for `tb_documents`
-- ----------------------------
DROP TABLE IF EXISTS `tb_documents`;
CREATE TABLE `tb_documents` (
  `fld_id` int(11) NOT NULL AUTO_INCREMENT,
  `fld_title` varchar(150) NOT NULL,
  `fld_username` varchar(50) NOT NULL,
  `fld_date` datetime NOT NULL,
  `fld_doc_type_id` int(11) NOT NULL,
  `fld_keywords` varchar(250) DEFAULT NULL,
  `fld_category_id` int(11) NOT NULL,
  PRIMARY KEY (`fld_id`),
  KEY `fk_tb_documents_tb_doc_types1_idx` (`fld_doc_type_id`),
  KEY `fk_tb_documents_tb_categories1_idx` (`fld_category_id`),
  KEY `fk_tb_documents_tb_authors1_idx` (`fld_username`),
  CONSTRAINT `fk_tb_documents_tb_authors1` FOREIGN KEY (`fld_username`) REFERENCES `tb_authors` (`fld_username`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tb_documents_tb_categories1` FOREIGN KEY (`fld_category_id`) REFERENCES `tb_categories` (`fld_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tb_documents_tb_doc_types1` FOREIGN KEY (`fld_doc_type_id`) REFERENCES `tb_doc_types` (`fld_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tb_documents
-- ----------------------------
INSERT INTO `tb_documents` VALUES ('1', 'End Stats', 'admin', '2014-01-10 00:00:00', '8', 'call center volume users supported', '1');
INSERT INTO `tb_documents` VALUES ('2', 'Technical Requirements', 'admin', '2014-02-03 10:00:00', '5', 'website preview user cases timeline requirements', '6');
INSERT INTO `tb_documents` VALUES ('3', 'Concept 1', 'stewart', '2014-02-10 10:00:00', '1', 'concept website design graphics draft', '5');
INSERT INTO `tb_documents` VALUES ('4', 'Incentive Plan', 'hellen', '2014-02-10 10:00:00', '10', 'incentive plan customers switch marketing strategy phone vs online', '3');
INSERT INTO `tb_documents` VALUES ('5', 'Cost per User Analysis', 'paul', '2014-02-10 10:00:00', '3', 'customer cost online analysis', '2');
INSERT INTO `tb_documents` VALUES ('6', 'Concept 2', 'admin', '2014-02-24 16:41:36', '1', 'concept design website draft graphics', '5');
INSERT INTO `tb_documents` VALUES ('7', 'Costs before and after implementation', 'admin', '2014-03-11 10:51:07', '3', 'cost analysis budget financial data', '2');
INSERT INTO `tb_documents` VALUES ('8', 'Security Issues and Requirements', 'paul', '2014-02-17 10:53:10', '6', '', '6');
INSERT INTO `tb_documents` VALUES ('9', 'Final Proposal Slides', 'matthew', '2014-03-25 10:00:00', '2', 'final website version management presentation powerpoint', '4');
INSERT INTO `tb_documents` VALUES ('10', 'Website Launch Email', 'stewart', '2014-03-25 10:00:00', '4', 'email marketing new launch', '3');

-- ----------------------------
-- Table structure for `tb_documents_active`
-- ----------------------------
DROP TABLE IF EXISTS `tb_documents_active`;
CREATE TABLE `tb_documents_active` (
  `fld_id` int(11) NOT NULL AUTO_INCREMENT,
  `fld_document_id` int(11) NOT NULL,
  `fld_file` longblob,
  `fld_filename` varchar(150) NOT NULL,
  `fld_filesize` varchar(45) DEFAULT NULL,
  `fld_date` datetime NOT NULL,
  `fld_username` varchar(50) NOT NULL,
  PRIMARY KEY (`fld_id`),
  KEY `fk_tb_documents_history_tb_documents1_idx` (`fld_document_id`),
  KEY `fk_tb_documents_history_tb_authors1_idx` (`fld_username`),
  CONSTRAINT `fk_tb_documents_history_tb_authors10` FOREIGN KEY (`fld_username`) REFERENCES `tb_authors` (`fld_username`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tb_documents_history_tb_documents10` FOREIGN KEY (`fld_document_id`) REFERENCES `tb_documents` (`fld_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tb_documents_active
-- ----------------------------
INSERT INTO `tb_documents_active` VALUES ('2', '1', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF090006000000000000000000000001000000190000000000000000100000FEFFFFFF00000000FEFFFFFF0000000018000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0908100000060500AF18CD074940000006010000E1000200B004C10002000000E20000005C007000140000426F73746F6E2053797374656D732047726F7570202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002000E00190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C001E041C000500170000222422232C2323305F293B5C28222422232C2323305C291E04210006001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E04220007001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E0427000800220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E0437002A003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E0029002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F002C003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E0436002B003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140001002B00F5FF200000F80000000000000000C020E000140001002900F5FF200000F80000000000000000C020E000140001002C00F5FF200000F80000000000000000C020E000140001002A00F5FF200000F80000000000000000C020E000140001000900F5FF200000F80000000000000000C02093020400108003FF93020400118006FF93020400128004FF93020400138007FF93020400008000FF93020400148005FF60010200000085000E00B30500000000060053686565743185000E00EA0600000000060053686565743285000E00F1070000000006005368656574338C00040001000100C1010800C101000060690100FC001D0001000000010000001200004461746120776F756C642062652068657265FF000A0008008C0500000C0000000A0000000908100000061000AF18CD0749400000060100000B0214000000000000000000010000006F060000A90600000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000001D000F00031000040000000100100010000404EF0006000000370000000A0000000908100000061000AF18CD0749400000060100000B021000000000000000000000000000A20700000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000040404000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0749400000060100000B021000000000000000000000000000A90800000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000C00000000700000001000000400000000400000048000000080000006800000012000000880000000C000000A00000000D000000AC00000013000000B800000002000000E40400001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC10140000000808AC025B3BBC101030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000007000000496E74756974006803000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000B000000576F726B73686565747300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFFFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF020000002008020000000000C0000000000000460000000000000000000000000000000000000000FEFFFFFF000000000000000057006F0072006B0062006F006F006B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000080000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000, 'Call Center.xls', null, '2014-03-10 15:01:49', 'admin');
INSERT INTO `tb_documents_active` VALUES ('10', '10', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF000000000000100000000000040000160400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001600000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC000000000000009F030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000001E03000002000000200300000000000020030000000000002003000000000000200300000000000020030000000000002003000024000000550400002002000075060000B4000000440300001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA0000000000000044030000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA0000000000000059030000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA000000000000001E0300000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA000000000000001E030000000000002A010000F40100002A0100000000000000000000000000001E03000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001E03000000000000FA00000000000000EE0000000C0000000098DE8DB3BBC101BC0000001A000000D600000000000000100100000A0000001E0300000000000000000000000000001E030000000000006F030000300000009F030000000000001E0300000000000029070000000000001A0100001000000029070000000000001E030000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E7420776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000160400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000404000101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E00740000000000000000000000000000000000160000000500000C00000000FFFFFFFF0000000018000000980000000030000000000000008000000080000400001604000003000000000400001604000004000000000400001604000005000000000000001100000015000000180000000700040007000000000018000000040000000000150000001800000004000700FFFF06000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000300043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E0074002E0064006F006300FF40018000001500000015000000D09E64004800480015000000000000000800000000000000021000000000000000160000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D00200006801000000008DB262A68DB262A6000000000200000000000300000012000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000320073741E000000130000004D6963726F736F667420576F726420392E3000704000000000000000000000004000000000264C6AB3BBC1014000000000264C6AB3BBC101030000000100000003000000030000000300000012000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001600000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C0000000000000460000000000000000000000000098DE8DB3BBC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000098DE8DB3BBC1010098DE8DB3BBC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Content.doc', null, '2014-03-13 11:42:16', 'paul');
INSERT INTO `tb_documents_active` VALUES ('11', '3', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF000000000000100000000000040000160400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001600000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC000000000000009F030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000001E03000002000000200300000000000020030000000000002003000000000000200300000000000020030000000000002003000024000000550400002002000075060000B4000000440300001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA0000000000000044030000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA0000000000000059030000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA000000000000001E0300000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA000000000000001E030000000000002A010000F40100002A0100000000000000000000000000001E03000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001E03000000000000FA00000000000000EE0000000C0000000098DE8DB3BBC101BC0000001A000000D600000000000000100100000A0000001E0300000000000000000000000000001E030000000000006F030000300000009F030000000000001E0300000000000029070000000000001A0100001000000029070000000000001E030000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E7420776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000160400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000404000101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E00740000000000000000000000000000000000160000000500000C00000000FFFFFFFF0000000018000000980000000030000000000000008000000080000400001604000003000000000400001604000004000000000400001604000005000000000000001100000015000000180000000700040007000000000018000000040000000000150000001800000004000700FFFF06000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000300043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E0074002E0064006F006300FF40018000001500000015000000D09E64004800480015000000000000000800000000000000021000000000000000160000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D00200006801000000008DB262A68DB262A6000000000200000000000300000012000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000320073741E000000130000004D6963726F736F667420576F726420392E3000704000000000000000000000004000000000264C6AB3BBC1014000000000264C6AB3BBC101030000000100000003000000030000000300000012000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001600000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C0000000000000460000000000000000000000000098DE8DB3BBC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000098DE8DB3BBC1010098DE8DB3BBC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Content.doc', null, '2014-03-14 09:26:37', 'admin');
INSERT INTO `tb_documents_active` VALUES ('14', '1', 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administrator.png', null, '2014-03-14 16:35:14', 'paul');
INSERT INTO `tb_documents_active` VALUES ('16', '6', 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administrator.png', null, '2014-03-14 16:41:36', 'admin');
INSERT INTO `tb_documents_active` VALUES ('21', '4', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Incentive.doc', null, '2014-03-25 10:23:25', 'admin');
INSERT INTO `tb_documents_active` VALUES ('22', '1', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000000100000000000000001000001B00000001000000FEFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFF1E000000030000000400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000E0000000F000000100000001100000012000000130000001400000015000000160000001700000018000000190000001A000000FEFFFFFFFEFFFFFF1D000000FEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000500FFFFFFFFFFFFFFFF020000002008020000000000C000000000000046000000006548E56F6F3CCF0170CD608A6F3CCF011C000000C00200000000000057006F0072006B0062006F006F006B000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001200020104000000FFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000020000001C310000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000E000000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000040000000C010000000000000908100000060500AB1FCD07C900010006040000E1000200B004C10002000000E20000005C0070000500005669746F72202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002001000190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001E00680101003800BC020000000200020701430061006D00620072006900610031001E002C0101003800BC020000000200020701430061006C00690062007200690031001E00040101003800BC020000000200020701430061006C00690062007200690031001E00DC0001003800BC020000000200020701430061006C00690062007200690031001E00DC000000110090010000000200020701430061006C00690062007200690031001E00DC000000140090010000000200020701430061006C00690062007200690031001E00DC0000003C0090010000000200020701430061006C00690062007200690031001E00DC0000003E0090010000000200020701430061006C00690062007200690031001E00DC0001003F00BC020000000200020701430061006C00690062007200690031001E00DC0001003400BC020000000200020701430061006C00690062007200690031001E00DC000000340090010000000200020701430061006C00690062007200690031001E00DC0001000900BC020000000200020701430061006C00690062007200690031001E00DC0000000A0090010000000200020701430061006C00690062007200690031001A00C8000000FF7F9001000000000002050141007200690061006C0031001E00DC000200170090010000000200020701430061006C00690062007200690031001E00DC0001000800BC020000000200020701430061006C00690062007200690031001E00DC000000090090010000000200020701430061006C00690062007200690031001E00DC000000080090010000000200020701430061006C0069006200720069001E041E000500190000225224225C20232C2323303B5C2D225224225C20232C2323301E04230006001E0000225224225C20232C2323303B5B5265645D5C2D225224225C20232C2323301E04240007001F0000225224225C20232C2323302E30303B5C2D225224225C20232C2323302E30301E0429000800240000225224225C20232C2323302E30303B5B5265645D5C2D225224225C20232C2323302E30301E043E002A003900005F2D225224225C202A20232C2323305F2D3B5C2D225224225C202A20232C2323305F2D3B5F2D225224225C202A20222D225F2D3B5F2D405F2D1E042C0029002700005F2D2A20232C2323305F2D3B5C2D2A20232C2323305F2D3B5F2D2A20222D225F2D3B5F2D405F2D1E0446002C004100005F2D225224225C202A20232C2323302E30305F2D3B5C2D225224225C202A20232C2323302E30305F2D3B5F2D225224225C202A20222D223F3F5F2D3B5F2D405F2D1E0434002B002F00005F2D2A20232C2323302E30305F2D3B5C2D2A20232C2323302E30305F2D3B5F2D2A20222D223F3F5F2D3B5F2D405F2D1E041C00A400170000222422232C2323305F293B5C28222422232C2323305C291E042100A5001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E042200A6001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E042700A700220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E043700A8003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E00A9002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F00AA003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E043600AB003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140016000000F5FF200000B400000000000000049F20E000140016000000F5FF200000B40000000000000004AD20E000140016000000F5FF200000B40000000000000004AA20E000140016000000F5FF200000B40000000000000004AE20E000140016000000F5FF200000B400000000000000049B20E000140016000000F5FF200000B40000000000000004AF20E000140016000000F5FF200000B40000000000000004AC20E000140016000000F5FF200000B400000000000000049D20E000140016000000F5FF200000B400000000000000048B20E000140016000000F5FF200000B40000000000000004AE20E000140016000000F5FF200000B40000000000000004AC20E000140016000000F5FF200000B40000000000000004B320E000140015000000F5FF200000B400000000000000049E20E000140015000000F5FF200000B400000000000000049D20E000140015000000F5FF200000B400000000000000048B20E000140015000000F5FF200000B40000000000000004A420E000140015000000F5FF200000B40000000000000004B120E000140015000000F5FF200000B40000000000000004B420E000140009000000F5FF200000B40000000000000004AA20E00014000E000000F5FF200000941111970B970B00049620E000140010000000F5FF200000946666BF1FBF1F0004B720E00014000F000000F5FF200000D400600000001A0000C020E000140015000000F5FF200000B40000000000000004BE20E000140015000000F5FF200000B400000000000000048A20E000140015000000F5FF200000B40000000000000004B920E000140015000000F5FF200000B40000000000000004A420E000140015000000F5FF200000B40000000000000004B120E000140015000000F5FF200000B40000000000000004B520E00014000C000000F5FF200000941111970B970B0004AF20E00014000A000000F5FF200000B40000000000000004AD20E00014000100AA00F5FF200000F80000000000000000C020E00014000100A800F5FF200000F80000000000000000C020E00014000B000000F5FF200000B40000000000000004AB20E000140012000000F5FF2000009C1111160B160B00049A20E000140001000900F5FF200000F80000000000000000C020E00014000D000000F5FF200000941111BF1FBF1F00049620E00014000100AB00F5FF200000F80000000000000000C020E00014000100A900F5FF200000F80000000000000000C020E000140011000000F5FF200000F40000000000000000C020E000140013000000F5FF200000F40000000000000000C020E000140005000000F5FF200000F40000000000000000C020E000140006000000F5FF200000D400500000001F0000C020E000140007000000F5FF200000D400500000000B0000C020E000140008000000F5FF200000D400200000000F0000C020E000140008000000F5FF200000F40000000000000000C020E000140014000000F5FF200000D4006100003E1F0000C0207C0814007C080000000000000000000000003E005D372EC07D082D007D080000000000000000000000003800000002000D001400030000000300000030305C293B5F282A0E000500017D0841007D080000000000000000000000003900000003000D001400030000000300000030305C293B5F282A0E000500020800140003000000040000003B5F28405F292D3B7D0841007D080000000000000000000000003A00000003000D001400030000000300000030305C293B5F282A0E00050002080014000300FF3F040000003B5F28405F292D3B7D0841007D080000000000000000000000003B00000003000D001400030000000300000030305C293B5F282A0E000500020800140003003233040000003B5F28405F292D3B7D082D007D080000000000000000000000003C00000002000D001400030000000300000030305C293B5F282A0E000500027D0841007D080000000000000000000000002200000003000D00140002000000006100FF30305C293B5F282A0E000500020400140002000000C6EFCEFF3B5F28405F292D3B7D0841007D080000000000000000000000002D00000003000D001400020000009C0006FF30305C293B5F282A0E000500020400140002000000FFC7CEFF3B5F28405F292D3B7D0841007D080000000000000000000000003000000003000D001400020000009C6500FF30305C293B5F282A0E000500020400140002000000FFEB9CFF3B5F28405F292D3B7D0891007D080000000000000000000000002C00000007000D001400020000003F3F76FF30305C293B5F282A0E000500020400140002000000FFCC99FF3B5F28405F292D3B07001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0891007D080000000000000000000000003300000007000D001400020000003F3F3FFF30305C293B5F282A0E000500020400140002000000F2F2F2FF3B5F28405F292D3B07001400020000003F3F3FFF202020202020202008001400020000003F3F3FFF202020202020202009001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D0891007D080000000000000000000000002300000007000D00140002000000FA7D00FF30305C293B5F282A0E000500020400140002000000F2F2F2FF3B5F28405F292D3B07001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0841007D080000000000000000000000002500000003000D00140002000000FA7D00FF30305C293B5F282A0E000500020800140002000000FF8001FF3B5F28405F292D3B7D0891007D080000000000000000000000002400000007000D001400030000000000000030305C293B5F282A0E000500020400140002000000A5A5A5FF3B5F28405F292D3B07001400020000003F3F3FFF202020202020202008001400020000003F3F3FFF202020202020202009001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D082D007D080000000000000000000000003600000002000D00140002000000FF0000FF30305C293B5F282A0E000500027D0878007D080000000000000000000000003100000005000400140002000000FFFFCCFF30305C293B5F282A0700140002000000B2B2B2FF00A5A5A5FF3B5F280800140002000000B2B2B2FF003F3F3FFF2020200900140002000000B2B2B2FF003F3F3FFF2020200A00140002000000B2B2B2FF003F3F3FFF0000007D082D007D080000000000000000000000003700000002000D001400020000007F7F7FFF30305C293B5F282A0E000500027D0855007D080000000000000000000000003D00000004000D001400030000000100000030305C293B5F282A0E000500020700140003000000040000003B5F28080014000208001400030000000400000020202009001400027D0841007D080000000000000000000000002600000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000040000003B5F2808001400027D0841007D080000000000000000000000001000000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566040000003B5F2808001400027D0841007D080000000000000000000000001600000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C040000003B5F2808001400027D0841007D080000000000000000000000001C00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233040000003B5F2808001400027D0841007D080000000000000000000000002700000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000050000003B5F2808001400027D0841007D080000000000000000000000001100000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566050000003B5F2808001400027D0841007D080000000000000000000000001700000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C050000003B5F2808001400027D0841007D080000000000000000000000001D00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233050000003B5F2808001400027D0841007D080000000000000000000000002800000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000060000003B5F2808001400027D0841007D080000000000000000000000001200000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566060000003B5F2808001400027D0841007D080000000000000000000000001800000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C060000003B5F2808001400027D0841007D080000000000000000000000001E00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233060000003B5F2808001400027D0841007D080000000000000000000000002900000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000070000003B5F2808001400027D0841007D080000000000000000000000001300000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566070000003B5F2808001400027D0841007D080000000000000000000000001900000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C070000003B5F2808001400027D0841007D080000000000000000000000001F00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233070000003B5F2808001400027D0841007D080000000000000000000000002A00000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000080000003B5F2808001400027D0841007D080000000000000000000000001400000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566080000003B5F2808001400027D0841007D080000000000000000000000001A00000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C080000003B5F2808001400027D0841007D080000000000000000000000002000000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233080000003B5F2808001400027D0841007D080000000000000000000000002B00000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000090000003B5F2808001400027D0841007D080000000000000000000000001500000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566090000003B5F2808001400027D0841007D080000000000000000000000001B00000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C090000003B5F2808001400027D0841007D080000000000000000000000002100000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233090000003B5F2808001400029302120010000D0000323025202D20CA6E666173653192084D0092080000000000000000000001041EFF0D0032003000250020002D002000CA006E00660061007300650031000000030001000C0007046566DBE5F1FF05000C0007010000000000FF25000500029302120011000D0000323025202D20CA6E666173653292084D00920800000000000000000000010422FF0D0032003000250020002D002000CA006E00660061007300650032000000030001000C0007056566F2DDDCFF05000C0007010000000000FF25000500029302120012000D0000323025202D20CA6E666173653392084D00920800000000000000000000010426FF0D0032003000250020002D002000CA006E00660061007300650033000000030001000C0007066566EAF1DDFF05000C0007010000000000FF25000500029302120013000D0000323025202D20CA6E666173653492084D0092080000000000000000000001042AFF0D0032003000250020002D002000CA006E00660061007300650034000000030001000C0007076566E5E0ECFF05000C0007010000000000FF25000500029302120014000D0000323025202D20CA6E666173653592084D0092080000000000000000000001042EFF0D0032003000250020002D002000CA006E00660061007300650035000000030001000C0007086566DBEEF3FF05000C0007010000000000FF25000500029302120015000D0000323025202D20CA6E666173653692084D00920800000000000000000000010432FF0D0032003000250020002D002000CA006E00660061007300650036000000030001000C0007096566FDE9D9FF05000C0007010000000000FF25000500029302120016000D0000343025202D20CA6E666173653192084D0092080000000000000000000001041FFF0D0034003000250020002D002000CA006E00660061007300650031000000030001000C000704CC4CB8CCE4FF05000C0007010000000000FF25000500029302120017000D0000343025202D20CA6E666173653292084D00920800000000000000000000010423FF0D0034003000250020002D002000CA006E00660061007300650032000000030001000C000705CC4CE6B9B8FF05000C0007010000000000FF25000500029302120018000D0000343025202D20CA6E666173653392084D00920800000000000000000000010427FF0D0034003000250020002D002000CA006E00660061007300650033000000030001000C000706CC4CD7E4BCFF05000C0007010000000000FF25000500029302120019000D0000343025202D20CA6E666173653492084D0092080000000000000000000001042BFF0D0034003000250020002D002000CA006E00660061007300650034000000030001000C000707CC4CCCC0DAFF05000C0007010000000000FF2500050002930212001A000D0000343025202D20CA6E666173653592084D0092080000000000000000000001042FFF0D0034003000250020002D002000CA006E00660061007300650035000000030001000C000708CC4CB6DDE8FF05000C0007010000000000FF2500050002930212001B000D0000343025202D20CA6E666173653692084D00920800000000000000000000010433FF0D0034003000250020002D002000CA006E00660061007300650036000000030001000C000709CC4CFCD5B4FF05000C0007010000000000FF2500050002930212001C000D0000363025202D20CA6E666173653192084D00920800000000000000000000010420FF0D0036003000250020002D002000CA006E00660061007300650031000000030001000C000704323395B3D7FF05000C0007000000FFFFFFFF2500050002930212001D000D0000363025202D20CA6E666173653292084D00920800000000000000000000010424FF0D0036003000250020002D002000CA006E00660061007300650032000000030001000C0007053233D99795FF05000C0007000000FFFFFFFF2500050002930212001E000D0000363025202D20CA6E666173653392084D00920800000000000000000000010428FF0D0036003000250020002D002000CA006E00660061007300650033000000030001000C0007063233C2D69AFF05000C0007000000FFFFFFFF2500050002930212001F000D0000363025202D20CA6E666173653492084D0092080000000000000000000001042CFF0D0036003000250020002D002000CA006E00660061007300650034000000030001000C0007073233B2A1C7FF05000C0007000000FFFFFFFF25000500029302120020000D0000363025202D20CA6E666173653592084D00920800000000000000000000010430FF0D0036003000250020002D002000CA006E00660061007300650035000000030001000C000708323393CDDDFF05000C0007000000FFFFFFFF25000500029302120021000D0000363025202D20CA6E666173653692084D00920800000000000000000000010434FF0D0036003000250020002D002000CA006E00660061007300650036000000030001000C0007093233FAC090FF05000C0007000000FFFFFFFF2500050002930208002200030000426F6D9208390092080000000000000000000001011AFF030042006F006D000000030001000C0005FF0000C6EFCEFF05000C0005FF0000006100FF250005000293020C00230007000043E16C63756C6F92087900920800000000000000000000010216FF07004300E1006C00630075006C006F000000070001000C0005FF0000F2F2F2FF05000C0005FF0000FA7D00FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF010093021A00240015000043E96C756C61206465205665726966696361E7E36F92089500920800000000000000000000010217FF15004300E9006C0075006C006100200064006500200056006500720069006600690063006100E700E3006F000000070001000C0005FF0000A5A5A5FF05000C0007000000FFFFFFFF250005000206000E0005FF00003F3F3FFF060007000E0005FF00003F3F3FFF060008000E0005FF00003F3F3FFF060009000E0005FF00003F3F3FFF060093021500250010000043E96C756C612056696E63756C61646192085500920800000000000000000000010218FF10004300E9006C0075006C0061002000560069006E00630075006C006100640061000000030005000C0005FF0000FA7D00FF250005000207000E0005FF0000FF8001FF060093020C002600070000CA6E66617365319208410092080000000000000000000001041DFF0700CA006E00660061007300650031000000030001000C00070400004F81BDFF05000C0007000000FFFFFFFF250005000293020C002700070000CA6E666173653292084100920800000000000000000000010421FF0700CA006E00660061007300650032000000030001000C0007050000C0504DFF05000C0007000000FFFFFFFF250005000293020C002800070000CA6E666173653392084100920800000000000000000000010425FF0700CA006E00660061007300650033000000030001000C00070600009BBB59FF05000C0007000000FFFFFFFF250005000293020C002900070000CA6E666173653492084100920800000000000000000000010429FF0700CA006E00660061007300650034000000030001000C00070700008064A2FF05000C0007000000FFFFFFFF250005000293020C002A00070000CA6E66617365359208410092080000000000000000000001042DFF0700CA006E00660061007300650035000000030001000C00070800004BACC6FF05000C0007000000FFFFFFFF250005000293020C002B00070000CA6E666173653692084100920800000000000000000000010431FF0700CA006E00660061007300650036000000030001000C0007090000F79646FF05000C0007000000FFFFFFFF250005000293020C002C00070000456E747261646192087900920800000000000000000000010214FF070045006E00740072006100640061000000070001000C0005FF0000FFCC99FF05000C0005FF00003F3F76FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF010093020E002D00090000496E636F727265746F9208450092080000000000000000000001011BFF090049006E0063006F0072007200650074006F000000030001000C0005FF0000FFC7CEFF05000C0005FF00009C0006FF2500050002930204002E8004FF92082000920800000000000000000000010504FF05004D006F0065006400610000000000930204002F8007FF92082800920800000000000000000000010507FF09004D006F0065006400610020005B0030005D000000000093020B0030000600004E657574726192083F0092080000000000000000000001011CFF06004E00650075007400720061000000030001000C0005FF0000FFEB9CFF05000C0005FF00009C6500FF250005000293020400008000FF92082200920800000000000000000000010100FF06004E006F0072006D0061006C00000000009302090031000400004E6F74619208620092080000000000000000000001020AFF04004E006F00740061000000050001000C0005FF0000FFFFCCFF06000E0005FF0000B2B2B2FF010007000E0005FF0000B2B2B2FF010008000E0005FF0000B2B2B2FF010009000E0005FF0000B2B2B2FF010093020400328005FF92082C00920800000000000000000000010505FF0B0050006F007200630065006E0074006100670065006D000000000093020A0033000500005361ED646192087500920800000000000000000000010215FF050053006100ED00640061000000070001000C0005FF0000F2F2F2FF05000C0005FF00003F3F3FFF250005000206000E0005FF00003F3F3FFF010007000E0005FF00003F3F3FFF010008000E0005FF00003F3F3FFF010009000E0005FF00003F3F3FFF010093020400348003FF92084000920800000000000000000000010503FF150053006500700061007200610064006F00720020006400650020006D0069006C00680061007200650073000000000093020400358006FF92084800920800000000000000000000010506FF190053006500700061007200610064006F00720020006400650020006D0069006C006800610072006500730020005B0030005D00000000009302130036000E0000546578746F20646520417669736F9208430092080000000000000000000001020BFF0E0054006500780074006F00200064006500200041007600690073006F000000020005000C0005FF0000FF0000FF2500050002930216003700110000546578746F204578706C6963617469766F92084900920800000000000000000000010235FF110054006500780074006F0020004500780070006C006900630061007400690076006F000000020005000C0005FF00007F7F7FFF250005000293020B00380006000054ED74756C6F9208330092080000000000000000000001030FFF06005400ED00740075006C006F000000020005000C00070300001F497DFF250005000193020D00390008000054ED74756C6F203192084500920800000000000000000000010310FF08005400ED00740075006C006F00200031000000030005000C00070300001F497DFF250005000207000E00070400004F81BDFF050093020D003A0008000054ED74756C6F203292084500920800000000000000000000010311FF08005400ED00740075006C006F00200032000000030005000C00070300001F497DFF250005000207000E000704FF3FA8C0DEFF050093020D003B0008000054ED74756C6F203392084500920800000000000000000000010312FF08005400ED00740075006C006F00200033000000030005000C00070300001F497DFF250005000207000E000704323395B3D7FF020093020D003C0008000054ED74756C6F203492083700920800000000000000000000010313FF08005400ED00740075006C006F00200034000000020005000C00070300001F497DFF250005000293020A003D00050000546F74616C92084D00920800000000000000000000010319FF050054006F00740061006C000000040005000C0007010000000000FF250005000206000E00070400004F81BDFF010007000E00070400004F81BDFF06008E0858008E080000000000000000000090000000110011005400610062006C0065005300740079006C0065004D0065006400690075006D0039005000690076006F0074005300740079006C0065004C0069006700680074003100360060010200000085000E002C2C00000000060053686565743185000E00FC2D00000000060053686565743285000E008C2F0000000006005368656574339A0818009A0800000000000000000000010000000000000004000000A3081000A30800000000000000000000000000008C00040037003700C1010800C10100001DEB0100FC00210001000000010000001600005965617220656E6420737461747320686572652E2E2EFF000A000800AB2B00000C00000063081600630800000000000000000000160000000000000002009608100096080000000000000000000042E501009B0810009B0800000000000000000000010000008C0810008C0800000000000000000000000000000A0000000908100000061000AB1FCD07C9000100060400000B021400000000000000000001000000422D00008C2D00000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF00010001000100040042E50100000000000000E03F000000000000E03F2E009C0826009C080000000000000000000000000000000000000000000000000000040000000000000000005500020008007D000C000000000024170F000200000000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030200000000000100020002000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A0000000908100000061000AB1FCD07C9000100060400000B0210000000000000000000000000000E2F00000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF000100010001000400020001FF000000000000E03F000000000000E03F00009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A0000000908100000061000AB1FCD07C9000100060400000B0210000000000000000000000000009E3000000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF000100010001000400020001FF000000000000E03F000000000000E03F00009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000200000003000000FEFFFFFF05000000060000000700000008000000FEFFFFFF0A000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFF0000060102000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000B00000000700000001000000400000000400000048000000080000006800000012000000780000000C000000900000000D0000009C00000013000000A800000002000000E40400001E00000018000000426F73746F6E2053797374656D732047726F7570000000001E000000080000005669746F720000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC1014000000080C4EB896F3CCF0103000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF000006010200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000008000000496E7475697400000300000000000C000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000A000000506C616E696C68617300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100FEFF030A0000FFFFFFFF2008020000000000C00000000000004628000000506C616E696C686120646F204D6963726F736F6674204F666669636520457863656C203230303300060000004269666638000E000000457863656C2E53686565742E3800F439B2710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010043006F006D0070004F0062006A0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000200FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000900000074000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Call Center 2013 stats.xls', null, '2014-03-25 10:26:28', 'admin');
INSERT INTO `tb_documents_active` VALUES ('23', '3', 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oncept1.htm', null, '2014-03-25 10:36:24', 'admin');
INSERT INTO `tb_documents_active` VALUES ('24', '6', 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oncept2.htm', null, '2014-03-25 10:37:14', 'admin');
INSERT INTO `tb_documents_active` VALUES ('25', '6', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Content outline.doc', null, '2014-03-25 10:37:14', 'admin');
INSERT INTO `tb_documents_active` VALUES ('26', '10', 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arketingEmail.htm', null, '2014-03-25 10:41:12', 'admin');
INSERT INTO `tb_documents_active` VALUES ('27', '10', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000000100000000000000001000001B00000001000000FEFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFF1E000000030000000400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000E0000000F000000100000001100000012000000130000001400000015000000160000001700000018000000190000001A000000FEFFFFFFFEFFFFFF1D000000FEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000500FFFFFFFFFFFFFFFF020000002008020000000000C00000000000004600000000000000000000000070DDDE073048CF011C000000C00200000000000057006F0072006B0062006F006F006B000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001200020104000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000200000009310000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000E000000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000040000000C010000000000000908100000060500AB1FCD07C900010006040000E1000200B004C10002000000E20000005C0070000500005669746F72202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002001000190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001E00680101003800BC020000000200020701430061006D00620072006900610031001E002C0101003800BC020000000200020701430061006C00690062007200690031001E00040101003800BC020000000200020701430061006C00690062007200690031001E00DC0001003800BC020000000200020701430061006C00690062007200690031001E00DC000000110090010000000200020701430061006C00690062007200690031001E00DC000000140090010000000200020701430061006C00690062007200690031001E00DC0000003C0090010000000200020701430061006C00690062007200690031001E00DC0000003E0090010000000200020701430061006C00690062007200690031001E00DC0001003F00BC020000000200020701430061006C00690062007200690031001E00DC0001003400BC020000000200020701430061006C00690062007200690031001E00DC000000340090010000000200020701430061006C00690062007200690031001E00DC0001000900BC020000000200020701430061006C00690062007200690031001E00DC0000000A0090010000000200020701430061006C00690062007200690031001A00C8000000FF7F9001000000000002050141007200690061006C0031001E00DC000200170090010000000200020701430061006C00690062007200690031001E00DC0001000800BC020000000200020701430061006C00690062007200690031001E00DC000000090090010000000200020701430061006C00690062007200690031001E00DC000000080090010000000200020701430061006C0069006200720069001E041E000500190000225224225C20232C2323303B5C2D225224225C20232C2323301E04230006001E0000225224225C20232C2323303B5B5265645D5C2D225224225C20232C2323301E04240007001F0000225224225C20232C2323302E30303B5C2D225224225C20232C2323302E30301E0429000800240000225224225C20232C2323302E30303B5B5265645D5C2D225224225C20232C2323302E30301E043E002A003900005F2D225224225C202A20232C2323305F2D3B5C2D225224225C202A20232C2323305F2D3B5F2D225224225C202A20222D225F2D3B5F2D405F2D1E042C0029002700005F2D2A20232C2323305F2D3B5C2D2A20232C2323305F2D3B5F2D2A20222D225F2D3B5F2D405F2D1E0446002C004100005F2D225224225C202A20232C2323302E30305F2D3B5C2D225224225C202A20232C2323302E30305F2D3B5F2D225224225C202A20222D223F3F5F2D3B5F2D405F2D1E0434002B002F00005F2D2A20232C2323302E30305F2D3B5C2D2A20232C2323302E30305F2D3B5F2D2A20222D223F3F5F2D3B5F2D405F2D1E041C00A400170000222422232C2323305F293B5C28222422232C2323305C291E042100A5001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E042200A6001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E042700A700220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E043700A8003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E00A9002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F00AA003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E043600AB003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140016000000F5FF200000B400000000000000049F20E000140016000000F5FF200000B40000000000000004AD20E000140016000000F5FF200000B40000000000000004AA20E000140016000000F5FF200000B40000000000000004AE20E000140016000000F5FF200000B400000000000000049B20E000140016000000F5FF200000B40000000000000004AF20E000140016000000F5FF200000B40000000000000004AC20E000140016000000F5FF200000B400000000000000049D20E000140016000000F5FF200000B400000000000000048B20E000140016000000F5FF200000B40000000000000004AE20E000140016000000F5FF200000B40000000000000004AC20E000140016000000F5FF200000B40000000000000004B320E000140015000000F5FF200000B400000000000000049E20E000140015000000F5FF200000B400000000000000049D20E000140015000000F5FF200000B400000000000000048B20E000140015000000F5FF200000B40000000000000004A420E000140015000000F5FF200000B40000000000000004B120E000140015000000F5FF200000B40000000000000004B420E000140009000000F5FF200000B40000000000000004AA20E00014000E000000F5FF200000941111970B970B00049620E000140010000000F5FF200000946666BF1FBF1F0004B720E00014000F000000F5FF200000D400600000001A0000C020E000140015000000F5FF200000B40000000000000004BE20E000140015000000F5FF200000B400000000000000048A20E000140015000000F5FF200000B40000000000000004B920E000140015000000F5FF200000B40000000000000004A420E000140015000000F5FF200000B40000000000000004B120E000140015000000F5FF200000B40000000000000004B520E00014000C000000F5FF200000941111970B970B0004AF20E00014000A000000F5FF200000B40000000000000004AD20E00014000100AA00F5FF200000F80000000000000000C020E00014000100A800F5FF200000F80000000000000000C020E00014000B000000F5FF200000B40000000000000004AB20E000140012000000F5FF2000009C1111160B160B00049A20E000140001000900F5FF200000F80000000000000000C020E00014000D000000F5FF200000941111BF1FBF1F00049620E00014000100AB00F5FF200000F80000000000000000C020E00014000100A900F5FF200000F80000000000000000C020E000140011000000F5FF200000F40000000000000000C020E000140013000000F5FF200000F40000000000000000C020E000140005000000F5FF200000F40000000000000000C020E000140006000000F5FF200000D400500000001F0000C020E000140007000000F5FF200000D400500000000B0000C020E000140008000000F5FF200000D400200000000F0000C020E000140008000000F5FF200000F40000000000000000C020E000140014000000F5FF200000D4006100003E1F0000C0207C0814007C080000000000000000000000003E005D372EC07D082D007D080000000000000000000000003800000002000D001400030000000300000030305C293B5F282A0E000500017D0841007D080000000000000000000000003900000003000D001400030000000300000030305C293B5F282A0E000500020800140003000000040000003B5F28405F292D3B7D0841007D080000000000000000000000003A00000003000D001400030000000300000030305C293B5F282A0E00050002080014000300FF3F040000003B5F28405F292D3B7D0841007D080000000000000000000000003B00000003000D001400030000000300000030305C293B5F282A0E000500020800140003003233040000003B5F28405F292D3B7D082D007D080000000000000000000000003C00000002000D001400030000000300000030305C293B5F282A0E000500027D0841007D080000000000000000000000002200000003000D00140002000000006100FF30305C293B5F282A0E000500020400140002000000C6EFCEFF3B5F28405F292D3B7D0841007D080000000000000000000000002D00000003000D001400020000009C0006FF30305C293B5F282A0E000500020400140002000000FFC7CEFF3B5F28405F292D3B7D0841007D080000000000000000000000003000000003000D001400020000009C6500FF30305C293B5F282A0E000500020400140002000000FFEB9CFF3B5F28405F292D3B7D0891007D080000000000000000000000002C00000007000D001400020000003F3F76FF30305C293B5F282A0E000500020400140002000000FFCC99FF3B5F28405F292D3B07001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0891007D080000000000000000000000003300000007000D001400020000003F3F3FFF30305C293B5F282A0E000500020400140002000000F2F2F2FF3B5F28405F292D3B07001400020000003F3F3FFF202020202020202008001400020000003F3F3FFF202020202020202009001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D0891007D080000000000000000000000002300000007000D00140002000000FA7D00FF30305C293B5F282A0E000500020400140002000000F2F2F2FF3B5F28405F292D3B07001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0841007D080000000000000000000000002500000003000D00140002000000FA7D00FF30305C293B5F282A0E000500020800140002000000FF8001FF3B5F28405F292D3B7D0891007D080000000000000000000000002400000007000D001400030000000000000030305C293B5F282A0E000500020400140002000000A5A5A5FF3B5F28405F292D3B07001400020000003F3F3FFF202020202020202008001400020000003F3F3FFF202020202020202009001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D082D007D080000000000000000000000003600000002000D00140002000000FF0000FF30305C293B5F282A0E000500027D0878007D080000000000000000000000003100000005000400140002000000FFFFCCFF30305C293B5F282A0700140002000000B2B2B2FF00A5A5A5FF3B5F280800140002000000B2B2B2FF003F3F3FFF2020200900140002000000B2B2B2FF003F3F3FFF2020200A00140002000000B2B2B2FF003F3F3FFF0000007D082D007D080000000000000000000000003700000002000D001400020000007F7F7FFF30305C293B5F282A0E000500027D0855007D080000000000000000000000003D00000004000D001400030000000100000030305C293B5F282A0E000500020700140003000000040000003B5F28080014000208001400030000000400000020202009001400027D0841007D080000000000000000000000002600000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000040000003B5F2808001400027D0841007D080000000000000000000000001000000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566040000003B5F2808001400027D0841007D080000000000000000000000001600000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C040000003B5F2808001400027D0841007D080000000000000000000000001C00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233040000003B5F2808001400027D0841007D080000000000000000000000002700000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000050000003B5F2808001400027D0841007D080000000000000000000000001100000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566050000003B5F2808001400027D0841007D080000000000000000000000001700000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C050000003B5F2808001400027D0841007D080000000000000000000000001D00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233050000003B5F2808001400027D0841007D080000000000000000000000002800000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000060000003B5F2808001400027D0841007D080000000000000000000000001200000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566060000003B5F2808001400027D0841007D080000000000000000000000001800000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C060000003B5F2808001400027D0841007D080000000000000000000000001E00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233060000003B5F2808001400027D0841007D080000000000000000000000002900000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000070000003B5F2808001400027D0841007D080000000000000000000000001300000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566070000003B5F2808001400027D0841007D080000000000000000000000001900000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C070000003B5F2808001400027D0841007D080000000000000000000000001F00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233070000003B5F2808001400027D0841007D080000000000000000000000002A00000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000080000003B5F2808001400027D0841007D080000000000000000000000001400000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566080000003B5F2808001400027D0841007D080000000000000000000000001A00000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C080000003B5F2808001400027D0841007D080000000000000000000000002000000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233080000003B5F2808001400027D0841007D080000000000000000000000002B00000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000090000003B5F2808001400027D0841007D080000000000000000000000001500000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566090000003B5F2808001400027D0841007D080000000000000000000000001B00000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C090000003B5F2808001400027D0841007D080000000000000000000000002100000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233090000003B5F2808001400029302120010000D0000323025202D20CA6E666173653192084D0092080000000000000000000001041EFF0D0032003000250020002D002000CA006E00660061007300650031000000030001000C0007046566DBE5F1FF05000C0007010000000000FF25000500029302120011000D0000323025202D20CA6E666173653292084D00920800000000000000000000010422FF0D0032003000250020002D002000CA006E00660061007300650032000000030001000C0007056566F2DDDCFF05000C0007010000000000FF25000500029302120012000D0000323025202D20CA6E666173653392084D00920800000000000000000000010426FF0D0032003000250020002D002000CA006E00660061007300650033000000030001000C0007066566EAF1DDFF05000C0007010000000000FF25000500029302120013000D0000323025202D20CA6E666173653492084D0092080000000000000000000001042AFF0D0032003000250020002D002000CA006E00660061007300650034000000030001000C0007076566E5E0ECFF05000C0007010000000000FF25000500029302120014000D0000323025202D20CA6E666173653592084D0092080000000000000000000001042EFF0D0032003000250020002D002000CA006E00660061007300650035000000030001000C0007086566DBEEF3FF05000C0007010000000000FF25000500029302120015000D0000323025202D20CA6E666173653692084D00920800000000000000000000010432FF0D0032003000250020002D002000CA006E00660061007300650036000000030001000C0007096566FDE9D9FF05000C0007010000000000FF25000500029302120016000D0000343025202D20CA6E666173653192084D0092080000000000000000000001041FFF0D0034003000250020002D002000CA006E00660061007300650031000000030001000C000704CC4CB8CCE4FF05000C0007010000000000FF25000500029302120017000D0000343025202D20CA6E666173653292084D00920800000000000000000000010423FF0D0034003000250020002D002000CA006E00660061007300650032000000030001000C000705CC4CE6B9B8FF05000C0007010000000000FF25000500029302120018000D0000343025202D20CA6E666173653392084D00920800000000000000000000010427FF0D0034003000250020002D002000CA006E00660061007300650033000000030001000C000706CC4CD7E4BCFF05000C0007010000000000FF25000500029302120019000D0000343025202D20CA6E666173653492084D0092080000000000000000000001042BFF0D0034003000250020002D002000CA006E00660061007300650034000000030001000C000707CC4CCCC0DAFF05000C0007010000000000FF2500050002930212001A000D0000343025202D20CA6E666173653592084D0092080000000000000000000001042FFF0D0034003000250020002D002000CA006E00660061007300650035000000030001000C000708CC4CB6DDE8FF05000C0007010000000000FF2500050002930212001B000D0000343025202D20CA6E666173653692084D00920800000000000000000000010433FF0D0034003000250020002D002000CA006E00660061007300650036000000030001000C000709CC4CFCD5B4FF05000C0007010000000000FF2500050002930212001C000D0000363025202D20CA6E666173653192084D00920800000000000000000000010420FF0D0036003000250020002D002000CA006E00660061007300650031000000030001000C000704323395B3D7FF05000C0007000000FFFFFFFF2500050002930212001D000D0000363025202D20CA6E666173653292084D00920800000000000000000000010424FF0D0036003000250020002D002000CA006E00660061007300650032000000030001000C0007053233D99795FF05000C0007000000FFFFFFFF2500050002930212001E000D0000363025202D20CA6E666173653392084D00920800000000000000000000010428FF0D0036003000250020002D002000CA006E00660061007300650033000000030001000C0007063233C2D69AFF05000C0007000000FFFFFFFF2500050002930212001F000D0000363025202D20CA6E666173653492084D0092080000000000000000000001042CFF0D0036003000250020002D002000CA006E00660061007300650034000000030001000C0007073233B2A1C7FF05000C0007000000FFFFFFFF25000500029302120020000D0000363025202D20CA6E666173653592084D00920800000000000000000000010430FF0D0036003000250020002D002000CA006E00660061007300650035000000030001000C000708323393CDDDFF05000C0007000000FFFFFFFF25000500029302120021000D0000363025202D20CA6E666173653692084D00920800000000000000000000010434FF0D0036003000250020002D002000CA006E00660061007300650036000000030001000C0007093233FAC090FF05000C0007000000FFFFFFFF2500050002930208002200030000426F6D9208390092080000000000000000000001011AFF030042006F006D000000030001000C0005FF0000C6EFCEFF05000C0005FF0000006100FF250005000293020C00230007000043E16C63756C6F92087900920800000000000000000000010216FF07004300E1006C00630075006C006F000000070001000C0005FF0000F2F2F2FF05000C0005FF0000FA7D00FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF010093021A00240015000043E96C756C61206465205665726966696361E7E36F92089500920800000000000000000000010217FF15004300E9006C0075006C006100200064006500200056006500720069006600690063006100E700E3006F000000070001000C0005FF0000A5A5A5FF05000C0007000000FFFFFFFF250005000206000E0005FF00003F3F3FFF060007000E0005FF00003F3F3FFF060008000E0005FF00003F3F3FFF060009000E0005FF00003F3F3FFF060093021500250010000043E96C756C612056696E63756C61646192085500920800000000000000000000010218FF10004300E9006C0075006C0061002000560069006E00630075006C006100640061000000030005000C0005FF0000FA7D00FF250005000207000E0005FF0000FF8001FF060093020C002600070000CA6E66617365319208410092080000000000000000000001041DFF0700CA006E00660061007300650031000000030001000C00070400004F81BDFF05000C0007000000FFFFFFFF250005000293020C002700070000CA6E666173653292084100920800000000000000000000010421FF0700CA006E00660061007300650032000000030001000C0007050000C0504DFF05000C0007000000FFFFFFFF250005000293020C002800070000CA6E666173653392084100920800000000000000000000010425FF0700CA006E00660061007300650033000000030001000C00070600009BBB59FF05000C0007000000FFFFFFFF250005000293020C002900070000CA6E666173653492084100920800000000000000000000010429FF0700CA006E00660061007300650034000000030001000C00070700008064A2FF05000C0007000000FFFFFFFF250005000293020C002A00070000CA6E66617365359208410092080000000000000000000001042DFF0700CA006E00660061007300650035000000030001000C00070800004BACC6FF05000C0007000000FFFFFFFF250005000293020C002B00070000CA6E666173653692084100920800000000000000000000010431FF0700CA006E00660061007300650036000000030001000C0007090000F79646FF05000C0007000000FFFFFFFF250005000293020C002C00070000456E747261646192087900920800000000000000000000010214FF070045006E00740072006100640061000000070001000C0005FF0000FFCC99FF05000C0005FF00003F3F76FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF010093020E002D00090000496E636F727265746F9208450092080000000000000000000001011BFF090049006E0063006F0072007200650074006F000000030001000C0005FF0000FFC7CEFF05000C0005FF00009C0006FF2500050002930204002E8004FF92082000920800000000000000000000010504FF05004D006F0065006400610000000000930204002F8007FF92082800920800000000000000000000010507FF09004D006F0065006400610020005B0030005D000000000093020B0030000600004E657574726192083F0092080000000000000000000001011CFF06004E00650075007400720061000000030001000C0005FF0000FFEB9CFF05000C0005FF00009C6500FF250005000293020400008000FF92082200920800000000000000000000010100FF06004E006F0072006D0061006C00000000009302090031000400004E6F74619208620092080000000000000000000001020AFF04004E006F00740061000000050001000C0005FF0000FFFFCCFF06000E0005FF0000B2B2B2FF010007000E0005FF0000B2B2B2FF010008000E0005FF0000B2B2B2FF010009000E0005FF0000B2B2B2FF010093020400328005FF92082C00920800000000000000000000010505FF0B0050006F007200630065006E0074006100670065006D000000000093020A0033000500005361ED646192087500920800000000000000000000010215FF050053006100ED00640061000000070001000C0005FF0000F2F2F2FF05000C0005FF00003F3F3FFF250005000206000E0005FF00003F3F3FFF010007000E0005FF00003F3F3FFF010008000E0005FF00003F3F3FFF010009000E0005FF00003F3F3FFF010093020400348003FF92084000920800000000000000000000010503FF150053006500700061007200610064006F00720020006400650020006D0069006C00680061007200650073000000000093020400358006FF92084800920800000000000000000000010506FF190053006500700061007200610064006F00720020006400650020006D0069006C006800610072006500730020005B0030005D00000000009302130036000E0000546578746F20646520417669736F9208430092080000000000000000000001020BFF0E0054006500780074006F00200064006500200041007600690073006F000000020005000C0005FF0000FF0000FF2500050002930216003700110000546578746F204578706C6963617469766F92084900920800000000000000000000010235FF110054006500780074006F0020004500780070006C006900630061007400690076006F000000020005000C0005FF00007F7F7FFF250005000293020B00380006000054ED74756C6F9208330092080000000000000000000001030FFF06005400ED00740075006C006F000000020005000C00070300001F497DFF250005000193020D00390008000054ED74756C6F203192084500920800000000000000000000010310FF08005400ED00740075006C006F00200031000000030005000C00070300001F497DFF250005000207000E00070400004F81BDFF050093020D003A0008000054ED74756C6F203292084500920800000000000000000000010311FF08005400ED00740075006C006F00200032000000030005000C00070300001F497DFF250005000207000E000704FF3FA8C0DEFF050093020D003B0008000054ED74756C6F203392084500920800000000000000000000010312FF08005400ED00740075006C006F00200033000000030005000C00070300001F497DFF250005000207000E000704323395B3D7FF020093020D003C0008000054ED74756C6F203492083700920800000000000000000000010313FF08005400ED00740075006C006F00200034000000020005000C00070300001F497DFF250005000293020A003D00050000546F74616C92084D00920800000000000000000000010319FF050054006F00740061006C000000040005000C0007010000000000FF250005000206000E00070400004F81BDFF010007000E00070400004F81BDFF06008E0858008E080000000000000000000090000000110011005400610062006C0065005300740079006C0065004D0065006400690075006D0039005000690076006F0074005300740079006C0065004C0069006700680074003100360060010200000085000E00292C00000000060053686565743185000E00E92D00000000060053686565743285000E00792F0000000006005368656574339A0818009A0800000000000000000000010000000000000004000000A3081000A30800000000000000000000000000008C00040037003700C1010800C10100001DEB0100FC001E000100000001000000130000437573746F6D657273204C6973742068657265FF000A000800AB2B00000C00000063081600630800000000000000000000160000000000000002009608100096080000000000000000000042E501009B0810009B0800000000000000000000010000008C0810008C0800000000000000000000000000000A0000000908100000061000AB1FCD07C9000100060400000B0214000000000000000000010000003F2D0000792D00000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF00010001000100040042E50100000000000000E03F000000000000E03F74009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030100000000000100010001000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A0000000908100000061000AB1FCD07C9000100060400000B021000000000000000000000000000FB2E00000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF000100010001000400020001FF000000000000E03F000000000000E03F00009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A0000000908100000061000AB1FCD07C9000100060400000B0210000000000000000000000000008B3000000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF000100010001000400020001FF000000000000E03F000000000000E03F00009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000200000003000000FEFFFFFF05000000060000000700000008000000FEFFFFFF0A000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFF0000060102000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000B00000000700000001000000400000000400000048000000080000006800000012000000780000000C000000900000000D0000009C00000013000000A800000002000000E40400001E00000018000000426F73746F6E2053797374656D732047726F7570000000001E000000080000005669746F720000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC1014000000000FF96073048CF0103000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF000006010200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000008000000496E7475697400000300000000000C000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000A000000506C616E696C68617300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100FEFF030A0000FFFFFFFF2008020000000000C00000000000004628000000506C616E696C686120646F204D6963726F736F6674204F666669636520457863656C203230303300060000004269666638000E000000457863656C2E53686565742E3800F439B2710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010043006F006D0070004F0062006A0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000200FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000900000074000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Customers_List.xls', null, '2014-03-25 10:42:24', 'admin');
INSERT INTO `tb_documents_active` VALUES ('28', '5', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF090006000000000000000000000001000000190000000000000000100000FEFFFFFF00000000FEFFFFFF0000000018000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0908100000060500AF18CD074140000006010000E1000200B004C10002000000E20000005C0070000500005669746F726E2053797374656D732047726F7570202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002000E00190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C001E041C000500170000222422232C2323305F293B5C28222422232C2323305C291E04210006001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E04220007001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E0427000800220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E0437002A003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E0029002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F002C003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E0436002B003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140001002B00F5FF200000F80000000000000000C020E000140001002900F5FF200000F80000000000000000C020E000140001002C00F5FF200000F80000000000000000C020E000140001002A00F5FF200000F80000000000000000C020E000140001000900F5FF200000F80000000000000000C02093020400108003FF93020400118006FF93020400128004FF93020400138007FF93020400008000FF93020400148005FF60010200000085000E00BC0500000000060053686565743185000E00F30600000000060053686565743285000E00FA070000000006005368656574338C00040001000100C1010800C101000060690100FC00260001000000010000001B0000436F737420416E616C7973697320776F756C6420676F2068657265FF000A0008008C0500000C0000000A0000000908100000061000AF18CD0741400000060100000B02140000000000000000000100000078060000B20600000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0741400000060100000B021000000000000000000000000000AB0700000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0741400000060100000B021000000000000000000000000000B20800000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000C00000000700000001000000400000000400000048000000080000006800000012000000880000000C000000A00000000D000000AC00000013000000B800000002000000E40400001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC10140000000000040E53EBAC101030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000007000000496E74756974006803000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000B000000576F726B73686565747300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFFFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF020000002008020000000000C000000000000046000000000000000000000000F02EDAEF2F48CF01FEFFFFFF000000000000000057006F0072006B0062006F006F006B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000080000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000, 'Customer.xls', null, '2014-03-25 10:47:30', 'admin');
INSERT INTO `tb_documents_active` VALUES ('29', '5', 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, 'Customer_costs_presentation.ppt', null, '2014-03-25 10:47:30', 'admin');
INSERT INTO `tb_documents_active` VALUES ('30', '5', 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costs_chart.png', null, '2014-03-25 10:47:30', 'admin');
INSERT INTO `tb_documents_active` VALUES ('31', '7', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF090006000000000000000000000001000000190000000000000000100000FEFFFFFF00000000FEFFFFFF0000000018000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0908100000060500AF18CD074140000006010000E1000200B004C10002000000E20000005C007000140000426F73746F6E2053797374656D732047726F7570202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002000E00190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C001E041C000500170000222422232C2323305F293B5C28222422232C2323305C291E04210006001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E04220007001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E0427000800220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E0437002A003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E0029002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F002C003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E0436002B003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140001002B00F5FF200000F80000000000000000C020E000140001002900F5FF200000F80000000000000000C020E000140001002C00F5FF200000F80000000000000000C020E000140001002A00F5FF200000F80000000000000000C020E000140001000900F5FF200000F80000000000000000C02093020400108003FF93020400118006FF93020400128004FF93020400138007FF93020400008000FF93020400148005FF60010200000085000E00BC0500000000060053686565743185000E00F30600000000060053686565743285000E00FA070000000006005368656574338C00040001000100C1010800C101000060690100FC00260001000000010000001B0000436F737420416E616C7973697320776F756C6420676F2068657265FF000A0008008C0500000C0000000A0000000908100000061000AF18CD0741400000060100000B02140000000000000000000100000078060000B20600000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0741400000060100000B021000000000000000000000000000AB0700000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0741400000060100000B021000000000000000000000000000B20800000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000C00000000700000001000000400000000400000048000000080000006800000012000000880000000C000000A00000000D000000AC00000013000000B800000002000000E40400001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC10140000000000040E53EBAC101030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000007000000496E74756974006803000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000B000000576F726B73686565747300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFFFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF020000002008020000000000C0000000000000460000000000000000000000000000000000000000FEFFFFFF000000000000000057006F0072006B0062006F006F006B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000080000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000, 'Website Implementation Cost Analysis.xls', null, '2014-03-25 10:51:07', 'admin');
INSERT INTO `tb_documents_active` VALUES ('32', '7', 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comparative_chart.png', null, '2014-03-25 10:51:07', 'admin');
INSERT INTO `tb_documents_active` VALUES ('33', '8', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Security.doc', null, '2014-03-25 10:53:10', 'admin');
INSERT INTO `tb_documents_active` VALUES ('34', '8', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Status Report.doc', null, '2014-03-25 10:53:10', 'admin');
INSERT INTO `tb_documents_active` VALUES ('35', '2', 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oncept3.htm', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO `tb_documents_active` VALUES ('36', '2', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Timeline.doc', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO `tb_documents_active` VALUES ('37', '2', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'user_cases.doc', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO `tb_documents_active` VALUES ('38', '2', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000000100000000000000001000000200000001000000FEFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFF0E000000FEFFFFFF0400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000F000000FEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000500FFFFFFFFFFFFFFFF01000000108D81649B4FCF1186EA00AA00B929E80000000000000000000000006037E02327BBC10103000000401600000000000050006F0077006500720050006F0069006E007400200044006F00630075006D0065006E0074000000000000000000000000000000000000000000000000000000280002010200000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000007A0E0000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E0000000000000000000000000000000000000000000000000000002800020104000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000003A0000000C05000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000004F000000F0010000000000000100000002000000030000000400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000E0000000F000000100000001100000012000000130000001400000015000000160000001700000018000000190000001A0000001B0000001C0000001D0000001E0000001F000000200000002100000022000000230000002400000025000000260000002700000028000000290000002A0000002B0000002C0000002D0000002E0000002F00000030000000310000003200000033000000340000003500000036000000370000003800000039000000FEFFFFFF3B0000003C0000003D0000003E0000003F000000400000004100000042000000430000004400000045000000460000004700000048000000490000004A0000004B0000004C0000004D0000004E000000FEFFFFFF50000000510000005200000053000000540000005500000056000000FEFFFFFF58000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0F00E803A60300000100E9032800000080160000E0100000E010000080160000050000000A000000000000000000000001000000000000010F00F203160100002F00C80F0C0000003000D20F04000000010000000F00D5074C0000000000B70F44000000540069006D006500730020004E0065007700200052006F006D0061006E000000CC36B80014D96200FCD8620076C70B30080000000000000014D9620028DD0D30000004000000A40F0A000000800060000000FFFFFFFF0000A50F0C000000000000082E000000070000000000A90F0A000000070000000200090400004000A30F6E0000000500FFFD3F0000002220000064000000000000006400000000000000000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF18000000000100000005000020012001000000000005000040024002000000000005000060036003000000000005000080048004000000000F000B04740000000F0000F06C000000000006F020000000020C00000300000009000000020000000100000007000000020000000400000063000BF024000000810104000008830100000008BF0110001000C00101000008FF010800080001020200000840001EF110000000040000080100000802000008F70000101F00F00F1C0000000000F3031400000002000000000000000000000000000080000000000F00D007370100001F0014041C0000000000150414000000BA1D75EC00CA9A3B324ECDC900CA9A3B010100010F00FA03670000000000FE03030000000001000000FD03340000004100000064000000410000006400000076C70B30080000000000000008D96200000000000000000094FFFFFF34FFFFFF010000007000FB030800000000000000700800007000FB030800000001000000400B00001F0007043C0000000000FD03340000002100000064000000210000006400000060F30D30C4DC620000000000B837B80000000000000000000000000000000000000162001F0013043C0000000000FD03340000006400000064000000640000006400000060F30D30C4DC620000000000B837B80000000000000000000000000000000000000162001F00FF0314000000020000040C0000000000000000000000020000000F00F00F690000000000F30314000000030000000000000002000000000100000000000000009F0F04000000060000000000A80F1B000000436F72706F726174652070726573656E746174696F6E206865726510009F0F04000000050000000000AA0F0A000000010000000100000000000000EA03000000000F00F8039C0800000200EF03180000000100000001020709080000000000000000000000000000006000F007200000000000FF00FFFFFF0000000000FFFF0000FF99000000FFFF00FF000000969696006000F00720000000FFFFFF0000000000808080000000000000CC99003333CC00CCCCFF00B2B2B2006000F00720000000FFFFFF00000000003333330000000000DDDDDD00808080004D4D4D00EAEAEA006000F00720000000FFFFCC0000000000666633008080000033993300800000000033CC00FFCC66006000F00720000000FFFFFF00000000008080800000000000FFCC66000000FF00CC00CC00C0C0C0006000F00720000000FFFFFF00000000008080800000000000C0C0C0000066FF00FF000000009900006000F00720000000FFFFFF000000000080808000000000003399FF0099FFCC00CC00CC00B2B2B2000000A30F3E0000000100FFFD3F0000002220000064000000000001006400000000000000000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF2C000000000300001000A30F7C0000000500FFFD3F000100222000006400000000000000640014000000D800000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF2000000000010000800500001320D4012001000002001C00800500002220D0024002000002001800800500001320F003600300000200140080050000BB0010058004000000002000A30F6E0000000500FFFD3F00000022200000640000000000000064001E0000000000000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF0C000000000100000005000020012001000000000005000040024002000000000005000060036003000000000005000080048004000000005000A30F52000000050000000109000000000100000000000000010001090000000001002001000000000200010900000000010040020000000003000109000000000100600300000000040001090000000001008004000000006000A30F0C0000000100000000000000000000007000A30F3E0000000500000000000000000002001C000100000000000000020018000200000000000000020014000300000000000000020012000400000000000000020012008000A30F3E00000005000000000000000000020018000100000000000000020014000200000000000000020012000300000000000000020010000400000000000000020010000F000C04D60400000F0002F0CE040000100008F00800000006000000060400000F0003F0660400000F0004F028000000010009F0100000000000000000000000000000000000000002000AF00800000000040000050000000F0004F0D200000012000AF00800000002040000000A000093000BF0360000007F00010005008000D069B800870001000000810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F0080000008001B001D01450040F0011F0100000000000C30B08000000000000000100B8000F000DF05400000000009F0F04000000000000000000A80F20000000436C69636B20746F2065646974204D6173746572207469746C65207374796C650000A20F060000002100000000000000AA0F0A000000210000000100000000000F0004F01601000012000AF00800000003040000000A000083000BF0300000007F00010005008000806CB800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000E004B001D014000F0F0011F0100000000000C30B08000000010000000200B8000F000DF09E00000000009F0F04000000010000000000A80F52000000436C69636B20746F2065646974204D61737465722074657874207374796C65730D5365636F6E64206C6576656C0D5468697264206C6576656C0D466F75727468206C6576656C0D4669667468206C6576656C0000A20F1E0000002100000000000D00000001000C00000002000D00000003000C00000004000000AA0F0A000000530000000100000000000F0004F0B600000012000AF00800000004040000000A000083000BF0300000007F000100050080000C71B800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000600FB001600680100F0011F0100000000000C30B08000000020000000701B8000F000DF03E00000000009F0F04000000040000000000A00F020000002A000000A10F140000000200000000000000000002000000000002000E000000F80F04000000000000000F0004F0B800000012000AF00800000005040000000A000083000BF0300000007F00010005008000E072B800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000600FB007D00E80100F0011F0100000000000C30B08000000030000000902B8000F000DF04000000000009F0F04000000040000000000A00F020000002A000000A10F1600000002000000000000080000010002000000000002000E000000FA0F04000000000000000F0004F0B800000012000AF00800000006040000000A000083000BF0300000007F000100050080005C7BB800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000600F2010D01480100F0011F0100000000000C30B08000000040000000802B8000F000DF04000000000009F0F04000000040000000000A00F020000002A000000A10F1600000002000000000000080000020002000000000002000E000000D80F04000000000000000F0004F04800000012000AF00800000001040000000C000083000BF03000000081010000000883010500000893018E9F8B009401DEBD6800BF0112001200FF01000008000403090000003F03010001001000F00720000000FFFFFF0000000000808080000000000000CC99003333CC00CCCCFF00B2B2B2002000BA0F1C000000440065006600610075006C0074002000440065007300690067006E000F00EE03E40100000200EF0318000000000000000F100000000000000000008000000000070000000F000C04940100000F0002F08C010000200008F00800000003000000030800000F0003F0240100000F0004F028000000010009F0100000000000000000000000000000000000000002000AF00800000000080000050000000F0004F07200000012000AF008000000020800002002000053000BF01E0000007F000000040080004CAEB800BF0100000100FF0100000100010302040000000010F008000000A005B001D01470080F0011F0100000000000C30B08000000000000000F00B8000F000DF00C00000000009E0F04000000000000000F0004F07200000012000AF008000000030800002002000053000BF01E0000007F00000004008000F4AEB800BF0101000100FF0101000100010303040000000010F008000000900960032013E00D0F0011F0100000000000C30B08000000010000001000B8000F000DF00C00000000009E0F04000000010000000F0004F04800000012000AF00800000001080000000C000083000BF03000000081010000000883010500000893018E9F8B009401DEBD6800BF0112001200FF01000008000403090000003F03010001001000F00720000000FFFFFF0000000000808080000000000000CC99003333CC00CCCCFF00B2B2B20000007217100000000100300000000000AE030000520C00000000F50F1C000000000100009C0A0003000000003E0E000001000000030000000100F7BF000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000DC0400000B00000001000000600000000200000068000000040000008C00000008000000AC00000009000000CC00000012000000D80000000A000000F80000000C000000040100000D000000100100000F0000001C010000110000002401000002000000E40400001E0000001B000000436F72706F726174652070726573656E7461696F6E206865726500001E00000015000000426F73746F6E2053797374656D732047726F7570002068651E00000015000000426F73746F6E2053797374656D732047726F7570002068651E00000002000000320073741E000000150000004D6963726F736F667420506F776572506F696E740020686540000000805C762A000000004000000060913EE445BAC101400000006037E02327BBC101030000000300000047000000AE030000FFFFFFFF0300000008008910670C0000010009000003CF01000006003000000000001100000026060F001800FFFFFFFF000010000000000000000000C0030000D00200000900000026060F000800FFFFFFFF020000001700000026060F002300FFFFFFFF04001B00544E50501400B400B80032000000FFFF4F00140000004D00690000000A00000026060F000A00544E505000000200F4030900000026060F000800FFFFFFFF030000000F00000026060F001400544E505004000C00010000000100000000000000050000000B0200000000050000000C02D002C0030400000004010D0007000000FC020000FFFFFF000000040000002D01000009000000FA02050000000000FFFFFF002200040000002D010100040000002D010000090000001D062100F000D002C00300000000040000002D010000040000002D01000009000000FA02000000000000000000002200040000002D0102001000000026060F001600FFFFFFFF0000470000008F02000011010000C10200000800000026060F000600FFFFFFFF01000D000000FB020000000000000000000000000001000000000000040000002D010300050000000902000000020500000014020000000004000000020102001000000026060F001600FFFFFFFF0000470100008F02000079020000C10200000800000026060F000600FFFFFFFF01000500000009020000000205000000140200000000040000000201020007000000FC020100000000000000040000002D010400040000002D010100070000001B0469017903F0004800040000002D010000040000002D010200050000000902000000020500000014020000000015000000FB02C5FF0000000000009001000000000040000054696D6573204E657720526F6D616E000000040000002D01050004000000F00103000500000009020000000205000000140200000000040000002E011800040000000201010030000000320A41019A001B000000436F72706F726174652070726573656E746174696F6E20686572650027001D0014001E001D0014001A0010001A000E001E0014001A00170019001E0010001A00100010001D001E000F001E00190014001A00040000002E01010004000000020102000400000002010200040000002D010100040000002D01040010000000FB021000070000000000BC02000000000102022253797374656D0000040000002D01030004000000F00105000F00000026060F001400544E505004000C000000000000000000000000000900000026060F000800FFFFFFFF01000000030000000000040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000C001000010000000010000008800000003000000900000000F000000A800000004000000B800000006000000C000000007000000C800000008000000D000000009000000D80000000A000000E000000017000000E80000000B000000F000000010000000F8000000130000000001000016000000080100000D000000100100000C0000005F01000002000000E40400001E0000000F0000004F6E2D73637265656E2053686F7700001E00000007000000496E747569740065030000007A0E00000300000001000000030000000100000003000000000000000300000000000000030000000000000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000001000000054696D6573204E657720526F6D616E000F00000044656661756C742044657369676E001C000000436F72706F726174652070726573656E746174696F6E2068657265000C100000060000001E0000000B000000466F6E747320557365640003000000010000001E0000001000000044657369676E2054656D706C6174650003000000010000001E0000000D000000536C696465205469746C657300030000000100000000000000000000000000000000000000000000F60F2C000000140000005FC091E3560E00001400F4030300DD02426F73746F6E2053797374656D732047726F75700800000042006F00730074006F006E00430075007200720065006E00740020005500730065007200000000000000000000000000000000000000000000000000000000000000000000000000000000001A000200FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000570000005C000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000530079007300740065006D0073002000470072006F007500700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'WebsiteFinal.ppt', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO `tb_documents_active` VALUES ('39', '2', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Requirements_analysis.doc', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO `tb_documents_active` VALUES ('40', '9', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000000100000000000000001000000200000001000000FEFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFF0E000000FEFFFFFF0400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000F000000FEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000500FFFFFFFFFFFFFFFF01000000108D81649B4FCF1186EA00AA00B929E80000000000000000000000006037E02327BBC10103000000401600000000000050006F0077006500720050006F0069006E007400200044006F00630075006D0065006E0074000000000000000000000000000000000000000000000000000000280002010200000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000007A0E0000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E0000000000000000000000000000000000000000000000000000002800020104000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000003A0000000C05000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000004F000000F0010000000000000100000002000000030000000400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000E0000000F000000100000001100000012000000130000001400000015000000160000001700000018000000190000001A0000001B0000001C0000001D0000001E0000001F000000200000002100000022000000230000002400000025000000260000002700000028000000290000002A0000002B0000002C0000002D0000002E0000002F00000030000000310000003200000033000000340000003500000036000000370000003800000039000000FEFFFFFF3B0000003C0000003D0000003E0000003F000000400000004100000042000000430000004400000045000000460000004700000048000000490000004A0000004B0000004C0000004D0000004E000000FEFFFFFF50000000510000005200000053000000540000005500000056000000FEFFFFFF58000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0F00E803A60300000100E9032800000080160000E0100000E010000080160000050000000A000000000000000000000001000000000000010F00F203160100002F00C80F0C0000003000D20F04000000010000000F00D5074C0000000000B70F44000000540069006D006500730020004E0065007700200052006F006D0061006E000000CC36B80014D96200FCD8620076C70B30080000000000000014D9620028DD0D30000004000000A40F0A000000800060000000FFFFFFFF0000A50F0C000000000000082E000000070000000000A90F0A000000070000000200090400004000A30F6E0000000500FFFD3F0000002220000064000000000000006400000000000000000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF18000000000100000005000020012001000000000005000040024002000000000005000060036003000000000005000080048004000000000F000B04740000000F0000F06C000000000006F020000000020C00000300000009000000020000000100000007000000020000000400000063000BF024000000810104000008830100000008BF0110001000C00101000008FF010800080001020200000840001EF110000000040000080100000802000008F70000101F00F00F1C0000000000F3031400000002000000000000000000000000000080000000000F00D007370100001F0014041C0000000000150414000000BA1D75EC00CA9A3B324ECDC900CA9A3B010100010F00FA03670000000000FE03030000000001000000FD03340000004100000064000000410000006400000076C70B30080000000000000008D96200000000000000000094FFFFFF34FFFFFF010000007000FB030800000000000000700800007000FB030800000001000000400B00001F0007043C0000000000FD03340000002100000064000000210000006400000060F30D30C4DC620000000000B837B80000000000000000000000000000000000000162001F0013043C0000000000FD03340000006400000064000000640000006400000060F30D30C4DC620000000000B837B80000000000000000000000000000000000000162001F00FF0314000000020000040C0000000000000000000000020000000F00F00F690000000000F30314000000030000000000000002000000000100000000000000009F0F04000000060000000000A80F1B000000436F72706F726174652070726573656E746174696F6E206865726510009F0F04000000050000000000AA0F0A000000010000000100000000000000EA03000000000F00F8039C0800000200EF03180000000100000001020709080000000000000000000000000000006000F007200000000000FF00FFFFFF0000000000FFFF0000FF99000000FFFF00FF000000969696006000F00720000000FFFFFF0000000000808080000000000000CC99003333CC00CCCCFF00B2B2B2006000F00720000000FFFFFF00000000003333330000000000DDDDDD00808080004D4D4D00EAEAEA006000F00720000000FFFFCC0000000000666633008080000033993300800000000033CC00FFCC66006000F00720000000FFFFFF00000000008080800000000000FFCC66000000FF00CC00CC00C0C0C0006000F00720000000FFFFFF00000000008080800000000000C0C0C0000066FF00FF000000009900006000F00720000000FFFFFF000000000080808000000000003399FF0099FFCC00CC00CC00B2B2B2000000A30F3E0000000100FFFD3F0000002220000064000000000001006400000000000000000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF2C000000000300001000A30F7C0000000500FFFD3F000100222000006400000000000000640014000000D800000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF2000000000010000800500001320D4012001000002001C00800500002220D0024002000002001800800500001320F003600300000200140080050000BB0010058004000000002000A30F6E0000000500FFFD3F00000022200000640000000000000064001E0000000000000040020000000007000000FFFFEF0000000000FFFFFFFFFFFF0C000000000100000005000020012001000000000005000040024002000000000005000060036003000000000005000080048004000000005000A30F52000000050000000109000000000100000000000000010001090000000001002001000000000200010900000000010040020000000003000109000000000100600300000000040001090000000001008004000000006000A30F0C0000000100000000000000000000007000A30F3E0000000500000000000000000002001C000100000000000000020018000200000000000000020014000300000000000000020012000400000000000000020012008000A30F3E00000005000000000000000000020018000100000000000000020014000200000000000000020012000300000000000000020010000400000000000000020010000F000C04D60400000F0002F0CE040000100008F00800000006000000060400000F0003F0660400000F0004F028000000010009F0100000000000000000000000000000000000000002000AF00800000000040000050000000F0004F0D200000012000AF00800000002040000000A000093000BF0360000007F00010005008000D069B800870001000000810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F0080000008001B001D01450040F0011F0100000000000C30B08000000000000000100B8000F000DF05400000000009F0F04000000000000000000A80F20000000436C69636B20746F2065646974204D6173746572207469746C65207374796C650000A20F060000002100000000000000AA0F0A000000210000000100000000000F0004F01601000012000AF00800000003040000000A000083000BF0300000007F00010005008000806CB800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000E004B001D014000F0F0011F0100000000000C30B08000000010000000200B8000F000DF09E00000000009F0F04000000010000000000A80F52000000436C69636B20746F2065646974204D61737465722074657874207374796C65730D5365636F6E64206C6576656C0D5468697264206C6576656C0D466F75727468206C6576656C0D4669667468206C6576656C0000A20F1E0000002100000000000D00000001000C00000002000D00000003000C00000004000000AA0F0A000000530000000100000000000F0004F0B600000012000AF00800000004040000000A000083000BF0300000007F000100050080000C71B800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000600FB001600680100F0011F0100000000000C30B08000000020000000701B8000F000DF03E00000000009F0F04000000040000000000A00F020000002A000000A10F140000000200000000000000000002000000000002000E000000F80F04000000000000000F0004F0B800000012000AF00800000005040000000A000083000BF0300000007F00010005008000E072B800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000600FB007D00E80100F0011F0100000000000C30B08000000030000000902B8000F000DF04000000000009F0F04000000040000000000A00F020000002A000000A10F1600000002000000000000080000010002000000000002000E000000FA0F04000000000000000F0004F0B800000012000AF00800000006040000000A000083000BF0300000007F000100050080005C7BB800810104000008830100000008BF0101001100C00101000008FF0101000900010202000008000010F008000000600F2010D01480100F0011F0100000000000C30B08000000040000000802B8000F000DF04000000000009F0F04000000040000000000A00F020000002A000000A10F1600000002000000000000080000020002000000000002000E000000D80F04000000000000000F0004F04800000012000AF00800000001040000000C000083000BF03000000081010000000883010500000893018E9F8B009401DEBD6800BF0112001200FF01000008000403090000003F03010001001000F00720000000FFFFFF0000000000808080000000000000CC99003333CC00CCCCFF00B2B2B2002000BA0F1C000000440065006600610075006C0074002000440065007300690067006E000F00EE03E40100000200EF0318000000000000000F100000000000000000008000000000070000000F000C04940100000F0002F08C010000200008F00800000003000000030800000F0003F0240100000F0004F028000000010009F0100000000000000000000000000000000000000002000AF00800000000080000050000000F0004F07200000012000AF008000000020800002002000053000BF01E0000007F000000040080004CAEB800BF0100000100FF0100000100010302040000000010F008000000A005B001D01470080F0011F0100000000000C30B08000000000000000F00B8000F000DF00C00000000009E0F04000000000000000F0004F07200000012000AF008000000030800002002000053000BF01E0000007F00000004008000F4AEB800BF0101000100FF0101000100010303040000000010F008000000900960032013E00D0F0011F0100000000000C30B08000000010000001000B8000F000DF00C00000000009E0F04000000010000000F0004F04800000012000AF00800000001080000000C000083000BF03000000081010000000883010500000893018E9F8B009401DEBD6800BF0112001200FF01000008000403090000003F03010001001000F00720000000FFFFFF0000000000808080000000000000CC99003333CC00CCCCFF00B2B2B20000007217100000000100300000000000AE030000520C00000000F50F1C000000000100009C0A0003000000003E0E000001000000030000000100F7BF000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000DC0400000B00000001000000600000000200000068000000040000008C00000008000000AC00000009000000CC00000012000000D80000000A000000F80000000C000000040100000D000000100100000F0000001C010000110000002401000002000000E40400001E0000001B000000436F72706F726174652070726573656E7461696F6E206865726500001E00000015000000426F73746F6E2053797374656D732047726F7570002068651E00000015000000426F73746F6E2053797374656D732047726F7570002068651E00000002000000320073741E000000150000004D6963726F736F667420506F776572506F696E740020686540000000805C762A000000004000000060913EE445BAC101400000006037E02327BBC101030000000300000047000000AE030000FFFFFFFF0300000008008910670C0000010009000003CF01000006003000000000001100000026060F001800FFFFFFFF000010000000000000000000C0030000D00200000900000026060F000800FFFFFFFF020000001700000026060F002300FFFFFFFF04001B00544E50501400B400B80032000000FFFF4F00140000004D00690000000A00000026060F000A00544E505000000200F4030900000026060F000800FFFFFFFF030000000F00000026060F001400544E505004000C00010000000100000000000000050000000B0200000000050000000C02D002C0030400000004010D0007000000FC020000FFFFFF000000040000002D01000009000000FA02050000000000FFFFFF002200040000002D010100040000002D010000090000001D062100F000D002C00300000000040000002D010000040000002D01000009000000FA02000000000000000000002200040000002D0102001000000026060F001600FFFFFFFF0000470000008F02000011010000C10200000800000026060F000600FFFFFFFF01000D000000FB020000000000000000000000000001000000000000040000002D010300050000000902000000020500000014020000000004000000020102001000000026060F001600FFFFFFFF0000470100008F02000079020000C10200000800000026060F000600FFFFFFFF01000500000009020000000205000000140200000000040000000201020007000000FC020100000000000000040000002D010400040000002D010100070000001B0469017903F0004800040000002D010000040000002D010200050000000902000000020500000014020000000015000000FB02C5FF0000000000009001000000000040000054696D6573204E657720526F6D616E000000040000002D01050004000000F00103000500000009020000000205000000140200000000040000002E011800040000000201010030000000320A41019A001B000000436F72706F726174652070726573656E746174696F6E20686572650027001D0014001E001D0014001A0010001A000E001E0014001A00170019001E0010001A00100010001D001E000F001E00190014001A00040000002E01010004000000020102000400000002010200040000002D010100040000002D01040010000000FB021000070000000000BC02000000000102022253797374656D0000040000002D01030004000000F00105000F00000026060F001400544E505004000C000000000000000000000000000900000026060F000800FFFFFFFF01000000030000000000040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000C001000010000000010000008800000003000000900000000F000000A800000004000000B800000006000000C000000007000000C800000008000000D000000009000000D80000000A000000E000000017000000E80000000B000000F000000010000000F8000000130000000001000016000000080100000D000000100100000C0000005F01000002000000E40400001E0000000F0000004F6E2D73637265656E2053686F7700001E00000007000000496E747569740065030000007A0E00000300000001000000030000000100000003000000000000000300000000000000030000000000000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000001000000054696D6573204E657720526F6D616E000F00000044656661756C742044657369676E001C000000436F72706F726174652070726573656E746174696F6E2068657265000C100000060000001E0000000B000000466F6E747320557365640003000000010000001E0000001000000044657369676E2054656D706C6174650003000000010000001E0000000D000000536C696465205469746C657300030000000100000000000000000000000000000000000000000000F60F2C000000140000005FC091E3560E00001400F4030300DD02426F73746F6E2053797374656D732047726F75700800000042006F00730074006F006E00430075007200720065006E00740020005500730065007200000000000000000000000000000000000000000000000000000000000000000000000000000000001A000200FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000570000005C000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000530079007300740065006D0073002000470072006F007500700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'WebsiteFinal.ppt', null, '2014-03-25 11:00:14', 'admin');

-- ----------------------------
-- Table structure for `tb_documents_history`
-- ----------------------------
DROP TABLE IF EXISTS `tb_documents_history`;
CREATE TABLE `tb_documents_history` (
  `fld_id` int(11) NOT NULL,
  `fld_document_id` int(11) NOT NULL,
  `fld_revision` int(11) DEFAULT NULL,
  `fld_file` longblob,
  `fld_filename` varchar(150) NOT NULL,
  `fld_filesize` varchar(45) DEFAULT NULL,
  `fld_date` datetime NOT NULL,
  `fld_username` varchar(50) NOT NULL,
  `fld_activated` varchar(1) NOT NULL,
  PRIMARY KEY (`fld_id`),
  KEY `fk_tb_documents_history_tb_documents1_idx` (`fld_document_id`),
  KEY `fk_tb_documents_history_tb_authors1_idx` (`fld_username`),
  CONSTRAINT `fk_tb_documents_history_tb_authors1` FOREIGN KEY (`fld_username`) REFERENCES `tb_authors` (`fld_username`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tb_documents_history_tb_documents1` FOREIGN KEY (`fld_document_id`) REFERENCES `tb_documents` (`fld_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tb_documents_history
-- ----------------------------
INSERT INTO `tb_documents_history` VALUES ('1', '1', '1', 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, 'WebsiteFinal.ppt', null, '2014-03-10 15:00:00', 'admin', 'N');
INSERT INTO `tb_documents_history` VALUES ('2', '1', '1', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF090006000000000000000000000001000000190000000000000000100000FEFFFFFF00000000FEFFFFFF0000000018000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0908100000060500AF18CD074940000006010000E1000200B004C10002000000E20000005C007000140000426F73746F6E2053797374656D732047726F7570202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002000E00190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C001E041C000500170000222422232C2323305F293B5C28222422232C2323305C291E04210006001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E04220007001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E0427000800220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E0437002A003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E0029002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F002C003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E0436002B003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140001002B00F5FF200000F80000000000000000C020E000140001002900F5FF200000F80000000000000000C020E000140001002C00F5FF200000F80000000000000000C020E000140001002A00F5FF200000F80000000000000000C020E000140001000900F5FF200000F80000000000000000C02093020400108003FF93020400118006FF93020400128004FF93020400138007FF93020400008000FF93020400148005FF60010200000085000E00B30500000000060053686565743185000E00EA0600000000060053686565743285000E00F1070000000006005368656574338C00040001000100C1010800C101000060690100FC001D0001000000010000001200004461746120776F756C642062652068657265FF000A0008008C0500000C0000000A0000000908100000061000AF18CD0749400000060100000B0214000000000000000000010000006F060000A90600000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000001D000F00031000040000000100100010000404EF0006000000370000000A0000000908100000061000AF18CD0749400000060100000B021000000000000000000000000000A20700000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000040404000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0749400000060100000B021000000000000000000000000000A90800000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000C00000000700000001000000400000000400000048000000080000006800000012000000880000000C000000A00000000D000000AC00000013000000B800000002000000E40400001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC10140000000808AC025B3BBC101030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000007000000496E74756974006803000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000B000000576F726B73686565747300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFFFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF020000002008020000000000C0000000000000460000000000000000000000000000000000000000FEFFFFFF000000000000000057006F0072006B0062006F006F006B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000080000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000, 'Call Center.xls', null, '2014-03-10 15:01:49', 'admin', 'Y');
INSERT INTO `tb_documents_history` VALUES ('10', '10', '3', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF000000000000100000000000040000160400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001600000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC000000000000009F030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000001E03000002000000200300000000000020030000000000002003000000000000200300000000000020030000000000002003000024000000550400002002000075060000B4000000440300001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA0000000000000044030000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA0000000000000059030000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA000000000000001E0300000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA000000000000001E030000000000002A010000F40100002A0100000000000000000000000000001E03000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001E03000000000000FA00000000000000EE0000000C0000000098DE8DB3BBC101BC0000001A000000D600000000000000100100000A0000001E0300000000000000000000000000001E030000000000006F030000300000009F030000000000001E0300000000000029070000000000001A0100001000000029070000000000001E030000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E7420776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000160400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000404000101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E00740000000000000000000000000000000000160000000500000C00000000FFFFFFFF0000000018000000980000000030000000000000008000000080000400001604000003000000000400001604000004000000000400001604000005000000000000001100000015000000180000000700040007000000000018000000040000000000150000001800000004000700FFFF06000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000300043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E0074002E0064006F006300FF40018000001500000015000000D09E64004800480015000000000000000800000000000000021000000000000000160000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D00200006801000000008DB262A68DB262A6000000000200000000000300000012000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000320073741E000000130000004D6963726F736F667420576F726420392E3000704000000000000000000000004000000000264C6AB3BBC1014000000000264C6AB3BBC101030000000100000003000000030000000300000012000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001600000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C0000000000000460000000000000000000000000098DE8DB3BBC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000098DE8DB3BBC1010098DE8DB3BBC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Content.doc', null, '2014-03-13 11:42:16', 'paul', 'Y');
INSERT INTO `tb_documents_history` VALUES ('11', '3', '1', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF000000000000100000000000040000160400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001600000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC000000000000009F030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000001E03000002000000200300000000000020030000000000002003000000000000200300000000000020030000000000002003000024000000550400002002000075060000B4000000440300001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA0000000000000044030000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA0000000000000059030000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA000000000000001E0300000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA000000000000001E030000000000002A010000F40100002A0100000000000000000000000000001E03000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001E03000000000000FA00000000000000EE0000000C0000000098DE8DB3BBC101BC0000001A000000D600000000000000100100000A0000001E0300000000000000000000000000001E030000000000006F030000300000009F030000000000001E0300000000000029070000000000001A0100001000000029070000000000001E030000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E7420776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000160400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000404000101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E00740000000000000000000000000000000000160000000500000C00000000FFFFFFFF0000000018000000980000000030000000000000008000000080000400001604000003000000000400001604000004000000000400001604000005000000000000001100000015000000180000000700040007000000000018000000040000000000150000001800000004000700FFFF06000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000300043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E0074002E0064006F006300FF40018000001500000015000000D09E64004800480015000000000000000800000000000000021000000000000000160000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D00200006801000000008DB262A68DB262A6000000000200000000000300000012000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000320073741E000000130000004D6963726F736F667420576F726420392E3000704000000000000000000000004000000000264C6AB3BBC1014000000000264C6AB3BBC101030000000100000003000000030000000300000012000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001600000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C0000000000000460000000000000000000000000098DE8DB3BBC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000098DE8DB3BBC1010098DE8DB3BBC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 'Content.doc', null, '2014-03-14 09:26:37', 'admin', 'Y');
INSERT INTO `tb_documents_history` VALUES ('12', '3', '1', 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, 'WebsiteFinal.ppt', null, '2014-03-14 09:26:37', 'admin', 'N');
INSERT INTO `tb_documents_history` VALUES ('14', '1', '3', 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