PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for "main"."categories"
-- ----------------------------

CREATE TABLE "categories" (
"categoryid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"categoryname"  varchar(100) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of categories
-- ----------------------------
INSERT INTO "categories" VALUES (1, 'CRMAPPLICATION');
INSERT INTO "categories" VALUES (2, 'WEB SITE');
INSERT INTO "categories" VALUES (3, 'SALES');
INSERT INTO "categories" VALUES (4, 'WEB MAIL');
INSERT INTO "categories" VALUES (5, 'PERIPHERAL');
INSERT INTO "categories" VALUES (6, 'SOFTWARE');
INSERT INTO "categories" VALUES (7, 'SCRIPTCASE');

-- ----------------------------
-- Table structure for "main"."customer"
-- ----------------------------

CREATE TABLE "customer" (
"customerid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"customername"  varchar(150) COLLATE NOCASE DEFAULT NULL,
"customeremail"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"customerphone"  varchar(20) COLLATE NOCASE DEFAULT NULL,
"customerlanguage"  varchar(30) COLLATE NOCASE DEFAULT NULL,
"customerpassword"  varchar(8) COLLATE NOCASE DEFAULT NULL,
"customertype"  char(15) DEFAULT NULL,
"activationcode"  varchar(32) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of customer
-- ----------------------------
INSERT INTO "customer" VALUES (1, 'John smith', 'john@scriptcase.net', '55 88 987 987', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), (2, 'Maria soza', 'maria@scriptcase.net', '55 88 987 666', 'es;es_es', 'customer', 'SUBSCRIBER', null), (3, 'Mary silva', 'mary.silva@scriptcase.net', '55 88 982 112', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), (4, 'Mary Popins', 'mary.popins@scriptcase.net', '55 88 231 222', 'es;es_es', 'customer', 'SUBSCRIBER', null), (5, 'July jordan', 'july.jordan@scriptcase.net', '55 88 227 654', 'es;es_es', 'customer', 'SUBSCRIBER', null), (6, 'Albert Einstein', 'albert.einstein@scriptcase.net', '55 88 227 678', 'es;es_es', 'customer', 'SUBSCRIBER', null), (7, 'Rick Flathmann', 'rick.flathmann@scriptcase.net', '55 88 227 911', 'es;es_es', 'customer', 'SUBSCRIBER', null), (8, 'Todd Huang', 'todd.huang@scriptcase.net', '55 88 227867', 'es;es_es', 'customer', 'SUBSCRIBER', null), (9, 'Alejandro Bailliet', 'alejandro.bailliet@scriptcase.net', '55 88 227 453', 'es;es_es', 'customer', 'SUBSCRIBER', null), (10, 'Joseph Mallinson', 'joseph.mallinson@scriptcase.net', '55 88 227 243', 'es;es_es', 'customer', 'SUBSCRIBER', null), (11, 'Elizabeth Workman', 'elizabeth.workman@scriptcase.net', '55 88 227 867', 'es;es_es', 'customer', 'SUBSCRIBER', null), (12, 'Barry Steinke', 'barry.steinke@scriptcase.net', '55 88 227 910', 'es;es_es', 'customer', 'SUBSCRIBER', null), (13, 'Harry Sissman', 'harry.sissman@scriptcase.net', '55 88 232 332', 'es;es_es', 'customer', 'SUBSCRIBER', null), (14, 'Jonathan Foster', 'jonathan.foster@scriptcase.net', '55 88 227 345', 'es;es_es', 'customer', 'NONSUBSCRIBER', null), (15, 'Helen Bennett', 'helen.bennett@scriptcase.net', '55 88 227 645', 'es;es_es', 'customer', 'NONSUBSCRIBER', null), (16, 'kathleen flanagan', 'kathleen.flanagan@scriptcase.net', '', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (17, 'Charlotte Nassar', 'charlotte.nassar@scriptcase.net', '55 88 227 900', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (18, 'Julie Hamilton', 'julie.hamilton@scriptcase.net', '55 88 227 645', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (19, 'Bryan LeBlanc', 'bryan.leblanc@scriptcase.net', '55 88 227 223', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (20, 'Melanie Steinke', 'melanie.steinke@scriptcase.net', '55 88 227 213', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (21, 'Art Blanton', 'art.blanton@scriptcase.net', '53 43 343 656', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (22, 'Toby Marshall', 'toby.marshall@scriptcase.net', '53 43 343 221', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (23, 'Suzanne Liston', 'suzanne.liston@scriptcase.net', '53 43 343 443', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (24, 'Dennis Gartler', 'dennis.gartler@scriptcase.net', '53 43 343 656', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), (25, 'Shirley LaWare', 'shirley.laware@scriptcase.net', '55 88 227 645', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), (26, 'Henry Wilson', 'henry.wilson@scriptcase.net', '55 88 227 909', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), (27, 'Kristen Kaydos', 'kristen.kaydos@scriptcase.net', '55 88 227 987', 'es;es_es', 'customer', 'SUBSCRIBER', null), (28, 'Chrissy Ralston', 'chrissy.ralston@scriptcase.net', '55 88 227 876', 'es;es_es', 'customer', 'SUBSCRIBER', null), (29, 'Ruben Noyes', 'ruben.noyes@scriptcase.net', '55 88 227 645', 'es;es_es', 'customer', 'SUBSCRIBER', null), (30, 'Patricia Ratner', 'patricia.ratner@scriptcase.net', '55 88 227 000', 'es;es_es', 'customer', 'SUBSCRIBER', null), (31, 'Tamara OBrien', 'tamara.obrien@scriptcase.net', '55 88 227 654', 'es;es_es', 'customer', 'SUBSCRIBER', null), (32, 'Ryan Cazamias', 'ryan.cazamias@scriptcase.net', '55 88 227 223', 'es;es_es', 'customer', 'SUBSCRIBER', null), (33, 'Victor Spruell', 'victor.spruell@scriptcase.net', '55 88 227 221', 'es;es_es', 'customer', 'SUBSCRIBER', null), (34, 'Allen Cromwell', 'allen.cromwell@scriptcase.net', '55 88 227 908', 'es;es_es', 'customer', 'SUBSCRIBER', null), (35, 'Renee Staebel', 'renee.staebel@scriptcase.net', '55 88 227 765', 'es;es_es', 'customer', 'SUBSCRIBER', null), (36, 'Kathryn Crawford', 'kathryn.crawford@scriptcase.net', '55 88 227 556', 'es;es_es', 'customer', 'SUBSCRIBER', null), (37, 'Crystal Trevas', 'crystal.trevas@scriptcase.net', '55 88 227 675', 'es;es_es', 'customer', 'SUBSCRIBER', null), (38, 'Scot Drescher', 'scot.drescher@scriptcase.net', '55 88 227 234', 'es;es_es', 'customer', 'SUBSCRIBER', null), (39, 'Natalie Neal', 'natalie.neal@scriptcase.net', '55 88 227 112', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), (40, 'Julio Iglesias', 'julio.iglesias@scriptcase.net', '', 'es;es_es', 123456, 'SUBSCRIBER', 'C5F026B6007C2A7F9330611A4FE2C0A3'), (41, 'Joao Andre', 'joao@scriptcase.net', '55 88 987 987', 'pt_br;pt_br', 'customer', 'SUBSCRIBER', null);

-- ----------------------------
-- Table structure for "main"."kb_articles"
-- ----------------------------

CREATE TABLE "kb_articles" (
"articlesid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"categoryid"  INTEGER NOT NULL,
"articlesubject"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"articlecontent"  text COLLATE NOCASE,
"articletypeid"  varchar(10) COLLATE NOCASE DEFAULT NULL,
"articleview"  INTEGER DEFAULT NULL,
"votesqty"  INTEGER DEFAULT NULL,
"votestotal"  INTEGER DEFAULT NULL,
"articledate"  datetime DEFAULT NULL,
CONSTRAINT "kb_articles_ibfk_2" FOREIGN KEY ("categoryid") REFERENCES "kb_categories" ("categoryid"),
CONSTRAINT "kb_articles_ibfk_1" FOREIGN KEY ("articletypeid") REFERENCES "kb_articletype" ("articletypeid")
);

-- ----------------------------
-- Records of kb_articles
-- ----------------------------
INSERT INTO "kb_articles" VALUES (1, 18, 'What is  the best way to start writing a PHP program?', '<p>Design, design, design. Figure out, on paper, exactly what you want to<br />do. Otherwise, youll just be coding your way around with no real <br />goal.<br /><br />Plan on separating content from logic, itll always assure cleaner, <br />more maintainable code. <br /><br />Usually the apps I write are DB-related, so to use that sort of<br />application as an example, the first step would be nailing down, with<br />fairly broad scope, what sort of data needs to be stored. This doesnt<br />have to mean tracking down every possible facet of information that <br />will ever be pertinent, just get a good idea. Part of the app design <br />may call for it to be extensible anyway, so you dont have to know<br />everything ahead of time.<br /><br />Once you have a good understanding of what data needs to be stored,<br />design your database. Flow charts are your friend. :) Having a<br />visualization of the structure of the DB will come in handy for<br />subsequent steps.<br /><br />Now its time for an interface between your app and the database. I<br />generally avoid putting direct DB calls in my app as much as possible,<br />your feelings may vary. Now that Pear is around, Ive been using that<br />for my abstraction. There are other options, of course. I tend to<br />write three functions for each logical grouping of database fields. <br />For example, if it were a web log, there may be some groups of fields <br />such as Users, Entries, Categories, and Polls. For these, I would <br />write getEntry, setEntry, deleteEntry, getUser, setUser, deleteUser, <br />and so on. I may not find a need to use all these functions, but <br />being able to assume theyre there if I come to that point later on is <br />handy.<br /><br />Usually for me the next step is the administrative portion of the app.<br />The screens involved in (using the web log example) logging in as a<br />user, posting a new entry, and perhaps adding a poll. The admin<br />interface tends to have three components to it: The navigation, the<br />forms for input, and the code for validating/DB access. Since<br />separating content from code is good, I tend to have these three<br />components thoroughly separated.<br /><br />The navigation can be done any number of ways, I tend to use button <br />menu screens (You log in, get a Main Menu, click on Manage Users, <br />get a User Menu, click on Add User, get an Add User form, etc.) For <br />form input, I like to make my forms dual-purpose. That is, the same <br />file can be used for adding a user as it can for editing. Its a <br />simple process, and its handy for keeping maintenance hassles low. <br />These forms, of course, submit their data to the code that does <br />validation and DB access.<br /><br />So thats the admin side, more or less. Once thats all in place, the<br />only thing left to do is the actual web pages that people will be <br />using. Im no designer, so I dont relish this part. Thankfully, I <br />work with people who are designers, so often while Im coding the <br />admin side, theyre doing up the templates for the site. Then <br />integration is just a matter of plugging in snippits of PHP to extract <br />a value here, interate through some DB fields there.. Pretty soon, <br />its all done. (Okay, so it usually doesnt seen like pretty soon <br />when it actually gets finished).<br /><br />Okay, Ill stop rambling now.<br /><br />Also, choosing a PHP aware editor helps, and PHP developmental tools. <br />Zend.com is a company dedicated to PHP and offers many great products <br />and tools, check them out. As far as PHP friendly text editors and <br />related tools go, check out these links:<br /><br /><a href=http://www.websitecompanyindia.com/seo-Links.htm>http://www.websitecompanyindia.com/seo-Links.htm</a><br /><a href=http://www.webs4soft.com/web-hosting-india.htm>http://www.webs4soft.com/web-hosting-india.htm</a><br /><a href=http://indianjewelry.websitecompanyindia.com/Diamond-Bracelets.htm>http://indianjewelry.websitecompanyindia.com/Diamond-Bracelets.htm</a></p>', 'PUBLISHED', 147, 2, 4, '2009-06-11 15:30:00'), (2, 18, 'authentication to my site with PHP', '<pre>For user authentication, you can use sessions to keep track whether a user is logged in or not, check out this faq :      Im new to sessions and cookies , where should I start?     -------------------------------------------------------     <a href=http://www.faqts.com/knowledge_base/view.phtml/aid/6621/fid/8>http://www.faqts.com/knowledge_base/view.phtml/aid/6621/fid/8</a>  You can check out a few existing PHP authentication scripts, some of  which are found here :      <a href=http://hotscripts.com/PHP/Scripts_and_Programs/User_Authentication/>http://hotscripts.com/PHP/Scripts_and_Programs/User_Authentication/</a></pre>', 'PUBLISHED', 48, 7, 17, '2009-06-11 16:00:00'), (3, 18, 'How can I get in PHP the value of variable coming from a WML < input > or < select > ?', '<p>best is an example...<br /><br />WML:<br />&lt;card id=post title=TestPost&gt;<br />&lt;p&gt;<br />&lt;input type=text name=in1 /&gt;<br />&lt;anchor&gt;Senden<br />&lt;go href=yourscript.php&gt;<br />&lt;postfield name=Post1 value=$in1 /&gt;<br />&lt;/go&gt;<br />&lt;/anchor&gt;<br />&lt;/card&gt;<br /><br />PHP:<br />its like php with html,&nbsp; in yourscript.php there will<br />be a variable called $_POST[Post1] creeated automatically by php</p>', 'PUBLISHED', 183, 2, 5, '2009-06-11 09:20:00'), (5, 18, 'How i can set a time expire page in PHP.', '<p>you can use the header  function like this:<br /><br />header (Expires: Mon, 26 Jul 1997 05:00:00 GMT);<br /><br />You can read more about this function here:<br /><br /><a href=http://php.net/header>http://php.net/header</a></p>', 'PUBLISHED', 68, null, null, '2009-06-11 11:02:00'), (6, 19, 'Can you trap function keys to prevent their native operations?', '<p>I found a way to do it, but it only works in IE and Ive only tested it <br />in IE5 . Netscape doesnt seem to return anything for function keys. If <br />you trap the keyCode you want to disable and assign a new value to the <br />it, you can do whatever you want with the function keys. The keycodes <br />for them are 112 - 123. The only real use Ive found for this is in a <br />proprietary app Im developing for IE, but I guess you could also annoy <br />the heck out of some people with it.<br /><br />document.onkeydown = function(){<br /><br />if(window.event && window.event.keyCode == 116) <br />        { // Capture and remap F5<br />window.event.keyCode = 505;<br />  }<br /><br />if(window.event && window.event.keyCode == 505) <br />        { // New action for F5<br />alert(F5 key was pressed);<br />return false; <br />        // Must return false or the browser will refresh anyway<br />}<br />}</p>', 'PUBLISHED', 193, 2, 3, '2009-06-11 08:10:00'), (7, 19, 'How to set default home page in IE4', '<pre>open ur notepade,copy and paste below,save a *.reg file,it is ok!:)   REGEDIT4  [HKEY_CURRENT_USERSoftwareMicrosoftInternet ExplorerMain] Start Page = http://www.scriptcase.net</pre>', 'PUBLISHED', 171, null, null, '2009-06-11 09:50:00'), (8, 19, 'How do I get a list of fonts available on a users computer?', '<p>&gt; Since this would be a security hole, there is no way to find out what <br />&gt; fonts are installed on a users computer<br />&gt; If you want to use one very specific font and are not sure that <br />&gt; everybody has t installed, simply get a copy of the font on the <br />&gt; server of your webpage (or whereever you can access it via url) and <br />&gt; reference it through a CSS (please see CSS-manual for additional <br />&gt; info).<br />&gt; Otherwise I do propose to use font-families like arial, sans-serif <br />&gt; and the likes.<br /><br />I also want to find out what fonts are avalaible from a client. It is <br />to enable users to print reports off in any font they have available <br />from their browser. If anyone has any idea, please post.<br /><br />Well, in that case Id say youll have to write an applet, since you <br />cannot:<br />a) find out what fonts are on a users computer via JS<br />b) tell the JS print() method which font to use<br />Java on the other side can do that and is just perfect for such tasks.<br /><br />HTH<br /><br />---------<br />See Identifying Installed Fonts at:<br /><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a href=http://www.webreference.com/dhtml/column30/>http://www.webreference.com/dhtml/column30/</a></p>', 'PUBLISHED', 109, null, null, '2009-06-11 07:10:00'), (9, 19, 'How to you mark a script as safe or trusted?1', '<p>Using HTA Applications all you need to do is mark your Frames Or <br />IFrames as APPLICATION=yes.<br /><br />First you must put all of the viewable content into frames.<br />Then in the frame tag itself insert APPLICATION=yes<br />Example:<br /><br />&lt;FRAMESET rows=20%,*&gt;<br />&nbsp; &lt;FRAME src=file.htm APPLICATION=yes&gt;<br />&lt;/FRAMESET&gt;<br /><br />This sets the frames content to Trusted.<br />Anything put in this Frame will be Trusted.</p>', 'PUBLISHED', 127, null, null, '2009-06-11 13:13:00'), (10, 19, 'Can you refer to a javascript variable in an html tag?', '<p>Yes, you can, but only inside so-called event handlers, or as part of a<br />javascript: URL. The only limitation is that you should have assigned<br />the variable before using it in the HTML; either on the HEAD section, or<br />on a SCRIPT conveniently placed before your JavaScript-calling HTML.<br /><br />A simple example follows:<br /><br />Suppose you have this script:<br />&lt;script language=JavaScript&gt;&lt;!--<br />&nbsp; var foo=Dont click here!;<br />// --&gt;&lt;/script&gt;<br /><br />Then, you can use that variable in some event handler:<br />&lt;a href=# onMouseOver=alert(foo)&gt;Click me if you dare!&lt;/a&gt;<br /><br />javascript: URLs are a way to execute functions from clicks on links,<br />by means of the href attribute. Since functions may or may not return<br />values, and the final result of a javascript: URL depends upon the<br />returned value of the called function, its usually easier and less<br />error prone to accomplish the same thing via the onClick event handler,<br />leaving href pointing to nowhere (a clean way to do that is using the<br /># symbol).<br /></p>', 'PUBLISHED', 100, null, null, '2009-06-11 14:00:00'), (11, 21, 'Advanced MySQL Replication - Improving Performance', '<h2>method 1 - Use Multiple Slaves</h2> <p>One method would be to break up data into multiple slaves. This could be done database by database (schema by schema) creating one slave database. Each slave would be pointing to the same master, and using replicate_do_db and replicate_ignore_db statements to specify which data to capture for its slave. However it may be that your applications are not broken up cleanly that way, or that load favors certain tables, rather than certain schemas. So for your site there may be reason to do it on a table-by-table basis. You would then use replicate_do_table and replicate_ignore_table. Youll also need to keep in mind that more slaves mean more threads on the master database, which could add load there. If you run into that problem, consider creating a distribution master, and then slaving off of that. As a further consideration, realize that if you are running backups off of slave databases, your backup scripts will obviously be more complicated in this arrangement, so document well.</p>', 'PUBLISHED', 209, 1, 2, '2009-06-11 22:02:00'), (12, 21, 'Advanced MySQL Replication - Improving Performance', '<h2>method 2 - Priming the Cache</h2> <p><strong><span style=font-size: x-small;>By </span></strong><a href=http://189.42.204.140/feedback.php/http://www.databasejournal.com/features/mysql/article.php/3801281><strong><span style=font-size: x-small;>Sean Hull</span></strong></a></p> <p>A second method would be to do whats called priming the cache. Recall that each of the SQL statements, which executed on the master, is re-executed on the slave database. All the work involved in reading blocks of data, sorting, and caching query execution details has to happen again on the slave. However, what if we could do this all BEFORE the slave SQL thread gets to that query. Thats what the maatkit mk-slave-prefetch tool was built to do. Some sites have had great success with this method, so it is worth investigating. As with anything, test, tweak, and evaluate before rolling out in production.</p>', 'PRIVATE', 77, 1, 3, '2009-06-11 23:05:00'), (13, 21, 'Advanced MySQL Replication - Improving Performance', '<p><strong><span style=font-size: x-small;>By </span></strong><a href=../../../../feedback.php/http://www.databasejournal.com/features/mysql/article.php/3801281><strong><span style=font-size: x-small;>Sean Hull</span></strong></a></p> <p>&nbsp;</p> <h2>method 3 - Move Writes Outside of Replication</h2> <p>A third method would be to move writes outside of replication. What does that mean? Suppose you have tables that load apache logs into your primary database. You can then use replicate_ignore_tables option to skip these heavy archive tables, and then just run a separate data load process on the slave to get that data into your slave database. Since this can also be done in parallel, it may provide surprising speedups.</p>', 'PUBLISHED', 15, 1, 3, '2009-06-11 15:03:00'), (15, 21, 'Query Optimizations in MySQL', '<h3>2. Beware of Character Set Conversions</h3> <p>The character set that your client or application is using may be different from that of the table itself.&nbsp; This will require MySQL to implicitly convert it on the fly.&nbsp; In addition, certain character sets such as UTF8 support multi-byte characters, so they make storage requirements greater. &nbsp;</p>', 'DRAFT', 173, null, null, '2009-06-11 23:59:00'), (24, 25, 'What is a firewall? ', '<p>A firewall protects networked computers from intentional hostile intrusion that could compromise confidentiality or result in data corruption or denial of service. It may be a hardware device or a software program running on a secure host computer. In either case, it must have at least two network interfaces, one for the network it is intended to protect, and one for the network it is exposed to.</p> <p>A firewall sits at the junction point or gateway between the two networks, usually a private network and a public network such as the Internet. The earliest firewalls were simply routers. The term firewall comes from the fact that by segmenting a network into different physical subnetworks, they limited the damage that could spread from one subnet to another just like firedoors or firewalls. <a name=Figure1><strong>Figure 1: Hardware Firewall</strong></a><br />Hardware firewall providing protection to a Local Network</p>', 'PUBLISHED', 46, null, null, '2009-06-11 13:15:00'), (25, 24, 'What cant a firewall do?', '<p>A firewall cannot prevent individual users with modems from dialling into or out of the network, bypassing the firewall altogether. Employee misconduct or carelessness cannot be controlled by firewalls. Policies involving the use and misuse of passwords and user accounts must be strictly enforced. These are management issues that should be raised during the planning of any security policy but that cannot be solved with firewalls alone.</p> <p>The arrest of the Phonemasters cracker ring brought these security issues to light. Although they were accused of breaking into information systems run by AT&amp;T Corp., British Telecommunications Inc., GTE Corp., MCI WorldCom, Southwestern Bell, and Sprint Corp, the group did not use any high tech methods such as IP spoofing (see question 10). They used a combination of social engineering and dumpster diving. Social engineering involves skills not unlike those of a confidence trickster. People are tricked into revealing sensitive information. Dumpster diving or garbology, as the name suggests, is just plain old looking through company trash. Firewalls cannot be effective against either of these techniques.</p>', 'PUBLISHED', 79, null, null, '2009-06-11 17:02:00'), (27, 25, 'What different types of firewalls are there? ', '<p>Firewalls fall into four broad categories: packet filters, circuit level gateways, application level gateways and stateful multilayer inspection firewalls.</p> <p>Packet filtering firewalls work at the network level of the OSI model, or the IP layer of TCP/IP. They are usually part of a router. A router is a device that receives packets from one network and forwards them to another network. In a packet filtering firewall each packet is compared to a set of criteria before it is forwarded. Depending on the packet and the criteria, the firewall can drop the packet, forward it or send a message to the originator. Rules can include source and destination IP address, source and destination port number and protocol used. The advantage of packet filtering firewalls is their low cost and low impact on network performance. Most routers support packet filtering. Even if other firewalls are used, implementing packet filtering at the router level affords an initial degree of security at a low network layer. This type of firewall only works at the network layer however and does not support sophisticated rule based models Network Address Translation (NAT) routers offer the advantages of packet filtering firewalls but can also hide the IP addresses of computers behind the firewall, and offer a level of circuit-based filtering.</p>', 'PUBLISHED', 40, 1, 3, '2009-06-11 12:02:00'), (28, 25, 'What is IP spoofing? ', '<p>Many firewalls examine the source IP addresses of packets to determine if they are legitimate. A firewall may be instructed to allow traffic through if it comes from a specific trusted host. A malicious cracker would then try to gain entry by spoofing the source IP address of packets sent to the firewall. If the firewall thought that the packets originated from a trusted host, it may let them through unless other criteria failed to be met. Of course the cracker would need to know a good deal about the firewalls rule base to exploit this kind of weakness. This reinforces the principle that technology alone will not solve all security problems. Responsible management of information is essential. One of Courtneys laws sums it up: There are management solutions to technical problems, but no technical solutions to management problems.</p> <p>An effective measure against IP spoofing is the use of a Virtual Private Network (VPN) protocol such as IPSec. This methodology involves encryption of the data in the packet as well as the source address. The VPN software or firmware decrypts the packet and the source address and performs a checksum. If either the data or the source address have been tampered with, the packet will be dropped. Without access to the encryption keys, a potential intruder would be unable to penetrate the firewall.</p>', 'PRIVATE', 129, null, null, '2009-06-11 13:00:00'), (29, 25, 'Benefits of a firewall ', '<p>Firewalls protect private local area networks from hostile intrusion from the Internet. Consequently, many LANs are now connected to the Internet where Internet connectivity would otherwise have been too great a risk.</p> <p>Firewalls allow network administrators to offer access to specific types of Internet services to selected LAN users. This selectivity is an essential part of any information management program, and involves not only protecting private information assets, but also knowing who has access to what. Privileges can be granted according to job description and need rather than on an all-or-nothing basis.</p>', 'PUBLISHED', 45, null, null, '2009-06-11 14:05:00'), (30, 24, 'Why is my wireless connection so slow? ', '<p>People often have problems with slow transfer speeds, so I decided to post this.<br /><br />The first thing you should understand is how speeds are measured and denoted. Speeds will be reported back in kilobits, kilobytes, megabits or megabytes per second. A common source of confusion is the difference between a bit and a byte. There are 8 bits in 1 byte, so if your transfer speeds are 12 megabits per second, youre really getting 1.5 megabytes per second (12 divided by 8). Some programs report back in bytes, some in bits, its a matter of which program youre using.<br /><br />The second thing you need to understand, is you will never get the full advertised speed on your wireless router. If the router says it is 54 megabits per second, you will likely only see half of that in real life situations. This is because of overhead and interference, which you can not get rid of. Even on 100 megabit wired connections, you will likely never see its full capacity. Most people will see around 2-3 megabytes per second (18-24Mbps) on their 54Mbps (802.11g) router/APs.<br /><br />The third thing you need to do, is get a program that will tell you what your current transfer speeds are. You have lots of different options. One of the most commonly used programs is <a href=http://readerror.gmxhome.de/><span style=color: monitor, but I prefer using a third-party program.<br /><br />After youve done all of that, actually try transferring a file while running NetMeter, or another transfer speed monitoring program. See what speeds youre currently getting, so you know what youre working with. Make sure the file you are testing with is large enough for an accurate speed result.<br /><br />Now youre ready to start troubleshooting slow wireless speeds.<br /></p> <hr /> <p><br />First, make note of your original transfer speed as a reference. You dont want to go through troubleshooting without remembering if your new speed was better than the old.<br /><br />Second, go into your router/APs web-config and make sure its set to Auto Negotiate connection speeds. Some routers are set out-of-the-box to only hand out connections at 1Mbps (I dont know why). Also, some of them randomly will change their auto-negotiation feature without user intervention. <br /><br />Third, try locating possible devices interfering with your network. There are lots of different types of devices that could be interfering with your network. To list a few, a neighbors wireless network, microwaves and cordless phones. To determine if any other wireless networks are in your area, download <a href=http://www.netstumbler.com/downloads/netstumblerinstaller_0_4_0.exe><span style=color: #0000ff;>Netstumbler</span></a> and run it. It will report back any other wireless networks in your range. If there are other networks, make note of what channel they are operating on. If its operating on channel 6, and youre also on channel 6, you will likely see interference that could result in slow speeds and/or frequent disconnections from your network, so try changing the wireless channel on your network. If you have 2.4 GHz wireless phones in your home, try finding the option to change the wireless channel they operate on. Many 2.4 GHz phones give you this option to lessen interference, but some may still not have that option. The easiest way to tell your (or your neighbors) wireless phone is interfering with your network is if when the phone rings, you loose connectivity to the wireless network. If yours is the definite cause of your interference, and you cant change the channel, try buying another phone. You can either get one of the newer phones that operate at more than 5 GHz, or go with some older models that operate at 900 MHz. As odd as it may sound, microwaves operate at frequencies very close to 2.4 GHz and can cause interference. Make sure you dont put your AP near a microwave (who puts APs in their kitchen anyways <img src=http://i.dslr.net/v2/lite/wink.gif border=0 alt= width=15 align=absBottom />). <br /><br />If you cant find any interfering devices in your area, try a different wireless card and/or AP. Either go to a friends house, or try buying another from the local store (then returning it after your testing is done). Its possible your original wireless card isnt very good and doesnt keep a very good link with the AP. Its just as likely your AP is the source of the problem because it has poor range. If you test with a different AP and your speeds are fixed, then you know the AP was the source of your problem. If you test with a different wireless card and your speeds have been fixed, then your wireless card was likely the problem child in your situation.<br /><br />If youve tried a different wireless card and/or AP, and you still dont have acceptable speeds, try wiring your computer directly into the router. See what speeds it gets that way to make sure the computer isnt the problem. Some older computers may not be able to keep up with faster transfer rates because they cant process the data as fast as youre sending it. <br /><br />If the computer isnt the problem, make sure youre not trying to get unrealistic speeds. Youre not going to get perfect speeds all the time. Wireless is completely different from wired connections and it isnt perfect.<br /><br />Another thing to take into consideration is what kind of encryption you are using. WEP supposedly takes away ~5-10% of speeds due to the encryption method used; WPA isnt as bad.<br /></p>', 'PUBLISHED', 76, null, null, '2009-06-11 11:03:00'), (32, 24, 'What is Bluetooth and how does it compare to WiFi?', '<p class=Normal>Bluetooth (BT) is a separate set of wireless standards to the IEEE 802.11 suite. It is similar to WiFi in that it can connect two devices with radio signals. The differences:</p> <ul class=Normal> <li class=Normal><strong>Speed</strong>: BT speeds are ~ 720kbps, WiFi maxes out at 11mbps </li> <li class=Normal><strong>Distance</strong>: BT primarily was designed for short range, up to 30 feet; while WiFi theoretically can reach 500 feet. </li> <li class=Normal><strong>Applications</strong>: BT was designed as a cable replacement, essentially to connect devices point-to-point. WiFi is designed to hook up an entire network. </li> <li class=Normal><strong>Simplicity</strong>: BT devices advertise their capabilities to others, and a single device can be connected to up to seven other devices at the same time. </li> <li class=Normal><strong>Cost</strong>: A quick survey of prices indicates that BT devices are slightly more expensive than their WiFi counterparts. However, the total final cost for each individual user will depend largely on their intended usage. Those people that already have some BT devices (BT-enabled printers and cell phones, for example) will find it less expensive to add a BT CF card to their Axim X5 than to add network capabilities to their printer or a modem-cable for their cell phone. On the other hand, if the user wants to use WiFi hotspots in addition to a cell phone connection, they will still need to buy the WiFi CF card and thus the economics will change. With PPCs that have built-in BT and WiFi, the user can pick and choose which protocol is used with each potential application. </li> <li class=Normal><strong>Energy usage</strong>: BT uses less power than WiFi, making it a good choice for connecting multiple battery powered devices or from a battery powered device to other equipment. </li> <li class=Normal><strong>Other equipment</strong>: WiFi equipment is essentially limited to computers and a few auxilary devices (in particular, printers). Since Bluetooth is designed primarily as a cable replacement, many more devices are available for BT connectivity. This includes printers, cameras, cell phones, keyboards, headsets, radios, etc. While users have been successful communicating with cell phones and other computing devices (PC, laptops, other PDAs) with their BT-enabled Axims, it is really not known whether all the available BT equipment will function in concert with the Axim. </li> </ul> <p class=Normal>Even though they were designed for different purposes, the lines are somewhat blurry. Recent developments with BT include APs with 100-meter ranges.</p> <p class=Normal>Check <a href=http://www.aximsite.com/bluetooth/>Teds Bluetooth Guide for Pocket PC Devices</a> for details on using BlueTooth with your PPC.</p>', 'PRIVATE', 206, null, null, '2009-06-11 15:12:00'), (33, 24, 'How has Windows Mobile 2003 affected WiFi, its cards/drivers, etc?', '<p>WM03 was designed to be more user friendly when setting your Axim up on a wireless network. Time will tell if Microsoft and Dell have succeeded in this goal. In the current early period after WM03s release, some issues have been recognized. For example, most of the manufacturers have not released drivers for their CF WiFi cards in WM03. Current exceptions to this include the Socket low power card, Dells TrueMobile, and Ambicom (which currently only has beta drivers available).</p>', 'DRAFT', 193, null, null, '2009-06-11 16:11:00'), (34, 24, 'Are there browsers other than Pocket IE?', '<p class=Normal><a href=http://www.af.wakwak.com/~ftoshi/pocket/index_e.html>FtxPBrowser</a> is a freeware plug-in that improves some of the functionality of Pocket IE (PIE).</p> <p class=Normal>NetFront is payware - I find it much better for accessing many of the websites although it still doesnt work for most finacial institutions Ive tried. Its available from Handango, just do a search on their site.</p> <p class=Normal><a href=http://www.bitstream.com/wireless/?wireless-web>Thunderhawk</a> is a subscription service that does reformatting of the websites you access so they work better on PPC</p>', 'PUBLISHED', 141, null, null, '2009-06-11 13:02:00'), (35, 27, 'What is the difference between the OCI8 and ORA extension modules?', '<p>PHP offers two extension modules that can be used to connect to Oracle:</p> <ul> <li>Oracle Call-Interface functions (OCI8) </li> <li>Oracle 7 functions (ORA) </li> </ul> <p>OCI8 should be used whenever possible since it is optimised and provides more options.</p> <p>ORA is deprecated and no longer included in supported versions of PHP. It is unstable, does not include support for CLOBs, BLOBs, BFILEs, ROWIDs, etc. and should not be used.</p> <ul> <li>PHP 5.2 contains OCI8 1.2. </li> <li>PHP 5.3 contains OCI8 1.3, which improves reliability and adds features such as DRCP connection pooling support, FAN support, and external authentication. </li> </ul> <p>You can <a class=external text title=http://pecl.php.net/package/oci8 rel=nofollow href=http://pecl.php.net/package/oci8>download OCI8 1.3 from PECL</a> and install in on PHP 4.3.9 onwards.</p>', 'PRIVATE', 227, null, null, '2009-06-11 10:05:00'), (36, 27, 'How does one configure PHP to use Oracle?', '<p>Follow these steps to prepare your PHP installation for connecting to Oracle databases:</p> <ul> <li>Download PHP from <a class=external free title=http://www.php.net/ rel=nofollow href=http://www.php.net/>http://www.php.net/</a>, install as per the install.txt or INSTALL files, and test if everything is working. </li> </ul> <ul> <li>Install the Oracle Instant Client, Oracle Client, or Oracle Server software on your machine and configure Oracle Net to connect to your database(s). See the <a title=SQL*Net FAQ href=http://189.42.204.140/wiki/SQL%2ANet_FAQ>SQL*Net FAQ</a> for details. </li> </ul> <ul> <li>On Windows, edit your php.ini file and uncomment (remove the semi-colon) the following line: </li> </ul> <pre> extension = php_oci8.dll </pre> <ul> <li>Ensure that your extension_dir parameter (in php.ini) points to the location where the above extension file resides. </li> </ul> <p>... otherwise, compile PHP with the following option:</p> <pre>--with-oci8=shared,/path/to/oracle/home/dir </pre> <ul> <li>Write a small program to test connectivity - see the next question. </li> </ul> <p>Oracle Technology Network has an article on <a class=external text title=http://www.oracle.com/technology/pub/notes/technote_php_instant.html rel=nofollow href=http://www.oracle.com/technology/pub/notes/technote_php_instant.html>Installing PHP and Oracle using Oracle Instant Client</a>.</p>', 'PUBLISHED', 115, null, null, '2009-06-11 17:02:00'), (37, 27, 'How does one connect to Oracle?', '<p>Using the <strong>OCI8 Extension Module</strong> -</p> <pre>&lt;?php  if ($c = oci_connect(hr, hr_password, localhost/XE)) {    echo Successfully connected to Oracle.n;    oci_close($c);  } else {    $err = oci_error();    echo Oracle Connect Error  . $err[text];  }  ?&gt; </pre> <p>NOTE: You might need to set Oracle environment variables such as ORACLE_HOME and NLS_LANG prior to starting your web server. Avoid setting variables in PHP because Oracle context may have been initialized by Apache prior to the execution of the script. However some variables used only at connection time are probably OK to set in scripts:</p> <pre>&lt;?php    PutEnv(ORACLE_SID=ORCL);    PutEnv(TNS_ADMIN=/var/opt/oracle);  ... </pre> <p>Please note that PHP will share/re-use connections if the same userid/password combination is used (more than once) on a particular page or httpd server session. One can use the oci_new_connect() function to ensure one gets a new session. Use the oci_pconnect() function to make persistent connections.</p>', 'PRIVATE', 41, null, null, '2009-06-11 18:15:00'), (38, 27, 'Why do we get error Call to undefined function: oci_connect()?', '<p>PHP is not using the correct extension module. Try compiling PHP with the following options:</p> <pre>--with-oci8=/path/to/oracle/home/dir </pre> <p>On Windows systems one can just uncomment the following lines in the php.ini file:</p> <pre>;extension = php_oci8.dll </pre> <p>Check your PATH (on Windows) and LD_LIBRARY_PATH (Linux) or equivalent variable and make sure it is set to the location of the Oracle libraries</p>', 'PUBLISHED', 52, null, null, '2009-06-11 14:11:00'), (42, 18, 'Where can I find a complete list of variables are available to me in PHP? ', '<dd><a name=faq.using.variables></a> <p class=para>Read the manual page on <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.predefined.php>predefined variables</a> as it includes a partial list of predefined variables available to your script. A complete list of available variables (and much more information) can be seen by calling the <a class=function href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/function.phpinfo.php>phpinfo()</a> function. Be sure to read the manual section on <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.external.php>variables from outside of PHP</a> as it describes common scenarios for external variables, like from a HTML form, a Cookie, and the URL.</p> <blockquote> <p><strong class=note>Note</strong>: <strong>register_globals: important note</strong><br />As of PHP 4.2.0, the default value for the PHP directive <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/ini.core.php#ini.register-globals>register_globals</a> is <em class=emphasis>off</em>, and it was completely removed as of PHP 6.0.0. The PHP community discourages developers from relying on this directive, and encourages the use of other means, such as the <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.predefined.php>superglobals</a>.</p> </blockquote></dd>', 'PUBLISHED', 38, null, null, '2009-06-11 00:10:00'), (43, 18, 'PHP vs. ASP?', '<p class=para>ASP is not really a language in itself, but an acronym for Active Server Pages; the actual languages used to program ASP include Visual Basic Script, JScript, and C#, among others. The biggest drawback of ASP is that its a proprietary system that is natively used only on the Microsoft Internet Information Server (IIS) platform. This limits its availability to Win32 based servers. There are a couple of projects in the works that allows ASP to function with other environments and webservers: <a class=link external href=http://www.stryon.com/products.asp?s=1>&raquo; InstantASP</a> from <a class=link external href=http://www.halcyonsoft.com/>&raquo; Halcyon</a> (commercial), Chili!Soft ASP from <a class=link external href=http://www.chilisoft.com/>&raquo; Chili!Soft</a> (commercial), and <a class=link external href=http://www.mono-project.com/>&raquo; Mono</a> (open-source). ASP is said to be a slower and more cumbersome language than PHP, with less overall stability. One of the pros of ASP is that, since it primarily uses VBScript, its relatively easy to pick up the language if youre already proficient in Visual Basic. ASP support is also enabled by default in IIS, making it easy to get up and running. However, the components built in ASP are really limited, so if you need to use advanced features (like interacting with FTP servers), youll need to buy additional components.</p>', 'PRIVATE', 46, null, null, '2009-06-11 00:05:00'), (44, 18, 'Migrating from PHP 4 to PHP 5 ', '<dd><a name=faq.migration5.php45></a> <p class=para>Although PHP 5 offers many new features, its designed to be as compatible with earlier versions of PHP as possible with little functionality being broken in the process.</p> <p class=para>Be sure to read the appropriate <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/migration5.php>PHP 5 migration appendix</a> of this manual as it contains even more information on the topic of migrating to PHP 5.</p> </dd>', 'PUBLISHED', 214, 2, 6, '2009-06-11 01:00:00'), (45, 18, 'Does MySQL work in PHP 5? It seemed to have disappeared. ', '<dd><a name=faq.migration5.mysql></a> <p class=para><a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/ref.mysql.php>MySQL</a> is supported with the only change being that MySQL support is no longer enabled by <em class=emphasis>default</em> in PHP 5. This essentially means that PHP doesnt include the <span class=option>--with-mysql</span> option in the <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/configuration.php>configure</a> line so that you must now manually do this when compiling PHP. Windows users will edit php.ini and enable the php_mysql.dll DLL as in PHP 4 no such DLL existed, it was simply built into your Windows PHP binaries.</p> <p class=para>Also, the MySQL client libraries are no longer bundled with PHP. More details on this topic are covered in <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/faq.databases.php#faq.databases.mysql.php5>the following FAQ</a> and be sure to read the <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/ref.mysql.php>MySQL section</a> for details on installing MySQL. An example configure line would be <span class=option>--with-mysql=/usr</span> while Windows users will need the libmySQL.dll available to the system.</p> </dd>', 'PUBLISHED', 84, null, null, '2009-06-11 02:00:00'), (47, 18, 'After installing shared MySQL support, Apache dumps core as soon as libphp4.so is loaded. Can this be fixed? ', '<p class=para>If your MySQL libs are linked against pthreads this will happen. Check using ldd. If they are, grab the MySQL tarball and compile from source, or recompile from the source rpm and remove the switch in the spec file that turns on the threaded client code. Either of these suggestions will fix this. Then recompile PHP with the new MySQL libs.</p>', 'PUBLISHED', 195, 1, 3, '2009-06-11 04:00:00'), (48, 18, 'How do I deal with register_globals? ', '<p class=para>For information about the security implications of <em>register_globals</em>, read the security chapter on <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/security.globals.php>Using register_globals</a>.</p> <p class=para>Its preferred to use <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.superglobals.php>superglobals</a>, rather than relying upon <em>register_globals</em> being on.</p> <p class=para>If you are on a shared host with <em>register_globals</em> turned off and need to use some legacy applications, which require this option to be turned on, or you are on some hosting server, where this feature is turned on, but you would like to eliminate security risks, you might need to emulate the opposite setting with PHP. It is always a good idea to first ask if it would be possible to change the option somehow in PHPs configuration, but if it is not possible, then you can use these compatibility snippets.</p>', 'PRIVATE', 181, 1, 2, '2009-06-11 03:00:00'), (49, 18, 'teste', '<p>teste</p>', 'DRAFT', 0, 0, 0, null), (50, 18, 'teste2', '<p>teste2</p>', 'DRAFT', 5, 0, 0, '2009-06-26 14:52:38');

-- ----------------------------
-- Table structure for "main"."kb_articletype"
-- ----------------------------

CREATE TABLE "kb_articletype" (
"articletypeid"  varchar(10) COLLATE NOCASE NOT NULL,
"articletypename"  varchar(255) COLLATE NOCASE DEFAULT NULL,
PRIMARY KEY ("articletypeid")
);

-- ----------------------------
-- Records of kb_articletype
-- ----------------------------
INSERT INTO "kb_articletype" VALUES ('DRAFT', 'The article is saved but not yet published. It can only be read bystaff'), ('PRIVATE', 'Private articles can only be read by staff.'), ('PUBLISHED', 'The article is viewable to everyone in the knowledgebase');

-- ----------------------------
-- Table structure for "main"."kb_categories"
-- ----------------------------

CREATE TABLE "kb_categories" (
"categoryid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"categoryname"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"categoryparent"  INTEGER DEFAULT NULL,
"categorylabel"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"categoryorder"  INTEGER DEFAULT NULL,
CONSTRAINT "kb_categories_ibfk_1" FOREIGN KEY ("categoryparent") REFERENCES "kb_categories" ("categoryid")
);

-- ----------------------------
-- Records of kb_categories
-- ----------------------------
INSERT INTO "kb_categories" VALUES (17, 'Programming', null, 'Programming', 1), (18, 'PHP', 17, 'PHP', 2), (19, 'JavaScript', 17, 'JavaScript', 3), (20, 'Databases', null, 'Databases', 4), (21, 'MYSQL', 20, 'MYSQL', 5), (22, 'Storedd Procedure', 21, '      Stored Procedure', 6), (23, 'Networking', null, 'Networking', 10), (24, 'Wireless', 23, 'Wireless', 11), (25, 'Firewall', 23, 'Firewall', 12), (26, 'UNION statement', 21, 'UNION statement', 7), (27, 'ORACLE', 20, 'ORACLE', 8), (28, 'NLS settings', 27, 'NLS settings', 9), (29, 'USB Modem', 23, 'USB Modem', 13);

-- ----------------------------
-- Table structure for "main"."languages"
-- ----------------------------

CREATE TABLE "languages" (
"serial"  INTEGER PRIMARY KEY AUTOINCREMENT,
"languageid"  varchar(30) COLLATE NOCASE DEFAULT NULL,
"languagename"  varchar(100) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of languages
-- ----------------------------
INSERT INTO "languages" VALUES (1, 'en_us;en_us', 'English'), (2, 'es;es_es', 'Spanish');

-- ----------------------------
-- Table structure for "main"."message_templates"
-- ----------------------------

CREATE TABLE "message_templates" (
"templateid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"categoryid"  INTEGER DEFAULT NULL,
"templatedescription"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"templatecontent"  text COLLATE NOCASE,
CONSTRAINT "message_templates_ibfk_1" FOREIGN KEY ("categoryid") REFERENCES "categories" ("categoryid")
);

-- ----------------------------
-- Records of message_templates
-- ----------------------------
INSERT INTO "message_templates" VALUES (1, 1, 'Customers file display na error in the e-mail.', 'Check the entry format. It should be: abc@abc.abc'), (2, 1, 'How to classify the customer by priority?', 'Check the user manual the topic How to configure the priority '), (3, 1, 'How can I access  a client  last orders?', 'In the Reports menu open the subfolder Customers and click on Last Orders.'), (4, 2, 'I can not download the technical standards  manual.', 'The file was temporarily removed for review. Soon it will be available for download.'), (5, 2, 'Access to the site is very slow on weekends.', 'This acorre due to the larger data traffic during the weekend.'), (6, 3, 'Can I pay my purchase in 12 instalments using the Visa?', 'The payment with 12 instalments is only allowed on mastercard'), (7, 3, 'I want to cancel my order number xxxxx.', 'To cancel your order please contact the service and quality center'), (8, 4, 'I can not open a message attachment. ', 'The file was blocked because it is an executable.'), (9, 4, 'I can&#180;t sync my mail.', 'The server was out  at that time, but is already operational.'), (10, 5, 'My desktop does not turn on', 'Make sure it is properly connected to the power supply.'), (11, 5, 'The mouse does not move to the side', 'Make sure the mouse is not dirty and  contact the hardware support.'), (12, 6, 'My Firefox browser  is displaying na Javascript error', 'Provavalmente an error occurred on the page you were accessing.'), (13, 6, 'My  Office does not open, or word or excel ...', 'Please, try reinstalling the program.');


-- ----------------------------
-- Table structure for "main"."staff"
-- ----------------------------

CREATE TABLE "staff" (
"staffid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"staffname"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"staffemail"  varchar(150) COLLATE NOCASE DEFAULT NULL,
"staffpassword"  varchar(8) COLLATE NOCASE DEFAULT NULL,
"adminflag"  char(1) DEFAULT NULL,
"stafflanguage"  varchar(30) COLLATE NOCASE DEFAULT NULL,
"signature"  varchar(255) COLLATE NOCASE DEFAULT NULL
);

-- ----------------------------
-- Records of staff
-- ----------------------------
INSERT INTO "staff" VALUES (1, 'Raymond', 'raymond@scriptcase.net', 'admin', 'Y', 'en_us;en_us', '<p>----------------------------</p>\n<p>Raymond Voltz</p>'), (2, 'Juan', 'gonzales@scriptcase.net', 'admin', 'Y', 'es;es_es', '<p>----------------------------</p>'), (3, 'Logan McKinley', 'staff@scriptcase.net', 'admin', 'Y', 'en_us;en_us', '<p>----------------------------</p>'), (4, 'Catherine Poddar', 'catherine@sctiptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), (5, 'Don Parker', 'staff_es@sctiptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), (6, 'Juan estevan', 'estevam@scriptcase.net', 'staff', 'N', 'es;es_es', '<p>----------------------------</p>'), (7, 'Maria Chong', 'staff@scriptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), (8, 'Sean', 'rodrigo@scriptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), (9, 'Margaret Royston', 'arlindo@scriptcase.net', 'staff', 'N', 'es;es_es', '<p>----------------------------</p>'), (10, 'Ruben Polking', 'staff@scriptcase.net', 'staff', 'N', 'es;es_es', '<p>----------------------------</p>');

-- ----------------------------
-- Table structure for "main"."staff_categories"
-- ----------------------------

CREATE TABLE "staff_categories" (
"categoryid"  INTEGER NOT NULL,
"staff_staffid"  INTEGER NOT NULL,
PRIMARY KEY ("categoryid", "staff_staffid"),
CONSTRAINT "staff_categories_ibfk_2" FOREIGN KEY ("staff_staffid") REFERENCES "staff" ("staffid"),
CONSTRAINT "staff_categories_ibfk_1" FOREIGN KEY ("categoryid") REFERENCES "categories" ("categoryid")
);

-- ----------------------------
-- Records of staff_categories
-- ----------------------------
INSERT INTO "staff_categories" VALUES (1, 3), (2, 3), (3, 3), (4, 3), (5, 3), (6, 3), (1, 5), (2, 5), (3, 5), (4, 5), (5, 5), (6, 5), (1, 6), (2, 6), (3, 6), (4, 6), (5, 6), (6, 6), (1, 7), (2, 7), (3, 7), (4, 7), (5, 7), (6, 7), (1, 8), (2, 8), (3, 8), (4, 8), (5, 8), (6, 8), (1, 9), (2, 9), (3, 9), (4, 9), (5, 9), (6, 9), (1, 10), (2, 10), (3, 10), (4, 10), (5, 10), (6, 10);

-- ----------------------------
-- Table structure for "main"."systemsettings"
-- ----------------------------

CREATE TABLE "systemsettings" (
"id"  INTEGER NOT NULL,
"smtpserver"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"smtpuser"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"smtppassword"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"emailaccount"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"assigmentmode"  varchar(30) COLLATE NOCASE DEFAULT NULL,
"publicticketsopening"  char(1) DEFAULT NULL,
"definedparameters"  varchar(255) COLLATE NOCASE DEFAULT 'NULL',
"broadcastmessages"  char(1) DEFAULT NULL,
"defaultpriority"  int(1) DEFAULT NULL,
"smtpsecurityflag"  char(1) DEFAULT NULL,
"smtpport"  char(3) DEFAULT NULL,
"urltrackingscreen"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"urlconfirmationscreen"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"defaultlanguage"  varchar(50) COLLATE NOCASE DEFAULT NULL,
"companyname"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"urlimgok"  varchar(300) COLLATE NOCASE DEFAULT NULL,
"urlimgfail"  varchar(300) COLLATE NOCASE DEFAULT NULL,
"sys_version"  varchar(100) COLLATE NOCASE NOT NULL,
PRIMARY KEY ("id" ASC)
);

-- ----------------------------
-- Records of systemsettings
-- ----------------------------
INSERT INTO "systemsettings" VALUES (1, 'smtp.example.com', '', null, 'example@example.com', 'Direct', 'Y', 'Y', 'N', 2, '', 25, 'http://localhost:83/scriptcase/app/sc_tickets/ctrl_tracking_tickets/ctrl_tracking_tickets.php', 'http://localhost:83/scriptcase/app/sc_tickets/ctrl_confirm_acount_creation/ctrl_confirm_acount_creation.php', 'en_us;en_us', 'ScriptCase', '<img src=../_lib/img/02.png>', '<img src=../_lib/img/01.png>', 'reg');

-- ----------------------------
-- Table structure for "main"."ticket"
-- ----------------------------

CREATE TABLE "ticket" (
"ticketid"  INTEGER PRIMARY KEY AUTOINCREMENT,
"ticketpriorityid"  INTEGER NOT NULL,
"statusid"  varchar(30) COLLATE NOCASE NOT NULL,
"ownerid"  INTEGER DEFAULT NULL,
"customerid"  INTEGER DEFAULT NULL,
"categoryid"  INTEGER DEFAULT NULL,
"subject"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"ticketdate"  datetime DEFAULT NULL,
"customerrating"  INTEGER DEFAULT NULL,
"customercomments"  varchar(255) COLLATE NOCASE DEFAULT NULL,
"ticketlastupdate"  datetime DEFAULT NULL,
"ticketlastreplier"  varchar(150) COLLATE NOCASE DEFAULT NULL,
"tickettrack"  varchar(10) COLLATE NOCASE DEFAULT NULL,
CONSTRAINT "ticket_ibfk_5" FOREIGN KEY ("categoryid") REFERENCES "categories" ("categoryid"),
CONSTRAINT "ticket_ibfk_1" FOREIGN KEY ("ticketpriorityid") REFERENCES "ticketpriority" ("ticketpriorityid"),
CONSTRAINT "ticket_ibfk_2" FOREIGN KEY ("statusid") REFERENCES "ticketstatus" ("statusid"),
CONSTRAINT "ticket_ibfk_3" FOREIGN KEY ("ownerid") REFERENCES "staff" ("staffid"),
CONSTRAINT "ticket_ibfk_4" FOREIGN KEY ("customerid") REFERENCES "customer" ("customerid")
);

-- ----------------------------
-- Records of ticket
-- ----------------------------
INSERT INTO "ticket" VALUES (1, 1, 'SOLVED', 10, 2, 5, 'Peripheral Issue', '2008-03-01 11:29:30', 4, null, '2008-03-14 14:40:08', 'STAFF', 'C4CA4238A0'), (2, 2, 'SOLVED', 1, 35, 5, 'Peripheral Issue', '2008-03-01 08:27:40', 4, null, '2008-03-02 17:34:42', 'STAFF', 'C81E728D9D'), (3, 3, 'SOLVED', 8, 34, 2, 'WEB Site Issue', '2008-03-01 08:34:55', 3, null, '2008-03-04 16:41:27', 'STAFF', 'ECCBC87E4B'), (4, 3, 'CLOSED', 2, 19, 6, 'Sotfware Issue', '2008-03-01 10:57:54', 3, null, '2008-03-08 14:35:01', 'STAFF', 'A87FF679A2'), (5, 2, 'SOLVED', 8, 1, 5, 'Peripheral Doubt', '2008-03-01 09:02:44', 3, null, '2008-03-04 16:32:15', 'STAFF', 'E4DA3B7FBB'), (6, 2, 'SOLVED', 4, 35, 3, 'Sales Issue', '2008-03-01 08:43:03', 3, null, '2008-03-04 13:41:01', 'STAFF', '1679091C5A'), (7, 2, 'SOLVED', 1, 22, 1, 'CRM Application Issue', '2008-03-02 07:33:45', 4, null, '2008-03-02 16:24:20', 'STAFF', '8F14E45FCE'), (8, 2, 'CLOSED', 10, 40, 6, 'Software Doubt', '2008-03-02 12:18:02', 1, null, '2008-03-03 16:14:08', 'STAFF', 'C9F0F895FB'), (9, 1, 'SOLVED', 3, 38, 2, 'WEB Site Issue', '2008-03-02 11:03:03', 4, null, '2008-03-05 14:23:54', 'STAFF', '45C48CCE2E'), (10, 2, 'CLOSED', 5, 35, 1, 'CRM Application Issue', '2008-03-02 08:10:59', 3, null, '2008-03-19 15:37:23', 'STAFF', 'D3D9446802'), (11, 3, 'SOLVED', 1, 34, 4, 'WEB Mail Issue', '2008-03-02 06:22:58', 4, null, '2008-03-10 18:28:53', 'STAFF', '6512BD43D9'), (12, 2, 'SOLVED', 9, 40, 6, 'Software Issue', '2008-03-03 07:09:28', 3, null, '2008-03-14 17:04:41', 'STAFF', 'C20AD4D76F'), (13, 2, 'SOLVED', 8, 11, 5, 'Peripheral Issue', '2008-03-03 10:21:58', 3, null, '2008-03-15 14:10:13', 'STAFF', 'C51CE410C1'), (14, 2, 'SOLVED', 10, 38, 5, 'Peripheral Issue', '2008-03-03 06:14:02', 4, null, '2008-03-09 16:13:36', 'STAFF', 'AAB3238922'), (15, 2, 'CLOSED', 2, 3, 1, 'CRM Application Issue', '2008-03-03 06:48:03', 1, null, '2008-03-06 14:15:09', 'STAFF', '9BF31C7FF0'), (16, 1, 'SOLVED', 9, 33, 5, 'Peripheral Issue', '2008-03-03 08:57:55', 4, null, '2008-03-16 14:09:42', 'STAFF', 'C74D97B01E'), (17, 2, 'SOLVED', 9, 29, 6, 'Sotfware Issue', '2008-03-03 08:14:34', 3, null, '2008-03-11 17:07:29', 'STAFF', '70EFDF2EC9'), (18, 1, 'SOLVED', 8, 29, 6, 'Software Issue', '2008-03-04 11:44:21', 4, null, '2008-03-19 16:34:42', 'STAFF', '6F4922F455'), (19, 3, 'SOLVED', 1, 1, 1, 'CRM Application Issue', '2008-03-04 10:22:22', 2, null, '2008-03-06 18:31:43', 'STAFF', '1F0E3DAD99'), (20, 3, 'CLOSED', 6, 33, 3, 'Sales Doubt', '2008-03-04 12:32:58', 3, null, '2008-03-09 13:11:29', 'STAFF', '98F1370821'), (21, 1, 'SOLVED', 6, 37, 5, 'Peripheral Doubt', '2008-03-04 07:28:24', 3, null, '2008-03-05 17:14:41', 'STAFF', '3C59DC048E'), (22, 1, 'SOLVED', 5, 12, 2, 'WEB Site Issue', '2008-03-04 06:24:00', 3, null, '2008-03-04 14:08:01', 'STAFF', 'B6D767D2F8'), (23, 2, 'SOLVED', 5, 11, 5, 'Peripheral Issue', '2008-03-04 11:27:57', 4, null, '2008-03-12 15:07:03', 'STAFF', '37693CFC74'), (24, 1, 'SOLVED', 2, 19, 1, 'CRM Application Doubt', '2008-03-04 07:58:18', 3, null, '2008-03-13 14:11:34', 'STAFF', '1FF1DE7740'), (25, 2, 'SOLVED', 2, 22, 4, 'WEB Mail Doubt', '2008-03-05 12:32:18', 3, null, '2008-03-06 14:26:41', 'STAFF', '8E296A067A'), (26, 2, 'SOLVED', 3, 19, 1, 'CRM Application Issue', '2008-03-06 07:06:38', 2, null, '2008-03-08 17:18:18', 'STAFF', '4E732CED34'), (27, 1, 'SOLVED', 10, 25, 4, 'WEB Mail Doubt', '2008-03-07 12:40:04', 4, null, '2008-03-17 14:06:10', 'STAFF', '02E74F10E0'), (28, 1, 'SOLVED', 1, 1, 3, 'Sales Doubt', '2008-03-07 09:31:36', 4, null, '2008-03-18 15:48:02', 'STAFF', '33E75FF09D'), (29, 2, 'SOLVED', 2, 33, 1, 'CRM Application Issue', '2008-03-07 11:05:07', 4, null, '2008-03-24 17:24:01', 'STAFF', '6EA9AB1BAA'), (30, 1, 'SOLVED', 1, 29, 6, 'Sotfware Issue', '2008-03-07 07:07:10', 2, null, '2008-03-08 16:22:28', 'STAFF', '34173CB38F'), (31, 2, 'CLOSED', 10, 28, 1, 'CRM Application Issue', '2008-03-07 06:21:54', 1, null, '2008-03-18 17:15:17', 'STAFF', 'C16A5320FA'), (32, 2, 'SOLVED', 9, 33, 3, 'Sales Issue', '2008-03-07 06:29:28', 2, null, '2008-03-14 16:32:00', 'STAFF', '6364D3F0F4'), (33, 2, 'CLOSED', 9, 10, 2, 'WEB Site Issue', '2008-03-07 06:02:34', 3, null, '2008-03-07 17:31:41', 'STAFF', '182BE0C5CD'), (34, 1, 'SOLVED', 1, 3, 5, 'Peripheral Issue', '2008-03-07 12:07:45', 3, null, '2008-03-16 18:04:50', 'STAFF', 'E369853DF7'), (35, 3, 'SOLVED', 1, 22, 3, 'Sales Doubt', '2008-03-08 09:57:45', 4, null, '2008-03-20 17:44:54', 'STAFF', '1C383CD30B'), (36, 2, 'SOLVED', 5, 34, 1, 'CRM Application Issue', '2008-03-08 06:25:18', 3, null, '2008-03-12 13:59:47', 'STAFF', '19CA14E7EA'), (37, 2, 'SOLVED', 7, 21, 4, 'WEB Mail Doubt', '2008-03-08 08:59:34', 3, null, '2008-03-17 16:44:37', 'STAFF', 'A5BFC9E079'), (38, 1, 'SOLVED', 1, 37, 4, 'WEB Mail Issue', '2008-03-08 09:07:55', 3, null, '2008-03-12 13:00:15', 'STAFF', 'A5771BCE93'), (39, 1, 'CLOSED', 3, 9, 5, 'Peripheral Doubt', '2008-03-09 06:37:09', 2, null, '2008-03-11 17:18:10', 'STAFF', 'D67D8AB4F4'), (40, 2, 'SOLVED', 6, 40, 4, 'WEB Mail Doubt', '2008-03-09 10:05:48', 2, null, '2008-03-11 14:43:27', 'STAFF', 'D645920E39'), (41, 2, 'SOLVED', 6, 39, 1, 'CRM Application Issue', '2008-03-09 06:49:20', 4, null, '2008-03-20 17:22:57', 'STAFF', '3416A75F4C'), (42, 2, 'SOLVED', 10, 37, 6, 'Software Issue', '2008-03-09 06:51:18', 2, null, '2008-03-20 13:23:01', 'STAFF', 'A1D0C6E83F'), (43, 1, 'SOLVED', 8, 22, 4, 'WEB Mail Doubt', '2008-03-09 10:39:45', 2, null, '2008-03-18 13:38:19', 'STAFF', '17E62166FC'), (44, 1, 'SOLVED', 10, 19, 6, 'Sotfware Issue', '2008-03-09 07:13:18', 2, null, '2008-03-09 15:02:22', 'STAFF', 'F7177163C8'), (45, 2, 'SOLVED', 1, 14, 4, 'WEB Mail Issue', '2008-03-09 08:00:10', 4, null, '2008-03-12 18:07:28', 'STAFF', '6C8349CC72'), (46, 2, 'SOLVED', 1, 34, 4, 'WEB Mail Doubt', '2008-03-09 11:47:54', 4, null, '2008-03-20 18:50:25', 'STAFF', 'D9D4F495E8'), (47, 2, 'SOLVED', 10, 33, 6, 'Software Doubt', '2008-03-09 06:31:25', 3, null, '2008-03-09 15:30:49', 'STAFF', '67C6A1E7CE'), (48, 2, 'CLOSED', 6, 1, 3, 'Sales Issue', '2008-03-09 06:00:42', 3, null, '2008-03-16 13:48:52', 'STAFF', '642E92EFB7'), (49, 3, 'SOLVED', 9, 11, 6, 'Software Issue', '2008-03-09 12:39:51', 3, null, '2008-03-13 17:02:23', 'STAFF', 'F457C545A9'), (50, 2, 'SOLVED', 5, 11, 4, 'WEB Mail Issue', '2008-03-10 08:47:08', 4, null, '2008-03-21 14:36:36', 'STAFF', 'C0C7C76D30'), (51, 3, 'SOLVED', 1, 13, 3, 'Sales Doubt', '2008-03-10 08:06:18', 2, null, '2008-03-11 13:54:04', 'STAFF', '2838023A77'), (52, 1, 'SOLVED', 1, 35, 5, 'Peripheral Issue', '2008-03-10 11:51:52', 3, null, '2008-03-20 14:55:06', 'STAFF', '9A1158154D'), (53, 3, 'SOLVED', 2, 14, 5, 'Peripheral Doubt', '2008-03-10 06:28:07', 2, null, '2008-03-16 13:15:01', 'STAFF', 'D82C8D1619'), (54, 1, 'CLOSED', 10, 24, 5, 'Peripheral Issue', '2008-03-10 09:11:15', 2, null, '2008-03-14 15:26:41', 'STAFF', 'A684ECEEE7'), (55, 3, 'SOLVED', 2, 37, 4, 'WEB Mail Doubt', '2008-03-10 11:02:11', 4, null, '2008-03-15 14:01:46', 'STAFF', 'B53B3A3D6A'), (56, 3, 'SOLVED', 8, 12, 3, 'Sales Doubt', '2008-03-11 08:12:06', 3, null, '2008-03-15 18:32:19', 'STAFF', '9F61408E3A'), (57, 2, 'SOLVED', 2, 5, 5, 'Peripheral Doubt', '2008-03-11 09:44:57', 3, null, '2008-03-16 15:59:36', 'STAFF', '72B32A1F75'), (58, 3, 'SOLVED', 10, 36, 6, 'Software Issue', '2008-03-12 10:21:32', 3, null, '2008-03-14 18:50:26', 'STAFF', '66F041E16A'), (59, 2, 'SOLVED', 10, 1, 6, 'Software Issue', '2008-03-12 11:25:36', 2, null, '2008-03-24 17:09:09', 'STAFF', '093F65E080'), (60, 2, 'SOLVED', 3, 28, 4, 'WEB Mail Issue', '2008-03-12 06:29:08', 3, null, '2008-03-20 17:57:38', 'STAFF', '072B030BA1'), (61, 2, 'SOLVED', 9, 19, 5, 'Peripheral Issue', '2008-03-14 10:11:42', 2, null, '2008-03-23 16:40:10', 'STAFF', '7F39F8317F'), (62, 1, 'SOLVED', 10, 5, 4, 'WEB Mail Issue', '2008-03-14 12:15:06', 2, null, '2008-03-24 15:50:15', 'STAFF', '44F683A841'), (63, 2, 'SOLVED', 10, 7, 6, 'Software Doubt', '2008-03-14 09:08:28', 2, null, '2008-03-19 17:14:14', 'STAFF', '03AFDBD66E'), (64, 2, 'SOLVED', 10, 31, 6, 'Sotfware Issue', '2008-03-14 10:31:35', 2, null, '2008-03-22 16:36:46', 'STAFF', 'EA5D2F1C46'), (65, 2, 'CLOSED', 4, 25, 3, 'Sales Doubt', '2008-03-14 06:32:40', 1, null, '2008-03-16 15:53:45', 'STAFF', 'FC490CA45C'), (66, 2, 'SOLVED', 3, 5, 3, 'Sales Issue', '2008-03-14 08:55:11', 2, null, '2008-03-30 17:33:54', 'STAFF', '3295C76ACB'), (67, 3, 'SOLVED', 1, 10, 6, 'Software Issue', '2008-03-14 12:57:52', 2, null, '2008-03-20 14:10:14', 'STAFF', '735B90B456'), (68, 2, 'SOLVED', 10, 31, 6, 'Sotfware Issue', '2008-03-14 12:57:35', 2, null, '2008-03-25 18:16:29', 'STAFF', 'A3F390D88E'), (69, 2, 'SOLVED', 5, 1, 3, 'Sales Doubt', '2008-03-15 09:27:27', 2, null, '2008-03-15 18:43:37', 'STAFF', '14BFA6BB14'), (70, 3, 'CLOSED', 9, 37, 1, 'CRM Application Doubt', '2008-03-15 10:15:17', 2, null, '2008-03-23 18:33:24', 'STAFF', '7CBBC409EC'), (71, 2, 'SOLVED', 4, 21, 5, 'Peripheral Issue', '2008-03-15 12:50:57', 3, null, '2008-03-23 17:16:22', 'STAFF', 'E2C420D928'), (72, 2, 'SOLVED', 1, 10, 6, 'Sotfware Issue', '2008-03-15 11:29:09', 3, null, '2008-03-28 17:41:36', 'STAFF', '32BB90E897'), (73, 3, 'SOLVED', 1, 25, 3, 'Sales Doubt', '2008-03-15 09:15:43', 3, null, '2008-03-16 18:16:38', 'STAFF', 'D2DDEA18F0'), (74, 2, 'CLOSED', 6, 22, 6, 'Software Issue', '2008-03-15 10:36:17', 1, null, '2008-03-21 15:18:52', 'STAFF', 'AD61AB1432'), (75, 1, 'SOLVED', 5, 1, 6, 'Sotfware Issue', '2008-03-16 12:12:27', 3, null, '2008-03-26 17:42:51', 'STAFF', 'D09BF41544'), (76, 2, 'SOLVED', 5, 17, 6, 'Software Doubt', '2008-03-16 10:28:25', 3, null, '2008-03-17 14:57:28', 'STAFF', 'FBD7939D67'), (77, 2, 'SOLVED', 1, 22, 4, 'WEB Mail Doubt', '2008-03-16 10:46:02', 2, null, '2008-03-30 18:55:56', 'STAFF', '28DD2C7955'), (78, 2, 'CLOSED', 1, 19, 6, 'Software Doubt', '2008-03-16 10:03:22', 1, null, '2008-03-22 14:56:35', 'STAFF', '35F4A8D465'), (79, 2, 'SOLVED', 2, 32, 6, 'Software Issue', '2008-03-16 06:48:53', 3, null, '2008-04-01 18:39:56', 'STAFF', 'D1FE173D08'), (80, 3, 'SOLVED', 10, 22, 5, 'Peripheral Issue', '2008-03-16 07:38:37', 2, null, '2008-03-21 13:47:24', 'STAFF', 'F033AB37C3'), (81, 1, 'SOLVED', 5, 21, 5, 'Peripheral Doubt', '2008-03-16 10:42:11', 3, null, '2008-03-25 17:26:17', 'STAFF', '43EC517D68'), (82, 1, 'CLOSED', 10, 10, 4, 'WEB Mail Doubt', '2008-03-16 06:49:29', 2, null, '2008-03-16 17:01:36', 'STAFF', '9778D5D219'), (83, 1, 'SOLVED', 4, 32, 6, 'Sotfware Issue', '2008-03-16 08:14:05', 3, null, '2008-03-19 13:40:01', 'STAFF', 'FE9FC289C3'), (84, 2, 'SOLVED', 7, 38, 5, 'Peripheral Issue', '2008-03-16 11:59:30', 4, null, '2008-03-26 16:11:30', 'STAFF', '68D30A9594'), (85, 2, 'SOLVED', 10, 19, 4, 'WEB Mail Issue', '2008-03-17 11:53:43', 4, null, '2008-03-22 13:41:51', 'STAFF', '3EF815416F'), (86, 3, 'SOLVED', 10, 17, 6, 'Software Doubt', '2008-03-17 11:08:52', 4, null, '2008-03-26 15:43:46', 'STAFF', '93DB85ED90'), (87, 2, 'SOLVED', 5, 28, 2, 'WEB Site Issue', '2008-03-17 10:01:10', 4, null, '2008-04-02 13:16:33', 'STAFF', 'C7E1249FFC'), (88, 1, 'SOLVED', 1, 32, 2, 'WEB Site Issue', '2008-03-17 08:10:47', 3, null, '2008-03-19 14:47:26', 'STAFF', '2A38A4A931'), (89, 2, 'SOLVED', 4, 10, 5, 'Peripheral Doubt', '2008-03-17 08:18:45', 2, null, '2008-03-30 16:41:36', 'STAFF', '7647966B73'), (90, 1, 'SOLVED', 5, 17, 1, 'CRM Application Issue', '2008-03-17 06:27:06', 3, null, '2008-03-26 15:26:20', 'STAFF', '8613985EC4'), (91, 3, 'SOLVED', 2, 5, 4, 'WEB Mail Doubt', '2008-03-18 10:29:52', 3, null, '2008-03-30 17:14:16', 'STAFF', '54229ABFCF'), (92, 3, 'SOLVED', 1, 22, 2, 'WEB Site Doubt', '2008-03-18 11:47:43', 3, null, '2008-03-21 15:34:30', 'STAFF', '92CC227532'), (93, 3, 'SOLVED', 1, 38, 2, 'WEB Site Issue', '2008-03-18 08:06:34', 2, null, '2008-03-26 15:07:53', 'STAFF', '98DCE83DA5'), (94, 2, 'SOLVED', 8, 11, 2, 'WEB Site Issue', '2008-03-18 10:36:08', 4, null, '2008-03-31 13:41:46', 'STAFF', 'F4B9EC30AD'), (95, 2, 'SOLVED', 6, 18, 6, 'Software Doubt', '2008-03-19 10:03:58', 4, null, '2008-03-27 18:23:27', 'STAFF', '812B4BA287'), (96, 2, 'SOLVED', 9, 39, 5, 'Peripheral Issue', '2008-03-20 09:39:40', 2, null, '2008-03-28 13:01:29', 'STAFF', '26657D5FF9'), (97, 2, 'SOLVED', 1, 22, 2, 'WEB Site Issue', '2008-03-20 07:01:05', 3, null, '2008-04-02 17:57:34', 'STAFF', 'E2EF524FBF'), (98, 2, 'SOLVED', 9, 17, 4, 'WEB Mail Issue', '2008-03-21 08:15:42', 2, null, '2008-03-29 17:10:05', 'STAFF', 'ED3D2C2199'), (99, 2, 'SOLVED', 5, 17, 3, 'Sales Issue', '2008-03-21 11:21:54', 2, null, '2008-04-03 14:35:33', 'STAFF', 'AC627AB1CC'), (100, 2, 'SOLVED', 7, 37, 2, 'WEB Site Issue', '2008-03-21 12:43:17', 4, null, '2008-04-06 18:23:55', 'STAFF', 'F899139DF5'), (101, 2, 'SOLVED', 3, 5, 5, 'Peripheral Doubt', '2008-03-21 07:29:31', 2, null, '2008-03-25 18:33:27', 'STAFF', '38B3EFF8BA'), (102, 3, 'CLOSED', 7, 29, 5, 'Peripheral Issue', '2008-03-21 06:37:39', 2, null, '2008-04-02 17:58:14', 'STAFF', 'EC8956637A'), (103, 3, 'SOLVED', 10, 37, 5, 'Peripheral Issue', '2008-03-21 08:45:42', 4, null, '2008-03-29 18:06:26', 'STAFF', '6974CE5AC6'), (104, 2, 'SOLVED', 4, 1, 1, 'CRM Application Issue', '2008-03-21 07:19:50', 3, null, '2008-04-02 17:56:41', 'STAFF', 'C9E1074F5B'), (105, 2, 'SOLVED', 1, 12, 2, 'WEB Site Issue', '2008-03-22 08:36:26', 3, null, '2008-04-06 18:20:23', 'STAFF', '65B9EEA6E1'), (106, 3, 'CLOSED', 9, 19, 5, 'Peripheral Issue', '2008-03-22 07:48:27', 3, null, '2008-04-05 14:30:25', 'STAFF', 'F0935E4CD5'), (107, 1, 'SOLVED', 2, 35, 6, 'Software Doubt', '2008-03-22 06:40:26', 2, null, '2008-04-10 14:36:17', 'STAFF', 'A97DA629B0'), (108, 1, 'SOLVED', 9, 40, 5, 'Peripheral Doubt', '2008-03-22 06:44:00', 3, null, '2008-03-26 18:21:04', 'STAFF', 'A3C65C2974'), (109, 1, 'SOLVED', 10, 35, 5, 'Peripheral Issue', '2008-03-22 07:19:09', 2, null, '2008-04-04 13:59:01', 'STAFF', '2723D092B6'), (110, 2, 'SOLVED', 4, 38, 6, 'Sotfware Issue', '2008-03-23 10:10:08', 4, null, '2008-04-03 13:50:47', 'STAFF', '5F93F98352'), (111, 2, 'SOLVED', 3, 20, 5, 'Peripheral Issue', '2008-03-23 12:26:29', 3, null, '2008-04-15 18:13:38', 'STAFF', '698D51A19D'), (112, 3, 'SOLVED', 10, 38, 2, 'WEB Site Issue', '2008-03-23 12:12:38', 4, null, '2008-03-27 18:04:09', 'STAFF', '7F6FFAA6BB'), (113, 1, 'SOLVED', 9, 3, 1, 'CRM Application Doubt', '2008-03-23 10:04:59', 2, null, '2008-03-26 15:17:13', 'STAFF', '73278A4A86'), (114, 2, 'SOLVED', 10, 9, 5, 'Peripheral Issue', '2008-03-23 11:09:24', 4, null, '2008-04-02 13:46:50', 'STAFF', '5FD0B37CD7'), (115, 2, 'SOLVED', 2, 10, 1, 'CRM Application Doubt', '2008-03-23 06:49:24', 4, null, '2008-04-06 15:56:13', 'STAFF', '2B44928AE1'), (116, 1, 'SOLVED', 8, 5, 5, 'Peripheral Issue', '2008-03-23 12:58:33', 2, null, '2008-03-25 13:27:14', 'STAFF', 'C45147DEE7'), (117, 2, 'SOLVED', 6, 17, 4, 'WEB Mail Doubt', '2008-03-24 06:14:08', 4, null, '2008-04-09 18:46:08', 'STAFF', 'EB160DE1DE'), (118, 2, 'SOLVED', 1, 19, 2, 'WEB Site Issue', '2008-03-24 10:37:26', 4, null, '2008-03-29 14:56:36', 'STAFF', '5EF059938B'), (119, 3, 'CLOSED', 7, 3, 4, 'WEB Mail Issue', '2008-03-24 10:08:17', 1, null, '2008-03-26 17:22:09', 'STAFF', '07E1CD7DCA'), (120, 2, 'SOLVED', 6, 38, 3, 'Sales Doubt', '2008-03-24 11:58:52', 3, null, '2008-04-05 13:24:24', 'STAFF', 'DA4FB5C6E9'), (121, 1, 'SOLVED', 8, 24, 2, 'WEB Site Issue', '2008-03-24 07:42:34', 2, null, '2008-04-06 18:25:12', 'STAFF', '4C56FF4CE4'), (122, 2, 'SOLVED', 10, 23, 5, 'Peripheral Issue', '2008-03-25 09:32:23', 3, null, '2008-04-05 14:57:42', 'STAFF', 'A0A080F42E'), (123, 2, 'SOLVED', 1, 25, 6, 'Software Issue', '2008-03-25 12:32:40', 2, null, '2008-04-05 13:44:42', 'STAFF', '202CB962AC'), (124, 2, 'SOLVED', 9, 10, 4, 'WEB Mail Issue', '2008-03-25 09:34:58', 2, null, '2008-03-30 14:07:37', 'STAFF', 'C8FFE9A587'), (125, 3, 'SOLVED', 9, 30, 5, 'Peripheral Issue', '2008-03-25 10:24:40', 3, null, '2008-03-26 13:15:25', 'STAFF', '3DEF184AD8'), (126, 2, 'SOLVED', 2, 10, 6, 'Software Issue', '2008-03-26 12:30:16', 2, null, '2008-04-10 15:07:59', 'STAFF', '069059B7EF'), (127, 2, 'SOLVED', 1, 14, 2, 'WEB Site Issue', '2008-03-26 10:24:23', 2, null, '2008-03-28 16:32:24', 'STAFF', 'EC5DECCA5E'), (128, 3, 'SOLVED', 9, 22, 6, 'Sotfware Issue', '2008-03-26 08:55:48', 4, null, '2008-04-05 18:08:09', 'STAFF', '76DC611D6E'), (129, 2, 'SOLVED', 10, 19, 5, 'Peripheral Doubt', '2008-03-26 11:13:41', 2, null, '2008-04-04 14:43:09', 'STAFF', 'D1F491A404'), (130, 3, 'CLOSED', 2, 33, 6, 'Software Issue', '2008-03-26 08:17:14', 1, null, '2008-04-08 15:11:22', 'STAFF', '9B8619251A'), (131, 3, 'SOLVED', 2, 4, 6, 'Software Issue', '2008-03-27 09:26:47', 4, null, '2008-04-11 18:57:40', 'STAFF', '1AFA34A7F9'), (132, 2, 'SOLVED', 10, 22, 2, 'WEB Site Issue', '2008-03-28 10:40:00', 4, null, '2008-04-03 18:20:14', 'STAFF', '65DED5353C'), (133, 2, 'SOLVED', 5, 1, 4, 'WEB Mail Doubt', '2008-03-28 06:13:08', 2, null, '2008-04-10 17:25:29', 'STAFF', '9FC3D7152B'), (134, 2, 'SOLVED', 8, 33, 6, 'Sotfware Issue', '2008-03-28 07:14:28', 4, null, '2008-03-31 18:13:42', 'STAFF', '02522A2B27'), (135, 1, 'SOLVED', 1, 23, 4, 'WEB Mail Doubt', '2008-03-28 10:01:52', 4, null, '2008-04-08 13:40:14', 'STAFF', '7F1DE29E6D'), (136, 2, 'CLOSED', 9, 39, 5, 'Peripheral Issue', '2008-03-28 11:42:23', 1, null, '2008-04-05 15:20:29', 'STAFF', '42A0E188F5'), (137, 2, 'SOLVED', 4, 35, 6, 'Software Doubt', '2008-03-28 11:34:03', 3, null, '2008-04-14 13:12:31', 'STAFF', '3988C7F88E'), (138, 1, 'SOLVED', 10, 8, 5, 'Peripheral Doubt', '2008-03-28 10:37:52', 3, null, '2008-04-01 13:09:22', 'STAFF', '013D407166'), (139, 1, 'SOLVED', 9, 9, 2, 'WEB Site Issue', '2008-03-29 08:11:19', 3, null, '2008-04-02 14:18:17', 'STAFF', 'E00DA03B68'), (140, 2, 'CLOSED', 9, 29, 2, 'WEB Site Issue', '2008-03-29 10:01:15', 1, null, '2008-04-01 17:20:29', 'STAFF', '1385974ED5'), (141, 3, 'SOLVED', 8, 30, 6, 'Sotfware Issue', '2008-03-29 12:49:51', 4, null, '2008-04-02 18:32:51', 'STAFF', '0F28B5D49B'), (142, 1, 'SOLVED', 6, 27, 6, 'Sotfware Issue', '2008-03-29 06:57:04', 2, null, '2008-03-30 14:26:32', 'STAFF', 'A8BAA56554'), (143, 1, 'SOLVED', 2, 36, 6, 'Software Issue', '2008-03-29 08:31:24', 2, null, '2008-04-15 15:26:50', 'STAFF', '903CE9225F'), (144, 2, 'SOLVED', 2, 29, 2, 'WEB Site Issue', '2008-03-30 11:39:44', 3, null, '2008-04-16 18:26:01', 'STAFF', '0A09C8844B'), (145, 1, 'SOLVED', 7, 10, 4, 'WEB Mail Doubt', '2008-03-30 06:39:06', 2, null, '2008-04-16 15:15:40', 'STAFF', '2B24D49505'), (146, 2, 'CLOSED', 3, 32, 3, 'Sales Doubt', '2008-03-30 08:23:51', 2, null, '2008-04-04 14:54:40', 'STAFF', 'A5E0013237'), (147, 1, 'CLOSED', 2, 23, 5, 'Peripheral Doubt', '2008-03-30 06:12:48', 2, null, '2008-04-16 16:03:04', 'STAFF', '8D5E957F29'), (148, 2, 'SOLVED', 3, 37, 6, 'Software Issue', '2008-03-30 11:33:00', 4, null, '2008-04-10 17:17:20', 'STAFF', '47D1E99058'), (149, 3, 'SOLVED', 5, 8, 6, 'Software Doubt', '2008-03-30 10:21:35', 4, null, '2008-04-01 17:09:21', 'STAFF', 'F2217062E9'), (150, 1, 'SOLVED', 4, 28, 1, 'CRM Application Issue', '2008-03-30 10:16:47', 3, null, '2008-04-01 13:26:11', 'STAFF', '7EF605FC8D'), (151, 2, 'SOLVED', 4, 31, 2, 'WEB Site Issue', '2008-03-31 11:59:58', 4, null, '2008-04-11 15:51:53', 'STAFF', 'A8F15EDA80'), (152, 2, 'SOLVED', 7, 22, 2, 'WEB Site Doubt', '2008-03-31 10:04:44', 3, null, '2008-04-13 15:44:47', 'STAFF', '37A749D808'), (153, 3, 'CLOSED', 3, 11, 5, 'Peripheral Doubt', '2008-03-31 11:53:01', 3, null, '2008-04-09 14:10:06', 'STAFF', 'B3E3E393C7'), (154, 1, 'SOLVED', 8, 34, 4, 'WEB Mail Issue', '2008-03-31 11:22:22', 2, null, '2008-04-16 16:37:01', 'STAFF', '1D7F7ABC18'), (155, 2, 'SOLVED', 4, 30, 5, 'Peripheral Doubt', '2008-03-31 12:32:04', 3, null, '2008-04-07 18:06:55', 'STAFF', '2A79EA27C2'), (156, 3, 'SOLVED', 2, 25, 2, 'WEB Site Doubt', '2008-03-31 09:40:34', 3, null, '2008-04-05 16:53:15', 'STAFF', '1C9AC0159C'), (157, 2, 'CLOSED', 4, 1, 6, 'Sotfware Issue', '2008-03-31 10:57:13', 2, null, '2008-04-02 13:38:50', 'STAFF', '6C4B761A28'), (158, 3, 'SOLVED', 3, 31, 1, 'CRM Application Doubt', '2008-03-31 10:51:41', 4, null, '2008-04-11 13:02:31', 'STAFF', 0640966322), (159, 2, 'SOLVED', 9, 3, 2, 'WEB Site Issue', '2008-03-31 08:26:54', 3, null, '2008-04-07 17:32:24', 'STAFF', '140F6969D5'), (160, 2, 'SOLVED', 6, 30, 3, 'Sales Doubt', '2008-04-01 07:42:02', 2, null, '2008-04-08 15:30:29', 'STAFF', 'B73CE398C3'), (161, 3, 'SOLVED', 4, 21, 6, 'Software Doubt', '2008-04-01 12:00:45', 2, null, '2008-04-03 17:50:10', 'STAFF', 'BD4C9AB730'), (162, 1, 'SOLVED', 2, 12, 6, 'Sotfware Issue', '2008-04-01 06:22:05', 2, null, '2008-04-11 18:29:45', 'STAFF', '82AA4B0AF3'), (163, 3, 'SOLVED', 5, 2, 4, 'WEB Mail Doubt', '2008-04-01 06:22:11', 2, null, '2008-04-06 13:55:46', 'STAFF', '0777D5C17D'), (164, 3, 'CLOSED', 10, 35, 2, 'WEB Site Issue', '2008-04-01 07:23:12', 3, null, '2008-04-12 16:01:48', 'STAFF', 'FA7CDFAD1A'), (165, 3, 'CLOSED', 3, 25, 6, 'Software Issue', '2008-04-01 09:42:13', 2, null, '2008-04-04 13:53:37', 'STAFF', '9766527F2B'), (166, 2, 'SOLVED', 8, 35, 1, 'CRM Application Issue', '2008-04-01 11:07:46', 3, null, '2008-04-05 14:01:41', 'STAFF', '7E7757B1E1'), (167, 2, 'CLOSED', 4, 36, 1, 'CRM Application Issue', '2008-04-02 06:00:23', 1, null, '2008-04-06 14:40:36', 'STAFF', '5878A7AB84'), (168, 1, 'SOLVED', 10, 6, 6, 'Software Issue', '2008-04-02 12:22:45', 2, null, '2008-04-06 13:30:44', 'STAFF', '006F52E910'), (169, 1, 'SOLVED', 3, 27, 6, 'Software Doubt', '2008-04-03 12:30:59', 2, null, '2008-04-20 14:47:04', 'STAFF', 3636638817), (170, 1, 'SOLVED', 10, 22, 6, 'Software Doubt', '2008-04-03 06:28:08', 3, null, '2008-04-08 14:31:37', 'STAFF', '149E9677A5'), (171, 1, 'SOLVED', 4, 32, 1, 'CRM Application Issue', '2008-04-04 07:59:05', 2, null, '2008-04-13 17:36:44', 'STAFF', 'A4A042CF4F'), (172, 2, 'SOLVED', 10, 23, 5, 'Peripheral Issue', '2008-04-04 06:36:53', 2, null, '2008-04-12 13:30:25', 'STAFF', '1FF8A7B5DC'), (173, 3, 'CLOSED', 1, 28, 2, 'WEB Site Issue', '2008-04-04 10:33:40', 1, null, '2008-04-13 16:14:42', 'STAFF', 'F7E6C85504'), (174, 2, 'CLOSED', 4, 17, 5, 'Peripheral Doubt', '2008-04-04 09:53:46', 3, null, '2008-04-22 15:45:04', 'STAFF', 'BF8229696F'), (175, 2, 'SOLVED', 8, 6, 1, 'CRM Application Doubt', '2008-04-04 08:03:23', 2, null, '2008-04-10 15:12:14', 'STAFF', 8216124282), (176, 1, 'SOLVED', 10, 10, 6, 'Sotfware Issue', '2008-04-04 09:43:10', 2, null, '2008-04-13 18:23:28', 'STAFF', '38AF86134B'), (177, 2, 'SOLVED', 10, 11, 6, 'Software Doubt', '2008-04-05 07:20:53', 3, null, '2008-04-19 15:14:10', 'STAFF', '96DA2F590C'), (178, 2, 'SOLVED', 5, 21, 1, 'CRM Application Doubt', '2008-04-05 08:04:41', 2, null, '2008-04-10 18:28:30', 'STAFF', '8F85517967'), (179, 1, 'CLOSED', 5, 6, 6, 'Sotfware Issue', '2008-04-05 10:10:06', 2, null, '2008-04-22 14:55:30', 'STAFF', '8F53295A73'), (180, 1, 'SOLVED', 10, 10, 2, 'WEB Site Issue', '2008-04-05 06:00:35', 4, null, '2008-04-09 18:27:37', 'STAFF', '045117B0E0'), (181, 2, 'SOLVED', 9, 11, 6, 'Software Doubt', '2008-04-05 06:17:24', 2, null, '2008-04-09 14:46:34', 'STAFF', 'FC22130974'), (182, 2, 'SOLVED', 9, 10, 5, 'Peripheral Doubt', '2008-04-05 08:01:45', 2, null, '2008-04-10 17:09:04', 'STAFF', '4C5BDE74A8'), (183, 2, 'SOLVED', 4, 37, 1, 'CRM Application Doubt', '2008-04-05 07:40:55', 3, null, '2008-04-09 18:42:06', 'STAFF', 'CEDEBB6E87'), (184, 2, 'SOLVED', 1, 26, 4, 'WEB Mail Issue', '2008-04-06 10:59:01', 4, null, '2008-04-25 15:37:25', 'STAFF', '6CDD60EA00'), (185, 1, 'SOLVED', 9, 28, 5, 'Peripheral Doubt', '2008-04-06 09:43:59', 4, null, '2008-04-14 18:26:22', 'STAFF', 'EECCA5B636'), (186, 2, 'CLOSED', 8, 21, 4, 'WEB Mail Issue', '2008-04-06 12:21:10', 2, null, '2008-04-15 16:37:15', 'STAFF', '9872ED9FC2'), (187, 1, 'SOLVED', 3, 27, 6, 'Software Doubt', '2008-04-06 10:27:02', 4, null, '2008-04-08 13:37:00', 'STAFF', '31FEFC0E57'), (188, 2, 'SOLVED', 10, 27, 4, 'WEB Mail Issue', '2008-04-06 09:17:58', 4, null, '2008-04-11 15:51:50', 'STAFF', '9DCB88E013'), (189, 2, 'SOLVED', 9, 23, 5, 'Peripheral Doubt', '2008-04-06 10:58:53', 2, null, '2008-04-08 17:45:42', 'STAFF', 'A2557A7B2E'), (190, 2, 'SOLVED', 4, 4, 4, 'WEB Mail Issue', '2008-04-06 09:33:40', 4, null, '2008-04-08 14:49:54', 'STAFF', 'CFECDB276F'), (191, 3, 'SOLVED', 1, 35, 3, 'Sales Doubt', '2008-04-06 07:01:58', 2, null, '2008-04-20 14:31:21', 'STAFF', '0AA1883C64'), (192, 2, 'CLOSED', 1, 10, 4, 'WEB Mail Issue', '2008-04-06 10:41:04', 3, null, '2008-04-24 15:10:40', 'STAFF', '58A2FC6ED3'), (193, 1, 'SOLVED', 5, 38, 5, 'Peripheral Issue', '2008-04-06 12:25:17', 3, null, '2008-04-10 13:21:12', 'STAFF', 'BD686FD640'), (194, 2, 'SOLVED', 8, 21, 4, 'WEB Mail Doubt', '2008-04-06 11:35:42', 3, null, '2008-04-12 14:59:20', 'STAFF', 'A597E50502'), (195, 2, 'SOLVED', 5, 3, 5, 'Peripheral Issue', '2008-04-06 11:30:31', 2, null, '2008-04-09 14:57:30', 'STAFF', '0336DCBAB0'), (196, 2, 'SOLVED', 4, 25, 3, 'Sales Issue', '2008-04-06 10:39:13', 3, null, '2008-04-12 16:16:24', 'STAFF', '084B6FBB10'), (197, 2, 'SOLVED', 10, 26, 3, 'Sales Issue', '2008-04-07 10:13:26', 4, null, '2008-04-17 18:55:41', 'STAFF', '85D8CE590A'), (198, 2, 'SOLVED', 6, 31, 4, 'WEB Mail Doubt', '2008-04-07 12:01:27', 2, null, '2008-04-23 17:04:47', 'STAFF', '0E65972DCE'), (199, 1, 'SOLVED', 2, 13, 1, 'CRM Application Doubt', '2008-04-07 09:47:28', 2, null, '2008-04-19 15:55:16', 'STAFF', '84D9EE44E4'), (200, 3, 'SOLVED', 2, 26, 3, 'Sales Doubt', '2008-04-07 10:21:09', 2, null, '2008-04-23 17:05:51', 'STAFF', '3644A684F9'), (201, 3, 'CLOSED', 10, 32, 3, 'Sales Doubt', '2008-04-07 09:32:08', 2, null, '2008-04-15 14:21:18', 'STAFF', '757B505CFD'), (202, 1, 'SOLVED', 10, 3, 4, 'WEB Mail Doubt', '2008-04-07 06:07:11', 4, null, '2008-04-11 15:33:49', 'STAFF', '854D6FAE5E'), (203, 2, 'SOLVED', 2, 39, 1, 'CRM Application Issue', '2008-04-07 09:33:06', 2, null, '2008-04-09 18:49:48', 'STAFF', 'E2C0BE2456'), (204, 1, 'CLOSED', 2, 18, 6, 'Software Issue', '2008-04-07 08:53:15', 3, null, '2008-04-07 15:40:26', 'STAFF', '274AD4786C'), (205, 1, 'SOLVED', 9, 31, 5, 'Peripheral Issue', '2008-04-07 12:46:55', 4, null, '2008-04-23 18:41:42', 'STAFF', 'EAE27D77CA'), (206, 3, 'SOLVED', 9, 26, 5, 'Peripheral Issue', '2008-04-08 11:04:30', 2, null, '2008-04-21 18:57:00', 'STAFF', '7EABE3A164'), (207, 2, 'SOLVED', 8, 10, 4, 'WEB Mail Doubt', '2008-04-08 06:10:15', 3, null, '2008-04-23 15:12:06', 'STAFF', '69ADC1E107'), (208, 2, 'SOLVED', 8, 38, 6, 'Software Issue', '2008-04-08 11:59:05', 2, null, '2008-04-15 18:01:42', 'STAFF', '091D584FCE'), (209, 2, 'SOLVED', 6, 10, 6, 'Sotfware Issue', '2008-04-08 07:57:00', 4, null, '2008-04-12 14:05:25', 'STAFF', 'B1D10E7BAF'), (210, 2, 'CLOSED', 10, 21, 2, 'WEB Site Issue', '2008-04-08 07:01:04', 1, null, '2008-04-17 15:53:22', 'STAFF', '6F3EF77AC0'), (211, 3, 'SOLVED', 10, 28, 3, 'Sales Doubt', '2008-04-08 08:47:04', 2, null, '2008-04-12 17:11:58', 'STAFF', 'EB16372791'), (212, 2, 'SOLVED', 1, 12, 6, 'Software Issue', '2008-04-08 07:36:49', 3, null, '2008-04-19 14:02:29', 'STAFF', '1534B76D32'), (213, 3, 'SOLVED', 3, 21, 6, 'Software Doubt', '2008-04-08 06:57:11', 3, null, '2008-04-13 17:30:02', 'STAFF', '979D472A84'), (214, 2, 'SOLVED', 10, 19, 6, 'Sotfware Issue', '2008-04-09 10:49:04', 3, null, '2008-04-23 16:02:23', 'STAFF', 'CA46C1B951'), (215, 1, 'CLOSED', 3, 40, 6, 'Software Doubt', '2008-04-11 12:03:57', 1, null, '2008-04-13 14:16:42', 'STAFF', '3B8A614226'), (216, 2, 'SOLVED', 9, 8, 6, 'Sotfware Issue', '2008-04-11 06:40:25', 2, null, '2008-04-28 14:49:17', 'STAFF', '45FBC6D3E0'), (217, 1, 'SOLVED', 10, 30, 2, 'WEB Site Doubt', '2008-04-11 06:16:02', 2, null, '2008-04-24 13:19:00', 'STAFF', '63DC7ED101'), (218, 2, 'SOLVED', 9, 33, 4, 'WEB Mail Doubt', '2008-04-11 09:38:29', 3, null, '2008-04-11 14:08:53', 'STAFF', 'E96ED478DA'), (219, 2, 'CLOSED', 5, 37, 4, 'WEB Mail Doubt', '2008-04-11 10:51:02', 1, null, '2008-04-26 14:41:40', 'STAFF', 'C0E190D826'), (220, 2, 'SOLVED', 6, 6, 6, 'Software Issue', '2008-04-11 08:56:35', 2, null, '2008-04-23 14:54:19', 'STAFF', 'EC8CE6ABB3'), (221, 2, 'SOLVED', 9, 23, 5, 'Peripheral Issue', '2008-04-11 08:09:41', 2, null, '2008-04-22 17:17:58', 'STAFF', '060AD92489'), (222, 2, 'SOLVED', 4, 31, 4, 'WEB Mail Doubt', '2008-04-11 06:01:47', 3, null, '2008-04-22 14:58:02', 'STAFF', 'BCBE3365E6'), (223, 1, 'SOLVED', 5, 19, 4, 'WEB Mail Issue', '2008-04-12 12:24:44', 3, null, '2008-04-19 18:36:42', 'STAFF', '115F895031'), (224, 2, 'SOLVED', 6, 11, 3, 'Sales Doubt', '2008-04-12 11:22:21', 3, null, '2008-04-15 17:10:03', 'STAFF', '13FE9D8431'), (225, 2, 'CLOSED', 10, 15, 6, 'Sotfware Issue', '2008-04-12 11:10:40', 2, null, '2008-04-14 14:00:22', 'STAFF', 'D1C38A09AC'), (226, 2, 'CLOSED', 6, 20, 3, 'Sales Issue', '2008-04-12 06:31:13', 3, null, '2008-04-22 16:00:42', 'STAFF', '9CFDF10E8F'), (227, 2, 'SOLVED', 7, 38, 4, 'WEB Mail Issue', '2008-04-12 09:40:53', 2, null, '2008-04-19 13:41:29', 'STAFF', '705F217283'), (228, 1, 'SOLVED', 1, 31, 2, 'WEB Site Issue', '2008-04-12 08:13:51', 2, null, '2008-04-15 14:30:22', 'STAFF', '74DB120F0A'), (229, 2, 'CLOSED', 1, 33, 5, 'Peripheral Issue', '2008-04-12 12:29:46', 2, null, '2008-04-15 14:14:14', 'STAFF', '57AEEE35C9'), (230, 1, 'SOLVED', 1, 17, 3, 'Sales Issue', '2008-04-12 07:27:23', 2, null, '2008-04-20 17:35:12', 'STAFF', '6DA9003B74'), (231, 1, 'CLOSED', 1, 6, 1, 'CRM Application Doubt', '2008-04-12 09:17:23', 2, null, '2008-04-12 13:42:58', 'STAFF', '9B04D15284'), (232, 2, 'SOLVED', 10, 32, 1, 'CRM Application Issue', '2008-04-12 12:42:20', 2, null, '2008-04-16 14:14:38', 'STAFF', 'BE83AB3ECD'), (233, 2, 'CLOSED', 6, 32, 2, 'WEB Site Issue', '2008-04-13 11:14:17', 2, null, '2008-04-14 15:56:40', 'STAFF', 'E165421110'), (234, 2, 'SOLVED', 6, 22, 5, 'Peripheral Doubt', '2008-04-13 07:31:01', 2, null, '2008-04-18 17:00:25', 'STAFF', '289DFF0766'), (235, 3, 'SOLVED', 5, 15, 5, 'Peripheral Issue', '2008-04-13 12:15:27', 3, null, '2008-04-27 15:11:10', 'STAFF', '577EF1154F'), (236, 3, 'SOLVED', 10, 27, 3, 'Sales Doubt', '2008-04-13 07:43:43', 3, null, '2008-04-13 16:24:51', 'STAFF', '01161AAA0B'), (237, 1, 'SOLVED', 5, 38, 6, 'Software Issue', '2008-04-13 06:42:21', 2, null, '2008-04-18 13:02:47', 'STAFF', '539FD53B59'), (238, 2, 'CLOSED', 10, 7, 5, 'Peripheral Issue', '2008-04-13 06:55:22', 1, null, '2008-04-22 16:18:55', 'STAFF', 'AC1DD209CB'), (239, 2, 'SOLVED', 5, 31, 4, 'WEB Mail Issue', '2008-04-13 09:07:58', 2, null, '2008-04-15 14:02:15', 'STAFF', '555D6702C9'), (240, 1, 'SOLVED', 1, 30, 4, 'WEB Mail Issue', '2008-04-13 12:39:09', 3, null, '2008-04-26 17:42:20', 'STAFF', '335F535208'), (241, 3, 'SOLVED', 8, 5, 6, 'Software Doubt', '2008-04-13 09:55:39', 4, null, '2008-04-24 17:32:14', 'STAFF', 'F340F1B1F6'), (242, 1, 'SOLVED', 10, 21, 2, 'WEB Site Issue', '2008-04-13 11:16:43', 3, null, '2008-04-25 15:10:03', 'STAFF', 'E4A6222CDB'), (243, 1, 'SOLVED', 2, 36, 1, 'CRM Application Issue', '2008-04-13 12:17:45', 3, null, '2008-04-16 14:11:15', 'STAFF', 'CB70AB3756'), (244, 2, 'SOLVED', 1, 37, 6, 'Software Doubt', '2008-04-13 07:32:57', 4, null, '2008-04-17 18:09:15', 'STAFF', '9188905E74'), (245, 2, 'CLOSED', 5, 31, 4, 'WEB Mail Doubt', '2008-04-13 08:39:57', 2, null, '2008-04-19 16:11:17', 'STAFF', '0266E33D3F'), (246, 1, 'SOLVED', 4, 28, 1, 'CRM Application Issue', '2008-04-13 09:32:03', 2, null, '2008-04-26 17:44:52', 'STAFF', '38DB3AED92'), (247, 2, 'CLOSED', 9, 23, 6, 'Software Issue', '2008-04-13 12:03:28', 1, null, '2008-04-17 16:36:21', 'STAFF', '3CEC07E9BA'), (248, 1, 'SOLVED', 2, 24, 6, 'Software Issue', '2008-04-14 12:30:11', 4, null, '2008-04-14 18:32:37', 'STAFF', '621BF66DDB'), (249, 2, 'CLOSED', 6, 32, 2, 'WEB Site Issue', '2008-04-14 08:32:27', 1, null, '2008-04-16 17:20:21', 'STAFF', '077E29B11B'), (250, 2, 'SOLVED', 7, 39, 1, 'CRM Application Doubt', '2008-04-14 11:14:54', 4, null, '2008-04-19 15:57:56', 'STAFF', '6C9882BBAC'), (251, 2, 'SOLVED', 2, 40, 4, 'WEB Mail Issue', '2008-04-14 11:58:41', 3, null, '2008-04-19 14:14:45', 'STAFF', '19F3CD308F'), (252, 3, 'SOLVED', 2, 11, 6, 'Software Issue', '2008-04-14 11:40:10', 4, null, '2008-04-14 17:45:29', 'STAFF', '03C6B06952'), (253, 3, 'SOLVED', 10, 38, 5, 'Peripheral Doubt', '2008-04-14 12:02:56', 4, null, '2008-04-25 17:28:27', 'STAFF', 'C24CD76E1C'), (254, 3, 'SOLVED', 3, 12, 2, 'WEB Site Issue', '2008-04-14 10:25:30', 4, null, '2008-04-23 13:01:07', 'STAFF', 'C52F1BD66C'), (255, 2, 'CLOSED', 8, 37, 4, 'WEB Mail Issue', '2008-04-15 12:48:22', 3, null, '2008-04-25 15:13:51', 'STAFF', 'FE131D7F5A'), (256, 3, 'CLOSED', 10, 5, 4, 'WEB Mail Doubt', '2008-04-15 09:32:56', 1, null, '2008-04-23 15:08:55', 'STAFF', 'F718499C1C'), (257, 1, 'SOLVED', 7, 19, 1, 'CRM Application Doubt', '2008-04-15 08:09:34', 2, null, '2008-04-15 15:42:58', 'STAFF', 'D96409BF89'), (258, 2, 'SOLVED', 2, 11, 5, 'Peripheral Issue', '2008-04-15 12:36:03', 4, null, '2008-04-23 13:45:17', 'STAFF', '502E4A1693'), (259, 1, 'SOLVED', 10, 7, 1, 'CRM Application Issue', '2008-04-15 09:45:02', 2, null, '2008-04-20 13:08:50', 'STAFF', 'CFA0860E83'), (260, 3, 'SOLVED', 9, 24, 6, 'Software Issue', '2008-04-15 09:04:37', 3, null, '2008-04-16 18:29:10', 'STAFF', 'A4F23670E1'), (261, 1, 'SOLVED', 9, 11, 2, 'WEB Site Issue', '2008-04-15 08:24:38', 2, null, '2008-04-24 14:10:59', 'STAFF', 'B1A59B315F'), (262, 1, 'SOLVED', 5, 23, 1, 'CRM Application Doubt', '2008-04-15 07:21:35', 4, null, '2008-04-22 16:46:09', 'STAFF', '36660E5985'), (263, 1, 'SOLVED', 9, 39, 4, 'WEB Mail Doubt', '2008-04-16 11:28:49', 3, null, '2008-04-23 18:41:07', 'STAFF', '8C19F571E2'), (264, 3, 'SOLVED', 1, 12, 4, 'WEB Mail Issue', '2008-04-16 10:02:39', 4, null, '2008-04-27 17:56:39', 'STAFF', 'D6BAF65E0B'), (265, 2, 'SOLVED', 7, 21, 1, 'CRM Application Issue', '2008-04-16 09:44:25', 2, null, '2008-05-01 15:59:33', 'STAFF', 'E56954B4F6'), (266, 3, 'SOLVED', 2, 38, 5, 'Peripheral Doubt', '2008-04-16 08:48:23', 2, null, '2008-04-18 17:28:12', 'STAFF', 'F7664060CC'), (267, 1, 'SOLVED', 5, 25, 5, 'Peripheral Doubt', '2008-04-17 08:14:41', 2, null, '2008-04-25 14:07:42', 'STAFF', 'EDA80A3D5B'), (268, 2, 'SOLVED', 5, 30, 5, 'Peripheral Issue', '2008-04-18 11:54:45', 3, null, '2008-04-24 14:07:28', 'STAFF', '8F121CE07D'), (269, 2, 'SOLVED', 10, 37, 6, 'Software Issue', '2008-04-18 10:16:48', 2, null, '2008-04-19 13:42:51', 'STAFF', '06138BC5AF'), (270, 3, 'SOLVED', 7, 31, 6, 'Software Issue', '2008-04-18 12:13:31', 2, null, '2008-05-04 17:13:37', 'STAFF', '39059724F7'), (271, 2, 'CLOSED', 8, 11, 4, 'WEB Mail Issue', '2008-04-18 06:47:38', 3, null, '2008-04-23 16:12:51', 'STAFF', '7F100B7B36'), (272, 2, 'SOLVED', 8, 10, 2, 'WEB Site Issue', '2008-04-18 10:56:55', 3, null, '2008-04-26 14:04:37', 'STAFF', '7A614FD06C'), (273, 1, 'SOLVED', 6, 31, 4, 'WEB Mail Doubt', '2008-04-18 06:23:44', 2, null, '2008-04-19 17:01:25', 'STAFF', '4734BA6F3D'), (274, 1, 'SOLVED', 6, 32, 1, 'CRM Application Doubt', '2008-04-18 08:02:53', 3, null, '2008-04-27 15:50:22', 'STAFF', 'D947BF06A8'), (275, 2, 'SOLVED', 1, 27, 5, 'Peripheral Issue', '2008-04-19 06:10:52', 2, null, '2008-05-01 18:54:27', 'STAFF', '63923F49E5'), (276, 1, 'CLOSED', 6, 37, 5, 'Peripheral Issue', '2008-04-19 06:32:43', 1, null, '2008-04-27 14:12:02', 'STAFF', 'DB8E1AF0CB'), (277, 2, 'SOLVED', 2, 19, 5, 'Peripheral Doubt', '2008-04-19 10:17:09', 4, null, '2008-04-25 15:08:03', 'STAFF', '20F07591C6'), (278, 3, 'SOLVED', 5, 15, 6, 'Software Issue', '2008-04-19 12:43:40', 2, null, '2008-05-02 13:16:43', 'STAFF', '07CDFD2337'), (279, 3, 'SOLVED', 4, 7, 5, 'Peripheral Issue', '2008-04-19 10:18:34', 3, null, '2008-04-24 13:23:44', 'STAFF', 'D395771085'), (280, 1, 'CLOSED', 10, 6, 3, 'Sales Doubt', '2008-04-19 08:13:03', 1, null, '2008-05-01 17:55:20', 'STAFF', '92C8C96E4C'), (281, 2, 'CLOSED', 1, 8, 5, 'Peripheral Doubt', '2008-04-19 09:01:45', 3, null, '2008-04-21 18:29:39', 'STAFF', 'E3796AE838'), (282, 2, 'SOLVED', 10, 9, 6, 'Sotfware Issue', '2008-04-19 07:26:25', 4, null, '2008-04-21 13:11:42', 'STAFF', '6A9AEDDFC6'), (283, 2, 'SOLVED', 1, 38, 6, 'Software Doubt', '2008-04-20 09:17:57', 2, null, '2008-04-21 13:39:17', 'STAFF', '0F49C89D1E'), (284, 2, 'SOLVED', 7, 26, 6, 'Software Issue', '2008-04-20 10:23:46', 4, null, '2008-04-20 16:19:38', 'STAFF', '46BA9F2A69'), (285, 2, 'SOLVED', 8, 4, 2, 'WEB Site Issue', '2008-04-20 11:23:30', 3, null, '2008-04-28 17:59:57', 'STAFF', '0E01938FC4'), (286, 2, 'SOLVED', 2, 27, 4, 'WEB Mail Doubt', '2008-04-20 11:41:57', 3, null, '2008-04-26 13:08:51', 'STAFF', '16A5CDAE36'), (287, 3, 'SOLVED', 8, 11, 6, 'Software Doubt', '2008-04-20 07:34:01', 4, null, '2008-04-25 14:02:01', 'STAFF', '918317B579'), (288, 2, 'CLOSED', 9, 11, 1, 'CRM Application Issue', '2008-04-20 09:09:26', 3, null, '2008-05-01 17:02:21', 'STAFF', '48AEDB8880'), (289, 2, 'SOLVED', 9, 23, 4, 'WEB Mail Issue', '2008-04-20 11:25:13', 4, null, '2008-04-27 15:16:46', 'STAFF', '839AB46820'), (290, 2, 'SOLVED', 1, 5, 5, 'Peripheral Doubt', '2008-04-20 10:57:38', 2, null, '2008-05-01 18:52:00', 'STAFF', 'F90F2ACA5C'), (291, 3, 'SOLVED', 9, 6, 5, 'Peripheral Doubt', '2008-04-20 08:14:51', 2, null, '2008-04-23 15:04:09', 'STAFF', '9C838D2E45'), (292, 2, 'CLOSED', 9, 21, 3, 'Sales Doubt', '2008-04-21 09:41:15', 2, null, '2008-04-26 14:54:26', 'STAFF', 1700002963), (293, 3, 'CLOSED', 10, 6, 5, 'Peripheral Issue', '2008-04-21 06:55:35', 2, null, '2008-04-22 13:24:32', 'STAFF', '53C3BCE66E'), (294, 1, 'SOLVED', 8, 19, 6, 'Software Issue', '2008-04-21 11:33:47', 4, null, '2008-04-23 14:41:15', 'STAFF', '6883966FD8'), (295, 2, 'CLOSED', 6, 36, 6, 'Software Doubt', '2008-04-21 11:11:38', 1, null, '2008-04-23 17:13:27', 'STAFF', '49182F81E6'), (296, 1, 'SOLVED', 5, 23, 1, 'CRM Application Doubt', '2008-04-21 07:26:51', 4, null, '2008-05-01 14:42:29', 'STAFF', 'D296C101DA'), (297, 2, 'SOLVED', 9, 38, 4, 'WEB Mail Doubt', '2008-04-21 07:05:51', 4, null, '2008-05-01 13:11:27', 'STAFF', '9FD81843AD'), (298, 2, 'SOLVED', 7, 13, 2, 'WEB Site Issue', '2008-04-21 10:30:35', 3, null, '2008-04-23 15:17:39', 'STAFF', '26E359E838'), (299, 3, 'SOLVED', 10, 22, 6, 'Software Issue', '2008-04-21 10:03:00', 2, null, '2008-04-23 16:06:59', 'STAFF', 'EF0D3930A7'), (300, 2, 'SOLVED', 10, 32, 1, 'CRM Application Doubt', '2008-04-21 07:38:05', 4, null, '2008-05-04 13:44:20', 'STAFF', '94F6D7E04A'), (301, 2, 'SOLVED', 5, 19, 5, 'Peripheral Issue', '2008-04-21 08:09:26', 2, null, '2008-05-06 13:41:39', 'STAFF', '34ED066DF3'), (302, 2, 'SOLVED', 10, 16, 2, 'WEB Site Issue', '2008-04-22 12:58:46', 3, null, '2008-05-05 15:02:28', 'STAFF', '577BCC914F'), (303, 3, 'SOLVED', 1, 36, 5, 'Peripheral Issue', '2008-04-22 07:47:00', 2, null, '2008-05-04 18:08:16', 'STAFF', '11B9842E0A'), (304, 2, 'SOLVED', 10, 40, 5, 'Peripheral Issue', '2008-04-22 08:31:01', 3, null, '2008-05-06 17:05:47', 'STAFF', '37BC2F75BF'), (305, 2, 'SOLVED', 6, 30, 5, 'Peripheral Issue', '2008-04-22 11:18:10', 4, null, '2008-05-05 18:23:31', 'STAFF', '496E05E1AE'), (306, 2, 'SOLVED', 9, 36, 6, 'Software Issue', '2008-04-22 06:01:38', 2, null, '2008-05-04 16:40:03', 'STAFF', 'B2EB734903'), (307, 2, 'CLOSED', 1, 30, 6, 'Software Doubt', '2008-04-22 06:12:57', 2, null, '2008-04-26 18:13:16', 'STAFF', '8E98D81F82'), (308, 2, 'SOLVED', 7, 17, 6, 'Sotfware Issue', '2008-04-22 12:52:57', 4, null, '2008-05-02 13:38:08', 'STAFF', 'A8C88A0055'), (309, 1, 'SOLVED', 6, 38, 4, 'WEB Mail Doubt', '2008-04-22 09:12:19', 3, null, '2008-04-27 18:12:52', 'STAFF', 'EDDEA82AD2'), (310, 2, 'CLOSED', 5, 19, 6, 'Sotfware Issue', '2008-04-23 11:40:32', 2, null, '2008-05-05 14:08:06', 'STAFF', '06EB61B839'), (311, 2, 'CLOSED', 2, 31, 5, 'Peripheral Issue', '2008-04-23 11:41:10', 1, null, '2008-04-25 13:15:24', 'STAFF', '9DFCD5E558'), (312, 2, 'SOLVED', 9, 21, 6, 'Sotfware Issue', '2008-04-23 10:04:06', 4, null, '2008-05-01 18:42:40', 'STAFF', '950A4152C2'), (313, 2, 'SOLVED', 9, 23, 1, 'CRM Application Issue', '2008-04-23 11:32:43', 2, null, '2008-04-27 18:58:53', 'STAFF', '158F3069A4'), (314, 1, 'CLOSED', 9, 5, 6, 'Software Issue', '2008-04-24 09:59:42', 2, null, '2008-04-28 13:24:49', 'STAFF', '758874998F'), (315, 2, 'SOLVED', 5, 28, 5, 'Peripheral Doubt', '2008-04-25 12:06:54', 4, null, '2008-04-25 14:26:58', 'STAFF', 'AD13A2A07C'), (316, 2, 'SOLVED', 1, 27, 4, 'WEB Mail Doubt', '2008-04-25 09:09:46', 3, null, '2008-05-04 14:36:08', 'STAFF', '3FE94A0023'), (317, 2, 'SOLVED', 10, 38, 6, 'Sotfware Issue', '2008-04-25 10:20:56', 2, null, '2008-05-06 18:59:49', 'STAFF', '5B8ADD2A5D'), (318, 2, 'CLOSED', 1, 39, 4, 'WEB Mail Issue', '2008-04-25 06:42:46', 2, null, '2008-05-07 16:46:58', 'STAFF', '432ACA3A1E'), (319, 2, 'SOLVED', 5, 23, 6, 'Software Doubt', '2008-04-25 08:01:57', 2, null, '2008-05-11 14:38:50', 'STAFF', '8D3BBA7425'), (320, 2, 'SOLVED', 6, 32, 1, 'CRM Application Doubt', '2008-04-25 06:28:05', 2, null, '2008-05-06 15:38:06', 'STAFF', '320722549D'), (321, 2, 'SOLVED', 1, 3, 4, 'WEB Mail Doubt', '2008-04-26 09:29:29', 3, null, '2008-05-15 17:53:14', 'STAFF', 'CAF1A3DFB5'), (322, 2, 'CLOSED', 5, 38, 6, 'Software Issue', '2008-04-26 10:32:03', 3, null, '2008-04-27 17:24:32', 'STAFF', '5737C6EC2E'), (323, 1, 'SOLVED', 1, 7, 2, 'WEB Site Doubt', '2008-04-26 12:34:36', 2, null, '2008-05-06 16:45:14', 'STAFF', 'BC6DC48B74'), (324, 2, 'SOLVED', 9, 32, 4, 'WEB Mail Doubt', '2008-04-26 12:03:28', 4, null, '2008-05-08 18:50:44', 'STAFF', 'F2FC990265'), (325, 2, 'SOLVED', 5, 33, 4, 'WEB Mail Doubt', '2008-04-26 09:33:55', 3, null, '2008-04-28 14:12:47', 'STAFF', '89F0FD5C92'), (326, 2, 'SOLVED', 10, 28, 1, 'CRM Application Issue', '2008-04-27 12:46:22', 3, null, '2008-05-09 17:50:09', 'STAFF', 'A666587AFD'), (327, 2, 'SOLVED', 1, 9, 5, 'Peripheral Issue', '2008-04-27 06:15:50', 3, null, '2008-05-01 16:48:04', 'STAFF', 'B83AAC23B9'), (328, 2, 'SOLVED', 6, 31, 5, 'Peripheral Issue', '2008-04-27 09:35:36', 3, null, '2008-05-15 17:30:31', 'STAFF', 'CD00692C3B'), (329, 3, 'SOLVED', 1, 19, 2, 'WEB Site Doubt', '2008-04-27 08:41:00', 3, null, '2008-05-08 18:41:39', 'STAFF', '6FAA8040DA'), (330, 2, 'SOLVED', 9, 23, 4, 'WEB Mail Issue', '2008-04-27 07:53:49', 4, null, '2008-05-03 15:39:57', 'STAFF', 'FE73F687E5'), (331, 1, 'SOLVED', 9, 33, 4, 'WEB Mail Issue', '2008-04-27 11:08:24', 2, null, '2008-05-04 15:08:26', 'STAFF', '6DA37DD313'), (332, 2, 'SOLVED', 2, 3, 4, 'WEB Mail Issue', '2008-04-27 07:41:10', 4, null, '2008-05-02 17:12:53', 'STAFF', 'C042F4DB68'), (333, 3, 'SOLVED', 8, 1, 6, 'Sotfware Issue', '2008-04-27 09:50:11', 2, null, '2008-04-27 18:28:17', 'STAFF', '310DCBBF4C'), (334, 1, 'CLOSED', 10, 24, 6, 'Software Issue', '2008-04-27 11:54:53', 1, null, '2008-05-08 15:56:54', 'STAFF', '2F2B265625'), (335, 2, 'SOLVED', 1, 2, 6, 'Software Issue', '2008-04-27 07:56:47', 2, null, '2008-05-02 16:59:17', 'STAFF', 'F9B902FC32'), (336, 3, 'SOLVED', 5, 31, 5, 'Peripheral Doubt', '2008-04-27 10:47:52', 3, null, '2008-05-08 15:49:05', 'STAFF', '6855456E2F'), (337, 2, 'SOLVED', 6, 19, 6, 'Software Doubt', '2008-04-27 07:49:29', 3, null, '2008-05-01 14:51:43', 'STAFF', '357A6FDF76'), (338, 2, 'SOLVED', 10, 37, 5, 'Peripheral Doubt', '2008-04-28 06:40:09', 4, null, '2008-04-28 14:21:36', 'STAFF', '819F46E52C'), (339, 2, 'SOLVED', 9, 37, 5, 'Peripheral Doubt', '2008-04-28 12:18:20', 2, null, '2008-05-01 17:32:48', 'STAFF', '04025959B1'), (340, 2, 'SOLVED', 9, 1, 3, 'Sales Doubt', '2008-04-28 08:49:37', 3, null, '2008-05-14 13:10:59', 'STAFF', '40008B9A53'), (341, 3, 'SOLVED', 10, 17, 6, 'Software Doubt', '2008-04-28 07:18:11', 4, null, '2008-05-01 18:20:00', 'STAFF', '3DD48AB31D'), (342, 2, 'SOLVED', 5, 37, 3, 'Sales Doubt', '2008-04-28 06:41:16', 2, null, '2008-05-06 17:38:00', 'STAFF', '58238E9AE2'), (343, 2, 'SOLVED', 10, 35, 4, 'WEB Mail Doubt', '2008-04-28 06:03:57', 4, null, '2008-05-10 15:38:00', 'STAFF', '3AD7C2EBB9'), (344, 1, 'SOLVED', 5, 22, 2, 'WEB Site Issue', '2008-04-28 07:17:34', 4, null, '2008-05-02 17:09:54', 'STAFF', 'B3967A0E93'), (345, 2, 'SOLVED', 6, 1, 4, 'WEB Mail Doubt', '2008-04-28 07:11:32', 2, null, '2008-05-06 17:46:36', 'STAFF', 'D81F9C1BE2'), (346, 2, 'SOLVED', 2, 22, 4, 'WEB Mail Doubt', '2008-05-01 12:57:34', 4, null, '2008-05-01 13:19:58', 'STAFF', '13F9896DF6'), (347, 2, 'SOLVED', 8, 38, 4, 'WEB Mail Doubt', '2008-05-01 12:18:37', 3, null, '2008-05-07 17:52:45', 'STAFF', 'C5FF2543B5'), (348, 2, 'SOLVED', 3, 1, 6, 'Software Doubt', '2008-05-01 09:45:02', 2, null, '2008-05-01 14:46:08', 'STAFF', '01386BD6D8'), (349, 2, 'SOLVED', 10, 1, 5, 'Peripheral Issue', '2008-05-01 10:17:32', 4, null, '2008-05-11 13:24:14', 'STAFF', '0BB4AEC171'), (350, 2, 'SOLVED', 6, 2, 5, 'Peripheral Doubt', '2008-05-01 11:19:20', 2, null, '2008-05-04 16:08:09', 'STAFF', '9DE6D14FFF'), (351, 2, 'SOLVED', 10, 37, 6, 'Software Doubt', '2008-05-01 07:04:52', 4, null, '2008-05-09 13:16:56', 'STAFF', 'EFE937780E'), (352, 2, 'SOLVED', 2, 35, 6, 'Software Doubt', '2008-05-02 10:07:52', 2, null, '2008-05-07 16:15:30', 'STAFF', '371BCE7DC8'), (353, 3, 'SOLVED', 2, 10, 3, 'Sales Doubt', '2008-05-03 10:32:41', 4, null, '2008-05-13 14:13:32', 'STAFF', '138BB06965'), (354, 2, 'SOLVED', 5, 29, 6, 'Software Doubt', '2008-05-03 10:16:16', 3, null, '2008-05-17 13:16:05', 'STAFF', '8DD48D6A2E'), (355, 1, 'CLOSED', 5, 1, 1, 'CRM Application Doubt', '2008-05-03 10:31:43', 3, null, '2008-05-09 17:59:27', 'STAFF', '82CEC96096'), (356, 2, 'SOLVED', 6, 34, 5, 'Peripheral Issue', '2008-05-03 10:08:29', 2, null, '2008-05-05 16:02:53', 'STAFF', '6C524F9D5D'), (357, 1, 'SOLVED', 9, 35, 2, 'WEB Site Issue', '2008-05-03 11:40:32', 2, null, '2008-05-14 13:15:24', 'STAFF', 'FB7B9FFA54'), (358, 2, 'SOLVED', 10, 32, 6, 'Software Issue', '2008-05-03 07:56:30', 4, null, '2008-05-05 13:39:56', 'STAFF', 'AA942AB2BF'), (359, 1, 'SOLVED', 7, 32, 2, 'WEB Site Doubt', '2008-05-03 07:02:37', 4, null, '2008-05-10 17:01:12', 'STAFF', 'C058F544C7'), (360, 3, 'SOLVED', 1, 1, 1, 'CRM Application Issue', '2008-05-03 11:36:38', 3, null, '2008-05-13 14:06:28', 'STAFF', 'E7B24B112A'), (361, 1, 'SOLVED', 2, 27, 3, 'Sales Doubt', '2008-05-03 06:44:49', 4, null, '2008-05-23 15:45:54', 'STAFF', '52720E0035'), (362, 3, 'SOLVED', 10, 7, 6, 'Software Doubt', '2008-05-04 10:04:24', 3, null, '2008-05-17 14:25:58', 'STAFF', 'C3E878E27F'), (363, 2, 'SOLVED', 10, 32, 3, 'Sales Doubt', '2008-05-04 08:58:40', 3, null, '2008-05-09 17:38:10', 'STAFF', '00411460F7'), (364, 1, 'SOLVED', 2, 33, 2, 'WEB Site Doubt', '2008-05-04 06:41:56', 4, null, '2008-05-17 18:07:06', 'STAFF', 'BAC9162B47'), (365, 3, 'CLOSED', 4, 38, 5, 'Peripheral Issue', '2008-05-04 07:10:59', 3, null, '2008-05-07 18:41:50', 'STAFF', '9BE40CEE5B'), (366, 2, 'SOLVED', 6, 32, 4, 'WEB Mail Doubt', '2008-05-04 08:00:34', 4, null, '2008-05-11 13:35:40', 'STAFF', '5EF698CD9F'), (367, 2, 'CLOSED', 10, 37, 6, 'Software Issue', '2008-05-05 09:55:23', 3, null, '2008-05-07 17:13:29', 'STAFF', '05049E90FA'), (368, 1, 'SOLVED', 10, 8, 3, 'Sales Doubt', '2008-05-05 07:56:41', 3, null, '2008-05-11 14:47:56', 'STAFF', 'CF004FDC76'), (369, 1, 'SOLVED', 5, 36, 4, 'WEB Mail Issue', '2008-05-05 11:57:46', 2, null, '2008-05-10 16:58:14', 'STAFF', '0C74B7F784'), (370, 3, 'CLOSED', 9, 38, 6, 'Software Issue', '2008-05-05 06:58:31', 3, null, '2008-05-20 16:26:13', 'STAFF', 'D709F38EF7'), (371, 3, 'SOLVED', 9, 24, 5, 'Peripheral Doubt', '2008-05-05 08:34:34', 2, null, '2008-05-11 18:30:36', 'STAFF', '41F1F19176'), (372, 2, 'SOLVED', 10, 35, 3, 'Sales Doubt', '2008-05-05 11:01:43', 2, null, '2008-05-18 17:03:46', 'STAFF', '24B16FEDE9'), (373, 3, 'SOLVED', 1, 27, 2, 'WEB Site Doubt', '2008-05-05 09:51:47', 3, null, '2008-05-09 18:43:25', 'STAFF', 'FFD52F3C7E'), (374, 2, 'SOLVED', 7, 19, 3, 'Sales Doubt', '2008-05-05 06:19:16', 3, null, '2008-05-14 14:00:25', 'STAFF', 'AD972F10E0'), (375, 2, 'SOLVED', 7, 27, 5, 'Peripheral Issue', '2008-05-05 12:12:59', 4, null, '2008-05-06 17:04:17', 'STAFF', 'F61D694746'), (376, 2, 'SOLVED', 9, 20, 4, 'WEB Mail Doubt', '2008-05-05 11:07:02', 3, null, '2008-05-11 14:58:31', 'STAFF', '142949DF56'), (377, 1, 'SOLVED', 8, 6, 4, 'WEB Mail Issue', '2008-05-05 06:19:16', 3, null, '2008-05-08 14:36:33', 'STAFF', 'D34AB169B7'), (378, 2, 'SOLVED', 6, 1, 6, 'Software Doubt', '2008-05-05 12:01:18', 4, null, '2008-05-10 18:52:04', 'STAFF', '8BF1211FD4'), (379, 2, 'SOLVED', 6, 6, 1, 'CRM Application Doubt', '2008-05-05 08:19:55', 4, null, '2008-05-07 17:26:46', 'STAFF', 'A02FFD91EC'), (380, 1, 'SOLVED', 1, 5, 6, 'Software Issue', '2008-05-05 10:57:20', 4, null, '2008-05-16 15:36:59', 'STAFF', 'BCA82E41EE'), (381, 2, 'SOLVED', 5, 19, 5, 'Peripheral Issue', '2008-05-05 10:41:03', 2, null, '2008-05-09 16:27:21', 'STAFF', '00EC53C468'), (382, 2, 'SOLVED', 5, 38, 4, 'WEB Mail Issue', '2008-05-05 12:18:42', 3, null, '2008-05-14 18:11:35', 'STAFF', '4F6FFE13A5'), (383, 2, 'SOLVED', 3, 27, 6, 'Sotfware Issue', '2008-05-05 09:12:27', 3, null, '2008-05-17 18:52:04', 'STAFF', 'BEED13602B'), (384, 2, 'SOLVED', 10, 31, 3, 'Sales Doubt', '2008-05-06 07:58:45', 2, null, '2008-05-14 18:17:41', 'STAFF', '0584CE565C'), (385, 2, 'SOLVED', 6, 28, 4, 'WEB Mail Doubt', '2008-05-06 09:20:47', 3, null, '2008-05-18 14:22:23', 'STAFF', 'DC912A253D'), (386, 2, 'SOLVED', 1, 20, 4, 'WEB Mail Doubt', '2008-05-06 06:13:36', 4, null, '2008-05-17 16:16:34', 'STAFF', '39461A19E9'), (387, 1, 'SOLVED', 9, 15, 5, 'Peripheral Doubt', '2008-05-06 07:17:41', 2, null, '2008-05-20 17:20:48', 'STAFF', '8EFB100A29'), (388, 2, 'SOLVED', 5, 37, 3, 'Sales Doubt', '2008-05-06 11:50:45', 2, null, '2008-05-10 17:18:24', 'STAFF', 'D9FC5B73A8'), (389, 2, 'SOLVED', 10, 22, 3, 'Sales Doubt', '2008-05-06 06:35:01', 3, null, '2008-05-13 15:19:15', 'STAFF', 'C86A7EE3D8'), (390, 1, 'SOLVED', 1, 4, 5, 'Peripheral Issue', '2008-05-06 07:48:47', 4, null, '2008-05-07 17:37:25', 'STAFF', 'A01A0380CA'), (391, 2, 'SOLVED', 2, 22, 5, 'Peripheral Issue', '2008-05-06 10:46:59', 4, null, '2008-05-17 17:38:10', 'STAFF', '5A4B25AAED'), (392, 1, 'CLOSED', 5, 32, 6, 'Software Doubt', '2008-05-06 12:36:43', 1, null, '2008-05-23 14:16:00', 'STAFF', 'F73B76CE89'), (393, 2, 'CLOSED', 8, 20, 5, 'Peripheral Doubt', '2008-05-06 07:27:06', 3, null, '2008-05-16 13:28:56', 'STAFF', '70C639DF5E'), (394, 1, 'SOLVED', 6, 11, 6, 'Software Doubt', '2008-05-06 07:15:10', 2, null, '2008-05-11 14:28:01', 'STAFF', '28F0B86459'), (395, 1, 'SOLVED', 10, 19, 1, 'CRM Application Issue', '2008-05-06 11:40:08', 3, null, '2008-05-11 14:01:36', 'STAFF', '1543843A47'), (396, 2, 'CLOSED', 1, 34, 6, 'Software Doubt', '2008-05-07 09:25:27', 1, null, '2008-05-13 14:27:53', 'STAFF', 'F8C1F23D6A'), (397, 1, 'SOLVED', 10, 10, 2, 'WEB Site Issue', '2008-05-07 09:34:01', 4, null, '2008-05-19 17:02:06', 'STAFF', 'E46DE7E1BC'), (398, 2, 'SOLVED', 5, 31, 6, 'Software Doubt', '2008-05-07 10:04:30', 4, null, '2008-05-09 18:54:47', 'STAFF', 'B7B16ECF8C'), (399, 1, 'SOLVED', 8, 29, 5, 'Peripheral Doubt', '2008-05-07 07:38:10', 4, null, '2008-05-18 16:15:51', 'STAFF', '352FE25DAF');
INSERT INTO "ticket" VALUES (400, 1, 'CLOSED', 1, 10, 6, 'Sotfware Issue', '2008-05-07 06:56:40', 1, null, '2008-05-15 17:52:12', 'STAFF', '18D8042386'), (401, 2, 'SOLVED', 9, 32, 2, 'WEB Site Doubt', '2008-05-07 09:19:57', 4, null, '2008-05-16 18:41:55', 'STAFF', '816B112C61'), (402, 2, 'SOLVED', 9, 16, 3, 'Sales Doubt', '2008-05-07 11:43:29', 2, null, '2008-05-11 18:06:13', 'STAFF', '69CB3EA317'), (403, 3, 'SOLVED', 8, 21, 5, 'Peripheral Issue', '2008-05-07 09:14:49', 4, null, '2008-05-12 16:51:34', 'STAFF', 'BBF94B34EB'), (404, 3, 'CLOSED', 1, 19, 6, 'Software Issue', '2008-05-08 06:48:26', 3, null, '2008-05-08 13:48:26', 'STAFF', '4F4ADCBF8C'), (405, 3, 'CLOSED', 4, 10, 5, 'Peripheral Issue', '2008-05-08 10:43:06', 1, null, '2008-05-17 18:37:20', 'STAFF', 'BBCBFF5C1F'), (406, 3, 'SOLVED', 4, 12, 5, 'Peripheral Issue', '2008-05-08 12:14:42', 4, null, '2008-05-20 14:19:08', 'STAFF', '8CB22BDD0B'), (407, 2, 'SOLVED', 2, 35, 6, 'Software Issue', '2008-05-08 09:17:24', 3, null, '2008-05-15 15:28:52', 'STAFF', 'F4F6DCE2F3'), (408, 3, 'SOLVED', 3, 25, 6, 'Software Doubt', '2008-05-08 07:53:31', 4, null, '2008-05-09 14:18:50', 'STAFF', '0D0FD7C6E0'), (409, 2, 'SOLVED', 2, 37, 2, 'WEB Site Issue', '2008-05-09 08:52:08', 3, null, '2008-05-24 18:29:27', 'STAFF', 'A96B65A721'), (410, 3, 'SOLVED', 1, 39, 4, 'WEB Mail Doubt', '2008-05-09 10:32:28', 2, null, '2008-05-10 13:20:42', 'STAFF', '1068C6E4C8'), (411, 1, 'SOLVED', 2, 29, 4, 'WEB Mail Doubt', '2008-05-10 07:39:38', 2, null, '2008-05-15 18:43:24', 'STAFF', '17D63B1625'), (412, 2, 'SOLVED', 2, 10, 6, 'Software Issue', '2008-05-10 09:11:15', 2, null, '2008-05-12 14:13:20', 'STAFF', 'B9228E0962'), (413, 2, 'SOLVED', 1, 9, 5, 'Peripheral Issue', '2008-05-10 07:12:17', 2, null, '2008-05-13 15:14:03', 'STAFF', '0DEB1C5481'), (414, 1, 'SOLVED', 10, 20, 4, 'WEB Mail Doubt', '2008-05-10 11:32:59', 2, null, '2008-05-20 13:51:58', 'STAFF', '66808E327D'), (415, 2, 'SOLVED', 10, 16, 5, 'Peripheral Issue', '2008-05-10 06:25:45', 4, null, '2008-05-13 18:10:41', 'STAFF', '42E7AAA88B'), (416, 2, 'SOLVED', 9, 25, 6, 'Software Issue', '2008-05-10 12:07:07', 2, null, '2008-05-25 15:56:18', 'STAFF', '8FE0093BB3'), (417, 3, 'SOLVED', 5, 35, 1, 'CRM Application Issue', '2008-05-10 08:04:19', 2, null, '2008-05-11 13:01:12', 'STAFF', '41AE36ECB9'), (418, 1, 'SOLVED', 10, 10, 4, 'WEB Mail Doubt', '2008-05-10 09:14:18', 2, null, '2008-05-19 17:05:19', 'STAFF', 'D1F255A373'), (419, 2, 'SOLVED', 8, 21, 1, 'CRM Application Issue', '2008-05-10 06:18:55', 3, null, '2008-05-15 15:47:06', 'STAFF', '7EACB53257'), (420, 2, 'SOLVED', 6, 32, 4, 'WEB Mail Doubt', '2008-05-10 06:38:54', 3, null, '2008-05-22 14:56:17', 'STAFF', 'B6F0479AE8'), (421, 2, 'SOLVED', 9, 33, 1, 'CRM Application Doubt', '2008-05-10 10:05:59', 4, null, '2008-05-20 14:18:18', 'STAFF', 'E0C641195B'), (422, 1, 'SOLVED', 10, 31, 5, 'Peripheral Issue', '2008-05-10 12:24:17', 3, null, '2008-05-21 15:41:56', 'STAFF', 'F85454E827'), (423, 2, 'SOLVED', 9, 7, 6, 'Software Doubt', '2008-05-11 06:58:24', 2, null, '2008-05-24 14:16:24', 'STAFF', 'FAA9AFEA49'), (424, 2, 'SOLVED', 1, 38, 6, 'Sotfware Issue', '2008-05-11 12:21:18', 3, null, '2008-05-19 15:46:41', 'STAFF', '3C7781A36B'), (425, 1, 'SOLVED', 7, 13, 4, 'WEB Mail Doubt', '2008-05-11 08:50:42', 2, null, '2008-05-19 16:49:51', 'STAFF', '25B2822C2F'), (426, 2, 'CLOSED', 9, 38, 1, 'CRM Application Issue', '2008-05-11 08:04:52', 1, null, '2008-05-14 14:44:45', 'STAFF', '6ECBDD6EC8'), (427, 2, 'SOLVED', 2, 18, 1, 'CRM Application Issue', '2008-05-11 07:50:45', 4, null, '2008-05-11 14:37:56', 'STAFF', '18997733EC'), (428, 3, 'CLOSED', 5, 37, 5, 'Peripheral Issue', '2008-05-11 11:36:23', 2, null, '2008-05-20 15:38:45', 'STAFF', '8D7D8EE069'), (429, 2, 'SOLVED', 1, 10, 6, 'Software Issue', '2008-05-12 08:51:52', 2, null, '2008-05-13 18:17:46', 'STAFF', '75FC093C0E'), (430, 2, 'SOLVED', 4, 5, 2, 'WEB Site Issue', '2008-05-12 10:32:47', 2, null, '2008-05-18 16:10:56', 'STAFF', 'F74909ACE6'), (431, 2, 'SOLVED', 1, 6, 6, 'Sotfware Issue', '2008-05-12 09:50:10', 3, null, '2008-05-28 14:04:19', 'STAFF', '66368270FF'), (432, 3, 'CLOSED', 9, 26, 5, 'Peripheral Issue', '2008-05-12 08:31:16', 1, null, '2008-05-25 15:23:08', 'STAFF', '248E844336'), (433, 1, 'CLOSED', 6, 28, 1, 'CRM Application Doubt', '2008-05-12 10:47:45', 3, null, '2008-05-18 14:32:55', 'STAFF', '019D385EB6'), (434, 3, 'SOLVED', 4, 3, 6, 'Software Doubt', '2008-05-12 12:05:19', 2, null, '2008-05-19 17:29:09', 'STAFF', 'A49E9411D6'), (435, 2, 'SOLVED', 1, 23, 6, 'Software Doubt', '2008-05-12 08:44:45', 3, null, '2008-05-17 18:00:33', 'STAFF', 'DDB30680A6'), (436, 2, 'SOLVED', 4, 18, 2, 'WEB Site Issue', '2008-05-12 11:36:10', 3, null, '2008-05-22 13:47:12', 'STAFF', '2421FCB126'), (437, 1, 'SOLVED', 1, 3, 5, 'Peripheral Doubt', '2008-05-12 07:08:29', 4, null, '2008-05-18 17:19:06', 'STAFF', 'FCCB60FB51'), (438, 2, 'CLOSED', 9, 39, 1, 'CRM Application Issue', '2008-05-12 09:00:50', 3, null, '2008-05-17 18:09:09', 'STAFF', '1651CF0D2F'), (439, 1, 'SOLVED', 9, 29, 5, 'Peripheral Doubt', '2008-05-12 09:34:25', 4, null, '2008-05-27 17:21:04', 'STAFF', 'EED5AF6ADD'), (440, 1, 'SOLVED', 7, 2, 5, 'Peripheral Issue', '2008-05-12 10:14:00', 4, null, '2008-05-28 18:04:07', 'STAFF', 'A8ABB4BB28'), (441, 1, 'SOLVED', 6, 1, 2, 'WEB Site Issue', '2008-05-13 07:26:27', 2, null, '2008-05-21 15:35:10', 'STAFF', '15D4E891D7'), (442, 2, 'SOLVED', 3, 1, 2, 'WEB Site Issue', '2008-05-13 10:04:05', 3, null, '2008-05-20 14:27:44', 'STAFF', 'C203D8A151'), (443, 3, 'SOLVED', 1, 21, 4, 'WEB Mail Doubt', '2008-05-13 12:38:47', 4, null, '2008-05-24 16:02:11', 'STAFF', '13F3CF8C53'), (444, 1, 'SOLVED', 5, 9, 4, 'WEB Mail Issue', '2008-05-13 10:40:31', 4, null, '2008-05-14 18:40:58', 'STAFF', '550A141F12'), (445, 3, 'SOLVED', 2, 38, 6, 'Software Doubt', '2008-05-13 08:53:21', 3, null, '2008-05-18 15:09:20', 'STAFF', '67F7FB873E'), (446, 2, 'SOLVED', 5, 10, 1, 'CRM Application Doubt', '2008-05-13 12:54:28', 3, null, '2008-05-17 15:32:15', 'STAFF', '1A5B1E4DAA'), (447, 2, 'SOLVED', 2, 23, 3, 'Sales Doubt', '2008-05-13 07:57:46', 4, null, '2008-05-22 17:38:52', 'STAFF', '9A96876E2F'), (448, 3, 'CLOSED', 3, 20, 2, 'WEB Site Issue', '2008-05-13 06:15:33', 1, null, '2008-05-14 13:57:15', 'STAFF', '9B70E8FE62'), (449, 3, 'CLOSED', 6, 19, 6, 'Software Doubt', '2008-05-13 07:47:16', 1, null, '2008-05-24 14:22:59', 'STAFF', 'D61E4BBD63'), (450, 2, 'SOLVED', 8, 17, 6, 'Sotfware Issue', '2008-05-14 07:36:33', 4, null, '2008-05-22 15:39:18', 'STAFF', 'F5F8590CD5'), (451, 2, 'SOLVED', 2, 38, 6, 'Software Doubt', '2008-05-14 08:28:17', 3, null, '2008-05-19 18:18:37', 'STAFF', '941E1AAABA'), (452, 2, 'SOLVED', 5, 1, 6, 'Software Doubt', '2008-05-14 11:52:02', 2, null, '2008-05-15 14:12:23', 'STAFF', '9431C87F27'), (453, 1, 'CLOSED', 1, 31, 6, 'Sotfware Issue', '2008-05-14 10:04:21', 2, null, '2008-05-26 15:07:44', 'STAFF', '49AE49A23F'), (454, 2, 'SOLVED', 4, 36, 4, 'WEB Mail Issue', '2008-05-14 11:16:11', 4, null, '2008-05-25 18:04:59', 'STAFF', 'E44FEA3BEC'), (455, 2, 'SOLVED', 2, 16, 2, 'WEB Site Issue', '2008-05-14 07:13:11', 3, null, '2008-05-28 13:37:40', 'STAFF', '821FA74B50'), (456, 1, 'SOLVED', 5, 7, 2, 'WEB Site Doubt', '2008-05-14 06:26:42', 2, null, '2008-05-27 18:34:13', 'STAFF', '250CF8B51C'), (457, 2, 'SOLVED', 10, 25, 6, 'Software Doubt', '2008-05-14 08:24:55', 4, null, '2008-05-17 17:49:06', 'STAFF', '42998CF32D'), (458, 3, 'SOLVED', 10, 7, 5, 'Peripheral Doubt', '2008-05-14 09:15:28', 2, null, '2008-05-25 13:48:31', 'STAFF', 'D07E70EFCF'), (459, 2, 'SOLVED', 1, 36, 6, 'Software Doubt', '2008-05-15 12:37:06', 4, null, '2008-05-25 17:44:15', 'STAFF', '7FE1F8ABAA'), (460, 2, 'SOLVED', 9, 16, 4, 'WEB Mail Doubt', '2008-05-15 06:26:43', 3, null, '2008-05-19 15:43:46', 'STAFF', '98B2979500'), (461, 3, 'SOLVED', 1, 35, 2, 'WEB Site Doubt', '2008-05-15 08:05:50', 2, null, '2008-05-31 15:25:02', 'STAFF', '0353AB4CBE'), (462, 2, 'SOLVED', 2, 36, 3, 'Sales Doubt', '2008-05-15 06:45:26', 3, null, '2008-05-19 17:06:01', 'STAFF', '51D92BE1C6'), (463, 1, 'SOLVED', 10, 17, 2, 'WEB Site Issue', '2008-05-16 07:53:48', 4, null, '2008-05-20 14:35:11', 'STAFF', '428FCA9BC1'), (464, 3, 'SOLVED', 2, 20, 2, 'WEB Site Issue', '2008-05-16 12:21:30', 2, null, '2008-05-28 14:46:57', 'STAFF', 'F1B6F2857F'), (465, 1, 'CLOSED', 1, 8, 2, 'WEB Site Issue', '2008-05-17 09:34:23', 2, null, '2008-05-17 15:43:48', 'STAFF', '68CE199EC2'), (466, 3, 'SOLVED', 9, 6, 6, 'Software Issue', '2008-05-17 11:04:57', 4, null, '2008-05-28 18:21:07', 'STAFF', 'E836D813FD'), (467, 3, 'SOLVED', 10, 36, 1, 'CRM Application Doubt', '2008-05-17 07:53:33', 2, null, '2008-05-27 16:51:20', 'STAFF', 'AB817C9349'), (468, 2, 'SOLVED', 2, 28, 1, 'CRM Application Doubt', '2008-05-17 06:23:36', 4, null, '2008-06-02 13:54:18', 'STAFF', '877A9BA7A9'), (469, 1, 'SOLVED', 10, 17, 5, 'Peripheral Issue', '2008-05-17 06:51:47', 2, null, '2008-06-04 17:27:59', 'STAFF', 'DC6A648964'), (470, 2, 'SOLVED', 10, 34, 6, 'Software Issue', '2008-05-17 08:32:09', 2, null, '2008-06-01 14:04:53', 'STAFF', '26337353B7'), (471, 2, 'CLOSED', 9, 27, 6, 'Software Doubt', '2008-05-17 11:37:05', 1, null, '2008-05-27 15:20:10', 'STAFF', '8E6B42F164'), (472, 2, 'SOLVED', 3, 31, 2, 'WEB Site Issue', '2008-05-17 11:56:27', 2, null, '2008-05-31 16:48:49', 'STAFF', 'EF575E8837'), (473, 3, 'SOLVED', 1, 28, 6, 'Software Issue', '2008-05-18 06:55:13', 4, null, '2008-06-02 14:56:40', 'STAFF', '2050E03CA1'), (474, 2, 'CLOSED', 8, 9, 3, 'Sales Issue', '2008-05-18 06:21:52', 1, null, '2008-05-31 15:37:47', 'STAFF', '25DDC0F8C9'), (475, 2, 'SOLVED', 6, 35, 2, 'WEB Site Issue', '2008-05-18 12:41:29', 2, null, '2008-05-29 15:12:56', 'STAFF', '5EF0B4EBA3'), (476, 2, 'CLOSED', 5, 19, 4, 'WEB Mail Doubt', '2008-05-18 09:25:03', 3, null, '2008-06-02 18:46:12', 'STAFF', '598B3E71EC'), (477, 1, 'SOLVED', 2, 10, 2, 'WEB Site Issue', '2008-05-18 06:01:22', 2, null, '2008-05-21 17:04:07', 'STAFF', '74071A6733'), (478, 1, 'CLOSED', 3, 7, 4, 'WEB Mail Doubt', '2008-05-18 10:20:32', 2, null, '2008-05-31 13:09:20', 'STAFF', 'CFEE398643'), (479, 2, 'SOLVED', 8, 30, 6, 'Software Doubt', '2008-05-18 11:12:43', 3, null, '2008-06-01 13:20:39', 'STAFF', 'D18F655C3F'), (480, 2, 'SOLVED', 1, 12, 1, 'CRM Application Doubt', '2008-05-18 08:15:35', 3, null, '2008-05-22 18:36:12', 'STAFF', '6EA2EF7311'), (481, 1, 'SOLVED', 10, 17, 1, 'CRM Application Issue', '2008-05-18 11:37:09', 4, null, '2008-05-19 13:16:10', 'STAFF', '9461CCE28E'), (482, 3, 'SOLVED', 7, 10, 2, 'WEB Site Issue', '2008-05-18 08:18:18', 4, null, '2008-05-30 15:35:27', 'STAFF', 'F770B62BC8'), (483, 3, 'SOLVED', 1, 20, 6, 'Software Issue', '2008-05-18 11:05:18', 4, null, '2008-05-27 18:11:24', 'STAFF', 'E1E32E235E'), (484, 2, 'SOLVED', 6, 28, 3, 'Sales Doubt', '2008-05-19 11:29:10', 4, null, '2008-06-09 16:49:52', 'STAFF', 'EBA0DC302B'), (485, 3, 'SOLVED', 5, 37, 6, 'Software Issue', '2008-05-19 09:09:50', 2, null, '2008-05-23 18:33:32', 'STAFF', '218A0AEFD1'), (486, 2, 'SOLVED', 10, 10, 1, 'CRM Application Issue', '2008-05-19 11:14:09', 2, null, '2008-06-04 17:50:30', 'STAFF', '7D04BBBE54'), (487, 1, 'SOLVED', 3, 11, 6, 'Software Issue', '2008-05-19 10:12:29', 4, null, '2008-05-21 13:36:02', 'STAFF', 'A516A87CFC'), (488, 1, 'SOLVED', 6, 20, 6, 'Software Issue', '2008-05-19 09:11:00', 2, null, '2008-06-06 13:21:15', 'STAFF', 'C3C59E5F8B'), (489, 2, 'SOLVED', 9, 37, 5, 'Peripheral Doubt', '2008-05-19 06:25:20', 4, null, '2008-06-08 18:34:28', 'STAFF', '854D9FCA60'), (490, 2, 'SOLVED', 8, 19, 6, 'Sotfware Issue', '2008-05-19 11:04:21', 4, null, '2008-05-24 17:15:17', 'STAFF', 'C410003EF1'), (491, 2, 'CLOSED', 10, 31, 5, 'Peripheral Issue', '2008-05-19 10:07:30', 2, null, '2008-06-01 15:27:11', 'STAFF', '559CB990C9'), (492, 2, 'SOLVED', 10, 31, 2, 'WEB Site Issue', '2008-05-19 08:22:13', 2, null, '2008-05-23 13:37:05', 'STAFF', '55A7CF9C71'), (493, 2, 'SOLVED', 10, 30, 6, 'Software Doubt', '2008-05-19 08:13:31', 3, null, '2008-05-28 13:56:06', 'STAFF', '2F55707D41'), (494, 1, 'SOLVED', 9, 6, 5, 'Peripheral Issue', '2008-05-19 12:12:47', 4, null, '2008-06-05 14:38:12', 'STAFF', '1BE3BC32E6'), (495, 2, 'SOLVED', 4, 28, 2, 'WEB Site Issue', '2008-05-19 09:09:41', 4, null, '2008-05-24 14:21:49', 'STAFF', '35051070E5'), (496, 2, 'CLOSED', 8, 28, 1, 'CRM Application Doubt', '2008-05-19 08:27:12', 1, null, '2008-05-28 16:54:12', 'STAFF', 'B534BA6823'), (497, 2, 'SOLVED', 5, 19, 5, 'Peripheral Issue', '2008-05-19 12:55:26', 2, null, '2008-05-26 18:04:08', 'STAFF', '7380AD8A67'), (498, 2, 'SOLVED', 1, 8, 2, 'WEB Site Issue', '2008-05-20 10:55:35', 3, null, '2008-05-31 15:55:08', 'STAFF', '05F971B5EC'), (499, 1, 'SOLVED', 10, 15, 2, 'WEB Site Doubt', '2008-05-20 08:36:00', 3, null, '2008-05-30 13:41:47', 'STAFF', '3CF166C6B7'), (500, 1, 'CLOSED', 6, 23, 4, 'WEB Mail Issue', '2008-05-20 09:11:54', 3, null, '2008-05-29 13:34:15', 'STAFF', 'CEE631121C'), (501, 3, 'SOLVED', 1, 22, 3, 'Sales Issue', '2008-05-20 12:49:41', 4, null, '2008-05-29 17:53:19', 'STAFF', '5B69B9CB83'), (502, 2, 'SOLVED', 5, 38, 3, 'Sales Doubt', '2008-05-20 07:18:39', 2, null, '2008-05-23 17:11:34', 'STAFF', 'B5B41FAC03'), (503, 2, 'CLOSED', 7, 2, 6, 'Software Doubt', '2008-05-20 08:58:42', 1, null, '2008-05-25 13:49:09', 'STAFF', '285E19F20B'), (504, 2, 'CLOSED', 2, 34, 6, 'Sotfware Issue', '2008-05-20 09:37:51', 2, null, '2008-06-05 14:50:12', 'STAFF', 'B337E84DE8'), (505, 2, 'SOLVED', 1, 17, 5, 'Peripheral Issue', '2008-05-21 10:19:28', 2, null, '2008-05-25 15:04:10', 'STAFF', 'E8C0653FEA'), (506, 2, 'SOLVED', 9, 5, 3, 'Sales Doubt', '2008-05-21 10:15:51', 2, null, '2008-06-03 17:10:25', 'STAFF', 'FF4D5FBBAF'), (507, 2, 'SOLVED', 9, 21, 5, 'Peripheral Issue', '2008-05-21 11:51:14', 4, null, '2008-05-25 15:29:29', 'STAFF', '2D6CC4B2D1'), (508, 2, 'SOLVED', 10, 17, 1, 'CRM Application Issue', '2008-05-21 08:44:13', 4, null, '2008-05-22 13:07:32', 'STAFF', '389BC7BB1E'), (509, 2, 'CLOSED', 10, 4, 6, 'Software Doubt', '2008-05-21 11:46:22', 2, null, '2008-06-06 17:39:05', 'STAFF', 'E2230B8535'), (510, 1, 'SOLVED', 5, 10, 4, 'WEB Mail Doubt', '2008-05-22 07:24:52', 2, null, '2008-05-27 17:12:21', 'STAFF', '087408522C'), (511, 2, 'SOLVED', 7, 25, 6, 'Sotfware Issue', '2008-05-22 08:11:00', 3, null, '2008-06-01 14:06:17', 'STAFF', 'A760880003'), (512, 2, 'SOLVED', 9, 7, 2, 'WEB Site Issue', '2008-05-22 08:25:37', 2, null, '2008-06-05 14:57:22', 'STAFF', '10A7CDD970'), (513, 2, 'SOLVED', 1, 19, 6, 'Sotfware Issue', '2008-05-23 12:26:45', 4, null, '2008-06-01 18:05:45', 'STAFF', '3DC4876F3F'), (514, 2, 'SOLVED', 9, 31, 1, 'CRM Application Doubt', '2008-05-23 06:55:14', 4, null, '2008-06-04 16:21:46', 'STAFF', '59B90E1005'), (515, 2, 'CLOSED', 9, 29, 5, 'Peripheral Issue', '2008-05-24 10:35:36', 1, null, '2008-05-31 14:29:46', 'STAFF', '2B8A61594B'), (516, 1, 'SOLVED', 6, 32, 5, 'Peripheral Issue', '2008-05-24 12:01:03', 2, null, '2008-06-05 17:29:42', 'STAFF', 'F3F27A3247'), (517, 1, 'SOLVED', 4, 9, 6, 'Software Doubt', '2008-05-24 10:46:52', 4, null, '2008-05-28 13:36:01', 'STAFF', '38913E1D6A'), (518, 2, 'SOLVED', 1, 31, 6, 'Software Doubt', '2008-05-24 11:19:06', 4, null, '2008-06-02 13:12:05', 'STAFF', 'EBD9629FC3'), (519, 3, 'SOLVED', 10, 35, 4, 'WEB Mail Doubt', '2008-05-24 09:04:37', 2, null, '2008-06-12 14:09:33', 'STAFF', '63538FE6EF'), (520, 2, 'SOLVED', 10, 30, 5, 'Peripheral Issue', '2008-05-24 07:21:08', 2, null, '2008-06-02 14:04:03', 'STAFF', 'CF67355A33'), (521, 2, 'SOLVED', 10, 28, 2, 'WEB Site Issue', '2008-05-24 06:41:00', 2, null, '2008-05-26 15:59:06', 'STAFF', '07563A3FE3'), (522, 1, 'SOLVED', 2, 10, 3, 'Sales Doubt', '2008-05-24 07:09:37', 4, null, '2008-06-07 15:48:00', 'STAFF', '53FDE96FCC'), (523, 2, 'SOLVED', 5, 30, 1, 'CRM Application Issue', '2008-05-24 11:01:39', 4, null, '2008-06-02 16:24:39', 'STAFF', '2BB232C0B1'), (524, 2, 'SOLVED', 1, 37, 4, 'WEB Mail Doubt', '2008-05-25 06:49:22', 3, null, '2008-05-30 17:17:39', 'STAFF', 'BA2FD310DC'), (525, 2, 'SOLVED', 1, 39, 5, 'Peripheral Issue', '2008-05-25 08:23:42', 2, null, '2008-06-07 13:36:41', 'STAFF', '69421F0324'), (526, 2, 'SOLVED', 9, 24, 1, 'CRM Application Issue', '2008-05-25 08:09:57', 2, null, '2008-05-25 18:26:21', 'STAFF', '85422AFB46'), (527, 1, 'CLOSED', 10, 17, 6, 'Software Issue', '2008-05-25 11:27:42', 2, null, '2008-05-25 18:08:12', 'STAFF', '13F320E7B5'), (528, 2, 'SOLVED', 7, 19, 2, 'WEB Site Issue', '2008-05-25 10:29:51', 3, null, '2008-06-13 13:36:48', 'STAFF', 'F4BE00279E'), (529, 2, 'SOLVED', 5, 35, 2, 'WEB Site Issue', '2008-05-25 12:35:23', 3, null, '2008-06-09 15:50:06', 'STAFF', '37F0E884FB'), (530, 3, 'SOLVED', 1, 38, 1, 'CRM Application Doubt', '2008-05-25 10:14:21', 2, null, '2008-05-29 14:26:42', 'STAFF', 'D64A340BCB'), (531, 3, 'SOLVED', 6, 28, 4, 'WEB Mail Issue', '2008-05-25 11:31:14', 4, null, '2008-06-04 17:19:27', 'STAFF', '0FCBC61ACD'), (532, 1, 'SOLVED', 9, 36, 4, 'WEB Mail Doubt', '2008-05-25 07:33:05', 4, null, '2008-06-12 18:39:36', 'STAFF', '298F95E1BF'), (533, 2, 'SOLVED', 2, 13, 6, 'Software Issue', '2008-05-25 10:33:07', 4, null, '2008-05-31 18:30:38', 'STAFF', 'DF877F3865'), (534, 2, 'SOLVED', 6, 4, 2, 'WEB Site Issue', '2008-05-25 11:59:03', 4, null, '2008-06-05 16:43:19', 'STAFF', 'C399862D3B'), (535, 2, 'SOLVED', 2, 11, 5, 'Peripheral Issue', '2008-05-25 08:23:17', 2, null, '2008-06-10 14:51:36', 'STAFF', '33E8075E99'), (536, 3, 'SOLVED', 4, 22, 1, 'CRM Application Doubt', '2008-05-25 07:05:49', 3, null, '2008-06-16 14:49:34', 'STAFF', '65658FDE58'), (537, 2, 'SOLVED', 10, 35, 6, 'Software Doubt', '2008-05-26 11:26:35', 4, null, '2008-05-31 15:29:38', 'STAFF', '5EA1649A31'), (538, 2, 'SOLVED', 2, 31, 6, 'Sotfware Issue', '2008-05-26 11:12:44', 3, null, '2008-06-05 18:36:54', 'STAFF', '7BCDF75AD2'), (539, 2, 'CLOSED', 10, 8, 6, 'Software Doubt', '2008-05-26 12:19:22', 3, null, '2008-06-01 18:37:28', 'STAFF', 5737034557), (540, 2, 'SOLVED', 6, 23, 6, 'Software Doubt', '2008-05-26 07:31:48', 3, null, '2008-06-04 15:18:12', 'STAFF', '9B72E31DAC'), (541, 1, 'SOLVED', 2, 21, 2, 'WEB Site Issue', '2008-05-26 10:27:59', 2, null, '2008-06-06 13:57:59', 'STAFF', '16C222AA19'), (542, 3, 'CLOSED', 7, 33, 1, 'CRM Application Doubt', '2008-05-26 06:42:45', 3, null, '2008-06-09 15:55:37', 'STAFF', '7DCD340D84'), (543, 3, 'CLOSED', 3, 21, 6, 'Software Issue', '2008-05-26 12:22:04', 3, null, '2008-05-27 18:07:13', 'STAFF', '81448138F5'), (544, 2, 'SOLVED', 9, 2, 6, 'Software Doubt', '2008-05-26 11:48:28', 2, null, '2008-05-28 16:12:39', 'STAFF', '97E8527FEA'), (545, 2, 'SOLVED', 10, 22, 4, 'WEB Mail Issue', '2008-05-26 10:33:32', 4, null, '2008-06-04 17:49:03', 'STAFF', '647BBA3443'), (546, 2, 'CLOSED', 4, 35, 3, 'Sales Issue', '2008-05-26 11:16:16', 3, null, '2008-05-26 13:06:15', 'STAFF', 'ED265BC903'), (547, 2, 'CLOSED', 2, 28, 5, 'Peripheral Doubt', '2008-05-26 06:40:55', 2, null, '2008-06-11 13:44:36', 'STAFF', 'C75B6F114C'), (548, 2, 'SOLVED', 1, 37, 5, 'Peripheral Issue', '2008-05-26 07:07:29', 2, null, '2008-06-12 17:12:22', 'STAFF', '8D34201A5B'), (549, 2, 'SOLVED', 5, 19, 2, 'WEB Site Doubt', '2008-05-26 06:15:56', 4, null, '2008-06-06 16:03:12', 'STAFF', 'CCB1D45FB7'), (550, 3, 'SOLVED', 8, 22, 6, 'Software Doubt', '2008-05-27 08:37:51', 3, null, '2008-05-27 18:51:37', 'STAFF', '01F78BE6F7'), (551, 1, 'SOLVED', 9, 17, 5, 'Peripheral Doubt', '2008-05-27 12:56:32', 4, null, '2008-06-01 15:21:49', 'STAFF', '7F24D24052'), (552, 2, 'SOLVED', 6, 23, 2, 'WEB Site Issue', '2008-05-27 11:08:02', 4, null, '2008-05-30 17:48:09', 'STAFF', '94C7BB58EF'), (553, 2, 'SOLVED', 9, 37, 6, 'Sotfware Issue', '2008-05-27 10:41:04', 4, null, '2008-06-17 13:12:23', 'STAFF', 'F387624DF5'), (554, 1, 'SOLVED', 4, 3, 6, 'Software Issue', '2008-05-27 08:37:27', 4, null, '2008-06-11 13:43:09', 'STAFF', '5E388103A3'), (555, 2, 'SOLVED', 1, 28, 3, 'Sales Issue', '2008-05-27 06:03:32', 4, null, '2008-06-01 14:35:11', 'STAFF', '15DE21C670'), (556, 2, 'SOLVED', 6, 23, 6, 'Software Issue', '2008-05-27 08:17:32', 4, null, '2008-05-31 13:19:23', 'STAFF', '11B921EF08'), (557, 1, 'SOLVED', 10, 37, 1, 'CRM Application Doubt', '2008-05-27 08:35:01', 2, null, '2008-05-28 16:53:00', 'STAFF', '6E2713A6EF'), (558, 3, 'CLOSED', 10, 19, 6, 'Sotfware Issue', '2008-05-27 10:18:29', 1, null, '2008-05-30 14:21:37', 'STAFF', '1BB91F73E9'), (559, 2, 'CLOSED', 4, 7, 5, 'Peripheral Issue', '2008-05-28 11:50:07', 1, null, '2008-06-08 18:58:57', 'STAFF', '3A0772443A'), (560, 3, 'SOLVED', 1, 23, 6, 'Software Doubt', '2008-05-28 08:05:04', 2, null, '2008-06-01 16:06:13', 'STAFF', 'A9A6653E48'), (561, 1, 'SOLVED', 7, 13, 1, 'CRM Application Issue', '2008-05-28 12:09:28', 2, null, '2008-05-31 15:35:55', 'STAFF', '58AE749F25'), (562, 2, 'SOLVED', 2, 5, 6, 'Software Issue', '2008-05-28 08:37:22', 3, null, '2008-05-31 14:23:12', 'STAFF', '4E4B5FBBBB'), (563, 2, 'CLOSED', 8, 28, 1, 'CRM Application Doubt', '2008-05-28 12:22:47', 1, null, '2008-06-09 14:57:40', 'STAFF', '8EEFCFDF59'), (564, 3, 'SOLVED', 7, 10, 1, 'CRM Application Issue', '2008-05-28 12:31:51', 2, null, '2008-06-06 14:47:50', 'STAFF', '1728EFBDA8'), (565, 2, 'SOLVED', 7, 10, 2, 'WEB Site Issue', '2008-05-28 06:58:49', 2, null, '2008-05-28 18:08:39', 'STAFF', 'CBCB58AC2E'), (566, 1, 'CLOSED', 10, 17, 2, 'WEB Site Issue', '2008-05-28 10:59:50', 1, null, '2008-05-30 16:27:07', 'STAFF', 'DB85E2590B'), (567, 2, 'CLOSED', 9, 39, 5, 'Peripheral Doubt', '2008-05-29 11:55:57', 2, null, '2008-06-12 16:09:45', 'STAFF', '99C5E07B4D'), (568, 2, 'SOLVED', 7, 12, 3, 'Sales Doubt', '2008-05-29 07:22:37', 3, null, '2008-06-05 16:27:31', 'STAFF', 'DD45850574'), (569, 2, 'SOLVED', 1, 39, 1, 'CRM Application Issue', '2008-05-29 11:05:19', 2, null, '2008-05-31 14:36:49', 'STAFF', '8B16EBC056'), (570, 3, 'SOLVED', 9, 31, 2, 'WEB Site Issue', '2008-05-29 10:10:08', 2, null, '2008-05-31 13:36:11', 'STAFF', 'A86C450B76'), (571, 2, 'CLOSED', 6, 39, 6, 'Software Issue', '2008-05-29 11:11:50', 1, null, '2008-06-06 13:37:33', 'STAFF', 'C9892A9891'), (572, 2, 'SOLVED', 1, 28, 6, 'Sotfware Issue', '2008-05-29 10:13:13', 2, null, '2008-06-10 14:46:24', 'STAFF', 'E6B4B2A746'), (573, 2, 'SOLVED', 4, 28, 4, 'WEB Mail Issue', '2008-05-30 10:17:00', 4, null, '2008-06-19 15:27:52', 'STAFF', 'E5F6AD6CE3'), (574, 1, 'CLOSED', 8, 26, 5, 'Peripheral Issue', '2008-05-31 06:40:57', 2, null, '2008-06-03 13:12:43', 'STAFF', 'F0E52B27A7'), (575, 1, 'SOLVED', 1, 9, 6, 'Software Doubt', '2008-05-31 12:32:27', 3, null, '2008-06-07 17:05:44', 'STAFF', 'FFEABD223D'), (576, 1, 'SOLVED', 10, 4, 5, 'Peripheral Issue', '2008-05-31 07:14:51', 2, null, '2008-06-08 16:18:46', 'STAFF', 'A7AEED7471'), (577, 2, 'CLOSED', 10, 14, 6, 'Software Doubt', '2008-05-31 12:06:42', 1, null, '2008-06-13 14:10:45', 'STAFF', 'FDE9264CF3'), (578, 2, 'CLOSED', 8, 36, 1, 'CRM Application Doubt', '2008-05-31 06:52:41', 2, null, '2008-06-15 17:02:38', 'STAFF', 'A8849B0524'), (579, 3, 'SOLVED', 5, 21, 3, 'Sales Doubt', '2008-05-31 08:15:33', 4, null, '2008-06-09 16:51:24', 'STAFF', '258BE18E31'), (580, 2, 'CLOSED', 2, 34, 5, 'Peripheral Doubt', '2008-05-31 12:11:28', 1, null, '2008-06-10 13:15:55', 'STAFF', '069D3BB002'), (581, 3, 'CLOSED', 1, 38, 2, 'WEB Site Issue', '2008-05-31 10:03:23', 3, null, '2008-06-04 13:37:32', 'STAFF', 'C6E19E8308'), (582, 1, 'SOLVED', 10, 5, 3, 'Sales Doubt', '2008-05-31 12:53:07', 4, null, '2008-06-13 17:07:17', 'STAFF', '46922A0880'), (583, 1, 'SOLVED', 2, 9, 6, 'Software Issue', '2008-05-31 11:56:29', 4, null, '2008-06-05 15:26:49', 'STAFF', '9AD6AAED51'), (584, 2, 'SOLVED', 2, 34, 5, 'Peripheral Issue', '2008-05-31 10:38:02', 4, null, '2008-06-07 14:01:05', 'STAFF', 'F5DEAEEAE1'), (585, 3, 'SOLVED', 9, 35, 3, 'Sales Doubt', '2008-05-31 11:20:44', 4, null, '2008-06-04 18:56:26', 'STAFF', 'A9A1D5317A'), (586, 2, 'SOLVED', 4, 31, 2, 'WEB Site Issue', '2008-06-01 06:27:08', 4, null, '2008-06-11 18:08:19', 'STAFF', '605FF764C6'), (587, 1, 'SOLVED', 7, 40, 5, 'Peripheral Doubt', '2008-06-01 11:26:41', 2, null, '2008-06-02 13:11:40', 'STAFF', '766EBCD596'), (588, 1, 'SOLVED', 1, 10, 5, 'Peripheral Issue', '2008-06-01 09:37:15', 2, null, '2008-06-05 14:31:48', 'STAFF', 'DACA41214B'), (589, 3, 'SOLVED', 4, 30, 1, 'CRM Application Doubt', '2008-06-01 10:22:49', 2, null, '2008-06-10 18:39:16', 'STAFF', '30BB3825E8'), (590, 1, 'SOLVED', 9, 5, 3, 'Sales Issue', '2008-06-01 10:57:50', 3, null, '2008-06-10 15:19:24', 'STAFF', '08B255A5D4'), (591, 3, 'SOLVED', 8, 15, 2, 'WEB Site Doubt', '2008-06-01 08:03:05', 2, null, '2008-06-11 17:45:08', 'STAFF', '3493894FA4'), (592, 2, 'CLOSED', 5, 1, 3, 'Sales Doubt', '2008-06-01 07:18:28', 3, null, '2008-06-06 15:48:37', 'STAFF', 'DBE272BAB6'), (593, 2, 'SOLVED', 10, 28, 2, 'WEB Site Doubt', '2008-06-01 10:53:12', 2, null, '2008-06-05 13:07:14', 'STAFF', 'ACC3E04046'), (594, 1, 'SOLVED', 3, 27, 2, 'WEB Site Issue', '2008-06-02 06:40:21', 3, null, '2008-06-23 17:31:57', 'STAFF', '076A0C97D0'), (595, 3, 'SOLVED', 7, 1, 5, 'Peripheral Doubt', '2008-06-02 10:35:27', 3, null, '2008-06-13 16:21:39', 'STAFF', '04ECB1FA28'), (596, 2, 'SOLVED', 5, 34, 1, 'CRM Application Doubt', '2008-06-02 11:58:05', 4, null, '2008-06-07 14:03:38', 'STAFF', 'B2EEB7362E'), (597, 2, 'SOLVED', 4, 1, 2, 'WEB Site Doubt', '2008-06-02 07:56:16', 4, null, '2008-06-10 15:14:31', 'STAFF', '08C5433A60'), (598, 1, 'SOLVED', 1, 2, 2, 'WEB Site Issue', '2008-06-02 12:05:54', 4, null, '2008-06-06 16:26:06', 'STAFF', '6ACA97005C'), (599, 1, 'SOLVED', 5, 16, 5, 'Peripheral Issue', '2008-06-02 10:54:15', 3, null, '2008-06-11 14:04:59', 'STAFF', '3435C378BB'), (600, 3, 'SOLVED', 5, 32, 1, 'CRM Application Doubt', '2008-06-02 07:07:21', 2, null, '2008-06-16 14:34:58', 'STAFF', 'D490D7B457'), (601, 1, 'SOLVED', 2, 22, 6, 'Software Doubt', '2008-06-02 09:56:14', 3, null, '2008-06-05 16:53:07', 'STAFF', 'B2F627FFF1'), (602, 2, 'SOLVED', 10, 21, 2, 'WEB Site Issue', '2008-06-02 06:51:17', 2, null, '2008-06-20 18:36:50', 'STAFF', 'C3992E9A68'), (603, 2, 'CLOSED', 9, 28, 6, 'Software Doubt', '2008-06-02 07:31:45', 1, null, '2008-06-13 18:31:50', 'STAFF', 'D86EA612DE'), (604, 1, 'SOLVED', 2, 38, 2, 'WEB Site Issue', '2008-06-02 07:31:43', 3, null, '2008-06-11 15:50:46', 'STAFF', '9CF81D8026'), (605, 2, 'SOLVED', 2, 27, 6, 'Software Issue', '2008-06-02 10:16:11', 2, null, '2008-06-12 13:30:43', 'STAFF', 'C361BC7B2C'), (606, 2, 'SOLVED', 3, 14, 6, 'Software Doubt', '2008-06-02 08:18:55', 3, null, '2008-06-12 16:48:35', 'STAFF', '44C4C17332'), (607, 2, 'SOLVED', 5, 11, 2, 'WEB Site Issue', '2008-06-03 09:32:40', 3, null, '2008-06-13 16:15:43', 'STAFF', 'DC82D632C9'), (608, 2, 'CLOSED', 8, 17, 3, 'Sales Doubt', '2008-06-03 12:54:20', 2, null, '2008-06-10 15:42:14', 'STAFF', '996A7FA078'), (609, 1, 'CLOSED', 10, 17, 4, 'WEB Mail Issue', '2008-06-03 10:23:09', 1, null, '2008-06-08 17:40:47', 'STAFF', 'D7A728A67D'), (610, 3, 'CLOSED', 9, 24, 2, 'WEB Site Issue', '2008-06-03 08:57:12', 2, null, '2008-06-16 18:15:08', 'STAFF', '00AC8ED3B4'), (611, 2, 'CLOSED', 9, 12, 3, 'Sales Doubt', '2008-06-03 09:36:53', 2, null, '2008-06-08 15:09:59', 'STAFF', '8EBDA540CB'), (612, 2, 'SOLVED', 9, 11, 6, 'Software Doubt', '2008-06-03 10:05:52', 2, null, '2008-06-07 15:18:57', 'STAFF', 'F76A89F0CB'), (613, 1, 'SOLVED', 10, 17, 6, 'Software Doubt', '2008-06-03 09:48:29', 4, null, '2008-06-15 18:44:42', 'STAFF', 'F29C21D489'), (614, 1, 'CLOSED', 3, 27, 5, 'Peripheral Doubt', '2008-06-03 11:16:05', 3, null, '2008-06-03 18:30:41', 'STAFF', '851DDF5058'), (615, 2, 'SOLVED', 4, 39, 5, 'Peripheral Issue', '2008-06-03 12:55:28', 3, null, '2008-06-09 18:06:01', 'STAFF', '58D4D1E7B1'), (616, 3, 'CLOSED', 1, 9, 6, 'Software Doubt', '2008-06-03 07:55:04', 2, null, '2008-06-13 16:45:14', 'STAFF', '7750CA3559'), (617, 1, 'SOLVED', 6, 25, 6, 'Software Doubt', '2008-06-03 12:36:25', 3, null, '2008-06-06 13:27:03', 'STAFF', '5D44EE6F2C'), (618, 2, 'SOLVED', 9, 38, 3, 'Sales Doubt', '2008-06-03 11:53:33', 3, null, '2008-06-13 15:31:06', 'STAFF', 'EB6FDC36B2'), (619, 2, 'SOLVED', 10, 37, 1, 'CRM Application Doubt', '2008-06-04 09:34:56', 4, null, '2008-06-15 13:09:49', 'STAFF', 'CDC0D6E63A'), (620, 1, 'SOLVED', 10, 31, 4, 'WEB Mail Doubt', '2008-06-04 08:31:40', 3, null, '2008-06-15 14:33:37', 'STAFF', 'B73DFE25B4'), (621, 1, 'SOLVED', 10, 7, 6, 'Software Doubt', '2008-06-04 06:03:21', 3, null, '2008-06-08 15:26:32', 'STAFF', '85FC37B18C'), (622, 3, 'SOLVED', 8, 34, 5, 'Peripheral Doubt', '2008-06-04 08:16:31', 4, null, '2008-06-08 15:25:21', 'STAFF', '3871BD6401'), (623, 3, 'SOLVED', 10, 19, 5, 'Peripheral Doubt', '2008-06-04 10:30:20', 2, null, '2008-06-09 15:23:48', 'STAFF', 'A733FA9B25'), (624, 1, 'SOLVED', 10, 36, 6, 'Software Doubt', '2008-06-04 08:29:37', 2, null, '2008-06-15 13:38:10', 'STAFF', '48AB2F9B45'), (625, 2, 'CLOSED', 10, 6, 3, 'Sales Doubt', '2008-06-04 12:25:31', 3, null, '2008-06-23 18:33:14', 'STAFF', '233509073E'), (626, 2, 'SOLVED', 6, 25, 4, 'WEB Mail Doubt', '2008-06-04 11:13:00', 4, null, '2008-06-09 18:02:29', 'STAFF', '45645A27C4'), (627, 2, 'SOLVED', 7, 12, 4, 'WEB Mail Doubt', '2008-06-04 08:15:12', 2, null, '2008-06-07 18:48:31', 'STAFF', '185C29DC24'), (628, 2, 'SOLVED', 10, 19, 6, 'Software Issue', '2008-06-07 09:17:44', 3, null, '2008-06-09 17:45:54', 'STAFF', '42E77B6363'), (629, 1, 'CLOSED', 9, 5, 6, 'Software Doubt', '2008-06-07 07:07:51', 1, null, '2008-06-09 18:35:34', 'STAFF', '051E4E127B'), (630, 3, 'CLOSED', 10, 32, 4, 'WEB Mail Doubt', '2008-06-07 07:07:13', 3, null, '2008-06-26 15:35:24', 'STAFF', '9CC138F8DC'), (631, 3, 'SOLVED', 10, 38, 5, 'Peripheral Doubt', '2008-06-07 08:05:20', 3, null, '2008-06-20 16:59:39', 'STAFF', 'B7BB35B9C6'), (632, 2, 'SOLVED', 4, 9, 3, 'Sales Issue', '2008-06-07 10:20:05', 3, null, '2008-06-19 18:58:22', 'STAFF', 'ABD815286B'), (633, 2, 'SOLVED', 4, 17, 1, 'CRM Application Issue', '2008-06-07 10:15:16', 3, null, '2008-06-19 16:34:51', 'STAFF', '26DD0DBC6E'), (634, 1, 'CLOSED', 3, 39, 6, 'Sotfware Issue', '2008-06-07 09:58:23', 1, null, '2008-06-25 13:18:43', 'STAFF', '6766AA2750'), (635, 3, 'SOLVED', 8, 11, 6, 'Sotfware Issue', '2008-06-07 06:19:32', 2, null, '2008-06-15 15:23:48', 'STAFF', '6A10BBD480'), (636, 2, 'SOLVED', 10, 11, 6, 'Software Issue', '2008-06-07 08:06:04', 4, null, '2008-06-11 17:40:23', 'STAFF', 'C5AB0BC60A'), (637, 2, 'SOLVED', 5, 23, 6, 'Software Doubt', '2008-06-07 07:57:05', 2, null, '2008-06-09 16:09:43', 'STAFF', 'A532400ED6'), (638, 2, 'SOLVED', 2, 34, 6, 'Software Issue', '2008-06-07 12:15:49', 4, null, '2008-06-19 16:54:31', 'STAFF', '4C27CEA852'), (639, 2, 'SOLVED', 10, 38, 6, 'Software Issue', '2008-06-08 12:36:02', 2, null, '2008-06-20 17:08:09', 'STAFF', '0F96613235'), (640, 1, 'SOLVED', 1, 22, 5, 'Peripheral Issue', '2008-06-08 06:26:59', 2, null, '2008-06-13 14:47:04', 'STAFF', '4FFCE04D92'), (641, 2, 'SOLVED', 1, 7, 3, 'Sales Issue', '2008-06-08 06:02:16', 3, null, '2008-06-12 15:24:14', 'STAFF', '67E103B076'), (642, 3, 'SOLVED', 5, 15, 5, 'Peripheral Issue', '2008-06-08 09:37:26', 3, null, '2008-06-08 14:33:18', 'STAFF', '291597A100'), (643, 1, 'SOLVED', 8, 19, 5, 'Peripheral Issue', '2008-06-08 10:39:33', 2, null, '2008-07-01 15:21:27', 'STAFF', '9B698EB310'), (644, 2, 'SOLVED', 1, 12, 5, 'Peripheral Issue', '2008-06-08 06:29:55', 3, null, '2008-06-22 13:21:32', 'STAFF', '8C7BBBBA95'), (645, 2, 'SOLVED', 6, 16, 5, 'Peripheral Doubt', '2008-06-08 11:02:25', 2, null, '2008-06-08 17:07:31', 'STAFF', '5E9F92A01C'), (646, 1, 'SOLVED', 9, 28, 4, 'WEB Mail Issue', '2008-06-08 07:24:18', 4, null, '2008-06-13 18:21:02', 'STAFF', '0FF39BBBF9'), (647, 1, 'SOLVED', 2, 20, 2, 'WEB Site Doubt', '2008-06-08 08:13:09', 2, null, '2008-06-13 15:06:41', 'STAFF', '303ED4C698'), (648, 3, 'CLOSED', 10, 33, 5, 'Peripheral Doubt', '2008-06-08 08:36:32', 3, null, '2008-06-15 15:44:12', 'STAFF', '443CB001C1'), (649, 2, 'CLOSED', 7, 28, 6, 'Software Issue', '2008-06-08 06:33:16', 1, null, '2008-06-12 15:19:52', 'STAFF', '55B37C5C27'), (650, 2, 'SOLVED', 1, 17, 4, 'WEB Mail Doubt', '2008-06-09 11:03:39', 2, null, '2008-06-19 17:50:35', 'STAFF', '884D247C6F'), (651, 1, 'SOLVED', 10, 1, 5, 'Peripheral Issue', '2008-06-09 08:10:17', 2, null, '2008-06-10 15:11:14', 'STAFF', '55743CC039'), (652, 2, 'SOLVED', 1, 7, 4, 'WEB Mail Doubt', '2008-06-09 09:12:37', 2, null, '2008-06-22 13:05:37', 'STAFF', '30EF30B642'), (653, 2, 'SOLVED', 6, 10, 4, 'WEB Mail Doubt', '2008-06-09 12:35:32', 4, null, '2008-06-27 13:38:33', 'STAFF', 'EAAE339C4D'), (654, 2, 'SOLVED', 2, 33, 4, 'WEB Mail Doubt', '2008-06-09 08:48:04', 2, null, '2008-06-16 18:38:08', 'STAFF', 'AB233B682E'), (655, 2, 'SOLVED', 1, 5, 3, 'Sales Doubt', '2008-06-09 12:40:18', 3, null, '2008-06-23 18:55:55', 'STAFF', '3D2D8CCB37'), (656, 3, 'SOLVED', 9, 6, 4, 'WEB Mail Issue', '2008-06-09 10:46:51', 4, null, '2008-06-28 18:27:48', 'STAFF', '26408FFA70'), (657, 2, 'SOLVED', 9, 12, 3, 'Sales Doubt', '2008-06-09 07:53:34', 3, null, '2008-06-24 16:47:25', 'STAFF', 'B4288D9C0E'), (658, 2, 'CLOSED', 2, 19, 4, 'WEB Mail Doubt', '2008-06-09 06:48:46', 1, null, '2008-07-02 16:17:40', 'STAFF', '2F37D10131'), (659, 2, 'SOLVED', 1, 12, 1, 'CRM Application Doubt', '2008-06-09 10:59:17', 3, null, '2008-06-27 13:14:03', 'STAFF', '0FF8033CF9'), (660, 2, 'SOLVED', 9, 24, 3, 'Sales Doubt', '2008-06-09 12:10:02', 4, null, '2008-06-14 13:20:13', 'STAFF', '68264BDB65'), (661, 2, 'SOLVED', 4, 5, 1, 'CRM Application Issue', '2008-06-09 06:57:03', 4, null, '2008-06-18 18:48:10', 'STAFF', '3A066BDA8C'), (662, 3, 'SOLVED', 10, 19, 6, 'Software Issue', '2008-06-09 11:29:38', 2, null, '2008-06-10 13:41:29', 'STAFF', 'BE3159AD04'), (663, 2, 'SOLVED', 8, 31, 6, 'Software Issue', '2008-06-09 10:24:49', 3, null, '2008-06-25 15:21:24', 'STAFF', '8757150DEC'), (664, 1, 'SOLVED', 9, 31, 4, 'WEB Mail Issue', '2008-06-09 08:10:37', 4, null, '2008-06-22 16:53:40', 'STAFF', '2291D2EC3B'), (665, 2, 'CLOSED', 3, 10, 3, 'Sales Doubt', '2008-06-09 08:27:09', 3, null, '2008-06-09 16:37:42', 'STAFF', '84117275BE'), (666, 3, 'SOLVED', 8, 19, 1, 'CRM Application Issue', '2008-06-10 08:21:30', 2, null, '2008-06-15 17:56:09', 'STAFF', 'FAE0B27C45'), (667, 2, 'SOLVED', 10, 5, 1, 'CRM Application Doubt', '2008-06-10 09:34:02', 4, null, '2008-06-11 17:12:11', 'STAFF', 'B5DC4E5D9B'), (668, 1, 'SOLVED', 1, 27, 6, 'Software Issue', '2008-06-10 08:12:41', 2, null, '2008-06-12 13:20:50', 'STAFF', '192FC044E7'), (669, 3, 'SOLVED', 7, 3, 1, 'CRM Application Issue', '2008-06-10 09:22:11', 2, null, '2008-06-14 18:43:58', 'STAFF', '5C04925674'), (670, 2, 'SOLVED', 1, 1, 1, 'CRM Application Doubt', '2008-06-10 10:59:15', 2, null, '2008-06-16 18:00:43', 'STAFF', '17C276C8E7'), (671, 2, 'SOLVED', 1, 35, 5, 'Peripheral Issue', '2008-06-10 07:23:33', 3, null, '2008-06-25 18:17:27', 'STAFF', '5DD9DB5E03'), (672, 3, 'CLOSED', 10, 10, 4, 'WEB Mail Doubt', '2008-06-10 06:37:07', 1, null, '2008-06-21 15:30:05', 'STAFF', '2DEA61EED4'), (673, 3, 'SOLVED', 2, 3, 1, 'CRM Application Doubt', '2008-06-10 07:35:23', 2, null, '2008-06-18 16:45:14', 'STAFF', '9F396FE44E'), (674, 3, 'SOLVED', 10, 21, 5, 'Peripheral Doubt', '2008-06-10 10:51:09', 2, null, '2008-06-24 18:56:05', 'STAFF', '0D7DE1ACA9'), (675, 1, 'SOLVED', 10, 17, 4, 'WEB Mail Doubt', '2008-06-10 08:48:57', 4, null, '2008-06-14 14:43:08', 'STAFF', '8FECB20817'), (676, 3, 'SOLVED', 2, 26, 6, 'Software Doubt', '2008-06-10 10:09:47', 4, null, '2008-06-16 18:28:01', 'STAFF', 'DC6A70712A'), (677, 2, 'SOLVED', 4, 25, 4, 'WEB Mail Doubt', '2008-06-10 11:02:13', 2, null, '2008-06-20 15:13:39', 'STAFF', '71A3CB155F'), (678, 1, 'SOLVED', 9, 13, 1, 'CRM Application Doubt', '2008-06-11 08:05:13', 3, null, '2008-06-12 15:55:19', 'STAFF', '9FE8593A8A'), (679, 2, 'SOLVED', 10, 16, 5, 'Peripheral Issue', '2008-06-11 07:23:41', 4, null, '2008-06-19 16:16:11', 'STAFF', 'CA9C267DAD'), (680, 3, 'SOLVED', 9, 11, 2, 'WEB Site Issue', '2008-06-11 12:03:18', 3, null, '2008-06-18 16:01:33', 'STAFF', 'FCCB3CDC9A'), (681, 2, 'SOLVED', 1, 1, 6, 'Software Doubt', '2008-06-11 09:42:00', 4, null, '2008-06-16 16:06:55', 'STAFF', '1595AF6435'), (682, 3, 'SOLVED', 6, 19, 4, 'WEB Mail Issue', '2008-06-11 11:29:24', 4, null, '2008-06-24 13:55:38', 'STAFF', '08D98638C6'), (683, 2, 'SOLVED', 8, 32, 6, 'Software Issue', '2008-06-11 07:29:00', 2, null, '2008-06-22 16:11:09', 'STAFF', 2468192842), (684, 1, 'CLOSED', 10, 37, 1, 'CRM Application Doubt', '2008-06-11 08:11:55', 1, null, '2008-06-16 15:12:11', 'STAFF', '556F391937'), (685, 3, 'CLOSED', 10, 19, 4, 'WEB Mail Doubt', '2008-06-11 09:17:10', 3, null, '2008-06-15 16:58:08', 'STAFF', '3328BDF9A4'), (686, 2, 'SOLVED', 6, 20, 6, 'Sotfware Issue', '2008-06-12 08:14:41', 3, null, '2008-06-23 18:48:52', 'STAFF', '109A0CA3BC'), (687, 2, 'CLOSED', 3, 10, 1, 'CRM Application Issue', '2008-06-12 06:05:16', 2, null, '2008-06-22 14:53:17', 'STAFF', '7F5D04D189'), (688, 2, 'SOLVED', 3, 21, 6, 'Sotfware Issue', '2008-06-12 10:17:37', 4, null, '2008-06-13 14:00:45', 'STAFF', 'F79921BBAE'), (689, 1, 'CLOSED', 1, 13, 3, 'Sales Doubt', '2008-06-12 12:23:00', 2, null, '2008-06-17 18:45:50', 'STAFF', '07A96B1F61'), (690, 3, 'SOLVED', 1, 10, 1, 'CRM Application Doubt', '2008-06-13 06:18:42', 3, null, '2008-06-23 18:47:59', 'STAFF', 'C06D06DA96'), (691, 2, 'SOLVED', 1, 33, 6, 'Software Doubt', '2008-06-14 08:59:19', 3, null, '2008-06-26 14:29:52', 'STAFF', '10A5AB2DB3'), (692, 2, 'SOLVED', 4, 9, 3, 'Sales Issue', '2008-06-14 07:27:26', 3, null, '2008-06-28 14:47:44', 'STAFF', 'E555EBE0CE'), (693, 2, 'SOLVED', 8, 29, 6, 'Software Doubt', '2008-06-14 09:16:53', 2, null, '2008-06-16 13:02:05', 'STAFF', '53E3A7161E'), (694, 3, 'SOLVED', 1, 6, 6, 'Software Doubt', '2008-06-14 08:23:38', 2, null, '2008-06-27 15:02:51', 'STAFF', '5487315B12'), (695, 1, 'SOLVED', 2, 11, 6, 'Sotfware Issue', '2008-06-14 09:53:37', 2, null, '2008-06-29 17:43:04', 'STAFF', 'E4BB4C5173'), (696, 3, 'SOLVED', 6, 30, 6, 'Software Doubt', '2008-06-14 08:09:11', 4, null, '2008-06-22 18:53:50', 'STAFF', '0CB929EAE7'), (697, 1, 'SOLVED', 9, 6, 3, 'Sales Doubt', '2008-06-14 11:35:49', 4, null, '2008-06-25 14:16:04', 'STAFF', '8A0E1141FD'), (698, 3, 'CLOSED', 10, 39, 2, 'WEB Site Doubt', '2008-06-14 09:26:34', 3, null, '2008-06-24 14:37:47', 'STAFF', '99BCFCD754'), (699, 2, 'SOLVED', 3, 34, 5, 'Peripheral Doubt', '2008-06-14 11:48:26', 2, null, '2008-06-19 16:34:36', 'STAFF', 'AFD4836712'), (700, 1, 'CLOSED', 9, 8, 6, 'Software Issue', '2008-06-14 10:37:53', 2, null, '2008-06-23 13:26:28', 'STAFF', 'E5841DF216'), (701, 3, 'SOLVED', 4, 15, 5, 'Peripheral Issue', '2008-06-14 09:24:08', 2, null, '2008-06-15 15:02:22', 'STAFF', 'B4A528955B'), (702, 1, 'SOLVED', 1, 6, 6, 'Software Issue', '2008-06-14 08:03:43', 3, null, '2008-06-27 17:22:12', 'STAFF', 'B1EEC33C72'), (703, 2, 'SOLVED', 2, 37, 5, 'Peripheral Issue', '2008-06-15 06:37:09', 4, null, '2008-06-15 14:43:01', 'STAFF', 'D6C651DDCD'), (704, 3, 'SOLVED', 4, 19, 1, 'CRM Application Doubt', '2008-06-15 07:14:47', 3, null, '2008-06-28 13:17:19', 'STAFF', 'F64EAC11F2'), (705, 2, 'SOLVED', 3, 38, 4, 'WEB Mail Doubt', '2008-06-15 08:01:08', 2, null, '2008-06-25 16:53:46', 'STAFF', '4A47D2983C'), (706, 2, 'SOLVED', 5, 32, 2, 'WEB Site Issue', '2008-06-15 06:45:07', 3, null, '2008-06-23 14:28:19', 'STAFF', '9C82C7143C'), (707, 2, 'SOLVED', 4, 36, 4, 'WEB Mail Doubt', '2008-06-15 12:11:10', 2, null, '2008-06-22 16:15:05', 'STAFF', '500E75A036'), (708, 2, 'CLOSED', 10, 30, 5, 'Peripheral Doubt', '2008-06-15 10:08:46', 1, null, '2008-07-04 15:04:47', 'STAFF', 'AE0EB3EED3'), (709, 3, 'SOLVED', 10, 38, 1, 'CRM Application Issue', '2008-06-15 09:58:58', 2, null, '2008-06-19 18:02:51', 'STAFF', '1ECFB46347'), (710, 3, 'SOLVED', 9, 39, 2, 'WEB Site Issue', '2008-06-15 09:53:19', 3, null, '2008-06-17 15:55:26', 'STAFF', 'E70611883D'), (711, 1, 'SOLVED', 6, 35, 3, 'Sales Issue', '2008-06-15 07:14:05', 3, null, '2008-06-17 13:00:21', 'STAFF', 6081594975), (712, 3, 'SOLVED', 9, 20, 6, 'Software Issue', '2008-06-16 09:24:53', 4, null, '2008-06-24 13:29:18', 'STAFF', '19BC916108'), (713, 2, 'SOLVED', 10, 17, 2, 'WEB Site Issue', '2008-06-16 08:32:16', 4, null, '2008-06-29 17:59:45', 'STAFF', '07C5807D0D'), (714, 1, 'SOLVED', 3, 28, 4, 'WEB Mail Doubt', '2008-06-16 09:35:20', 3, null, '2008-06-27 17:37:02', 'STAFF', 'D14220EE66'), (715, 2, 'SOLVED', 3, 17, 1, 'CRM Application Doubt', '2008-06-16 07:58:50', 4, null, '2008-06-18 17:35:00', 'STAFF', '8DF707A948'), (716, 2, 'SOLVED', 9, 8, 6, 'Software Doubt', '2008-06-16 08:23:20', 3, null, '2008-06-26 18:50:12', 'STAFF', 'E7F8A7FB0B'), (717, 2, 'SOLVED', 5, 5, 6, 'Software Doubt', '2008-06-16 06:40:24', 4, null, '2008-06-24 17:18:18', 'STAFF', '788D986905'), (718, 2, 'SOLVED', 7, 25, 2, 'WEB Site Issue', '2008-06-16 11:43:28', 2, null, '2008-07-04 18:25:51', 'STAFF', '50C3D76149'), (719, 2, 'CLOSED', 10, 38, 6, 'Software Doubt', '2008-06-16 09:13:38', 3, null, '2008-06-19 17:57:44', 'STAFF', '2AFE4567E1'), (720, 1, 'SOLVED', 4, 11, 2, 'WEB Site Issue', '2008-06-16 08:53:26', 2, null, '2008-06-27 15:13:52', 'STAFF', '5F2C22CB4A'), (721, 3, 'SOLVED', 9, 3, 2, 'WEB Site Issue', '2008-06-16 10:19:01', 2, null, '2008-07-07 18:02:33', 'STAFF', 'ABA3B6FD5D'), (722, 1, 'CLOSED', 1, 25, 6, 'Software Doubt', '2008-06-16 08:14:36', 2, null, '2008-06-17 18:37:51', 'STAFF', 'C8ED21DB4F'), (723, 2, 'SOLVED', 9, 39, 2, 'WEB Site Issue', '2008-06-16 12:02:40', 3, null, '2008-07-05 15:26:52', 'STAFF', '08419BE897'), (724, 2, 'SOLVED', 7, 7, 2, 'WEB Site Issue', '2008-06-16 08:30:03', 3, null, '2008-06-25 13:49:57', 'STAFF', '7F1171A78C'), (725, 2, 'SOLVED', 9, 12, 5, 'Peripheral Doubt', '2008-06-16 10:45:09', 3, null, '2008-06-26 15:17:37', 'STAFF', '82F2B308C3'), (726, 1, 'CLOSED', 5, 11, 4, 'WEB Mail Doubt', '2008-06-16 07:18:39', 3, null, '2008-06-28 15:19:20', 'STAFF', '0D3180D672'), (727, 2, 'SOLVED', 10, 28, 1, 'CRM Application Issue', '2008-06-16 10:09:26', 2, null, '2008-07-03 14:44:15', 'STAFF', 'FB89705AE6'), (728, 3, 'CLOSED', 7, 14, 4, 'WEB Mail Doubt', '2008-06-17 10:40:21', 3, null, '2008-07-04 18:40:14', 'STAFF', 'D4C2E4A329'), (729, 2, 'SOLVED', 4, 37, 1, 'CRM Application Issue', '2008-06-17 11:30:22', 3, null, '2008-06-19 16:20:27', 'STAFF', '5751EC3E9A'), (730, 2, 'SOLVED', 5, 30, 3, 'Sales Doubt', '2008-06-17 11:31:54', 3, null, '2008-07-01 13:48:25', 'STAFF', 'D5CFEAD94F'), (731, 1, 'SOLVED', 6, 19, 4, 'WEB Mail Doubt', '2008-06-17 10:03:05', 2, null, '2008-07-03 14:57:46', 'STAFF', '59C3301688'), (732, 2, 'SOLVED', 5, 7, 5, 'Peripheral Issue', '2008-06-17 10:17:02', 2, null, '2008-06-22 18:22:23', 'STAFF', 'BA3866600C'), (733, 3, 'SOLVED', 8, 38, 5, 'Peripheral Issue', '2008-06-17 08:33:28', 2, null, '2008-06-17 15:31:26', 'STAFF', '6C29793A14'), (734, 1, 'SOLVED', 6, 4, 4, 'WEB Mail Doubt', '2008-06-17 07:35:43', 3, null, '2008-06-24 18:10:18', 'STAFF', 'E995F98D56'), (735, 2, 'CLOSED', 3, 36, 2, 'WEB Site Issue', '2008-06-17 07:05:16', 1, null, '2008-07-02 17:59:06', 'STAFF', '6CD67D9B6F'), (736, 3, 'SOLVED', 6, 37, 6, 'Software Issue', '2008-06-17 10:22:23', 3, null, '2008-06-23 14:07:48', 'STAFF', '6BC24FC1AB'), (737, 1, 'SOLVED', 7, 10, 5, 'Peripheral Doubt', '2008-06-18 07:05:47', 3, null, '2008-06-29 17:23:33', 'STAFF', 'A5CDD4AA00'), (738, 1, 'SOLVED', 6, 23, 3, 'Sales Doubt', '2008-06-18 12:17:36', 4, null, '2008-06-25 14:39:39', 'STAFF', '217EEDD1BA'), (739, 1, 'SOLVED', 9, 23, 5, 'Peripheral Doubt', '2008-06-18 11:44:13', 2, null, '2008-06-22 15:48:22', 'STAFF', 'DF263D9962'), (740, 2, 'SOLVED', 10, 11, 6, 'Software Doubt', '2008-06-18 08:38:47', 2, null, '2008-07-07 14:38:10', 'STAFF', 'EDFBE1AFCF'), (741, 2, 'SOLVED', 1, 1, 6, 'Software Doubt', '2008-06-18 12:31:44', 4, null, '2008-06-28 16:53:17', 'STAFF', '2E65F2F2FD'), (742, 3, 'SOLVED', 10, 20, 6, 'Software Doubt', '2008-06-19 08:40:42', 2, null, '2008-06-30 14:32:22', 'STAFF', 'E94550C93C'), (743, 2, 'SOLVED', 8, 9, 6, 'Software Issue', '2008-06-20 09:36:24', 3, null, '2008-06-23 15:21:17', 'STAFF', '5C572ECA05'), (744, 2, 'SOLVED', 10, 29, 3, 'Sales Doubt', '2008-06-20 09:11:26', 3, null, '2008-06-30 14:24:03', 'STAFF', '0537FB40A6'), (745, 1, 'SOLVED', 4, 39, 5, 'Peripheral Doubt', '2008-06-21 09:47:50', 4, null, '2008-07-02 15:38:15', 'STAFF', '5F0F5E5F33'), (746, 1, 'CLOSED', 5, 23, 1, 'CRM Application Doubt', '2008-06-21 12:11:53', 3, null, '2008-06-30 16:22:15', 'STAFF', '185E65BC40'), (747, 3, 'SOLVED', 2, 25, 6, 'Sotfware Issue', '2008-06-21 11:29:07', 3, null, '2008-07-09 13:13:29', 'STAFF', '8D317BDCF4'), (748, 3, 'CLOSED', 9, 10, 1, 'CRM Application Issue', '2008-06-21 11:02:10', 1, null, '2008-07-06 18:48:26', 'STAFF', 'E49B8B4053'), (749, 3, 'SOLVED', 1, 12, 5, 'Peripheral Issue', '2008-06-21 10:59:35', 4, null, '2008-06-24 15:44:53', 'STAFF', 'B056EB1587'), (750, 2, 'SOLVED', 10, 7, 4, 'WEB Mail Doubt', '2008-06-21 12:36:50', 2, null, '2008-07-12 16:28:40', 'STAFF', 'B137FDD1F7'), (751, 2, 'SOLVED', 6, 38, 6, 'Software Doubt', '2008-06-21 11:56:01', 4, null, '2008-06-23 18:32:44', 'STAFF', '912D2B1C7B'), (752, 3, 'SOLVED', 10, 22, 3, 'Sales Doubt', '2008-06-21 06:09:40', 3, null, '2008-07-04 18:14:01', 'STAFF', 'A1D33D0DFE'), (753, 3, 'SOLVED', 3, 1, 6, 'Software Issue', '2008-06-21 12:48:25', 2, null, '2008-06-21 15:28:55', 'STAFF', '6F2268BD1D'), (754, 3, 'SOLVED', 8, 1, 3, 'Sales Doubt', '2008-06-21 06:37:54', 3, null, '2008-07-03 17:08:57', 'STAFF', '872488F88D'), (755, 1, 'CLOSED', 9, 18, 6, 'Software Doubt', '2008-06-21 06:30:14', 3, null, '2008-06-27 16:30:04', 'STAFF', 'CCB0989662'), (756, 1, 'CLOSED', 10, 38, 3, 'Sales Doubt', '2008-06-21 11:54:04', 3, null, '2008-06-22 18:39:23', 'STAFF', '2823F47971'), (757, 2, 'SOLVED', 9, 17, 6, 'Software Doubt', '2008-06-22 07:50:59', 4, null, '2008-06-22 15:58:52', 'STAFF', '470E7A4F01'), (758, 1, 'SOLVED', 2, 35, 6, 'Software Doubt', '2008-06-22 08:03:48', 3, null, '2008-06-25 15:18:29', 'STAFF', 'BF62768CA4'), (759, 1, 'SOLVED', 9, 36, 5, 'Peripheral Issue', '2008-06-22 06:02:21', 3, null, '2008-06-26 14:50:42', 'STAFF', 'FA14D4FE2F'), (760, 2, 'SOLVED', 7, 11, 5, 'Peripheral Doubt', '2008-06-22 08:59:29', 3, null, '2008-07-03 16:36:58', 'STAFF', '2CA65F58E3'), (761, 1, 'CLOSED', 10, 31, 5, 'Peripheral Doubt', '2008-06-22 07:33:31', 2, null, '2008-07-01 16:12:34', 'STAFF', '88AE6372CF'), (762, 2, 'SOLVED', 9, 17, 6, 'Software Issue', '2008-06-22 07:19:41', 2, null, '2008-06-28 18:27:32', 'STAFF', '06997F04A7'), (763, 3, 'SOLVED', 9, 35, 6, 'Software Issue', '2008-06-22 06:57:49', 2, null, '2008-06-22 17:31:19', 'STAFF', 'EEFC9E10EB'), (764, 2, 'CLOSED', 10, 19, 6, 'Sotfware Issue', '2008-06-22 09:08:16', 1, null, '2008-06-29 14:41:39', 'STAFF', '5807A685D1'), (765, 2, 'SOLVED', 1, 5, 6, 'Software Issue', '2008-06-23 06:09:33', 3, null, '2008-06-24 14:48:06', 'STAFF', 'D840CC5D90'), (766, 1, 'CLOSED', 1, 32, 5, 'Peripheral Issue', '2008-06-23 12:27:02', 1, null, '2008-07-11 13:04:27', 'STAFF', '959A557F5F'), (767, 1, 'SOLVED', 1, 24, 2, 'WEB Site Issue', '2008-06-23 11:44:08', 2, null, '2008-07-04 18:49:13', 'STAFF', 'F2201F5191'), (768, 3, 'SOLVED', 2, 28, 6, 'Software Issue', '2008-06-23 08:48:35', 3, null, '2008-06-30 17:29:23', 'STAFF', '3A835D3215'), (769, 1, 'SOLVED', 1, 36, 6, 'Software Issue', '2008-06-23 09:44:22', 4, null, '2008-06-28 15:18:48', 'STAFF', '288CC0FF02'), (770, 2, 'SOLVED', 10, 23, 4, 'WEB Mail Issue', '2008-06-23 06:50:16', 2, null, '2008-07-11 14:42:27', 'STAFF', '4EA06FBC83'), (771, 3, 'SOLVED', 2, 8, 5, 'Peripheral Issue', '2008-06-23 11:57:37', 2, null, '2008-07-06 14:24:10', 'STAFF', 'B7EE6F5F9A'), (772, 2, 'SOLVED', 10, 32, 6, 'Software Issue', '2008-06-23 10:22:05', 3, null, '2008-06-30 15:46:19', 'STAFF', 'E57C6B956A'), (773, 2, 'SOLVED', 1, 20, 6, 'Software Issue', '2008-06-23 07:45:18', 4, null, '2008-06-24 16:48:27', 'STAFF', '86B122D435'), (774, 2, 'SOLVED', 5, 24, 6, 'Software Issue', '2008-06-23 07:22:28', 2, null, '2008-06-27 15:25:58', 'STAFF', '4E0928DE07'), (775, 1, 'SOLVED', 3, 6, 2, 'WEB Site Issue', '2008-06-23 09:44:17', 3, null, '2008-07-02 14:36:42', 'STAFF', 'C0F168CE89'), (776, 2, 'SOLVED', 10, 18, 5, 'Peripheral Doubt', '2008-06-23 08:07:56', 4, null, '2008-07-03 14:05:54', 'STAFF', '8C6744C9D4'), (777, 2, 'CLOSED', 10, 8, 6, 'Software Issue', '2008-06-23 07:05:56', 3, null, '2008-06-25 15:18:55', 'STAFF', 'F1C1592588'), (778, 2, 'SOLVED', 6, 5, 4, 'WEB Mail Doubt', '2008-06-23 11:18:53', 3, null, '2008-07-03 13:58:27', 'STAFF', 'E074133548'), (779, 2, 'SOLVED', 10, 19, 5, 'Peripheral Doubt', '2008-06-23 06:51:15', 4, null, '2008-07-04 13:11:43', 'STAFF', '67D96D458A'), (780, 2, 'SOLVED', 2, 23, 1, 'CRM Application Doubt', '2008-06-24 08:25:00', 2, null, '2008-07-08 13:40:40', 'STAFF', 'A8E864D04C'), (781, 2, 'SOLVED', 3, 33, 6, 'Software Issue', '2008-06-24 10:31:30', 3, null, '2008-06-30 18:14:10', 'STAFF', '7143D7FBAD'), (782, 3, 'CLOSED', 9, 36, 3, 'Sales Doubt', '2008-06-24 09:53:44', 1, null, '2008-06-29 18:08:45', 'STAFF', '72DA7FD6D1'), (783, 2, 'SOLVED', 5, 17, 6, 'Software Doubt', '2008-06-24 06:49:10', 4, null, '2008-06-28 18:04:12', 'STAFF', '6E0721B2C6'), (784, 2, 'SOLVED', 2, 28, 6, 'Software Doubt', '2008-06-24 06:47:02', 4, null, '2008-07-08 14:06:58', 'STAFF', 'FC8001F834'), (785, 1, 'SOLVED', 9, 36, 2, 'WEB Site Issue', '2008-06-24 06:29:25', 2, null, '2008-06-25 15:33:38', 'STAFF', '4B04A686B0'), (786, 1, 'CLOSED', 4, 10, 5, 'Peripheral Doubt', '2008-06-24 10:18:13', 3, null, '2008-07-04 18:41:49', 'STAFF', '61B4A64BE6'), (787, 1, 'SOLVED', 1, 31, 6, 'Sotfware Issue', '2008-06-24 09:34:18', 3, null, '2008-06-24 17:48:50', 'STAFF', '3621F1454C'), (788, 2, 'SOLVED', 2, 17, 5, 'Peripheral Issue', '2008-06-24 09:51:06', 2, null, '2008-07-03 16:16:11', 'STAFF', 'C15DA1F2B5'), (789, 3, 'SOLVED', 5, 1, 6, 'Software Doubt', '2008-06-24 09:44:28', 4, null, '2008-06-29 13:48:49', 'STAFF', '68053AF292'), (790, 3, 'CLOSED', 9, 23, 4, 'WEB Mail Doubt', '2008-06-24 08:41:44', 2, null, '2008-07-05 15:31:33', 'STAFF', '2DACE78F80'), (791, 3, 'CLOSED', 5, 38, 3, 'Sales Doubt', '2008-06-24 11:58:19', 1, null, '2008-07-11 15:37:12', 'STAFF', 'DF7F28AC89'), (792, 3, 'SOLVED', 1, 38, 4, 'WEB Mail Doubt', '2008-06-25 08:34:47', 2, null, '2008-07-07 17:02:22', 'STAFF', '96EA64F3A1'), (793, 2, 'SOLVED', 9, 11, 5, 'Peripheral Doubt', '2008-06-25 11:44:37', 3, null, '2008-06-27 18:40:45', 'STAFF', 'DA8CE53CF0'), (794, 3, 'SOLVED', 4, 2, 6, 'Software Doubt', '2008-06-25 06:19:41', 4, null, '2008-07-06 15:58:53', 'STAFF', '82489C9737'), (795, 3, 'SOLVED', 1, 21, 3, 'Sales Doubt', '2008-06-25 07:23:13', 3, null, '2008-06-25 18:48:14', 'STAFF', '7C590F0149'), (796, 1, 'SOLVED', 3, 24, 3, 'Sales Doubt', '2008-06-25 08:00:17', 2, null, '2008-07-12 16:47:49', 'STAFF', '35CF8659CF'), (797, 3, 'SOLVED', 10, 19, 4, 'WEB Mail Doubt', '2008-06-25 11:09:52', 4, null, '2008-07-01 16:23:09', 'STAFF', 'BEB22FB694'), (798, 2, 'CLOSED', 8, 29, 4, 'WEB Mail Doubt', '2008-06-26 07:36:13', 2, null, '2008-06-27 15:49:34', 'STAFF', '9E3CFC48EC');
INSERT INTO "ticket" VALUES (799, 2, 'SOLVED', 10, 26, 1, 'CRM Application Issue', '2008-06-26 11:56:08', 3, null, '2008-07-05 14:55:06', 'STAFF', '28267AB848'), (800, 2, 'SOLVED', 1, 35, 5, 'Peripheral Doubt', '2008-06-26 10:46:24', 4, null, '2008-07-13 16:20:54', 'STAFF', '7A53928FA4'), (801, 3, 'CLOSED', 5, 20, 2, 'WEB Site Issue', '2008-06-26 07:05:52', 2, null, '2008-07-05 16:38:42', 'STAFF', '1905AEDAB9'), (802, 2, 'SOLVED', 6, 11, 6, 'Software Issue', '2008-06-26 06:47:01', 2, null, '2008-07-11 18:31:24', 'STAFF', '1141938BA2'), (803, 1, 'SOLVED', 9, 23, 3, 'Sales Doubt', '2008-06-28 07:45:02', 4, null, '2008-06-28 18:05:19', 'STAFF', '1AA48FC488'), (804, 2, 'SOLVED', 10, 31, 5, 'Peripheral Issue', '2008-06-28 11:26:41', 2, null, '2008-07-06 17:13:15', 'STAFF', 'DC5689792E'), (805, 2, 'SOLVED', 7, 31, 2, 'WEB Site Issue', '2008-06-28 12:39:28', 3, null, '2008-07-12 17:37:03', 'STAFF', '846C260D71'), (806, 2, 'SOLVED', 4, 11, 3, 'Sales Doubt', '2008-06-28 07:01:16', 2, null, '2008-07-01 17:04:54', 'STAFF', 'D58072BE28'), (807, 2, 'SOLVED', 1, 38, 6, 'Sotfware Issue', '2008-06-28 12:54:48', 3, null, '2008-07-02 18:49:41', 'STAFF', '6E7B33FDEA'), (808, 2, 'SOLVED', 6, 32, 6, 'Sotfware Issue', '2008-06-28 12:36:44', 4, null, '2008-07-08 17:00:02', 'STAFF', 'A8ECBABAE1'), (809, 2, 'SOLVED', 5, 32, 6, 'Software Doubt', '2008-06-28 09:23:10', 3, null, '2008-07-05 15:43:00', 'STAFF', '32B30A250A'), (810, 3, 'SOLVED', 1, 7, 5, 'Peripheral Doubt', '2008-06-28 06:35:54', 3, null, '2008-06-29 16:53:53', 'STAFF', 'B6EDC1CD1F'), (811, 2, 'SOLVED', 3, 36, 3, 'Sales Doubt', '2008-06-28 09:17:28', 4, null, '2008-07-01 13:23:37', 'STAFF', '670E8A43B2'), (812, 2, 'CLOSED', 10, 17, 3, 'Sales Issue', '2008-06-28 12:10:38', 2, null, '2008-06-28 15:00:14', 'STAFF', '81E74D6785'), (813, 2, 'SOLVED', 7, 7, 6, 'Sotfware Issue', '2008-06-28 08:04:39', 2, null, '2008-07-07 16:45:50', 'STAFF', 'E0CF1F4711'), (814, 1, 'SOLVED', 9, 20, 5, 'Peripheral Issue', '2008-06-29 06:42:39', 3, null, '2008-07-03 16:24:08', 'STAFF', '96B9BFF013'), (815, 2, 'CLOSED', 1, 5, 5, 'Peripheral Issue', '2008-06-29 08:50:09', 2, null, '2008-07-10 16:35:25', 'STAFF', '71AD16AD2C'), (816, 3, 'SOLVED', 1, 22, 5, 'Peripheral Issue', '2008-06-29 11:50:14', 2, null, '2008-07-20 13:19:05', 'STAFF', '43FA7F58B7'), (817, 1, 'SOLVED', 3, 31, 6, 'Software Doubt', '2008-06-29 08:34:06', 4, null, '2008-07-02 14:35:41', 'STAFF', '31839B036F'), (818, 2, 'SOLVED', 1, 19, 5, 'Peripheral Issue', '2008-06-29 11:04:55', 4, null, '2008-07-02 15:36:30', 'STAFF', 'F0ADC8838F'), (819, 2, 'SOLVED', 9, 33, 2, 'WEB Site Doubt', '2008-06-29 11:05:50', 2, null, '2008-07-08 17:20:41', 'STAFF', '3B5DCA501E'), (820, 3, 'SOLVED', 5, 34, 6, 'Software Issue', '2008-06-29 08:16:02', 4, null, '2008-07-09 18:01:59', 'STAFF', 'E2A2DCC36A'), (821, 1, 'SOLVED', 10, 35, 4, 'WEB Mail Issue', '2008-06-29 12:13:49', 3, null, '2008-06-30 18:37:08', 'STAFF', '4558DBB6F6'), (822, 1, 'SOLVED', 9, 7, 1, 'CRM Application Issue', '2008-06-29 12:48:52', 3, null, '2008-07-03 14:15:41', 'STAFF', 'AFDA332245'), (823, 1, 'SOLVED', 4, 35, 6, 'Sotfware Issue', '2008-06-30 06:00:06', 3, null, '2008-07-02 13:01:07', 'STAFF', '632CEE946D'), (824, 3, 'SOLVED', 1, 7, 1, 'CRM Application Doubt', '2008-06-30 06:00:49', 2, null, '2008-07-01 16:32:21', 'STAFF', '677E09724F'), (825, 2, 'CLOSED', 2, 27, 5, 'Peripheral Issue', '2008-06-30 06:42:03', 3, null, '2008-06-30 17:37:35', 'STAFF', 'D554F7BB7B'), (826, 2, 'SOLVED', 4, 37, 4, 'WEB Mail Issue', '2008-06-30 08:18:35', 3, null, '2008-07-05 14:59:01', 'STAFF', '795C7A7A5E'), (827, 1, 'SOLVED', 5, 4, 2, 'WEB Site Doubt', '2008-06-30 06:16:33', 3, null, '2008-07-19 17:12:21', 'STAFF', 'FA3A3C407F'), (828, 1, 'CLOSED', 1, 28, 3, 'Sales Doubt', '2008-06-30 06:45:12', 2, null, '2008-07-02 14:18:47', 'STAFF', 'C2626D850C'), (829, 2, 'SOLVED', 4, 11, 6, 'Software Doubt', '2008-06-30 09:33:43', 4, null, '2008-07-13 15:58:01', 'STAFF', 'CE78D1DA25'), (830, 2, 'CLOSED', 10, 6, 2, 'WEB Site Issue', '2008-06-30 12:44:59', 2, null, '2008-06-30 17:21:19', 'STAFF', '8E82AB7243'), (831, 3, 'SOLVED', 8, 8, 6, 'Software Doubt', '2008-06-30 10:48:18', 3, null, '2008-07-02 15:25:48', 'STAFF', 'E0EC453E28'), (832, 2, 'SOLVED', 9, 34, 2, 'WEB Site Issue', '2008-06-30 08:34:38', 4, null, '2008-07-10 13:19:50', 'STAFF', '7250EB93B3'), (833, 1, 'SOLVED', 5, 10, 6, 'Software Doubt', '2008-06-30 06:54:27', 4, null, '2008-07-05 14:03:05', 'STAFF', '013A006F03'), (834, 2, 'SOLVED', 1, 32, 6, 'Software Issue', '2008-06-30 06:48:27', 2, null, '2008-07-10 16:40:16', 'STAFF', '301AD0E3BD'), (835, 1, 'SOLVED', 8, 33, 3, 'Sales Doubt', '2008-06-30 08:49:17', 3, null, '2008-07-05 14:15:42', 'STAFF', '4D5B995358'), (836, 2, 'SOLVED', 6, 36, 6, 'Software Doubt', '2008-06-30 07:21:15', 4, null, '2008-07-04 17:57:54', 'STAFF', 'AB88B15733'), (837, 2, 'SOLVED', 1, 8, 4, 'WEB Mail Issue', '2008-06-30 11:48:52', 3, null, '2008-07-02 13:19:33', 'STAFF', 'B0B183C207'), (838, 1, 'SOLVED', 2, 21, 6, 'Software Doubt', '2008-07-01 06:53:51', 3, null, '2008-07-04 17:16:53', 'STAFF', 'F9028FAEC7'), (839, 2, 'SOLVED', 10, 19, 2, 'WEB Site Doubt', '2008-07-01 08:15:00', 4, null, '2008-07-16 16:41:38', 'STAFF', '8F7D807E1F'), (840, 2, 'SOLVED', 8, 37, 5, 'Peripheral Issue', '2008-07-01 10:12:12', 4, null, '2008-07-14 15:14:56', 'STAFF', 'FA83A11A19'), (841, 2, 'SOLVED', 1, 38, 2, 'WEB Site Issue', '2008-07-01 08:41:23', 3, null, '2008-07-02 17:17:25', 'STAFF', '02A32AD266'), (842, 3, 'SOLVED', 1, 6, 5, 'Peripheral Issue', '2008-07-01 07:48:29', 3, null, '2008-07-07 18:14:45', 'STAFF', 'FC3CF452D3'), (843, 1, 'CLOSED', 5, 1, 3, 'Sales Doubt', '2008-07-01 09:36:43', 3, null, '2008-07-15 13:12:20', 'STAFF', '3D8E28CAF9'), (844, 2, 'SOLVED', 2, 1, 4, 'WEB Mail Issue', '2008-07-01 06:24:56', 4, null, '2008-07-22 15:15:52', 'STAFF', 'E97EE2054D'), (845, 2, 'CLOSED', 10, 14, 5, 'Peripheral Issue', '2008-07-01 10:31:50', 3, null, '2008-07-06 13:12:23', 'STAFF', 'B86E8D03FE'), (846, 2, 'SOLVED', 9, 21, 4, 'WEB Mail Doubt', '2008-07-02 11:13:12', 2, null, '2008-07-14 14:20:22', 'STAFF', '84F7E69969'), (847, 2, 'SOLVED', 5, 14, 1, 'CRM Application Doubt', '2008-07-02 06:31:18', 2, null, '2008-07-16 17:04:34', 'STAFF', 'F4552671F8'), (848, 1, 'SOLVED', 4, 39, 5, 'Peripheral Issue', '2008-07-02 08:32:20', 4, null, '2008-07-03 14:28:35', 'STAFF', '362E80D4DF'), (849, 2, 'SOLVED', 3, 13, 6, 'Software Doubt', '2008-07-02 09:07:58', 2, null, '2008-07-14 13:53:21', 'STAFF', 'FE8C15FED5'), (850, 1, 'CLOSED', 9, 24, 6, 'Software Issue', '2008-07-02 10:20:47', 1, null, '2008-07-12 14:03:40', 'STAFF', '1EFA39BCAE'), (851, 1, 'SOLVED', 8, 26, 2, 'WEB Site Issue', '2008-07-02 07:29:27', 2, null, '2008-07-18 16:05:15', 'STAFF', '92FB0C6D17'), (852, 3, 'SOLVED', 4, 9, 2, 'WEB Site Doubt', '2008-07-02 10:19:48', 3, null, '2008-07-22 14:58:48', 'STAFF', '22AC3C5A5B'), (853, 3, 'CLOSED', 1, 11, 1, 'CRM Application Issue', '2008-07-02 06:51:02', 2, null, '2008-07-05 17:38:26', 'STAFF', 'AFF1621254'), (854, 2, 'SOLVED', 9, 39, 6, 'Software Issue', '2008-07-03 07:00:09', 4, null, '2008-07-07 15:54:07', 'STAFF', 'F7E9050C92'), (855, 2, 'SOLVED', 3, 17, 6, 'Software Issue', '2008-07-03 09:21:22', 3, null, '2008-07-14 18:07:11', 'STAFF', 'ADDFA9B7E2'), (856, 2, 'SOLVED', 9, 25, 6, 'Sotfware Issue', '2008-07-03 06:18:27', 3, null, '2008-07-20 14:45:25', 'STAFF', '8C235F89A8'), (857, 2, 'SOLVED', 6, 19, 4, 'WEB Mail Issue', '2008-07-05 12:06:23', 2, null, '2008-07-06 17:08:45', 'STAFF', '847CC55B70'), (858, 3, 'SOLVED', 8, 28, 6, 'Software Doubt', '2008-07-05 12:57:46', 2, null, '2008-07-17 14:53:29', 'STAFF', 'A67F096809'), (859, 3, 'SOLVED', 3, 35, 5, 'Peripheral Issue', '2008-07-05 12:30:40', 2, null, '2008-07-17 13:52:24', 'STAFF', '2A084E55C8'), (860, 3, 'SOLVED', 10, 10, 4, 'WEB Mail Doubt', '2008-07-05 08:12:34', 4, null, '2008-07-17 13:51:43', 'STAFF', 'FC49306D97'), (861, 2, 'SOLVED', 10, 34, 4, 'WEB Mail Doubt', '2008-07-05 11:07:07', 4, null, '2008-07-13 16:48:58', 'STAFF', 'F9A40A4780'), (862, 2, 'SOLVED', 7, 19, 2, 'WEB Site Issue', '2008-07-05 10:30:57', 2, null, '2008-07-15 16:52:15', 'STAFF', '5EC91AAC30'), (863, 2, 'SOLVED', 8, 6, 4, 'WEB Mail Doubt', '2008-07-05 08:25:36', 2, null, '2008-07-09 14:24:06', 'STAFF', '19B650660B'), (864, 2, 'SOLVED', 1, 28, 6, 'Software Issue', '2008-07-05 07:05:31', 3, null, '2008-07-19 16:07:31', 'STAFF', '1FC214004C'), (865, 2, 'CLOSED', 5, 39, 6, 'Software Issue', '2008-07-05 06:26:19', 3, null, '2008-07-12 13:37:50', 'STAFF', '3B3DBAF685'), (866, 1, 'SOLVED', 10, 39, 4, 'WEB Mail Doubt', '2008-07-05 08:33:55', 4, null, '2008-07-16 15:09:32', 'STAFF', 'CA8155F4D2'), (867, 1, 'SOLVED', 7, 17, 2, 'WEB Site Issue', '2008-07-05 08:57:56', 2, null, '2008-07-12 18:33:55', 'STAFF', 'EDE7E2B6D1'), (868, 2, 'SOLVED', 10, 32, 4, 'WEB Mail Issue', '2008-07-06 09:56:17', 4, null, '2008-07-19 17:58:24', 'STAFF', 'DD45045F8C'), (869, 1, 'CLOSED', 6, 6, 5, 'Peripheral Issue', '2008-07-06 11:31:50', 2, null, '2008-07-24 13:19:02', 'STAFF', '49C9ADB18E'), (870, 2, 'SOLVED', 1, 31, 6, 'Software Doubt', '2008-07-06 09:25:23', 3, null, '2008-07-16 15:22:50', 'STAFF', '22FB0CEE7E'), (871, 2, 'SOLVED', 9, 33, 6, 'Software Doubt', '2008-07-06 08:22:12', 2, null, '2008-07-10 13:33:00', 'STAFF', 'AEB3135B43'), (872, 2, 'SOLVED', 7, 8, 6, 'Software Doubt', '2008-07-06 11:37:17', 4, null, '2008-07-09 13:16:58', 'STAFF', '43FEAEEECD'), (873, 2, 'SOLVED', 2, 1, 5, 'Peripheral Doubt', '2008-07-07 07:03:52', 3, null, '2008-07-08 15:23:22', 'STAFF', '98D6F58AB0'), (874, 2, 'CLOSED', 5, 20, 3, 'Sales Doubt', '2008-07-07 09:50:03', 3, null, '2008-07-18 15:01:36', 'STAFF', '51EF186E18'), (875, 2, 'CLOSED', 8, 19, 4, 'WEB Mail Issue', '2008-07-07 08:24:33', 1, null, '2008-07-07 13:44:12', 'STAFF', '4B0A59DDF1'), (876, 1, 'CLOSED', 3, 5, 5, 'Peripheral Issue', '2008-07-07 07:40:44', 1, null, '2008-07-15 15:47:02', 'STAFF', '67D16D0020'), (877, 2, 'SOLVED', 4, 25, 3, 'Sales Doubt', '2008-07-07 06:48:55', 2, null, '2008-07-27 18:18:48', 'STAFF', '352407221A'), (878, 1, 'SOLVED', 9, 26, 6, 'Software Issue', '2008-07-07 09:19:36', 2, null, '2008-07-14 13:31:45', 'STAFF', 'DD8EB9F23F'), (879, 2, 'SOLVED', 3, 20, 3, 'Sales Doubt', '2008-07-07 07:59:18', 2, null, '2008-07-20 13:56:56', 'STAFF', 'D516B13671'), (880, 2, 'CLOSED', 10, 26, 5, 'Peripheral Doubt', '2008-07-07 07:32:53', 2, null, '2008-07-11 15:42:10', 'STAFF', '1F50893F80'), (881, 3, 'SOLVED', 1, 32, 4, 'WEB Mail Doubt', '2008-07-07 09:46:15', 4, null, '2008-07-11 17:49:23', 'STAFF', '7504ADAD8B'), (882, 2, 'SOLVED', 4, 3, 4, 'WEB Mail Doubt', '2008-07-07 10:06:07', 2, null, '2008-07-22 13:34:27', 'STAFF', '6C3CF77D52'), (883, 2, 'CLOSED', 10, 1, 1, 'CRM Application Issue', '2008-07-07 11:39:57', 1, null, '2008-07-22 18:31:07', 'STAFF', '210F760A89'), (884, 1, 'SOLVED', 1, 36, 2, 'WEB Site Issue', '2008-07-07 07:27:52', 4, null, '2008-07-12 14:07:09', 'STAFF', '170C944978'), (885, 2, 'SOLVED', 8, 17, 4, 'WEB Mail Issue', '2008-07-07 11:39:11', 3, null, '2008-07-14 18:50:30', 'STAFF', '0EFE32849D'), (886, 2, 'CLOSED', 4, 33, 1, 'CRM Application Issue', '2008-07-07 10:04:06', 1, null, '2008-07-21 16:19:02', 'STAFF', '704AFE0739'), (887, 2, 'SOLVED', 9, 23, 4, 'WEB Mail Issue', '2008-07-07 06:49:20', 2, null, '2008-07-12 13:27:26', 'STAFF', '7CE3284B74'), (888, 3, 'CLOSED', 3, 6, 6, 'Software Issue', '2008-07-07 09:33:59', 3, null, '2008-07-11 17:56:27', 'STAFF', '0A113EF6B6'), (889, 3, 'SOLVED', 4, 30, 6, 'Software Issue', '2008-07-08 12:43:23', 2, null, '2008-07-15 14:11:54', 'STAFF', '07871915A8'), (890, 2, 'CLOSED', 10, 20, 6, 'Software Issue', '2008-07-08 11:09:27', 2, null, '2008-07-17 16:28:34', 'STAFF', '024D7F84FF'), (891, 1, 'SOLVED', 8, 25, 4, 'WEB Mail Doubt', '2008-07-08 06:24:39', 4, null, '2008-07-16 16:45:33', 'STAFF', 'CFBCE4C1D7'), (892, 3, 'CLOSED', 1, 11, 1, 'CRM Application Issue', '2008-07-08 06:25:52', 2, null, '2008-07-18 16:00:20', 'STAFF', 'C2AEE86157'), (893, 1, 'SOLVED', 6, 33, 6, 'Software Doubt', '2008-07-08 07:05:47', 2, null, '2008-07-19 16:41:06', 'STAFF', 'D56B9FC4B0'), (894, 2, 'SOLVED', 3, 9, 6, 'Sotfware Issue', '2008-07-08 11:13:08', 2, null, '2008-07-23 13:58:53', 'STAFF', '4B02507935'), (895, 2, 'SOLVED', 10, 38, 6, 'Software Doubt', '2008-07-08 10:12:31', 2, null, '2008-07-19 16:44:09', 'STAFF', '20AEE3A5F4'), (896, 2, 'SOLVED', 5, 18, 6, 'Software Doubt', '2008-07-08 08:57:33', 3, null, '2008-07-18 15:32:34', 'STAFF', '061412E4A0'), (897, 3, 'SOLVED', 7, 34, 4, 'WEB Mail Doubt', '2008-07-08 08:03:14', 4, null, '2008-07-18 16:18:57', 'STAFF', '5705E1164A'), (898, 2, 'SOLVED', 7, 29, 6, 'Sotfware Issue', '2008-07-08 11:24:30', 4, null, '2008-07-24 13:14:59', 'STAFF', 'A64C94BAAF'), (899, 2, 'SOLVED', 3, 19, 2, 'WEB Site Doubt', '2008-07-08 12:26:48', 3, null, '2008-07-25 16:09:01', 'STAFF', '01882513D5'), (900, 2, 'SOLVED', 9, 1, 3, 'Sales Issue', '2008-07-08 10:47:53', 4, null, '2008-07-21 17:43:56', 'STAFF', 'ACF4B89D3D'), (901, 2, 'SOLVED', 9, 7, 3, 'Sales Doubt', '2008-07-09 08:31:19', 2, null, '2008-07-14 13:41:06', 'STAFF', '892C91E0A6'), (902, 2, 'SOLVED', 7, 37, 2, 'WEB Site Issue', '2008-07-09 07:39:17', 2, null, '2008-07-16 17:20:06', 'STAFF', 'B6A1085A27'), (903, 2, 'SOLVED', 10, 35, 4, 'WEB Mail Doubt', '2008-07-09 12:06:56', 2, null, '2008-07-20 17:55:30', 'STAFF', 'AA169B49B5'), (904, 2, 'SOLVED', 1, 7, 1, 'CRM Application Issue', '2008-07-09 08:18:33', 3, null, '2008-07-20 18:07:51', 'STAFF', 'F47D0AD31C'), (905, 2, 'SOLVED', 9, 19, 4, 'WEB Mail Doubt', '2008-07-09 07:40:01', 2, null, '2008-07-13 16:33:04', 'STAFF', 'F57A2F557B'), (906, 2, 'SOLVED', 1, 29, 6, 'Sotfware Issue', '2008-07-09 09:38:46', 3, null, '2008-07-11 13:00:55', 'STAFF', 'C8FBBC86AB'), (907, 2, 'SOLVED', 4, 40, 1, 'CRM Application Issue', '2008-07-09 09:33:17', 3, null, '2008-07-12 17:16:12', 'STAFF', '621461AF90'), (908, 3, 'SOLVED', 2, 1, 5, 'Peripheral Doubt', '2008-07-09 08:34:29', 4, null, '2008-07-19 15:28:40', 'STAFF', '8B6DD7DB9A'), (909, 3, 'CLOSED', 10, 40, 4, 'WEB Mail Doubt', '2008-07-10 06:01:00', 3, null, '2008-07-30 17:49:45', 'STAFF', 'A4300B002B'), (910, 3, 'CLOSED', 1, 32, 4, 'WEB Mail Doubt', '2008-07-10 12:38:52', 1, null, '2008-07-21 14:03:19', 'STAFF', 'E205EE2A5D'), (911, 2, 'SOLVED', 2, 9, 2, 'WEB Site Issue', '2008-07-10 10:12:11', 4, null, '2008-07-19 15:30:36', 'STAFF', 'B56A18E0EA'), (912, 2, 'SOLVED', 2, 17, 2, 'WEB Site Issue', '2008-07-11 07:17:43', 4, null, '2008-07-26 15:37:14', 'STAFF', '2A9D121CD9'), (913, 2, 'SOLVED', 10, 35, 2, 'WEB Site Issue', '2008-07-12 08:37:46', 2, null, '2008-07-20 15:25:23', 'STAFF', '8B5040A8A5'), (914, 3, 'SOLVED', 6, 12, 4, 'WEB Mail Issue', '2008-07-12 12:05:18', 2, null, '2008-07-26 15:46:35', 'STAFF', '7634EA65A4'), (915, 2, 'CLOSED', 9, 11, 2, 'WEB Site Issue', '2008-07-12 07:46:16', 3, null, '2008-07-30 17:49:13', 'STAFF', '24896EE4C6'), (916, 2, 'CLOSED', 5, 35, 3, 'Sales Doubt', '2008-07-12 08:21:33', 2, null, '2008-07-13 18:56:21', 'STAFF', '23CE185134'), (917, 2, 'SOLVED', 8, 23, 1, 'CRM Application Issue', '2008-07-12 08:07:32', 3, null, '2008-07-15 17:50:48', 'STAFF', 'DA0D1111D2'), (918, 3, 'CLOSED', 9, 30, 3, 'Sales Doubt', '2008-07-12 11:10:33', 2, null, '2008-07-12 17:30:41', 'STAFF', '1E056D2B0E'), (919, 3, 'SOLVED', 6, 1, 2, 'WEB Site Issue', '2008-07-12 12:23:31', 3, null, '2008-07-26 14:18:46', 'STAFF', '3E89EBDB49'), (920, 2, 'SOLVED', 7, 36, 2, 'WEB Site Doubt', '2008-07-12 06:00:41', 2, null, '2008-07-12 16:32:57', 'STAFF', '6D0F846348'), (921, 2, 'SOLVED', 5, 3, 6, 'Software Doubt', '2008-07-12 10:53:31', 2, null, '2008-07-23 17:09:13', 'STAFF', '430C3626B8'), (922, 2, 'SOLVED', 10, 35, 5, 'Peripheral Doubt', '2008-07-12 12:55:42', 4, null, '2008-07-30 18:57:10', 'STAFF', 'CCC0AA1B81'), (923, 2, 'SOLVED', 9, 7, 2, 'WEB Site Issue', '2008-07-13 10:29:01', 3, null, '2008-07-18 17:56:00', 'STAFF', 'C4015B7F36'), (924, 1, 'CLOSED', 9, 33, 4, 'WEB Mail Doubt', '2008-07-13 07:02:20', 3, null, '2008-07-16 16:43:51', 'STAFF', 'BEA5955B30'), (925, 2, 'SOLVED', 10, 3, 4, 'WEB Mail Doubt', '2008-07-13 11:57:24', 4, null, '2008-07-25 18:55:50', 'STAFF', '7FA732B517'), (926, 2, 'CLOSED', 3, 9, 3, 'Sales Doubt', '2008-07-13 11:10:30', 2, null, '2008-07-17 18:19:12', 'STAFF', 'CBB6A3B884'), (927, 1, 'SOLVED', 1, 40, 5, 'Peripheral Issue', '2008-07-13 06:40:43', 3, null, '2008-07-19 15:14:31', 'STAFF', '1F4477BAD7'), (928, 2, 'SOLVED', 7, 24, 1, 'CRM Application Issue', '2008-07-13 11:38:55', 2, null, '2008-08-04 16:44:36', 'STAFF', 'D045C59A90'), (929, 3, 'SOLVED', 10, 28, 5, 'Peripheral Issue', '2008-07-13 06:29:14', 2, null, '2008-07-20 18:52:08', 'STAFF', '0D0871F080'), (930, 2, 'CLOSED', 10, 26, 3, 'Sales Issue', '2008-07-13 06:41:57', 1, null, '2008-07-16 18:49:28', 'STAFF', '1CC3633C57'), (931, 2, 'SOLVED', 10, 32, 2, 'WEB Site Issue', '2008-07-13 06:52:24', 2, null, '2008-07-25 13:43:27', 'STAFF', '9F53D83EC0'), (932, 3, 'SOLVED', 2, 35, 2, 'WEB Site Issue', '2008-07-13 08:59:42', 2, null, '2008-07-16 16:07:03', 'STAFF', 'D2ED45A52B'), (933, 2, 'SOLVED', 6, 37, 1, 'CRM Application Doubt', '2008-07-13 11:49:56', 2, null, '2008-07-17 15:09:51', 'STAFF', '043C3D7E48'), (934, 3, 'SOLVED', 9, 32, 6, 'Sotfware Issue', '2008-07-13 08:19:57', 2, null, '2008-07-14 14:25:12', 'STAFF', '4DAA3DB355'), (935, 2, 'SOLVED', 2, 40, 5, 'Peripheral Doubt', '2008-07-14 08:34:19', 2, null, '2008-07-16 16:29:35', 'STAFF', 'E820A45F1D'), (936, 2, 'SOLVED', 2, 1, 6, 'Software Issue', '2008-07-14 10:12:34', 4, null, '2008-07-28 17:13:50', 'STAFF', '90794E3B05'), (937, 2, 'CLOSED', 10, 30, 5, 'Peripheral Doubt', '2008-07-14 11:35:24', 2, null, '2008-07-30 16:38:14', 'STAFF', 'B7892FB3C2'), (938, 2, 'SOLVED', 10, 4, 1, 'CRM Application Issue', '2008-07-14 11:21:09', 4, null, '2008-07-27 14:16:36', 'STAFF', '74BBA22728'), (939, 1, 'SOLVED', 6, 36, 4, 'WEB Mail Issue', '2008-07-14 08:22:13', 3, null, '2008-07-24 14:37:19', 'STAFF', '3DF1D4B96D'), (940, 1, 'SOLVED', 10, 6, 2, 'WEB Site Issue', '2008-07-14 12:22:50', 3, null, '2008-07-21 16:00:11', 'STAFF', '8D6DC35E50'), (941, 2, 'SOLVED', 6, 22, 4, 'WEB Mail Issue', '2008-07-14 07:32:53', 3, null, '2008-07-26 16:40:55', 'STAFF', '92262BF907'), (942, 2, 'SOLVED', 7, 13, 6, 'Software Doubt', '2008-07-14 09:13:00', 3, null, '2008-07-18 15:56:31', 'STAFF', 'B55EC28C52'), (943, 1, 'SOLVED', 9, 30, 4, 'WEB Mail Issue', '2008-07-14 10:41:02', 4, null, '2008-07-24 15:03:06', 'STAFF', '2F885D0FBE'), (944, 3, 'SOLVED', 2, 17, 4, 'WEB Mail Doubt', '2008-07-14 09:56:14', 3, null, '2008-07-19 17:03:22', 'STAFF', '64223CCF70'), (945, 2, 'CLOSED', 2, 12, 6, 'Software Issue', '2008-07-14 11:34:01', 1, null, '2008-08-03 16:22:11', 'STAFF', '4B6538A44A'), (946, 3, 'CLOSED', 10, 35, 2, 'WEB Site Issue', '2008-07-14 10:43:37', 3, null, '2008-08-01 13:51:47', 'STAFF', 'C8C41C4A18'), (947, 3, 'SOLVED', 10, 39, 3, 'Sales Doubt', '2008-07-14 12:27:34', 4, null, '2008-07-21 14:47:07', 'STAFF', 'C4B31CE7D9'), (948, 2, 'SOLVED', 7, 10, 1, 'CRM Application Doubt', '2008-07-14 09:57:37', 2, null, '2008-07-19 17:41:24', 'STAFF', '58E4D44E55'), (949, 2, 'SOLVED', 8, 1, 4, 'WEB Mail Issue', '2008-07-14 11:33:31', 3, null, '2008-07-16 15:39:07', 'STAFF', '3CEF96DCC9'), (950, 2, 'SOLVED', 1, 31, 5, 'Peripheral Issue', '2008-07-14 12:04:56', 4, null, '2008-07-26 15:57:55', 'STAFF', 'A3D68B461B'), (951, 1, 'SOLVED', 3, 35, 5, 'Peripheral Issue', '2008-07-14 11:20:46', 2, null, '2008-07-28 17:28:21', 'STAFF', '1C1D4DF596'), (952, 2, 'SOLVED', 1, 38, 1, 'CRM Application Doubt', '2008-07-15 09:55:36', 3, null, '2008-07-17 13:09:46', 'STAFF', 'E6CB2A3C14'), (953, 1, 'SOLVED', 10, 37, 2, 'WEB Site Doubt', '2008-07-15 08:07:28', 2, null, '2008-07-18 18:33:58', 'STAFF', '9232FE8122'), (954, 3, 'SOLVED', 10, 6, 5, 'Peripheral Doubt', '2008-07-15 11:10:59', 4, null, '2008-07-26 13:10:08', 'STAFF', '6395EBD0F4'), (955, 2, 'SOLVED', 9, 30, 5, 'Peripheral Issue', '2008-07-15 07:30:19', 4, null, '2008-07-15 14:37:40', 'STAFF', 'EF4E3B775C'), (956, 2, 'CLOSED', 10, 3, 6, 'Software Issue', '2008-07-15 08:30:39', 3, null, '2008-07-20 17:16:08', 'STAFF', '168908DD32'), (957, 2, 'SOLVED', 1, 28, 3, 'Sales Doubt', '2008-07-15 07:11:21', 3, null, '2008-07-26 14:32:55', 'STAFF', '2BA596643C'), (958, 2, 'SOLVED', 1, 30, 6, 'Software Doubt', '2008-07-15 11:45:24', 3, null, '2008-07-29 13:53:17', 'STAFF', 'D240E3D38A'), (959, 2, 'CLOSED', 5, 31, 6, 'Sotfware Issue', '2008-07-15 10:39:55', 2, null, '2008-07-18 16:35:40', 'STAFF', '0F840BE9B8'), (960, 1, 'CLOSED', 10, 7, 1, 'CRM Application Doubt', '2008-07-15 07:18:09', 3, null, '2008-07-17 16:22:16', 'STAFF', '437D7D1D97'), (961, 3, 'CLOSED', 10, 39, 3, 'Sales Doubt', '2008-07-16 07:57:28', 3, null, '2008-07-31 16:11:24', 'STAFF', 'D707329BEC'), (962, 1, 'SOLVED', 1, 29, 2, 'WEB Site Issue', '2008-07-16 10:53:22', 4, null, '2008-07-30 13:01:49', 'STAFF', '5C936263F3'), (963, 2, 'SOLVED', 6, 38, 4, 'WEB Mail Doubt', '2008-07-16 08:50:49', 3, null, '2008-07-25 14:22:35', 'STAFF', '1CE927F875'), (964, 2, 'SOLVED', 9, 28, 2, 'WEB Site Issue', '2008-07-16 09:56:02', 3, null, '2008-07-26 16:25:14', 'STAFF', '8065D07DA4'), (965, 2, 'SOLVED', 1, 23, 1, 'CRM Application Issue', '2008-07-16 12:45:04', 3, null, '2008-07-20 13:33:12', 'STAFF', 'EEB69A3CB9'), (966, 1, 'CLOSED', 10, 2, 4, 'WEB Mail Doubt', '2008-07-16 07:38:48', 1, null, '2008-07-25 16:28:53', 'STAFF', '4E0CB6FB5F'), (967, 2, 'SOLVED', 2, 8, 6, 'Software Doubt', '2008-07-16 07:50:51', 3, null, '2008-07-18 16:51:50', 'STAFF', '6CFE0E6127'), (968, 2, 'SOLVED', 1, 33, 1, 'CRM Application Issue', '2008-07-16 10:28:19', 4, null, '2008-07-21 13:53:35', 'STAFF', '8F468C873A'), (969, 3, 'SOLVED', 1, 17, 4, 'WEB Mail Doubt', '2008-07-16 12:39:40', 3, null, '2008-07-19 13:09:00', 'STAFF', 'E744F91C29'), (970, 2, 'SOLVED', 6, 37, 6, 'Software Issue', '2008-07-16 08:43:03', 2, null, '2008-07-27 17:02:00', 'STAFF', '89FCD07F20'), (971, 2, 'SOLVED', 9, 22, 4, 'WEB Mail Doubt', '2008-07-16 11:15:30', 3, null, '2008-08-04 13:51:01', 'STAFF', '6602294BE9'), (972, 2, 'CLOSED', 8, 31, 5, 'Peripheral Issue', '2008-07-17 09:01:32', 1, null, '2008-08-01 16:21:05', 'STAFF', 'C22ABFA379'), (973, 1, 'SOLVED', 8, 20, 1, 'CRM Application Issue', '2008-07-17 07:37:48', 3, null, '2008-07-28 16:29:24', 'STAFF', 'CA75910166'), (974, 3, 'SOLVED', 2, 34, 6, 'Sotfware Issue', '2008-07-17 08:14:36', 4, null, '2008-07-21 18:13:02', 'STAFF', '4311359ED4'), (975, 1, 'SOLVED', 9, 17, 5, 'Peripheral Doubt', '2008-07-17 11:17:54', 4, null, '2008-07-24 17:16:13', 'STAFF', '92977AE4D2'), (976, 1, 'CLOSED', 1, 33, 4, 'WEB Mail Issue', '2008-07-17 09:26:51', 2, null, '2008-07-17 13:16:13', 'STAFF', '9C01802DDB'), (977, 2, 'SOLVED', 10, 26, 6, 'Software Doubt', '2008-07-19 09:15:47', 3, null, '2008-07-26 18:37:47', 'STAFF', 'CC1AA43627'), (978, 2, 'CLOSED', 1, 25, 3, 'Sales Doubt', '2008-07-19 09:55:15', 2, null, '2008-08-01 14:35:53', 'STAFF', '2AB56412B1'), (979, 2, 'SOLVED', 2, 6, 1, 'CRM Application Issue', '2008-07-19 06:51:08', 3, null, '2008-07-22 17:19:27', 'STAFF', 'C32D9BF27A'), (980, 1, 'SOLVED', 2, 36, 4, 'WEB Mail Doubt', '2008-07-19 10:46:24', 3, null, '2008-07-21 14:17:59', 'STAFF', 'D79AAC0759'), (981, 1, 'SOLVED', 3, 39, 3, 'Sales Doubt', '2008-07-19 08:21:38', 3, null, '2008-07-29 18:34:16', 'STAFF', '287E03DB1D'), (982, 2, 'SOLVED', 10, 26, 5, 'Peripheral Issue', '2008-07-19 10:42:36', 2, null, '2008-08-09 18:19:37', 'STAFF', 'FEC8D47D41'), (983, 2, 'CLOSED', 7, 31, 4, 'WEB Mail Doubt', '2008-07-19 08:30:43', 1, null, '2008-07-22 17:17:05', 'STAFF', '6AAB127066'), (984, 1, 'SOLVED', 5, 28, 6, 'Sotfware Issue', '2008-07-19 08:17:56', 3, null, '2008-07-22 18:07:44', 'STAFF', 'D93ED5B6DB'), (985, 3, 'SOLVED', 6, 36, 6, 'Sotfware Issue', '2008-07-19 06:23:43', 2, null, '2008-07-28 18:43:50', 'STAFF', '54A367D629'), (986, 1, 'SOLVED', 2, 39, 3, 'Sales Doubt', '2008-07-19 10:55:20', 3, null, '2008-07-21 13:57:36', 'STAFF', 'FE7EE8FC19'), (987, 1, 'SOLVED', 4, 26, 1, 'CRM Application Issue', '2008-07-20 06:07:46', 4, null, '2008-07-29 16:09:59', 'STAFF', 'DF6D2338B2'), (988, 1, 'SOLVED', 10, 28, 1, 'CRM Application Issue', '2008-07-20 12:18:47', 2, null, '2008-07-26 18:02:22', 'STAFF', '9908279EBB'), (989, 2, 'CLOSED', 10, 12, 6, 'Sotfware Issue', '2008-07-20 11:52:33', 1, null, '2008-08-04 14:08:31', 'STAFF', 'A1140A3D0D'), (990, 2, 'SOLVED', 10, 20, 5, 'Peripheral Issue', '2008-07-20 06:48:37', 3, null, '2008-08-01 15:23:09', 'STAFF', '4FAC9BA115'), (991, 1, 'CLOSED', 3, 8, 6, 'Software Doubt', '2008-07-20 11:27:06', 1, null, '2008-07-30 17:21:41', 'STAFF', '692F93BE8C'), (992, 3, 'CLOSED', 6, 26, 5, 'Peripheral Doubt', '2008-07-20 08:21:56', 1, null, '2008-08-02 15:46:37', 'STAFF', '860320BE12'), (993, 2, 'SOLVED', 10, 3, 4, 'WEB Mail Issue', '2008-07-20 12:58:17', 2, null, '2008-07-31 18:33:39', 'STAFF', '7B13B22030'), (994, 3, 'SOLVED', 10, 22, 5, 'Peripheral Issue', '2008-07-20 07:47:01', 3, null, '2008-07-28 14:00:22', 'STAFF', '934815AD54'), (995, 1, 'CLOSED', 2, 19, 6, 'Sotfware Issue', '2008-07-21 12:56:28', 1, null, '2008-07-26 18:14:16', 'STAFF', '2BCAB9D935'), (996, 2, 'SOLVED', 7, 37, 4, 'WEB Mail Doubt', '2008-07-21 07:20:38', 3, null, '2008-07-30 15:02:38', 'STAFF', '0B8AFF0438'), (997, 1, 'SOLVED', 9, 27, 5, 'Peripheral Doubt', '2008-07-21 11:07:38', 4, null, '2008-08-09 14:15:20', 'STAFF', 'EC5AA0B784'), (998, 1, 'CLOSED', 7, 1, 4, 'WEB Mail Issue', '2008-07-21 12:47:43', 3, null, '2008-07-29 16:12:08', 'STAFF', '9AB0D88431'), (999, 2, 'SOLVED', 1, 39, 4, 'WEB Mail Doubt', '2008-07-21 10:53:57', 4, null, '2008-07-22 14:52:22', 'STAFF', 'B706835DE7'), (3000, 2, 'SOLVED', 1, 1, 6, 'Sotfware Issue', '2009-05-02 11:12:04', 2, null, '2009-05-20 16:29:33', 'STAFF', 'E93028BDC1'), (3001, 3, 'SOLVED', 4, 31, 6, 'Software Issue', '2009-05-02 12:33:46', 2, null, '2009-05-05 14:57:56', 'STAFF', '908C9A564A'), (3002, 2, 'CLOSED', 1, 19, 4, 'WEB Mail Issue', '2009-05-02 12:40:20', 1, null, '2009-05-16 14:31:43', 'STAFF', 'D806CA13CA'), (3003, 3, 'SOLVED', 10, 5, 6, 'Software Doubt', '2009-05-02 12:16:55', 3, null, '2009-05-04 18:17:19', 'STAFF', 'A4380923DD'), (3004, 2, 'SOLVED', 1, 1, 5, 'Peripheral Doubt', '2009-05-02 06:47:15', 2, null, '2009-05-03 17:19:56', 'STAFF', '20479C788F'), (3005, 1, 'SOLVED', 10, 6, 5, 'Peripheral Doubt', '2009-05-03 07:15:38', 4, null, '2009-05-11 16:15:26', 'STAFF', '3A61ED715E'), (3006, 2, 'SOLVED', 7, 28, 3, 'Sales Doubt', '2009-05-03 09:31:47', 2, null, '2009-05-20 15:06:26', 'STAFF', '5F268DFB0F'), (3007, 3, 'SOLVED', 7, 39, 5, 'Peripheral Issue', '2009-05-03 11:30:55', 3, null, '2009-05-08 14:09:36', 'STAFF', 'A724B9124A'), (3008, 1, 'SOLVED', 5, 38, 3, 'Sales Doubt', '2009-05-03 06:10:26', 2, null, '2009-05-08 18:19:54', 'STAFF', 'C02F9DE3C2'), (3009, 1, 'CLOSED', 3, 35, 6, 'Software Issue', '2009-05-03 09:13:51', 1, null, '2009-05-08 17:10:55', 'STAFF', 'EE16FA83C0'), (3010, 2, 'SOLVED', 6, 36, 6, 'Sotfware Issue', '2009-05-03 08:17:28', 2, null, '2009-05-10 17:47:20', 'STAFF', '22722A3435'), (3011, 1, 'SOLVED', 9, 11, 6, 'Software Doubt', '2009-05-03 11:12:12', 2, null, '2009-05-11 13:41:07', 'STAFF', 'B1F62FA99D'), (3012, 2, 'CLOSED', 2, 23, 3, 'Sales Doubt', '2009-05-03 09:27:07', 2, null, '2009-05-05 14:19:42', 'STAFF', '5A01F0597A'), (3013, 2, 'SOLVED', 4, 22, 5, 'Peripheral Doubt', '2009-05-03 07:43:13', 4, null, '2009-05-18 17:40:07', 'STAFF', '4110A19944'), (3014, 2, 'SOLVED', 1, 35, 2, 'WEB Site Issue', '2009-05-03 09:27:17', 4, null, '2009-05-21 15:28:49', 'STAFF', '77EDBE5F89'), (3015, 2, 'SOLVED', 10, 25, 6, 'Software Issue', '2009-05-03 08:38:43', 2, null, '2009-05-12 15:29:47', 'STAFF', '51BE2FED6C'), (3016, 3, 'SOLVED', 1, 39, 4, 'WEB Mail Doubt', '2009-05-03 09:22:16', 2, null, '2009-05-03 17:29:20', 'STAFF', '53A1320CB5'), (3017, 1, 'SOLVED', 6, 38, 1, 'CRM Application Issue', '2009-05-04 06:33:57', 4, null, '2009-05-07 18:13:57', 'STAFF', '248024541D'), (3018, 1, 'CLOSED', 5, 33, 6, 'Software Issue', '2009-05-04 08:33:57', 3, null, '2009-05-08 15:57:26', 'STAFF', '9A96A2C73C'), (3019, 1, 'SOLVED', 8, 24, 5, 'Peripheral Issue', '2009-05-04 07:11:57', 4, null, '2009-05-14 18:14:43', 'STAFF', 'A74C3BAE3E'), (3020, 3, 'SOLVED', 5, 14, 3, 'Sales Doubt', '2009-05-04 06:57:15', 4, null, '2009-05-07 14:45:17', 'STAFF', 'E4A93F0332'), (3021, 2, 'CLOSED', 3, 10, 3, 'Sales Doubt', '2009-05-04 08:59:11', 2, null, '2009-05-14 17:06:11', 'STAFF', '9CB9ED4F35'), (3022, 2, 'SOLVED', 2, 7, 2, 'WEB Site Issue', '2009-05-04 08:45:04', 3, null, '2009-05-20 18:11:48', 'STAFF', 'C8862FC1A3'), (3023, 2, 'CLOSED', 5, 2, 4, 'WEB Mail Doubt', '2009-05-04 10:01:04', 3, null, '2009-05-08 16:04:11', 'STAFF', '09D37C08F7'), (3024, 1, 'SOLVED', 8, 11, 4, 'WEB Mail Issue', '2009-05-04 10:24:31', 3, null, '2009-05-07 13:12:35', 'STAFF', 'E5522F7AC7'), (3025, 2, 'SOLVED', 6, 5, 5, 'Peripheral Doubt', '2009-05-04 07:32:33', 4, null, '2009-05-18 16:00:15', 'STAFF', '2BD235C31C'), (3026, 3, 'SOLVED', 9, 17, 3, 'Sales Doubt', '2009-05-04 12:30:06', 3, null, '2009-05-09 15:08:09', 'STAFF', '0CDF61037D'), (3027, 1, 'SOLVED', 4, 1, 6, 'Software Doubt', '2009-05-04 11:59:32', 3, null, '2009-05-14 16:27:29', 'STAFF', 'B922EDE9C9'), (3028, 2, 'SOLVED', 3, 35, 1, 'CRM Application Doubt', '2009-05-04 07:28:53', 4, null, '2009-05-20 15:13:47', 'STAFF', '7EDFD52220'), (3029, 3, 'SOLVED', 8, 31, 6, 'Software Issue', '2009-05-05 10:47:52', 2, null, '2009-05-15 17:09:15', 'STAFF', 'A0BA2648AC'), (3030, 2, 'SOLVED', 6, 26, 3, 'Sales Doubt', '2009-05-05 09:46:18', 3, null, '2009-05-14 14:42:00', 'STAFF', '2D95666E26'), (3031, 1, 'SOLVED', 10, 15, 4, 'WEB Mail Doubt', '2009-05-05 10:47:46', 4, null, '2009-05-12 13:21:44', 'STAFF', '0CD60EFB55'), (3032, 2, 'SOLVED', 9, 24, 3, 'Sales Doubt', '2009-05-05 10:48:56', 4, null, '2009-05-22 15:24:46', 'STAFF', '8A56257EA0'), (3033, 2, 'SOLVED', 5, 31, 1, 'CRM Application Doubt', '2009-05-05 06:49:39', 4, null, '2009-05-12 18:46:04', 'STAFF', '272E117005'), (3034, 3, 'SOLVED', 8, 3, 2, 'WEB Site Issue', '2009-05-05 11:46:21', 3, null, '2009-05-11 16:32:17', 'STAFF', '7B66E8931C'), (3035, 1, 'CLOSED', 9, 10, 3, 'Sales Doubt', '2009-05-05 09:03:29', 1, null, '2009-05-25 16:43:50', 'STAFF', '03BFC1D478'), (3036, 3, 'CLOSED', 8, 32, 5, 'Peripheral Issue', '2009-05-05 10:27:06', 3, null, '2009-05-13 17:11:36', 'STAFF', '4B86CA48D9'), (3037, 3, 'SOLVED', 7, 32, 6, 'Sotfware Issue', '2009-05-06 06:25:20', 3, null, '2009-05-20 15:29:20', 'STAFF', '10CE03A1ED'), (3038, 2, 'SOLVED', 6, 23, 6, 'Software Issue', '2009-05-06 09:03:08', 3, null, '2009-05-22 13:39:47', 'STAFF', 'A92C274B8B'), (3039, 2, 'SOLVED', 9, 31, 1, 'CRM Application Doubt', '2009-05-06 10:21:24', 2, null, '2009-05-20 18:24:53', 'STAFF', 'F0204E1D3E'), (3040, 2, 'SOLVED', 6, 30, 5, 'Peripheral Issue', '2009-05-06 07:31:19', 4, null, '2009-05-20 17:26:09', 'STAFF', '9023EFFE3C'), (3041, 2, 'SOLVED', 2, 38, 3, 'Sales Doubt', '2009-05-06 11:38:15', 3, null, '2009-05-11 18:57:23', 'STAFF', '9922F5774D'), (3042, 1, 'SOLVED', 8, 33, 2, 'WEB Site Issue', '2009-05-06 11:21:28', 3, null, '2009-05-08 13:05:07', 'STAFF', '3FD6098329'), (3043, 2, 'CLOSED', 2, 17, 6, 'Sotfware Issue', '2009-05-06 07:50:11', 1, null, '2009-05-10 15:55:04', 'STAFF', 'FC325D4B59'), (3044, 2, 'SOLVED', 5, 10, 3, 'Sales Issue', '2009-05-09 06:12:45', 4, null, '2009-05-11 15:50:30', 'STAFF', 'B8AF7D0FBF'), (3045, 2, 'SOLVED', 5, 25, 6, 'Software Issue', '2009-05-09 08:25:06', 4, null, '2009-05-29 13:22:07', 'STAFF', '0EBF197205'), (3046, 1, 'CLOSED', 3, 37, 5, 'Peripheral Issue', '2009-05-09 09:32:44', 2, null, '2009-05-19 15:58:46', 'STAFF', '975E610777'), (3047, 2, 'CLOSED', 2, 11, 3, 'Sales Doubt', '2009-05-09 09:59:54', 3, null, '2009-05-22 17:09:05', 'STAFF', '8E489B4966'), (3048, 2, 'SOLVED', 5, 29, 6, 'Software Doubt', '2009-05-09 10:18:58', 4, null, '2009-05-23 16:27:14', 'STAFF', '5DA713A690'), (3049, 2, 'CLOSED', 3, 15, 1, 'CRM Application Doubt', '2009-05-09 10:25:47', 1, null, '2009-05-13 17:57:49', 'STAFF', '4FA177DF22'), (3050, 1, 'SOLVED', 10, 34, 6, 'Software Issue', '2009-05-09 11:13:45', 3, null, '2009-05-20 14:35:49', 'STAFF', 'EF72D53990'), (3051, 3, 'SOLVED', 2, 24, 6, 'Software Issue', '2009-05-09 08:06:56', 2, null, '2009-05-12 13:34:58', 'STAFF', 'F0B1D58798'), (3052, 2, 'SOLVED', 1, 17, 4, 'WEB Mail Issue', '2009-05-09 08:50:36', 2, null, '2009-05-11 17:08:25', 'STAFF', 'C1B70D965C'), (3053, 2, 'SOLVED', 8, 22, 6, 'Software Doubt', '2009-05-09 06:48:33', 4, null, '2009-05-24 17:11:26', 'STAFF', '177540C7BC'), (3054, 2, 'SOLVED', 2, 10, 1, 'CRM Application Doubt', '2009-05-10 10:42:25', 3, null, '2009-05-17 15:56:54', 'STAFF', 'D9B1655C13'), (3055, 2, 'CLOSED', 1, 11, 6, 'Software Doubt', '2009-05-10 12:26:41', 2, null, '2009-05-13 18:17:52', 'STAFF', '2836BE05E7'), (3056, 1, 'SOLVED', 9, 11, 4, 'WEB Mail Doubt', '2009-05-10 08:53:41', 3, null, '2009-05-25 17:38:48', 'STAFF', 'DC6E224A8D'), (3057, 2, 'CLOSED', 10, 34, 3, 'Sales Doubt', '2009-05-10 12:00:02', 3, null, '2009-05-22 16:45:02', 'STAFF', 'C1502AE5A4'), (3058, 1, 'SOLVED', 1, 10, 5, 'Peripheral Doubt', '2009-05-10 08:52:39', 4, null, '2009-05-26 14:23:40', 'STAFF', '3F5EE24354'), (3059, 2, 'SOLVED', 8, 3, 5, 'Peripheral Issue', '2009-05-10 06:33:39', 3, null, '2009-05-15 15:51:18', 'STAFF', 'CC431FD7EC'), (3060, 1, 'SOLVED', 1, 26, 2, 'WEB Site Issue', '2009-05-10 10:39:17', 3, null, '2009-05-18 14:39:40', 'STAFF', '0A5C79B1EA'), (3061, 3, 'SOLVED', 8, 10, 2, 'WEB Site Issue', '2009-05-10 12:19:09', 3, null, '2009-05-16 15:02:03', 'STAFF', '4AA0E93B91'), (3062, 3, 'CLOSED', 3, 10, 5, 'Peripheral Doubt', '2009-05-10 11:22:44', 3, null, '2009-05-13 14:55:35', 'STAFF', '1AA057313C'), (3063, 2, 'SOLVED', 5, 16, 3, 'Sales Doubt', '2009-05-10 10:55:59', 3, null, '2009-05-21 13:02:16', 'STAFF', '1BD4B29A8E'), (3064, 2, 'SOLVED', 5, 19, 3, 'Sales Issue', '2009-05-10 12:55:59', 3, null, '2009-05-14 16:14:56', 'STAFF', '494BA9FF03'), (3065, 3, 'SOLVED', 1, 38, 2, 'WEB Site Issue', '2009-05-10 06:39:04', 4, null, '2009-05-12 15:07:29', 'STAFF', '6FEC24EAC8'), (3066, 1, 'CLOSED', 1, 27, 6, 'Sotfware Issue', '2009-05-11 09:30:00', 3, null, '2009-05-24 13:43:04', 'STAFF', 'D8AB1A52F0'), (3067, 3, 'SOLVED', 4, 27, 2, 'WEB Site Issue', '2009-05-11 07:24:22', 3, null, '2009-05-28 13:52:44', 'STAFF', 'FEDF67D6F3'), (3068, 2, 'SOLVED', 5, 38, 4, 'WEB Mail Issue', '2009-05-11 09:27:54', 4, null, '2009-05-12 16:35:04', 'STAFF', 'F549625260'), (3069, 3, 'SOLVED', 10, 8, 3, 'Sales Doubt', '2009-05-11 12:44:35', 4, null, '2009-05-18 16:51:38', 'STAFF', 'BDB6920ADC'), (3070, 1, 'SOLVED', 3, 15, 4, 'WEB Mail Issue', '2009-05-11 08:30:49', 2, null, '2009-05-20 15:57:24', 'STAFF', 'BB073F2855'), (3071, 2, 'SOLVED', 10, 26, 5, 'Peripheral Doubt', '2009-05-11 11:52:57', 2, null, '2009-05-21 16:22:04', 'STAFF', '6917FF2A7B'), (3072, 1, 'SOLVED', 9, 28, 6, 'Software Issue', '2009-05-11 09:35:20', 3, null, '2009-05-20 18:11:41', 'STAFF', 'BE767243CA'), (3073, 3, 'SOLVED', 5, 38, 1, 'CRM Application Doubt', '2009-05-11 09:17:02', 2, null, '2009-05-30 18:08:52', 'STAFF', 'C8CD63E1BF'), (3074, 2, 'SOLVED', 5, 39, 1, 'CRM Application Issue', '2009-05-11 06:43:55', 4, null, '2009-05-15 15:02:32', 'STAFF', '639D79CC85'), (3075, 2, 'SOLVED', 1, 23, 5, 'Peripheral Doubt', '2009-05-11 12:04:45', 2, null, '2009-05-24 18:20:31', 'STAFF', 'A2186AA7C0'), (3076, 3, 'SOLVED', 6, 10, 6, 'Software Doubt', '2009-05-11 06:05:25', 4, null, '2009-05-17 16:39:20', 'STAFF', 'B6E710870A'), (3077, 1, 'CLOSED', 5, 5, 6, 'Software Doubt', '2009-05-11 10:45:36', 3, null, '2009-05-31 17:18:06', 'STAFF', '663FD3C514'), (3078, 2, 'SOLVED', 10, 12, 6, 'Sotfware Issue', '2009-05-11 12:04:43', 4, null, '2009-05-17 18:34:24', 'STAFF', '1091660F3D'), (3079, 1, 'SOLVED', 4, 33, 2, 'WEB Site Issue', '2009-05-11 09:39:17', 3, null, '2009-05-25 17:51:43', 'STAFF', 'F44EE26395'), (3080, 1, 'SOLVED', 10, 15, 6, 'Software Issue', '2009-05-11 06:17:23', 4, null, '2009-05-17 13:20:02', 'STAFF', 'A9986CB066'), (3081, 2, 'SOLVED', 9, 19, 4, 'WEB Mail Doubt', '2009-05-11 10:52:59', 4, null, '2009-05-20 14:48:25', 'STAFF', 'CE60FF163C'), (3082, 2, 'SOLVED', 5, 33, 5, 'Peripheral Issue', '2009-05-11 08:48:07', 3, null, '2009-05-22 18:30:35', 'STAFF', 'F14BC21BE7'), (3083, 3, 'SOLVED', 10, 23, 6, 'Software Doubt', '2009-05-12 08:42:35', 2, null, '2009-05-16 14:03:06', 'STAFF', 'D3157F2F02'), (3084, 1, 'SOLVED', 9, 7, 3, 'Sales Doubt', '2009-05-12 06:19:59', 4, null, '2009-05-27 15:33:24', 'STAFF', '1706F191D7'), (3085, 2, 'CLOSED', 10, 18, 5, 'Peripheral Doubt', '2009-05-12 08:12:09', 1, null, '2009-05-31 18:34:49', 'STAFF', '2BB0502C80'), (3086, 2, 'CLOSED', 9, 9, 4, 'WEB Mail Doubt', '2009-05-12 08:31:58', 1, null, '2009-05-23 18:52:50', 'STAFF', 'A081CAB429'), (3087, 2, 'SOLVED', 9, 15, 4, 'WEB Mail Doubt', '2009-05-12 07:40:59', 4, null, '2009-05-22 14:53:30', 'STAFF', '78BC62D08A'), (3088, 1, 'SOLVED', 1, 37, 4, 'WEB Mail Doubt', '2009-05-12 10:12:07', 2, null, '2009-05-26 15:20:04', 'STAFF', 'DC6A7E655D'), (3089, 3, 'SOLVED', 5, 10, 4, 'WEB Mail Issue', '2009-05-12 12:33:24', 2, null, '2009-05-28 18:56:08', 'STAFF', 'CCD2E3EAA5'), (3090, 2, 'SOLVED', 1, 37, 6, 'Software Issue', '2009-05-12 06:59:40', 2, null, '2009-05-13 16:31:48', 'STAFF', '748D6B6ED8'), (3091, 1, 'SOLVED', 1, 24, 5, 'Peripheral Doubt', '2009-05-12 08:27:45', 4, null, '2009-05-25 18:54:02', 'STAFF', '05B8CAAF6B'), (3092, 1, 'SOLVED', 1, 33, 4, 'WEB Mail Issue', '2009-05-12 08:13:29', 4, null, '2009-05-15 15:24:31', 'STAFF', '6AD4174EBA'), (3093, 2, 'SOLVED', 8, 33, 5, 'Peripheral Issue', '2009-05-12 09:31:04', 3, null, '2009-05-30 17:35:14', 'STAFF', '8004D637B6'), (3094, 2, 'SOLVED', 5, 10, 6, 'Software Issue', '2009-05-12 12:16:29', 2, null, '2009-05-22 16:30:08', 'STAFF', '512FC3C522'), (3095, 2, 'SOLVED', 3, 38, 5, 'Peripheral Issue', '2009-05-13 09:57:39', 4, null, '2009-05-13 16:34:28', 'STAFF', '4DB0F8B0FC'), (3096, 3, 'SOLVED', 6, 29, 1, 'CRM Application Doubt', '2009-05-13 10:13:57', 4, null, '2009-05-20 13:01:03', 'STAFF', '60792D855C'), (3097, 1, 'SOLVED', 2, 1, 2, 'WEB Site Issue', '2009-05-13 07:07:32', 2, null, '2009-05-25 17:02:27', 'STAFF', '3B5020BB89'), (3098, 3, 'SOLVED', 3, 12, 5, 'Peripheral Issue', '2009-05-13 08:02:46', 4, null, '2009-05-25 18:37:16', 'STAFF', 'ADA5E0B63E'), (3099, 3, 'SOLVED', 1, 35, 5, 'Peripheral Issue', '2009-05-13 07:28:38', 2, null, '2009-05-15 14:18:49', 'STAFF', 'B23F522024'), (3100, 2, 'SOLVED', 1, 28, 6, 'Sotfware Issue', '2009-05-13 11:12:54', 4, null, '2009-05-23 13:43:32', 'STAFF', 'CC3D69ED78'), (3101, 2, 'SOLVED', 7, 10, 2, 'WEB Site Issue', '2009-05-13 11:42:06', 4, null, '2009-05-17 16:48:46', 'STAFF', '62F91CE9B8'), (3102, 2, 'SOLVED', 2, 34, 6, 'Software Issue', '2009-05-13 09:29:12', 4, null, '2009-05-27 15:53:11', 'STAFF', 'C5D9256689'), (3103, 2, 'SOLVED', 3, 30, 5, 'Peripheral Issue', '2009-05-13 08:37:01', 3, null, '2009-05-22 15:12:08', 'STAFF', '96629F1AAC'), (3104, 2, 'SOLVED', 5, 20, 6, 'Software Doubt', '2009-05-14 10:52:59', 2, null, '2009-05-31 18:20:38', 'STAFF', '75B9B6DC7F'), (3105, 2, 'SOLVED', 9, 35, 5, 'Peripheral Doubt', '2009-05-14 07:43:42', 2, null, '2009-05-23 16:57:21', 'STAFF', '37E7897F62'), (3106, 2, 'SOLVED', 8, 10, 6, 'Software Issue', '2009-05-14 06:22:50', 4, null, '2009-05-17 16:07:53', 'STAFF', '4AEC1B3435'), (3107, 3, 'CLOSED', 7, 35, 4, 'WEB Mail Doubt', '2009-05-15 06:24:34', 2, null, '2009-05-28 18:23:55', 'STAFF', '1CFEAD9959'), (3108, 2, 'SOLVED', 1, 32, 2, 'WEB Site Issue', '2009-05-15 10:38:29', 2, null, '2009-05-19 14:39:39', 'STAFF', 'FFBD6CBB01'), (3109, 1, 'SOLVED', 7, 21, 3, 'Sales Doubt', '2009-05-16 08:23:01', 3, null, '2009-05-24 18:25:06', 'STAFF', 'D4A897919A'), (3110, 2, 'CLOSED', 1, 1, 6, 'Software Issue', '2009-05-16 10:00:21', 3, null, '2009-05-31 16:18:27', 'STAFF', 'E9FB2EDA3D'), (3111, 2, 'SOLVED', 1, 21, 4, 'WEB Mail Doubt', '2009-05-16 06:12:33', 3, null, '2009-05-21 18:08:56', 'STAFF', '9E6A921FBC'), (3112, 1, 'SOLVED', 10, 37, 6, 'Software Issue', '2009-05-16 12:05:23', 2, null, '2009-06-03 14:12:25', 'STAFF', '87F4D79E36'), (3113, 2, 'SOLVED', 7, 5, 4, 'WEB Mail Doubt', '2009-05-16 12:45:47', 3, null, '2009-05-20 13:51:13', 'STAFF', '532B7CBE07'), (3114, 3, 'SOLVED', 9, 6, 5, 'Peripheral Doubt', '2009-05-16 06:14:51', 4, null, '2009-06-04 17:36:58', 'STAFF', 'BBB001BA00'), (3115, 2, 'SOLVED', 5, 1, 6, 'Software Issue', '2009-05-16 08:38:08', 3, null, '2009-05-31 18:58:14', 'STAFF', '366F0BC7BD'), (3116, 3, 'SOLVED', 1, 21, 1, 'CRM Application Doubt', '2009-05-16 07:21:24', 3, null, '2009-05-19 13:05:16', 'STAFF', '58191D2A91'), (3117, 3, 'SOLVED', 6, 10, 2, 'WEB Site Issue', '2009-05-16 12:56:33', 4, null, '2009-05-27 17:17:50', 'STAFF', '8B313CBF30'), (3118, 2, 'SOLVED', 6, 33, 4, 'WEB Mail Doubt', '2009-05-16 08:00:21', 2, null, '2009-05-25 15:43:45', 'STAFF', 'F0031C7A91'), (3119, 1, 'SOLVED', 9, 39, 4, 'WEB Mail Doubt', '2009-05-16 07:48:37', 2, null, '2009-05-25 13:10:05', 'STAFF', 'F42C7F9C8A'), (3120, 2, 'SOLVED', 10, 33, 6, 'Software Issue', '2009-05-17 12:09:46', 2, null, '2009-05-18 17:19:40', 'STAFF', 'F231F2107D'), (3121, 2, 'SOLVED', 2, 28, 1, 'CRM Application Issue', '2009-05-17 06:05:10', 2, null, '2009-05-18 13:24:31', 'STAFF', '097E26B2FF'), (3122, 3, 'SOLVED', 8, 1, 4, 'WEB Mail Doubt', '2009-05-17 08:18:02', 4, null, '2009-05-20 16:19:06', 'STAFF', 'A2D10D355C'), (3123, 1, 'SOLVED', 9, 31, 2, 'WEB Site Issue', '2009-05-17 08:43:00', 4, null, '2009-05-29 16:31:07', 'STAFF', '2E0ACA891F'), (3124, 3, 'SOLVED', 2, 33, 2, 'WEB Site Issue', '2009-05-17 09:39:26', 4, null, '2009-05-22 16:51:55', 'STAFF', '7C78335A89'), (3125, 2, 'SOLVED', 9, 5, 4, 'WEB Mail Doubt', '2009-05-17 09:41:29', 3, null, '2009-05-23 15:26:11', 'STAFF', '019F8B946A'), (3126, 1, 'SOLVED', 4, 25, 2, 'WEB Site Issue', '2009-05-17 10:51:53', 4, null, '2009-05-22 13:49:34', 'STAFF', '9F8684E630'), (3127, 2, 'SOLVED', 10, 29, 6, 'Sotfware Issue', '2009-05-17 12:39:45', 2, null, '2009-05-24 14:58:36', 'STAFF', 'CA1D3153A1'), (3128, 2, 'CLOSED', 6, 17, 6, 'Software Issue', '2009-05-17 10:44:56', 1, null, '2009-05-18 16:49:51', 'STAFF', 'DFF8E9C2AC'), (3129, 3, 'SOLVED', 2, 28, 1, 'CRM Application Doubt', '2009-05-18 11:58:39', 3, null, '2009-06-04 14:39:23', 'STAFF', 'C6A01432C8'), (3130, 1, 'SOLVED', 5, 31, 6, 'Software Issue', '2009-05-18 10:46:35', 3, null, '2009-05-24 15:43:31', 'STAFF', 'C922DE9E01'), (3131, 1, 'CLOSED', 9, 33, 4, 'WEB Mail Doubt', '2009-05-18 08:21:09', 1, null, '2009-05-27 16:17:14', 'STAFF', '54FDA78AA8'), (3132, 1, 'CLOSED', 6, 16, 2, 'WEB Site Issue', '2009-05-18 10:28:54', 2, null, '2009-05-30 16:17:14', 'STAFF', 'FB2606A506'), (3133, 3, 'SOLVED', 4, 24, 6, 'Software Issue', '2009-05-18 11:13:28', 4, null, '2009-05-26 18:07:43', 'STAFF', '7221E5C8EC'), (3134, 2, 'SOLVED', 1, 23, 2, 'WEB Site Issue', '2009-05-18 09:25:31', 4, null, '2009-05-27 13:44:59', 'STAFF', '35937E3425'), (3135, 1, 'SOLVED', 7, 12, 6, 'Software Issue', '2009-05-18 10:50:07', 4, null, '2009-05-29 13:03:08', 'STAFF', '8B83881803'), (3136, 2, 'SOLVED', 3, 1, 5, 'Peripheral Issue', '2009-05-18 10:17:10', 3, null, '2009-05-23 14:46:30', 'STAFF', '2ECD2BD947'), (3137, 1, 'CLOSED', 2, 33, 6, 'Sotfware Issue', '2009-05-18 10:32:18', 2, null, '2009-05-23 18:20:45', 'STAFF', '8C9A14FFEB'), (3138, 1, 'CLOSED', 2, 22, 6, 'Software Issue', '2009-05-18 06:04:33', 1, null, '2009-05-29 13:58:48', 'STAFF', '86B20716FB'), (3139, 2, 'SOLVED', 9, 33, 5, 'Peripheral Doubt', '2009-05-18 06:29:22', 3, null, '2009-05-25 16:08:51', 'STAFF', 'E8BF0F27D7'), (3140, 1, 'CLOSED', 9, 1, 4, 'WEB Mail Doubt', '2009-05-18 09:04:45', 2, null, '2009-05-27 18:03:21', 'STAFF', '747D3443E3'), (3141, 3, 'SOLVED', 10, 1, 4, 'WEB Mail Issue', '2009-05-18 06:01:10', 4, null, '2009-05-19 14:28:53', 'STAFF', '92A08BF918'), (3142, 2, 'SOLVED', 5, 19, 6, 'Software Doubt', '2009-05-18 09:59:06', 2, null, '2009-05-21 18:26:22', 'STAFF', 'BD85282513'), (3143, 2, 'CLOSED', 6, 40, 6, 'Sotfware Issue', '2009-05-19 09:40:06', 2, null, '2009-05-30 16:46:23', 'STAFF', '0AFA92FC0F'), (3144, 2, 'SOLVED', 10, 1, 1, 'CRM Application Doubt', '2009-05-19 07:09:08', 3, null, '2009-05-31 17:47:29', 'STAFF', 'A41B3BB3E6'), (3145, 3, 'SOLVED', 2, 5, 6, 'Sotfware Issue', '2009-05-19 08:19:31', 2, null, '2009-05-26 13:05:28', 'STAFF', 1160453108), (3146, 2, 'SOLVED', 1, 21, 5, 'Peripheral Doubt', '2009-05-19 07:37:41', 2, null, '2009-05-21 15:07:46', 'STAFF', '5D4AE76F05'), (3147, 2, 'SOLVED', 1, 32, 2, 'WEB Site Doubt', '2009-05-19 12:07:07', 2, null, '2009-05-29 14:11:14', 'STAFF', '38ED162A0D'), (3148, 2, 'SOLVED', 5, 24, 6, 'Software Issue', '2009-05-19 10:57:42', 2, null, '2009-05-22 13:27:09', 'STAFF', 'D87C68A56B'), (3149, 2, 'CLOSED', 9, 38, 4, 'WEB Mail Doubt', '2009-05-19 12:03:21', 1, null, '2009-05-26 16:58:45', 'STAFF', '32B3EE0272'), (3150, 3, 'SOLVED', 10, 38, 6, 'Software Doubt', '2009-05-19 10:14:21', 4, null, '2009-05-22 18:23:30', 'STAFF', '77EE3BC58C'), (3151, 2, 'SOLVED', 1, 32, 6, 'Software Issue', '2009-05-19 12:43:25', 4, null, '2009-06-07 15:13:59', 'STAFF', '98C39996BF'), (3152, 1, 'CLOSED', 3, 5, 5, 'Peripheral Issue', '2009-05-19 06:44:58', 3, null, '2009-05-24 14:41:03', 'STAFF', '32CBF68788'), (3153, 2, 'CLOSED', 2, 27, 3, 'Sales Doubt', '2009-05-19 11:29:30', 2, null, '2009-05-26 17:36:21', 'STAFF', '9AEADE7BEA'), (3154, 2, 'SOLVED', 8, 19, 2, 'WEB Site Issue', '2009-05-19 08:01:16', 4, null, '2009-06-04 14:48:39', 'STAFF', 'FDBD31F202'), (3155, 2, 'SOLVED', 10, 4, 1, 'CRM Application Doubt', '2009-05-20 08:13:43', 3, null, '2009-05-25 15:09:06', 'STAFF', 'B22B257AD0'), (3156, 2, 'CLOSED', 1, 39, 6, 'Software Doubt', '2009-05-20 09:36:19', 3, null, '2009-05-25 15:20:40', 'STAFF', '2227D753DC'), (3157, 2, 'SOLVED', 1, 31, 6, 'Sotfware Issue', '2009-05-20 11:15:40', 4, null, '2009-05-25 13:58:57', 'STAFF', '2B45E8D6AB'), (3158, 2, 'SOLVED', 8, 35, 6, 'Software Doubt', '2009-05-20 06:13:24', 3, null, '2009-06-07 16:17:03', 'STAFF', '55D99A37B2'), (3159, 2, 'CLOSED', 8, 39, 6, 'Software Doubt', '2009-05-20 07:23:28', 2, null, '2009-05-20 16:52:37', 'STAFF', '99EF04EB61'), (3160, 2, 'CLOSED', 7, 38, 6, 'Software Issue', '2009-05-20 11:51:17', 1, null, '2009-06-02 16:51:51', 'STAFF', '9808AE3875'), (3161, 3, 'SOLVED', 4, 5, 4, 'WEB Mail Doubt', '2009-05-20 09:04:12', 4, null, '2009-05-23 18:48:35', 'STAFF', '29539ED932'), (3162, 3, 'SOLVED', 9, 12, 3, 'Sales Doubt', '2009-05-20 12:45:00', 2, null, '2009-05-21 16:51:12', 'STAFF', 'D60678E8F2'), (3163, 1, 'SOLVED', 9, 3, 3, 'Sales Doubt', '2009-05-21 06:44:07', 2, null, '2009-05-30 13:33:30', 'STAFF', '6A4D5952D4'), (3164, 2, 'SOLVED', 10, 26, 4, 'WEB Mail Doubt', '2009-05-21 11:59:40', 4, null, '2009-06-09 15:31:36', 'STAFF', '98B17F068D'), (3165, 2, 'CLOSED', 8, 37, 1, 'CRM Application Issue', '2009-05-21 07:47:36', 2, null, '2009-05-22 17:03:45', 'STAFF', 'B299AD862B'), (3166, 2, 'SOLVED', 8, 8, 5, 'Peripheral Doubt', '2009-05-21 09:49:25', 4, null, '2009-05-22 14:40:27', 'STAFF', '5E6D27A7A8'), (3167, 3, 'SOLVED', 9, 29, 4, 'WEB Mail Doubt', '2009-05-21 07:34:24', 4, null, '2009-05-22 17:07:26', 'STAFF', '20C86A6282'), (3168, 1, 'CLOSED', 4, 39, 6, 'Software Doubt', '2009-05-23 07:22:20', 1, null, '2009-05-31 17:43:51', 'STAFF', 'CE393994E8'), (3169, 1, 'CLOSED', 1, 40, 4, 'WEB Mail Doubt', '2009-05-23 10:03:08', 1, null, '2009-05-29 18:51:33', 'STAFF', '7A98AF17E6'), (3170, 1, 'SOLVED', 2, 5, 4, 'WEB Mail Issue', '2009-05-23 12:04:48', 3, null, '2009-06-06 17:07:15', 'STAFF', '73E5080F0F'), (3171, 3, 'CLOSED', 7, 14, 6, 'Software Doubt', '2009-05-23 08:05:31', 2, null, '2009-05-26 14:16:00', 'STAFF', '976ABF4997'), (3172, 3, 'SOLVED', 10, 11, 1, 'CRM Application Doubt', '2009-05-23 10:24:39', 2, null, '2009-06-03 18:15:01', 'STAFF', 'E25CFA90F0'), (3173, 2, 'SOLVED', 6, 23, 6, 'Sotfware Issue', '2009-05-23 12:14:21', 2, null, '2009-06-02 14:23:46', 'STAFF', 'E8258E5140'), (3174, 2, 'SOLVED', 3, 27, 5, 'Peripheral Issue', '2009-05-23 07:55:34', 2, null, '2009-06-04 16:52:23', 'STAFF', '45C166D697'), (3175, 1, 'SOLVED', 1, 11, 2, 'WEB Site Doubt', '2009-05-23 09:53:41', 2, null, '2009-05-25 15:29:46', 'STAFF', 'CE47BE4ABD'), (3176, 1, 'CLOSED', 9, 31, 4, 'WEB Mail Doubt', '2009-05-23 12:21:37', 3, null, '2009-05-23 16:26:59', 'STAFF', '59DFA2DF42'), (3177, 1, 'CLOSED', 1, 28, 6, 'Software Issue', '2009-05-24 10:49:34', 3, null, '2009-05-31 17:27:12', 'STAFF', 'D3630410C5'), (3178, 3, 'SOLVED', 2, 33, 5, 'Peripheral Doubt', '2009-05-24 07:20:54', 2, null, '2009-05-25 18:35:08', 'STAFF', 'BA95D78A7C'), (3179, 2, 'SOLVED', 10, 1, 6, 'Software Doubt', '2009-05-24 08:37:58', 4, null, '2009-06-13 15:17:48', 'STAFF', '91378B3313'), (3180, 2, 'SOLVED', 6, 11, 4, 'WEB Mail Issue', '2009-05-24 12:13:21', 4, null, '2009-06-02 18:09:38', 'STAFF', 'C20A7CE2A6'), (3181, 2, 'SOLVED', 5, 26, 5, 'Peripheral Issue', '2009-05-24 11:08:29', 2, null, '2009-06-01 18:48:50', 'STAFF', 'F4AA0DD960'), (3182, 1, 'SOLVED', 9, 28, 6, 'Software Doubt', '2009-05-24 10:27:47', 2, null, '2009-06-03 18:14:23', 'STAFF', '8051A3C405'), (3183, 2, 'SOLVED', 10, 1, 4, 'WEB Mail Issue', '2009-05-24 10:53:34', 2, null, '2009-05-24 16:43:09', 'STAFF', 'D9896106CA'), (3184, 3, 'SOLVED', 2, 18, 6, 'Software Doubt', '2009-05-24 07:08:12', 2, null, '2009-06-03 16:24:45', 'STAFF', '3EB414BF1C'), (3185, 2, 'CLOSED', 3, 33, 6, 'Software Doubt', '2009-05-25 07:12:05', 3, null, '2009-06-06 14:19:40', 'STAFF', '39AE2ED11B'), (3186, 2, 'CLOSED', 10, 31, 2, 'WEB Site Issue', '2009-05-25 10:47:55', 3, null, '2009-05-30 14:42:45', 'STAFF', '3F4366AEB9'), (3187, 3, 'SOLVED', 10, 5, 4, 'WEB Mail Doubt', '2009-05-25 10:20:12', 4, null, '2009-06-03 15:19:49', 'STAFF', '31C0C178A9'), (3188, 2, 'SOLVED', 8, 30, 3, 'Sales Doubt', '2009-05-25 07:07:33', 4, null, '2009-06-06 15:12:41', 'STAFF', '8D30AA96E7'), (3189, 3, 'SOLVED', 4, 11, 5, 'Peripheral Doubt', '2009-05-25 08:56:46', 3, null, '2009-06-03 16:20:28', 'STAFF', '8832AE3913'), (3190, 3, 'SOLVED', 10, 23, 5, 'Peripheral Doubt', '2009-05-25 09:56:16', 4, null, '2009-06-09 17:48:52', 'STAFF', '07C4B1FDD1'), (3191, 2, 'SOLVED', 1, 26, 3, 'Sales Doubt', '2009-05-25 12:19:18', 3, null, '2009-05-26 18:23:47', 'STAFF', 'F023559C6D'), (3192, 1, 'SOLVED', 1, 37, 1, 'CRM Application Doubt', '2009-05-25 11:24:16', 3, null, '2009-06-07 13:38:45', 'STAFF', '766E428D1E'), (3193, 1, 'SOLVED', 10, 38, 1, 'CRM Application Doubt', '2009-05-25 12:21:21', 2, null, '2009-06-03 17:21:56', 'STAFF', '68A9750337'), (3194, 3, 'SOLVED', 6, 20, 5, 'Peripheral Issue', '2009-05-25 09:09:06', 2, null, '2009-05-29 18:39:18', 'STAFF', '563CA5E068'), (3195, 2, 'SOLVED', 6, 10, 5, 'Peripheral Issue', '2009-05-25 09:17:02', 4, null, '2009-05-28 13:24:40', 'STAFF', '7F01C93976'), (3196, 1, 'SOLVED', 7, 22, 6, 'Software Issue', '2009-05-25 12:12:01', 2, null, '2009-06-04 14:53:05', 'STAFF', '6C4BB406B3'), (3197, 2, 'SOLVED', 6, 20, 2, 'WEB Site Doubt', '2009-05-26 09:35:06', 3, null, '2009-06-03 15:23:22', 'STAFF', '721E7285B2');
INSERT INTO "ticket" VALUES (3198, 3, 'CLOSED', 7, 38, 5, 'Peripheral Doubt', '2009-05-26 07:51:04', 1, null, '2009-05-29 14:20:05', 'STAFF', 'B08354F368'), (3199, 3, 'SOLVED', 3, 4, 6, 'Software Doubt', '2009-05-26 12:17:26', 2, null, '2009-06-06 14:40:07', 'STAFF', 'B59307FDAC'), (3200, 2, 'SOLVED', 9, 20, 5, 'Peripheral Issue', '2009-05-26 10:03:45', 4, null, '2009-05-29 18:42:13', 'STAFF', '731AE30AF8'), (3201, 2, 'SOLVED', 2, 39, 6, 'Software Doubt', '2009-05-26 09:36:45', 4, null, '2009-05-28 16:49:54', 'STAFF', '24EC8468B6'), (3202, 3, 'CLOSED', 10, 1, 3, 'Sales Doubt', '2009-05-26 08:17:07', 1, null, '2009-05-30 17:27:46', 'STAFF', '7486CEF252'), (3203, 2, 'SOLVED', 10, 19, 3, 'Sales Doubt', '2009-05-26 12:03:33', 2, null, '2009-06-12 13:05:46', 'STAFF', '799DE6D3DA'), (3204, 1, 'CLOSED', 2, 8, 6, 'Sotfware Issue', '2009-05-26 08:46:29', 3, null, '2009-05-31 13:51:19', 'STAFF', '640258597C'), (3205, 2, 'SOLVED', 1, 37, 4, 'WEB Mail Doubt', '2009-05-26 07:12:11', 2, null, '2009-05-29 15:44:34', 'STAFF', '9EF2ED4B7F'), (3206, 2, 'SOLVED', 9, 22, 3, 'Sales Doubt', '2009-05-26 09:18:09', 2, null, '2009-06-12 14:03:21', 'STAFF', '211ED78FE9'), (3207, 3, 'SOLVED', 1, 24, 3, 'Sales Doubt', '2009-05-27 12:07:58', 4, null, '2009-06-11 17:34:20', 'STAFF', 'D77E68596C'), (3208, 2, 'SOLVED', 6, 38, 3, 'Sales Doubt', '2009-05-27 08:46:07', 2, null, '2009-06-09 18:36:41', 'STAFF', '2EF248C049'), (3209, 2, 'CLOSED', 1, 39, 6, 'Sotfware Issue', '2009-05-27 11:54:03', 3, null, '2009-06-05 17:18:12', 'STAFF', '1271A7029C'), (3210, 2, 'CLOSED', 10, 32, 3, 'Sales Doubt', '2009-05-27 12:10:52', 2, null, '2009-06-08 18:29:28', 'STAFF', '731309C4BB'), (3211, 3, 'SOLVED', 3, 11, 6, 'Software Doubt', '2009-05-27 12:16:09', 4, null, '2009-05-27 13:32:13', 'STAFF', '6B620AEDFA'), (3212, 3, 'CLOSED', 2, 34, 6, 'Sotfware Issue', '2009-05-27 11:41:58', 3, null, '2009-05-27 15:35:28', 'STAFF', '0AAE0FEDE9'), (3213, 2, 'SOLVED', 3, 23, 3, 'Sales Doubt', '2009-05-27 09:50:31', 2, null, '2009-06-01 17:49:38', 'STAFF', '9BD5EE6FE5'), (3214, 2, 'SOLVED', 1, 18, 5, 'Peripheral Issue', '2009-05-27 09:05:55', 3, null, '2009-06-07 13:57:49', 'STAFF', '89D4402DC0'), (3215, 2, 'CLOSED', 5, 37, 6, 'Sotfware Issue', '2009-05-27 09:28:15', 3, null, '2009-06-01 18:46:04', 'STAFF', 'E2EACAFF46'), (3216, 2, 'SOLVED', 6, 33, 6, 'Sotfware Issue', '2009-05-27 11:00:42', 2, null, '2009-06-06 14:36:02', 'STAFF', '133B3752E5'), (3217, 3, 'SOLVED', 10, 35, 5, 'Peripheral Issue', '2009-05-27 09:19:15', 4, null, '2009-05-27 16:55:42', 'STAFF', '52EDC4A589'), (3218, 2, 'SOLVED', 6, 37, 1, 'CRM Application Doubt', '2009-05-28 11:58:23', 2, null, '2009-06-08 16:25:30', 'STAFF', 'B0169350CD'), (3219, 2, 'SOLVED', 10, 22, 4, 'WEB Mail Doubt', '2009-05-30 09:52:09', 2, null, '2009-06-09 13:10:57', 'STAFF', '94B5BDE6DE'), (3220, 2, 'SOLVED', 7, 31, 6, 'Software Doubt', '2009-05-30 06:07:09', 2, null, '2009-06-11 14:52:48', 'STAFF', '5812F92450'), (3221, 3, 'SOLVED', 9, 19, 5, 'Peripheral Doubt', '2009-05-30 10:39:38', 3, null, '2009-06-14 18:12:18', 'STAFF', 'F5C150AFBF'), (3222, 2, 'SOLVED', 8, 26, 4, 'WEB Mail Issue', '2009-05-30 09:04:32', 3, null, '2009-06-01 17:19:38', 'STAFF', '687FD5C7E0'), (3223, 1, 'CLOSED', 3, 24, 1, 'CRM Application Doubt', '2009-05-30 08:14:44', 3, null, '2009-06-03 15:18:30', 'STAFF', 'DF83971673'), (3224, 1, 'SOLVED', 3, 27, 5, 'Peripheral Issue', '2009-05-30 11:27:39', 3, null, '2009-06-10 14:50:21', 'STAFF', '0D352B4D3A'), (3225, 2, 'SOLVED', 9, 27, 2, 'WEB Site Doubt', '2009-05-30 06:42:06', 3, null, '2009-06-11 17:35:42', 'STAFF', '6DFE08EDA7'), (3226, 1, 'SOLVED', 10, 21, 5, 'Peripheral Issue', '2009-05-30 06:53:06', 3, null, '2009-06-17 14:00:53', 'STAFF', '907EDB0AA6'), (3227, 3, 'SOLVED', 5, 3, 5, 'Peripheral Doubt', '2009-05-30 08:03:39', 3, null, '2009-06-02 17:06:21', 'STAFF', 'AAC61539FD'), (3228, 2, 'CLOSED', 4, 32, 3, 'Sales Issue', '2009-05-30 12:49:33', 1, null, '2009-06-13 14:27:18', 'STAFF', '040A99F23E'), (3229, 1, 'CLOSED', 10, 16, 3, 'Sales Doubt', '2009-05-30 07:26:24', 2, null, '2009-06-02 18:19:23', 'STAFF', '85AE750AD1'), (3230, 3, 'SOLVED', 10, 10, 6, 'Software Doubt', '2009-05-30 12:01:35', 3, null, '2009-06-03 15:29:23', 'STAFF', 'C12706A7C6'), (3231, 1, 'SOLVED', 5, 34, 4, 'WEB Mail Doubt', '2009-05-31 12:07:05', 3, null, '2009-06-11 13:25:11', 'STAFF', 'C3D377D10B'), (3232, 3, 'SOLVED', 5, 1, 6, 'Software Issue', '2009-05-31 11:51:36', 3, null, '2009-06-03 15:21:57', 'STAFF', '12E0860668'), (3233, 2, 'SOLVED', 3, 17, 4, 'WEB Mail Doubt', '2009-05-31 09:54:14', 3, null, '2009-06-04 17:52:14', 'STAFF', 'B6D67A2490'), (3234, 2, 'SOLVED', 5, 39, 1, 'CRM Application Issue', '2009-05-31 06:25:32', 3, null, '2009-06-06 16:50:11', 'STAFF', 'C5658C711B'), (3235, 3, 'SOLVED', 3, 38, 1, 'CRM Application Issue', '2009-05-31 07:30:50', 3, null, '2009-06-18 13:19:58', 'STAFF', 'F87522788A'), (3236, 2, 'SOLVED', 9, 37, 5, 'Peripheral Issue', '2009-05-31 07:55:13', 4, null, '2009-06-17 13:55:44', 'STAFF', 'DDCB155487'), (3237, 3, 'CLOSED', 2, 10, 6, 'Software Issue', '2009-05-31 06:10:02', 2, null, '2009-06-14 15:24:34', 'STAFF', '544A4F59F6'), (3238, 1, 'SOLVED', 1, 34, 6, 'Sotfware Issue', '2009-05-31 10:13:54', 4, null, '2009-06-10 17:49:05', 'STAFF', '528AECDF9C'), (3239, 2, 'SOLVED', 5, 10, 5, 'Peripheral Doubt', '2009-05-31 09:56:47', 4, null, '2009-05-31 16:12:57', 'STAFF', 'AE3539867A'), (3240, 2, 'SOLVED', 1, 5, 1, 'CRM Application Doubt', '2009-05-31 12:35:49', 3, null, '2009-06-11 14:53:11', 'STAFF', 'D15426B9C3'), (3241, 2, 'CLOSED', 9, 22, 4, 'WEB Mail Doubt', '2009-06-01 06:15:34', 2, null, '2009-06-05 15:17:47', 'STAFF', 'A64BD53139'), (3242, 2, 'SOLVED', 6, 20, 4, 'WEB Mail Issue', '2009-06-01 06:03:24', 3, null, '2009-06-06 18:15:56', 'STAFF', '032DD17B77'), (3243, 2, 'SOLVED', 6, 3, 2, 'WEB Site Issue', '2009-06-01 09:51:19', 3, null, '2009-06-12 14:44:57', 'STAFF', '38811C5285'), (3244, 2, 'SOLVED', 9, 10, 6, 'Software Issue', '2009-06-01 08:07:06', 2, null, '2009-06-06 15:55:13', 'STAFF', '88E1CE84F9'), (3245, 3, 'SOLVED', 9, 21, 6, 'Sotfware Issue', '2009-06-01 10:22:34', 2, null, '2009-06-04 16:49:19', 'STAFF', '0E1EBAD68A'), (3246, 2, 'CLOSED', 9, 17, 6, 'Sotfware Issue', '2009-06-01 09:27:05', 1, null, '2009-06-04 15:04:34', 'STAFF', 'D309CD6396'), (3247, 1, 'SOLVED', 6, 28, 6, 'Software Doubt', '2009-06-01 06:32:31', 2, null, '2009-06-08 16:43:38', 'STAFF', 'AC45088DF2'), (3248, 2, 'SOLVED', 9, 37, 5, 'Peripheral Issue', '2009-06-01 10:24:05', 3, null, '2009-06-06 13:57:35', 'STAFF', 'C57ABE86DE'), (3249, 1, 'SOLVED', 2, 1, 1, 'CRM Application Doubt', '2009-06-01 08:01:52', 2, null, '2009-06-20 14:26:33', 'STAFF', '0613239E12'), (3250, 3, 'SOLVED', 4, 10, 4, 'WEB Mail Doubt', '2009-06-01 09:01:19', 4, null, '2009-06-16 16:40:51', 'STAFF', '326FB04C3A'), (3251, 3, 'SOLVED', 10, 5, 4, 'WEB Mail Doubt', '2009-06-01 07:58:13', 3, null, '2009-06-17 17:38:15', 'STAFF', '504C296F8E'), (3252, 2, 'SOLVED', 1, 7, 3, 'Sales Doubt', '2009-06-01 09:54:04', 4, null, '2009-06-06 13:35:08', 'STAFF', '1E3B21CB22'), (3253, 2, 'CLOSED', 5, 39, 2, 'WEB Site Issue', '2009-06-01 08:04:56', 3, null, '2009-06-13 15:50:25', 'STAFF', '4AD13F04EF'), (3254, 2, 'SOLVED', 2, 11, 1, 'CRM Application Issue', '2009-06-01 11:18:58', 4, null, '2009-06-13 16:57:22', 'STAFF', '8DEB8D1DD9'), (3255, 2, 'SOLVED', 5, 8, 6, 'Software Issue', '2009-06-02 12:05:08', 2, null, '2009-06-17 16:29:38', 'STAFF', '2067E2650C'), (3256, 1, 'SOLVED', 10, 25, 6, 'Software Doubt', '2009-06-02 10:10:35', 2, null, '2009-06-18 18:28:44', 'STAFF', '2131F8ECF1'), (3257, 2, 'SOLVED', 6, 32, 5, 'Peripheral Doubt', '2009-06-02 07:56:23', 2, null, '2009-06-04 15:01:17', 'STAFF', '4EA83D9519'), (3258, 2, 'SOLVED', 2, 3, 5, 'Peripheral Doubt', '2009-06-02 07:09:49', 3, null, '2009-06-14 14:20:54', 'STAFF', '485843481A'), (3259, 2, 'SOLVED', 1, 11, 5, 'Peripheral Issue', '2009-06-02 11:14:40', 2, null, '2009-06-08 18:29:26', 'STAFF', 'A87D27F712'), (3260, 1, 'SOLVED', 9, 21, 1, 'CRM Application Issue', '2009-06-02 08:29:35', 2, null, '2009-06-11 14:37:35', 'STAFF', 'D54CE9DE9D'), (3261, 2, 'SOLVED', 10, 38, 6, 'Sotfware Issue', '2009-06-02 09:20:29', 2, null, '2009-06-07 15:06:25', 'STAFF', '95177E528F'), (3262, 1, 'SOLVED', 10, 10, 5, 'Peripheral Issue', '2009-06-02 08:33:46', 4, null, '2009-06-16 17:33:50', 'STAFF', '8A50BAE297'), (3263, 2, 'SOLVED', 7, 32, 6, 'Sotfware Issue', '2009-06-02 09:23:22', 3, null, '2009-06-03 18:42:17', 'STAFF', 'F8037F94E5'), (3264, 2, 'CLOSED', 10, 25, 2, 'WEB Site Issue', '2009-06-02 09:10:50', 1, null, '2009-06-13 18:49:24', 'STAFF', 'F0EAF559F8'), (3265, 2, 'SOLVED', 6, 25, 3, 'Sales Doubt', '2009-06-02 07:50:13', 4, null, '2009-06-15 14:48:58', 'STAFF', 'F4334C131C'), (3266, 1, 'SOLVED', 10, 16, 2, 'WEB Site Issue', '2009-06-02 12:00:36', 4, null, '2009-06-13 13:47:42', 'STAFF', 'AC73001B1D'), (3267, 2, 'SOLVED', 5, 22, 4, 'WEB Mail Issue', '2009-06-03 06:43:24', 4, null, '2009-06-22 16:32:33', 'STAFF', '073B00AB99'), (3268, 3, 'SOLVED', 5, 9, 6, 'Software Issue', '2009-06-03 07:10:50', 2, null, '2009-06-10 14:44:22', 'STAFF', 'A4D92E2CD5'), (3269, 1, 'SOLVED', 1, 37, 3, 'Sales Doubt', '2009-06-03 07:11:41', 4, null, '2009-06-06 15:07:37', 'STAFF', 'C91E3483CF'), (3270, 2, 'SOLVED', 5, 17, 4, 'WEB Mail Doubt', '2009-06-03 11:36:10', 3, null, '2009-06-19 13:01:41', 'STAFF', '3F7BCD0B3E'), (3271, 2, 'SOLVED', 8, 39, 6, 'Sotfware Issue', '2009-06-03 10:32:36', 3, null, '2009-06-07 16:22:13', 'STAFF', 'BFBB56BEE6'), (3272, 2, 'SOLVED', 3, 15, 6, 'Software Issue', '2009-06-03 12:02:57', 4, null, '2009-06-14 16:00:06', 'STAFF', '79514E888B'), (3273, 3, 'REPLIED', 10, 35, 1, 'CRM Application Doubt', '2009-06-03 09:22:27', 0, null, '2009-06-15 14:09:17', 'STAFF', '9C8661BEFA'), (3274, 1, 'SOLVED', 2, 39, 6, 'Sotfware Issue', '2009-06-03 07:52:36', 3, null, '2009-06-16 18:47:43', 'STAFF', '2B323D6EB2'), (3275, 2, 'CLOSED', 10, 29, 4, 'WEB Mail Issue', '2009-06-03 12:06:35', 3, null, '2009-06-18 13:42:31', 'STAFF', '52B738B303'), (3276, 1, 'SOLVED', 2, 25, 6, 'Software Issue', '2009-06-03 11:28:18', 4, null, '2009-06-06 14:02:06', 'STAFF', 'B58AC8403E'), (3277, 2, 'REPLIED', 1, 4, 3, 'Sales Doubt', '2009-06-04 09:10:55', 0, null, '2009-06-19 15:56:12', 'STAFF', 'FD8C07A31F'), (3278, 1, 'CLOSED', 9, 17, 1, 'CRM Application Doubt', '2009-06-04 06:20:04', 2, null, '2009-06-14 18:46:25', 'STAFF', 'F507783927'), (3279, 2, 'RETURNED', 7, 39, 2, 'WEB Site Doubt', '2009-06-04 07:04:49', 0, null, '2009-06-04 07:04:49', 'CUSTOMER', '706608CFDB'), (3280, 2, 'SOLVED', 5, 18, 1, 'CRM Application Issue', '2009-06-04 11:18:57', 4, null, '2009-06-12 14:43:25', 'STAFF', 'CC96578847'), (3281, 2, 'CLOSED', 5, 1, 5, 'Peripheral Issue', '2009-06-04 10:45:32', 3, null, '2009-06-05 13:12:15', 'STAFF', '60A70BB05B'), (3282, 2, 'SOLVED', 1, 19, 2, 'WEB Site Issue', '2009-06-05 09:28:49', 3, null, '2009-06-16 16:04:04', 'STAFF', 'A495EEBBFA'), (3283, 2, 'SOLVED', 1, 6, 6, 'Sotfware Issue', '2009-06-06 11:35:04', 4, null, '2009-06-15 18:59:30', 'STAFF', 'C819904DDE'), (3284, 2, 'SOLVED', 2, 10, 2, 'WEB Site Issue', '2009-06-06 08:08:39', 3, null, '2009-06-18 13:56:45', 'STAFF', 'C1D0F19C3F'), (3285, 3, 'SOLVED', 8, 6, 4, 'WEB Mail Issue', '2009-06-06 08:09:46', 3, null, '2009-06-12 14:19:08', 'STAFF', '72B3862240'), (3286, 3, 'SOLVED', 4, 19, 6, 'Software Issue', '2009-06-06 11:14:14', 2, null, '2009-06-10 16:10:40', 'STAFF', '9DDB9DD5D8'), (3287, 2, 'SOLVED', 6, 22, 6, 'Software Doubt', '2009-06-06 09:50:58', 4, null, '2009-06-14 18:47:46', 'STAFF', '946E3ECE1F'), (3288, 3, 'CLOSED', 1, 39, 1, 'CRM Application Issue', '2009-06-06 10:08:38', 2, null, '2009-06-21 13:54:42', 'STAFF', 'B98249B383'), (3289, 3, 'SOLVED', 8, 28, 6, 'Sotfware Issue', '2009-06-06 10:53:52', 4, null, '2009-06-12 14:30:35', 'STAFF', '645E6BFDD0'), (3290, 2, 'SOLVED', 10, 10, 5, 'Peripheral Issue', '2009-06-06 07:11:39', 2, null, '2009-06-13 18:37:47', 'STAFF', '3A30BE93EB'), (3291, 1, 'SOLVED', 10, 33, 3, 'Sales Doubt', '2009-06-06 08:57:08', 4, null, '2009-06-17 18:44:13', 'STAFF', '980A875FF6'), (3292, 2, 'CLOSED', 7, 30, 6, 'Sotfware Issue', '2009-06-06 10:33:19', 3, null, '2009-06-20 18:31:59', 'STAFF', 'CFCCE0621B'), (3293, 3, 'SOLVED', 10, 14, 5, 'Peripheral Issue', '2009-06-06 11:51:00', 2, null, '2009-06-20 16:31:55', 'STAFF', 'CA3EC59800'), (3294, 1, 'SOLVED', 9, 7, 4, 'WEB Mail Doubt', '2009-06-07 12:39:31', 2, null, '2009-06-11 18:25:02', 'STAFF', '7A430339C1'), (3295, 3, 'SOLVED', 9, 29, 3, 'Sales Doubt', '2009-06-07 08:42:14', 4, null, '2009-06-08 15:35:43', 'STAFF', 'D5D7F5BBA7'), (3296, 1, 'SOLVED', 1, 37, 4, 'WEB Mail Issue', '2009-06-07 06:32:27', 4, null, '2009-06-08 16:10:05', 'STAFF', '42CD63CB18'), (3297, 2, 'CLOSED', 5, 11, 5, 'Peripheral Issue', '2009-06-07 06:50:11', 2, null, '2009-06-21 14:31:37', 'STAFF', '7A4BF9BA2B'), (3298, 1, 'RETURNED', 2, 10, 1, 'CRM Application Doubt', '2009-06-07 06:05:32', 0, null, '2009-06-15 11:34:24', 'CUSTOMER', 'FA84632D74'), (3299, 2, 'RETURNED', 8, 26, 6, 'Sotfware Issue', '2009-06-07 09:19:18', 0, null, '2009-06-17 12:04:21', 'CUSTOMER', '7371364B3D'), (3300, 3, 'UNASSIGNED', 2, 19, 6, 'Software Doubt', '2009-06-07 10:54:14', 0, null, '2009-06-07 10:54:14', 'CUSTOMER', '63BFD6E8F2'), (3301, 2, 'CLOSED', 9, 7, 1, 'CRM Application Doubt', '2009-06-08 12:42:23', 1, null, '2009-06-19 13:34:21', 'STAFF', '8217BB4E7F'), (3302, 2, 'SOLVED', 9, 1, 4, 'WEB Mail Doubt', '2009-06-08 12:13:59', 2, null, '2009-06-21 17:52:19', 'STAFF', '6FAB6E3AA3'), (3303, 1, 'SOLVED', 3, 20, 4, 'WEB Mail Doubt', '2009-06-08 12:52:39', 3, null, '2009-06-17 16:34:04', 'STAFF', 'F24AD6F72D'), (3304, 2, 'CLOSED', 5, 30, 2, 'WEB Site Issue', '2009-06-08 11:04:46', 1, null, '2009-06-16 15:21:53', 'STAFF', '0E9D935F7E'), (3305, 2, 'SOLVED', 5, 6, 6, 'Sotfware Issue', '2009-06-08 09:00:30', 3, null, '2009-06-14 18:35:53', 'STAFF', 'B848EDAE25'), (3306, 2, 'SOLVED', 2, 10, 3, 'Sales Doubt', '2009-06-08 07:05:51', 4, null, '2009-06-12 18:46:50', 'STAFF', '16FC18D787'), (3307, 3, 'RETURNED', 6, 5, 2, 'WEB Site Issue', '2009-06-08 11:58:32', 0, null, '2009-06-14 08:15:03', 'CUSTOMER', 'D7AAB42E6B'), (3308, 2, 'RETURNED', 4, 17, 5, 'Peripheral Issue', '2009-06-08 07:12:43', 0, null, '2009-06-18 12:09:02', 'CUSTOMER', 'C4B43AE017'), (3309, 2, 'RETURNED', 4, 17, 6, 'Software Doubt', '2009-06-08 06:14:14', 0, null, '2009-06-08 06:14:14', 'CUSTOMER', '2B7B82A7EC'), (3310, 2, 'SOLVED', 10, 35, 1, 'CRM Application Issue', '2009-06-08 07:22:00', 3, null, '2009-06-11 17:29:43', 'STAFF', '69386F6BB1'), (3311, 2, 'SOLVED', 5, 31, 3, 'Sales Doubt', '2009-06-08 09:54:14', 2, null, '2009-06-19 13:39:18', 'STAFF', 'BDD8817990'), (3312, 1, 'SOLVED', 10, 36, 2, 'WEB Site Issue', '2009-06-08 10:28:04', 4, null, '2009-06-16 15:32:55', 'STAFF', '334467D41D'), (3313, 2, 'REPLIED', 7, 1, 5, 'Peripheral Doubt', '2009-06-08 12:22:43', 0, null, '2009-06-11 14:43:41', 'STAFF', 0906061606), (3314, 3, 'SOLVED', 9, 33, 4, 'WEB Mail Doubt', '2009-06-08 08:45:10', 4, null, '2009-06-10 17:29:18', 'STAFF', 'C46482DD5D'), (3315, 1, 'SOLVED', 1, 20, 2, 'WEB Site Issue', '2009-06-08 06:16:58', 2, null, '2009-06-08 13:12:41', 'STAFF', '62DAD6E273'), (3316, 3, 'SOLVED', 10, 1, 6, 'Software Issue', '2009-06-08 07:43:32', 2, null, '2009-06-11 16:33:31', 'STAFF', '8CE5D98937'), (3317, 2, 'SOLVED', 10, 5, 6, 'Software Doubt', '2009-06-08 12:57:27', 2, null, '2009-06-21 15:24:56', 'STAFF', '2C758933AF'), (3318, 2, 'CLOSED', 4, 21, 6, 'Software Doubt', '2009-06-09 08:50:50', 2, null, '2009-06-25 14:39:18', 'STAFF', '831B1AC54C'), (3319, 2, 'SOLVED', 7, 33, 5, 'Peripheral Issue', '2009-06-09 08:04:32', 4, null, '2009-06-21 13:00:54', 'STAFF', '8A1D694707'), (3320, 1, 'SOLVED', 10, 21, 1, 'CRM Application Issue', '2009-06-09 10:47:31', 3, null, '2009-06-22 18:53:48', 'STAFF', '36ED197B3F'), (3321, 3, 'SOLVED', 1, 18, 6, 'Sotfware Issue', '2009-06-09 12:15:44', 3, null, '2009-06-22 18:59:57', 'STAFF', '3CFBDF468F'), (3322, 3, 'SOLVED', 8, 28, 1, 'CRM Application Issue', '2009-06-09 11:20:54', 4, null, '2009-06-14 17:09:25', 'STAFF', 'F7CFDDE9DB'), (3323, 2, 'SOLVED', 1, 24, 6, 'Software Issue', '2009-06-09 12:01:43', 4, null, '2009-06-24 16:23:21', 'STAFF', 'A4351B79D9'), (3324, 3, 'SOLVED', 6, 22, 4, 'WEB Mail Issue', '2009-06-09 06:15:00', 3, null, '2009-06-22 16:21:19', 'STAFF', '3CE6D3C883'), (3325, 1, 'CLOSED', 2, 17, 4, 'WEB Mail Doubt', '2009-06-09 11:08:49', 3, null, '2009-06-21 17:12:49', 'STAFF', '936824C019'), (3326, 2, 'SOLVED', 9, 17, 4, 'WEB Mail Issue', '2009-06-09 10:02:28', 2, null, '2009-06-20 14:52:08', 'STAFF', 'DBA132F6AB'), (3327, 2, 'SOLVED', 2, 36, 5, 'Peripheral Doubt', '2009-06-09 10:46:53', 2, null, '2009-06-27 17:58:05', 'STAFF', '20B02DC951'), (3328, 2, 'SOLVED', 5, 10, 4, 'WEB Mail Issue', '2009-06-10 12:09:09', 3, null, '2009-06-11 18:01:30', 'STAFF', 'E94FE9AC8D'), (3329, 2, 'CLOSED', 2, 35, 6, 'Software Issue', '2009-06-10 06:45:54', 3, null, '2009-06-20 17:58:16', 'STAFF', 'AC8CD1808D'), (3330, 1, 'UNASSIGNED', 2, 21, 3, 'Sales Issue', '2009-06-10 12:38:51', 0, null, '2009-06-10 12:38:51', 'CUSTOMER', 2996962656), (3331, 2, 'CLOSED', 9, 30, 1, 'CRM Application Issue', '2009-06-10 08:32:07', 2, null, '2009-06-27 16:46:31', 'STAFF', '0A2A51DAC6'), (3332, 3, 'SOLVED', 2, 31, 3, 'Sales Doubt', '2009-06-10 09:49:08', 3, null, '2009-06-21 13:15:53', 'STAFF', 'B0AB42FCB7'), (3333, 1, 'SOLVED', 8, 40, 6, 'Sotfware Issue', '2009-06-10 09:48:48', 3, null, '2009-06-15 17:50:56', 'STAFF', '2BE9BD7A34'), (3334, 2, 'RETURNED', 1, 11, 5, 'Peripheral Doubt', '2009-06-10 11:21:55', 0, null, '2009-06-10 11:21:55', 'CUSTOMER', '331316D4EF'), (3335, 2, 'SOLVED', 1, 31, 2, 'WEB Site Doubt', '2009-06-10 07:59:55', 2, null, '2009-06-10 16:19:30', 'STAFF', '59A3ADEA76'), (3336, 2, 'SOLVED', 8, 29, 3, 'Sales Issue', '2009-06-10 07:49:39', 2, null, '2009-06-22 17:14:02', 'STAFF', '98BD65207E'), (3337, 1, 'SOLVED', 3, 4, 4, 'WEB Mail Doubt', '2009-06-10 10:42:20', 2, null, '2009-06-12 14:41:25', 'STAFF', 'A4FA7175D4'), (3338, 3, 'SOLVED', 9, 19, 5, 'Peripheral Issue', '2009-06-10 12:05:30', 3, null, '2009-06-20 17:29:35', 'STAFF', '2DE7CF2043'), (3339, 2, 'SOLVED', 10, 29, 4, 'WEB Mail Doubt', '2009-06-11 12:53:39', 4, null, '2009-06-18 15:17:49', 'STAFF', '7BA0691B77'), (3340, 2, 'SOLVED', 4, 17, 5, 'Peripheral Doubt', '2009-06-11 09:25:06', 2, null, '2009-06-18 18:48:33', 'STAFF', 'F471223D1A'), (3341, 2, 'REPLIED', 4, 27, 4, 'WEB Mail Issue', '2009-06-11 11:13:32', 0, null, '2009-06-18 15:04:03', 'STAFF', 'ACF06CDD9C'), (3342, 2, 'SOLVED', 10, 1, 6, 'Software Doubt', '2009-06-11 07:51:35', 4, null, '2009-06-16 17:07:52', 'STAFF', '14491B756B'), (3343, 1, 'SOLVED', 1, 5, 2, 'WEB Site Issue', '2009-06-11 10:11:52', 3, null, '2009-06-23 13:43:38', 'STAFF', '21C5BBA1DD'), (3344, 3, 'CLOSED', 9, 10, 4, 'WEB Mail Doubt', '2009-06-12 08:21:41', 3, null, '2009-06-18 16:32:20', 'STAFF', '3083202A93'), (3345, 3, 'CLOSED', 9, 30, 6, 'Software Doubt', '2009-06-13 10:07:07', 2, null, '2009-06-23 13:16:11', 'STAFF', '38A77AA456'), (3346, 2, 'UNASSIGNED', 10, 37, 4, 'WEB Mail Doubt', '2009-06-13 08:08:28', 0, null, '2009-06-13 08:08:28', 'CUSTOMER', '0655F11744'), (3347, 2, 'SOLVED', 10, 27, 3, 'Sales Doubt', '2009-06-13 09:33:48', 2, null, '2009-06-19 13:51:16', 'STAFF', '1A04F96581'), (3348, 2, 'SOLVED', 1, 24, 5, 'Peripheral Issue', '2009-06-13 07:04:09', 4, null, '2009-06-16 13:32:11', 'STAFF', '333CB763FA'), (3349, 2, 'SOLVED', 1, 19, 3, 'Sales Doubt', '2009-06-13 10:51:09', 2, null, '2009-06-22 16:14:58', 'STAFF', '69F268FB2B'), (3350, 1, 'SOLVED', 10, 29, 4, 'WEB Mail Doubt', '2009-06-13 08:29:53', 2, null, '2009-06-20 14:44:38', 'STAFF', 'B7EE0D0D4D'), (3351, 2, 'CLOSED', 10, 33, 2, 'WEB Site Issue', '2009-06-13 09:30:53', 3, null, '2009-07-02 17:01:39', 'STAFF', '0B6ACE9E89'), (3352, 3, 'SOLVED', 2, 31, 4, 'WEB Mail Doubt', '2009-06-13 12:48:23', 3, null, '2009-07-03 14:39:00', 'STAFF', '0987B8B338'), (3353, 3, 'SOLVED', 2, 16, 1, 'CRM Application Doubt', '2009-06-13 07:35:12', 4, null, '2009-06-26 16:05:11', 'STAFF', '8B9E7AB295'), (3354, 2, 'SOLVED', 2, 22, 6, 'Software Issue', '2009-06-13 11:02:24', 3, null, '2009-06-17 14:54:40', 'STAFF', 'D2CD33E9C0'), (3355, 1, 'REPLIED', 3, 36, 6, 'Software Doubt', '2009-06-13 06:33:48', 0, null, '2009-06-28 18:45:39', 'STAFF', 'CA793D8B79'), (3356, 3, 'CLOSED', 1, 12, 5, 'Peripheral Doubt', '2009-06-14 11:29:26', 3, null, '2009-06-24 14:18:13', 'STAFF', 'A36B598ABB'), (3357, 2, 'SOLVED', 9, 32, 2, 'WEB Site Issue', '2009-06-14 12:41:04', 3, null, '2009-06-24 18:36:05', 'STAFF', '0CD6A652ED'), (3358, 2, 'REPLIED', 6, 27, 2, 'WEB Site Doubt', '2009-06-14 09:43:45', 0, null, '2009-06-24 13:59:14', 'STAFF', '97108695BD'), (3359, 1, 'CLOSED', 9, 22, 5, 'Peripheral Issue', '2009-06-14 10:47:31', 1, null, '2009-06-25 15:59:14', 'STAFF', '82B0639A82'), (3360, 2, 'SOLVED', 5, 16, 5, 'Peripheral Issue', '2009-06-14 06:48:30', 4, null, '2009-06-16 14:00:08', 'STAFF', '75DF636098'), (3361, 2, 'SOLVED', 8, 33, 4, 'WEB Mail Issue', '2009-06-15 08:34:56', 4, null, '2009-06-26 18:59:15', 'STAFF', '8D9766A69B'), (3362, 1, 'SOLVED', 7, 11, 6, 'Sotfware Issue', '2009-06-15 06:24:57', 4, null, '2009-06-28 14:39:46', 'STAFF', '39CD7B469B'), (3363, 2, 'SOLVED', 2, 19, 1, 'CRM Application Issue', '2009-06-15 12:38:27', 2, null, '2009-07-02 13:14:04', 'STAFF', '664DD858DB'), (3364, 1, 'CLOSED', 2, 3, 5, 'Peripheral Issue', '2009-06-15 06:48:02', 1, null, '2009-06-24 15:07:43', 'STAFF', '8A1EE9F2B7'), (3365, 2, 'SOLVED', 10, 19, 1, 'CRM Application Issue', '2009-06-15 11:42:15', 2, null, '2009-06-19 15:42:07', 'STAFF', 'B445E31413'), (3366, 2, 'SOLVED', 1, 12, 4, 'WEB Mail Doubt', '2009-06-15 11:21:10', 3, null, '2009-06-25 13:55:15', 'STAFF', '07F75D9144'), (3367, 2, 'SOLVED', 4, 38, 6, 'Software Doubt', '2009-06-15 12:34:19', 2, null, '2009-06-28 16:49:21', 'STAFF', '0E7E05FA10'), (3368, 2, 'CLOSED', 9, 39, 1, 'CRM Application Doubt', '2009-06-15 11:33:04', 2, null, '2009-06-15 17:55:32', 'STAFF', '165A59F7CF'), (3369, 3, 'SOLVED', 5, 1, 2, 'WEB Site Issue', '2009-06-15 08:43:30', 4, null, '2009-06-19 17:50:50', 'STAFF', 'DDA99DE58F'), (3370, 1, 'SOLVED', 10, 38, 2, 'WEB Site Issue', '2009-06-15 09:11:45', 4, null, '2009-06-22 15:41:35', 'STAFF', '900C563BFD'), (3371, 2, 'SOLVED', 5, 1, 2, 'WEB Site Issue', '2009-06-15 12:40:50', 2, null, '2009-06-26 18:23:06', 'STAFF', '285DA2198B'), (3372, 1, 'SOLVED', 1, 7, 6, 'Software Doubt', '2009-06-15 10:08:13', 4, null, '2009-06-17 17:29:59', 'STAFF', '37D0B499FB'), (3373, 1, 'RETURNED', 5, 30, 2, 'WEB Site Issue', '2009-06-15 11:12:24', 0, null, '2009-06-22 09:03:03', 'CUSTOMER', '0084AE4BC2'), (3374, 2, 'SOLVED', 3, 7, 6, 'Software Issue', '2009-06-15 10:12:14', 4, null, '2009-06-15 18:09:32', 'STAFF', '6C349155B1'), (3375, 3, 'SOLVED', 3, 32, 6, 'Sotfware Issue', '2009-06-15 11:25:34', 4, null, '2009-06-27 18:23:51', 'STAFF', '9B9B05072D'), (3376, 1, 'SOLVED', 9, 11, 6, 'Software Issue', '2009-06-15 10:08:22', 2, null, '2009-06-20 18:28:19', 'STAFF', '14E422F05B'), (3377, 1, 'SOLVED', 10, 32, 1, 'CRM Application Issue', '2009-06-15 06:50:32', 2, null, '2009-06-27 16:02:22', 'STAFF', 'A9B4EC2EB4'), (3378, 3, 'RETURNED', 3, 29, 4, 'WEB Mail Issue', '2009-06-15 08:53:19', 0, null, '2009-06-23 10:34:55', 'CUSTOMER', '2E2C080D54'), (3379, 1, 'SOLVED', 10, 31, 6, 'Software Issue', '2009-06-15 08:18:54', 3, null, '2009-06-15 18:10:23', 'STAFF', 8885554757), (3380, 2, 'SOLVED', 9, 30, 4, 'WEB Mail Issue', '2009-06-16 08:49:30', 4, null, '2009-06-30 13:32:18', 'STAFF', 'F2BFF08078'), (3381, 2, 'SOLVED', 10, 38, 2, 'WEB Site Issue', '2009-06-16 06:24:26', 3, null, '2009-06-22 16:17:13', 'STAFF', '6E16656A6E'), (3382, 1, 'SOLVED', 9, 22, 5, 'Peripheral Issue', '2009-06-16 10:30:02', 3, null, '2009-06-19 16:39:52', 'STAFF', '29DDBDB402'), (3383, 2, 'REPLIED', 6, 21, 4, 'WEB Mail Issue', '2009-06-16 06:01:12', 0, null, '2009-07-04 17:49:28', 'STAFF', '0668E20B3C'), (3384, 2, 'CLOSED', 6, 30, 6, 'Software Issue', '2009-06-16 10:56:35', 3, null, '2009-07-06 16:49:32', 'STAFF', '2517756C5A'), (3385, 2, 'SOLVED', 6, 28, 2, 'WEB Site Issue', '2009-06-16 08:05:31', 4, null, '2009-06-29 18:40:59', 'STAFF', '131F383B43'), (3386, 1, 'RETURNED', 5, 10, 6, 'Sotfware Issue', '2009-06-16 12:51:08', 0, null, '2009-06-22 11:04:47', 'CUSTOMER', '31CA0CA711'), (3387, 2, 'SOLVED', 10, 37, 5, 'Peripheral Issue', '2009-06-16 12:56:46', 3, null, '2009-06-27 17:06:37', 'STAFF', '4A11654AD1'), (3388, 2, 'CLOSED', 1, 1, 6, 'Software Doubt', '2009-06-17 12:16:07', 2, null, '2009-06-24 18:24:14', 'STAFF', '621FBD17DA'), (3389, 2, 'REPLIED', 1, 38, 6, 'Software Doubt', '2009-06-17 07:42:38', 0, null, '2009-06-21 13:01:44', 'STAFF', '8643C8E210'), (3390, 2, 'SOLVED', 8, 1, 6, 'Software Doubt', '2009-06-17 11:09:33', 4, null, '2009-06-21 18:59:40', 'STAFF', '8ED36A8485'), (3391, 2, 'SOLVED', 9, 19, 1, 'CRM Application Doubt', '2009-06-17 07:24:08', 3, null, '2009-06-17 13:01:37', 'STAFF', 'DBB422937D'), (3392, 1, 'SOLVED', 6, 39, 6, 'Software Issue', '2009-06-17 07:28:35', 4, null, '2009-06-23 14:02:21', 'STAFF', '6463C88460'), (3393, 1, 'SOLVED', 5, 3, 2, 'WEB Site Issue', '2009-06-17 09:47:08', 3, null, '2009-06-20 13:03:48', 'STAFF', '477B02D99D'), (3394, 2, 'SOLVED', 1, 19, 6, 'Software Issue', '2009-06-17 07:59:36', 4, null, '2009-06-22 17:06:58', 'STAFF', 'E8A642ED6A'), (3395, 2, 'SOLVED', 3, 28, 6, 'Software Doubt', '2009-06-17 10:37:45', 2, null, '2009-06-30 14:42:12', 'STAFF', '828752F77A'), (3396, 3, 'SOLVED', 10, 22, 1, 'CRM Application Issue', '2009-06-17 09:04:33', 3, null, '2009-06-22 17:05:12', 'STAFF', '818DE4D2EC'), (3397, 2, 'SOLVED', 5, 20, 5, 'Peripheral Issue', '2009-06-17 07:59:33', 4, null, '2009-06-27 13:40:53', 'STAFF', '5C80985BD4'), (3398, 2, 'CLOSED', 4, 12, 5, 'Peripheral Issue', '2009-06-17 09:36:09', 3, null, '2009-06-29 14:49:51', 'STAFF', '384BABC3E7'), (3399, 2, 'SOLVED', 10, 3, 6, 'Software Issue', '2009-06-18 12:39:13', 3, null, '2009-06-24 14:17:31', 'STAFF', '57F04BB297'), (3400, 3, 'SOLVED', 1, 31, 2, 'WEB Site Issue', '2009-06-18 12:24:21', 4, null, '2009-07-05 15:33:24', 'STAFF', 'E945DE21A1'), (3401, 2, 'RETURNED', 7, 15, 3, 'Sales Issue', '2009-06-18 11:29:23', 0, null, '2009-06-23 06:37:17', 'CUSTOMER', '7FCC48D228'), (3402, 2, 'SOLVED', 9, 39, 4, 'WEB Mail Doubt', '2009-06-18 10:29:51', 3, null, '2009-06-23 18:35:16', 'STAFF', '91D0DBFD38'), (3403, 2, 'REPLIED', 1, 35, 6, 'Software Doubt', '2009-06-18 12:24:25', 0, null, '2009-06-20 14:18:05', 'STAFF', '898DD88CCA'), (3404, 2, 'SOLVED', 8, 37, 6, 'Software Doubt', '2009-06-20 11:26:21', 2, null, '2009-07-02 13:44:05', 'STAFF', 'C6B8C8D762'), (3405, 1, 'SOLVED', 7, 31, 2, 'WEB Site Issue', '2009-06-20 08:19:48', 4, null, '2009-07-05 14:27:45', 'STAFF', 'BE1BC79976'), (3406, 2, 'SOLVED', 5, 20, 1, 'CRM Application Doubt', '2009-06-20 06:14:58', 3, null, '2009-06-23 15:14:23', 'STAFF', '32FDAB6559'), (3407, 3, 'RETURNED', 10, 11, 1, 'CRM Application Issue', '2009-06-20 09:32:13', 0, null, '2009-06-30 07:37:49', 'CUSTOMER', 'DAB49080D8'), (3408, 2, 'SOLVED', 10, 40, 2, 'WEB Site Issue', '2009-06-20 07:06:47', 2, null, '2009-07-03 18:22:53', 'STAFF', '734E6BFCD3'), (3409, 2, 'CLOSED', 2, 8, 2, 'WEB Site Issue', '2009-06-20 07:26:32', 2, null, '2009-06-22 17:48:55', 'STAFF', '20125FD9B2'), (3410, 3, 'SOLVED', 8, 27, 6, 'Software Issue', '2009-06-20 07:28:20', 2, null, '2009-07-03 16:38:24', 'STAFF', 'C6F798B844'), (3411, 1, 'SOLVED', 8, 24, 2, 'WEB Site Issue', '2009-06-20 09:57:15', 3, null, '2009-06-24 13:41:12', 'STAFF', '2FD0FD3EFA'), (3412, 3, 'RETURNED', 1, 27, 2, 'WEB Site Doubt', '2009-06-20 06:47:58', 0, null, '2009-07-01 09:05:41', 'CUSTOMER', '90F1F4972D'), (3413, 3, 'SOLVED', 9, 39, 4, 'WEB Mail Doubt', '2009-06-21 10:58:13', 3, null, '2009-06-25 16:50:53', 'STAFF', '30192E936B'), (3414, 2, 'CLOSED', 5, 4, 6, 'Software Doubt', '2009-06-21 06:30:23', 3, null, '2009-07-03 16:59:52', 'STAFF', '63A7769EFB'), (3415, 1, 'SOLVED', 10, 28, 3, 'Sales Doubt', '2009-06-21 09:03:56', 4, null, '2009-07-08 13:00:59', 'STAFF', 'F6D9E459B9'), (3416, 2, 'SOLVED', 2, 16, 3, 'Sales Doubt', '2009-06-21 08:36:32', 3, null, '2009-06-23 13:19:12', 'STAFF', '1FFFEB2192'), (3417, 2, 'SOLVED', 10, 23, 6, 'Software Doubt', '2009-06-21 08:26:09', 3, null, '2009-07-02 13:31:02', 'STAFF', '471C50AD1A'), (3418, 2, 'SOLVED', 5, 8, 6, 'Software Doubt', '2009-06-21 08:59:26', 4, null, '2009-06-21 14:34:46', 'STAFF', 'D594B1A945'), (3419, 1, 'SOLVED', 10, 11, 2, 'WEB Site Issue', '2009-06-21 08:31:12', 2, null, '2009-07-03 18:03:20', 'STAFF', '4A53359176'), (3420, 1, 'SOLVED', 7, 10, 5, 'Peripheral Issue', '2009-06-21 12:11:42', 3, null, '2009-07-05 16:58:10', 'STAFF', '643DE7CF7B'), (3421, 1, 'RETURNED', 9, 31, 6, 'Software Issue', '2009-06-21 10:16:11', 0, null, '2009-06-21 10:16:11', 'CUSTOMER', 'E846FB8A4F'), (3422, 1, 'SOLVED', 5, 10, 1, 'CRM Application Issue', '2009-06-21 11:29:22', 3, null, '2009-06-30 15:23:32', 'STAFF', '73640DE25B'), (3423, 2, 'SOLVED', 2, 11, 3, 'Sales Doubt', '2009-06-21 06:01:18', 3, null, '2009-07-01 18:42:03', 'STAFF', '3D324C2883'), (3424, 2, 'SOLVED', 1, 30, 6, 'Software Issue', '2009-06-22 09:31:37', 3, null, '2009-07-02 14:04:07', 'STAFF', '71A5C0514A'), (3425, 2, 'SOLVED', 4, 11, 4, 'WEB Mail Doubt', '2009-06-22 11:06:20', 3, null, '2009-06-24 18:08:22', 'STAFF', '07211688A0'), (3426, 2, 'SOLVED', 9, 8, 6, 'Software Issue', '2009-06-22 10:39:28', 3, null, '2009-07-02 15:41:44', 'STAFF', '5D2C2CEE8A'), (3427, 2, 'SOLVED', 2, 27, 2, 'WEB Site Issue', '2009-06-22 10:55:46', 2, null, '2009-06-25 13:17:00', 'STAFF', '5421E01356'), (3428, 2, 'SOLVED', 6, 24, 6, 'Software Issue', '2009-06-22 11:30:44', 4, null, '2009-06-26 16:11:55', 'STAFF', '4500E40377'), (3429, 3, 'SOLVED', 3, 30, 3, 'Sales Doubt', '2009-06-22 09:26:02', 3, null, '2009-06-27 15:52:55', 'STAFF', 'CAA202034F'), (3430, 2, 'SOLVED', 8, 19, 4, 'WEB Mail Doubt', '2009-06-22 10:17:12', 2, null, '2009-07-04 18:05:54', 'STAFF', '2D2C8394E3'), (3431, 2, 'SOLVED', 10, 3, 4, 'WEB Mail Doubt', '2009-06-22 06:22:30', 3, null, '2009-06-22 13:26:22', 'STAFF', '84C2D4860A'), (3432, 2, 'SOLVED', 10, 25, 4, 'WEB Mail Doubt', '2009-06-22 06:19:10', 4, null, '2009-07-08 13:27:13', 'STAFF', 7200798384), (3433, 2, 'CLOSED', 5, 38, 6, 'Software Doubt', '2009-06-22 07:09:56', 2, null, '2009-06-30 16:49:03', 'STAFF', 'A91AF177D3'), (3434, 3, 'SOLVED', 6, 17, 6, 'Software Issue', '2009-06-22 06:30:13', 2, null, '2009-07-04 14:42:26', 'STAFF', '14C879F3F5'), (3435, 1, 'SOLVED', 10, 34, 2, 'WEB Site Doubt', '2009-06-23 12:38:04', 4, null, '2009-07-03 14:55:03', 'STAFF', '5B970A1D9B'), (3436, 1, 'CLOSED', 4, 39, 2, 'WEB Site Issue', '2009-06-23 10:15:25', 1, null, '2009-06-25 15:16:35', 'STAFF', '61F2585B0E'), (3437, 2, 'SOLVED', 5, 35, 5, 'Peripheral Doubt', '2009-06-23 10:59:41', 3, null, '2009-06-26 15:37:26', 'STAFF', 'C2F32522A8'), (3438, 3, 'SOLVED', 5, 25, 5, 'Peripheral Doubt', '2009-06-23 07:31:52', 3, null, '2009-07-01 17:09:39', 'STAFF', 'F34185C4CA'), (3439, 2, 'SOLVED', 1, 16, 6, 'Sotfware Issue', '2009-06-23 09:12:28', 4, null, '2009-07-05 13:17:27', 'STAFF', '4FA91C1901'), (3440, 3, 'SOLVED', 1, 21, 3, 'Sales Doubt', '2009-06-23 09:12:44', 4, null, '2009-07-06 14:51:21', 'STAFF', '7DE32147A4'), (3441, 2, 'SOLVED', 1, 11, 5, 'Peripheral Issue', '2009-06-23 08:10:04', 2, null, '2009-07-04 13:32:02', 'STAFF', 'B2004314AA'), (3442, 2, 'SOLVED', 5, 36, 1, 'CRM Application Doubt', '2009-06-24 12:13:44', 2, null, '2009-07-13 14:27:01', 'STAFF', '586F9B4035'), (3443, 1, 'SOLVED', 5, 30, 5, 'Peripheral Doubt', '2009-06-24 07:41:28', 3, null, '2009-07-06 15:40:26', 'STAFF', '12092A75CA'), (3444, 1, 'SOLVED', 10, 36, 5, 'Peripheral Issue', '2009-06-24 11:18:38', 4, null, '2009-07-07 16:27:01', 'STAFF', '758BE1F9F7'), (3445, 2, 'SOLVED', 3, 31, 5, 'Peripheral Doubt', '2009-06-24 11:12:08', 4, null, '2009-07-01 15:04:06', 'STAFF', '09BA3F0DF1'), (3446, 1, 'CLOSED', 9, 25, 4, 'WEB Mail Doubt', '2009-06-24 07:47:15', 3, null, '2009-07-02 14:18:52', 'STAFF', '5B4A214624'), (3447, 1, 'SOLVED', 10, 3, 3, 'Sales Doubt', '2009-06-24 08:08:25', 3, null, '2009-06-29 17:14:04', 'STAFF', '2E1B24A664'), (3448, 2, 'SOLVED', 4, 10, 6, 'Software Doubt', '2009-06-26 06:28:44', 3, null, '2009-07-05 17:21:48', 'STAFF', 'C5BBD980E5'), (3449, 2, 'REPLIED', 9, 8, 1, 'CRM Application Doubt', '2009-06-27 06:21:46', 0, null, '2009-07-05 14:14:33', 'STAFF', '86A1793F65'), (3450, 1, 'SOLVED', 10, 36, 1, 'CRM Application Doubt', '2009-06-27 08:09:04', 3, null, '2009-07-02 18:58:50', 'STAFF', '703957B6DD'), (3451, 2, 'SOLVED', 6, 5, 2, 'WEB Site Doubt', '2009-06-27 12:41:04', 4, null, '2009-07-05 13:20:46', 'STAFF', 'DE7F47E09C'), (3452, 1, 'CLOSED', 1, 23, 2, 'WEB Site Issue', '2009-06-27 07:09:15', 2, null, '2009-07-10 17:06:15', 'STAFF', '66121D1F78'), (3453, 2, 'SOLVED', 10, 35, 2, 'WEB Site Issue', '2009-06-27 10:31:55', 4, null, '2009-07-08 13:38:25', 'STAFF', 'F356355C16'), (3454, 2, 'SOLVED', 6, 28, 1, 'CRM Application Doubt', '2009-06-27 12:47:40', 4, null, '2009-07-08 17:12:07', 'STAFF', '5ABDF8B852'), (3455, 2, 'CLOSED', 1, 38, 6, 'Software Doubt', '2009-06-27 12:59:20', 1, null, '2009-07-11 14:23:01', 'STAFF', '473447AC58'), (3456, 1, 'CLOSED', 5, 19, 6, 'Software Doubt', '2009-06-27 12:37:48', 3, null, '2009-07-18 16:49:28', 'STAFF', 'DEF7924E31'), (3457, 2, 'SOLVED', 6, 35, 6, 'Software Doubt', '2009-06-27 06:57:07', 4, null, '2009-07-12 13:05:04', 'STAFF', 'E1FC9C082D'), (3458, 3, 'SOLVED', 10, 32, 6, 'Sotfware Issue', '2009-06-28 08:05:05', 3, null, '2009-07-16 15:25:22', 'STAFF', 'E3EA33961A'), (3459, 3, 'SOLVED', 9, 10, 5, 'Peripheral Issue', '2009-06-28 08:57:33', 3, null, '2009-07-10 14:07:02', 'STAFF', '13D63838EF'), (3460, 3, 'SOLVED', 1, 1, 1, 'CRM Application Issue', '2009-06-28 12:52:57', 3, null, '2009-07-06 16:41:44', 'STAFF', '56503192B1'), (3461, 2, 'SOLVED', 3, 39, 4, 'WEB Mail Doubt', '2009-06-28 10:44:34', 2, null, '2009-07-12 16:40:19', 'STAFF', '7E8D7E5CCB'), (3462, 3, 'SOLVED', 6, 7, 4, 'WEB Mail Doubt', '2009-06-28 06:22:57', 2, null, '2009-07-01 18:16:38', 'STAFF', '9EDDA0FD4D'), (3463, 2, 'SOLVED', 2, 31, 6, 'Software Issue', '2009-06-28 11:41:59', 4, null, '2009-07-14 18:27:33', 'STAFF', '73C0318676'), (3464, 2, 'UNASSIGNED', 10, 9, 6, 'Software Doubt', '2009-06-28 10:07:09', 0, null, '2009-06-28 10:07:09', 'CUSTOMER', '51E6D6E679'), (3465, 2, 'SOLVED', 5, 35, 2, 'WEB Site Issue', '2009-06-28 08:29:33', 2, null, '2009-07-02 16:52:39', 'STAFF', '797134C3E4'), (3466, 1, 'SOLVED', 7, 5, 2, 'WEB Site Issue', '2009-06-28 08:09:21', 2, null, '2009-07-02 14:59:30', 'STAFF', '606555CF42'), (3467, 2, 'CLOSED', 3, 4, 5, 'Peripheral Issue', '2009-06-28 11:18:26', 2, null, '2009-07-13 16:50:59', 'STAFF', '2A27179561'), (3468, 2, 'SOLVED', 3, 35, 1, 'CRM Application Issue', '2009-06-28 07:40:33', 4, null, '2009-07-06 13:18:19', 'STAFF', '322F62469C'), (3469, 1, 'SOLVED', 7, 37, 6, 'Software Doubt', '2009-06-28 11:24:05', 3, null, '2009-07-07 14:19:13', 'STAFF', 'CA851E9F71'), (3470, 2, 'CLOSED', 7, 7, 4, 'WEB Mail Doubt', '2009-06-29 06:46:42', 2, null, '2009-07-05 17:57:27', 'STAFF', '73FED7FD47'), (3471, 2, 'RETURNED', 7, 30, 6, 'Software Doubt', '2009-06-29 07:07:48', 0, null, '2009-06-29 07:07:48', 'CUSTOMER', '735143E9FF'), (3472, 2, 'CLOSED', 3, 32, 4, 'WEB Mail Doubt', '2009-06-29 07:59:31', 2, null, '2009-07-04 18:23:03', 'STAFF', '2974788B53'), (3473, 2, 'SOLVED', 10, 26, 2, 'WEB Site Issue', '2009-06-29 11:25:40', 4, null, '2009-06-29 15:44:26', 'STAFF', '99BE9F8374'), (3474, 2, 'SOLVED', 2, 34, 4, 'WEB Mail Doubt', '2009-06-29 10:18:51', 3, null, '2009-07-12 17:53:07', 'STAFF', 'E91068FFF3'), (3475, 2, 'SOLVED', 1, 22, 6, 'Software Issue', '2009-06-29 09:41:11', 4, null, '2009-06-30 18:38:04', 'STAFF', 'D38EE19A48'), (3476, 2, 'SOLVED', 9, 32, 2, 'WEB Site Issue', '2009-06-29 08:58:19', 4, null, '2009-07-04 17:46:12', 'STAFF', 'DDCBE25988'), (3477, 3, 'SOLVED', 6, 35, 2, 'WEB Site Issue', '2009-06-29 06:22:49', 4, null, '2009-07-06 14:46:45', 'STAFF', '6D6968D87C'), (3478, 2, 'CLOSED', 5, 18, 6, 'Software Doubt', '2009-06-29 12:16:29', 3, null, '2009-07-15 13:05:03', 'STAFF', 'B071CFA816'), (3479, 2, 'CLOSED', 5, 1, 2, 'WEB Site Issue', '2009-06-29 07:25:37', 1, null, '2009-06-30 15:31:06', 'STAFF', '6950AA02AE'), (3480, 2, 'SOLVED', 7, 39, 6, 'Software Issue', '2009-06-29 09:28:55', 4, null, '2009-07-01 18:54:49', 'STAFF', 'E8E0DD181E'), (3481, 2, 'SOLVED', 4, 34, 4, 'WEB Mail Doubt', '2009-06-30 10:23:44', 2, null, '2009-07-13 18:51:22', 'STAFF', '3FB04953D9'), (3482, 2, 'SOLVED', 5, 1, 5, 'Peripheral Doubt', '2009-06-30 07:46:27', 2, null, '2009-07-03 16:28:48', 'STAFF', 'B7FEDE84C2'), (3483, 1, 'SOLVED', 1, 11, 1, 'CRM Application Doubt', '2009-06-30 10:36:21', 4, null, '2009-07-01 15:41:48', 'STAFF', 'CB953F6CA5'), (3484, 3, 'CLOSED', 2, 11, 5, 'Peripheral Issue', '2009-06-30 08:38:40', 2, null, '2009-07-09 17:05:19', 'STAFF', '966B6DFB6B'), (3485, 2, 'CLOSED', 10, 2, 5, 'Peripheral Doubt', '2009-06-30 12:38:57', 2, null, '2009-07-08 17:39:30', 'STAFF', 'DFEB9598FB'), (3486, 2, 'RETURNED', 1, 17, 5, 'Peripheral Issue', '2009-06-30 12:19:33', 0, null, '2009-07-10 10:05:45', 'CUSTOMER', 'AB4F2B5FD9'), (3487, 2, 'SOLVED', 6, 23, 6, 'Software Issue', '2009-06-30 09:21:15', 4, null, '2009-07-05 14:04:14', 'STAFF', '944A5AE348'), (3488, 2, 'SOLVED', 10, 26, 1, 'CRM Application Issue', '2009-06-30 12:23:46', 2, null, '2009-07-03 18:37:03', 'STAFF', 'C7B90B0FC2'), (3489, 3, 'SOLVED', 10, 11, 6, 'Sotfware Issue', '2009-06-30 11:05:13', 4, null, '2009-07-20 13:56:29', 'STAFF', '1B318124E3'), (3490, 3, 'SOLVED', 9, 39, 2, 'WEB Site Issue', '2009-06-30 07:22:20', 4, null, '2009-06-30 18:32:47', 'STAFF', '72F67E70F6'), (3491, 2, 'SOLVED', 5, 9, 4, 'WEB Mail Doubt', '2009-06-30 06:18:26', 3, null, '2009-07-05 15:34:42', 'STAFF', '6C91724B89'), (3492, 2, 'SOLVED', 9, 23, 4, 'WEB Mail Doubt', '2009-07-01 08:23:46', 2, null, '2009-07-17 14:48:29', 'STAFF', '0060EF47B1'), (3493, 1, 'SOLVED', 8, 22, 4, 'WEB Mail Issue', '2009-07-01 06:09:36', 4, null, '2009-07-09 15:16:07', 'STAFF', 'BA036D2288'), (3494, 3, 'SOLVED', 1, 21, 6, 'Software Issue', '2009-07-01 10:16:17', 3, null, '2009-07-11 14:29:24', 'STAFF', '6DBD2699E8'), (3495, 2, 'SOLVED', 2, 37, 2, 'WEB Site Issue', '2009-07-01 11:06:59', 3, null, '2009-07-08 14:37:54', 'STAFF', '8485AE387A'), (3496, 2, 'SOLVED', 2, 12, 6, 'Software Doubt', '2009-07-01 10:16:50', 2, null, '2009-07-04 14:07:09', 'STAFF', '0A348EDE8A'), (3497, 2, 'SOLVED', 1, 10, 6, 'Software Issue', '2009-07-01 08:32:38', 4, null, '2009-07-04 15:32:53', 'STAFF', '7535BBB91C'), (3498, 1, 'SOLVED', 7, 26, 2, 'WEB Site Issue', '2009-07-01 12:38:12', 3, null, '2009-07-11 13:30:25', 'STAFF', 'FD9DCF1D14'), (3499, 3, 'RETURNED', 8, 39, 5, 'Peripheral Doubt', '2009-07-01 12:25:54', 0, null, '2009-07-15 09:29:40', 'CUSTOMER', '3EA2DB50E6'), (3500, 2, 'RETURNED', 9, 40, 3, 'Sales Issue', '2009-07-01 06:23:11', 0, null, '2009-07-09 06:18:26', 'CUSTOMER', 'E2065CB56F'), (3501, 2, 'SOLVED', 1, 25, 1, 'CRM Application Issue', '2009-07-01 12:17:25', 3, null, '2009-07-11 14:26:20', 'STAFF', 'D494020FF8'), (3502, 2, 'SOLVED', 10, 21, 1, 'CRM Application Issue', '2009-07-03 08:29:53', 3, null, '2009-07-21 17:15:51', 'STAFF', 'D2350A54D7'), (3503, 2, 'CLOSED', 5, 31, 4, 'WEB Mail Issue', '2009-07-04 07:21:06', 3, null, '2009-07-19 14:11:20', 'STAFF', '87F7EE4FDB'), (3504, 1, 'CLOSED', 10, 38, 6, 'Software Doubt', '2009-07-04 12:45:44', 2, null, '2009-07-08 17:16:19', 'STAFF', '73231E53EE'), (3505, 2, 'SOLVED', 10, 1, 6, 'Sotfware Issue', '2009-07-04 09:23:39', 4, null, '2009-07-15 13:22:17', 'STAFF', '2A3D6D6CC4'), (3506, 3, 'SOLVED', 9, 23, 3, 'Sales Doubt', '2009-07-04 07:47:30', 2, null, '2009-07-09 16:39:04', 'STAFF', 'E0126439E0'), (3507, 2, 'SOLVED', 3, 33, 4, 'WEB Mail Doubt', '2009-07-04 12:40:47', 3, null, '2009-07-09 18:13:18', 'STAFF', '0E7C7D6C41'), (3508, 2, 'UNASSIGNED', 10, 23, 4, 'WEB Mail Doubt', '2009-07-04 10:43:01', 0, null, '2009-07-04 10:43:01', 'CUSTOMER', '7D2BE41B1B'), (3509, 2, 'SOLVED', 5, 37, 6, 'Software Issue', '2009-07-04 08:30:26', 3, null, '2009-07-15 15:47:10', 'STAFF', '0141A8AEDB'), (3510, 2, 'SOLVED', 8, 35, 4, 'WEB Mail Doubt', '2009-07-04 08:19:01', 4, null, '2009-07-16 17:27:08', 'STAFF', '15E122E839'), (3511, 3, 'CLOSED', 1, 34, 4, 'WEB Mail Doubt', '2009-07-04 10:53:27', 3, null, '2009-07-11 13:52:26', 'STAFF', '9A85C12A21'), (3512, 1, 'UNASSIGNED', 1, 7, 6, 'Software Issue', '2009-07-04 10:20:58', 0, null, '2009-07-04 10:20:58', 'CUSTOMER', '0DBB3FB9A5'), (3513, 2, 'SOLVED', 10, 21, 4, 'WEB Mail Doubt', '2009-07-04 06:59:03', 4, null, '2009-07-05 16:15:20', 'STAFF', '0FFACA95E3'), (3514, 2, 'RETURNED', 9, 11, 3, 'Sales Issue', '2009-07-05 10:58:58', 0, null, '2009-07-12 07:40:44', 'CUSTOMER', '7288251B27'), (3515, 2, 'SOLVED', 5, 33, 4, 'WEB Mail Doubt', '2009-07-05 11:39:38', 4, null, '2009-07-10 16:13:56', 'STAFF', '5FEF3EFF51'), (3516, 2, 'SOLVED', 3, 9, 2, 'WEB Site Issue', '2009-07-05 08:48:59', 2, null, '2009-07-05 16:19:49', 'STAFF', 'CF1CF43CBA'), (3517, 2, 'SOLVED', 10, 11, 3, 'Sales Doubt', '2009-07-05 11:49:33', 3, null, '2009-07-08 16:58:20', 'STAFF', 'B5B0DB7F3A'), (3518, 2, 'SOLVED', 1, 8, 1, 'CRM Application Doubt', '2009-07-05 10:45:23', 4, null, '2009-07-10 14:33:10', 'STAFF', '5401ACFE63'), (3519, 3, 'SOLVED', 5, 32, 6, 'Sotfware Issue', '2009-07-05 10:01:32', 3, null, '2009-07-22 16:21:39', 'STAFF', '1FD7B875D3'), (3520, 3, 'SOLVED', 4, 1, 1, 'CRM Application Issue', '2009-07-05 07:53:30', 2, null, '2009-07-13 14:06:43', 'STAFF', '6C0958D82A'), (3521, 3, 'SOLVED', 9, 36, 1, 'CRM Application Doubt', '2009-07-06 09:31:18', 4, null, '2009-07-10 17:04:19', 'STAFF', '98AFDCC1EB'), (3522, 2, 'RETURNED', 2, 39, 5, 'Peripheral Doubt', '2009-07-06 12:48:12', 0, null, '2009-07-15 10:29:01', 'CUSTOMER', 'EE14C41E92'), (3523, 3, 'UNASSIGNED', 1, 31, 6, 'Software Doubt', '2009-07-06 12:35:54', 0, null, '2009-07-06 12:35:54', 'CUSTOMER', '939314105C'), (3524, 2, 'SOLVED', 8, 5, 5, 'Peripheral Doubt', '2009-07-06 12:01:14', 4, null, '2009-07-19 14:17:13', 'STAFF', 'A9DE093D06'), (3525, 1, 'CLOSED', 1, 1, 5, 'Peripheral Issue', '2009-07-06 12:57:21', 1, null, '2009-07-08 18:33:02', 'STAFF', 'DA9E6A4A4A'), (3526, 1, 'SOLVED', 9, 23, 3, 'Sales Doubt', '2009-07-06 12:45:11', 3, null, '2009-07-12 14:56:27', 'STAFF', '0E4F5CC9F4'), (3527, 2, 'SOLVED', 9, 35, 6, 'Software Doubt', '2009-07-06 12:17:05', 2, null, '2009-07-18 18:50:39', 'STAFF', 'B874707824'), (3528, 2, 'SOLVED', 2, 18, 3, 'Sales Doubt', '2009-07-06 06:33:41', 2, null, '2009-07-11 14:11:45', 'STAFF', 'EAD81FE8CF'), (3529, 2, 'RETURNED', 9, 21, 4, 'WEB Mail Doubt', '2009-07-06 08:59:04', 0, null, '2009-07-14 08:21:20', 'CUSTOMER', '9BDB8B1FAF'), (3530, 2, 'SOLVED', 1, 29, 2, 'WEB Site Issue', '2009-07-06 06:27:17', 3, null, '2009-07-19 15:15:16', 'STAFF', '30A0B73609'), (3531, 1, 'SOLVED', 1, 34, 5, 'Peripheral Doubt', '2009-07-06 11:52:40', 3, null, '2009-07-20 16:31:54', 'STAFF', 'E52AD5C9F7'), (3532, 2, 'SOLVED', 4, 22, 5, 'Peripheral Doubt', '2009-07-06 07:48:58', 2, null, '2009-07-09 17:13:47', 'STAFF', 'AFAB3E9707'), (3533, 2, 'SOLVED', 9, 22, 4, 'WEB Mail Doubt', '2009-07-06 07:13:16', 2, null, '2009-07-10 18:47:41', 'STAFF', '5A9D8BF5B7'), (3534, 1, 'SOLVED', 5, 22, 4, 'WEB Mail Doubt', '2009-07-06 07:14:52', 2, null, '2009-07-07 17:10:37', 'STAFF', 'AA97D58486'), (3535, 1, 'SOLVED', 3, 11, 5, 'Peripheral Doubt', '2009-07-06 12:59:37', 2, null, '2009-07-08 14:58:04', 'STAFF', 'B99D193B66'), (3536, 1, 'SOLVED', 2, 26, 3, 'Sales Doubt', '2009-07-06 07:31:22', 4, null, '2009-07-07 17:24:10', 'STAFF', '291D43C696'), (3537, 2, 'CLOSED', 10, 25, 6, 'Sotfware Issue', '2009-07-07 06:56:21', 1, null, '2009-07-16 15:45:38', 'STAFF', '416849DA96'), (3538, 2, 'SOLVED', 2, 29, 6, 'Software Issue', '2009-07-07 07:12:56', 4, null, '2009-07-20 16:42:14', 'STAFF', '1458E7509A'), (3539, 2, 'SOLVED', 5, 15, 6, 'Software Issue', '2009-07-07 11:09:43', 2, null, '2009-07-11 15:41:10', 'STAFF', '142C65E00F'), (3540, 1, 'SOLVED', 2, 2, 6, 'Software Issue', '2009-07-07 12:46:01', 3, null, '2009-07-18 16:47:43', 'STAFF', '8844C5F003'), (3541, 2, 'SOLVED', 10, 26, 6, 'Sotfware Issue', '2009-07-07 09:11:20', 3, null, '2009-07-14 14:33:19', 'STAFF', 'C5F5C23BE1'), (3542, 2, 'SOLVED', 1, 5, 1, 'CRM Application Issue', '2009-07-07 07:40:48', 4, null, '2009-07-11 16:19:19', 'STAFF', '8487E01FBA'), (3543, 2, 'SOLVED', 10, 22, 5, 'Peripheral Issue', '2009-07-07 11:50:26', 3, null, '2009-07-08 13:19:26', 'STAFF', '196F5641AA'), (3544, 2, 'SOLVED', 7, 32, 6, 'Software Issue', '2009-07-07 12:10:39', 2, null, '2009-07-16 16:26:45', 'STAFF', '147EBE6370'), (3545, 1, 'SOLVED', 4, 6, 5, 'Peripheral Doubt', '2009-07-07 11:14:26', 3, null, '2009-07-14 15:37:54', 'STAFF', '06EE4C5C93'), (3546, 3, 'SOLVED', 9, 15, 6, 'Software Issue', '2009-07-07 10:31:53', 3, null, '2009-07-23 13:20:44', 'STAFF', 'A8166DA05C'), (3547, 3, 'CLOSED', 10, 37, 5, 'Peripheral Issue', '2009-07-07 06:44:23', 3, null, '2009-07-08 13:54:14', 'STAFF', 'E6BA70FC09'), (3548, 1, 'SOLVED', 10, 23, 6, 'Software Issue', '2009-07-08 12:30:04', 3, null, '2009-07-12 15:03:16', 'STAFF', '50CF0763D8'), (3549, 3, 'SOLVED', 3, 10, 5, 'Peripheral Doubt', '2009-07-08 10:36:50', 3, null, '2009-07-17 16:02:35', 'STAFF', 'DB98DC0DBA'), (3550, 2, 'SOLVED', 1, 6, 4, 'WEB Mail Doubt', '2009-07-08 06:39:46', 4, null, '2009-07-17 13:47:14', 'STAFF', '018DD1E07A'), (3551, 2, 'CLOSED', 5, 20, 6, 'Software Doubt', '2009-07-08 08:24:15', 3, null, '2009-07-28 14:19:28', 'STAFF', 'ABDEB6F575'), (3552, 2, 'SOLVED', 1, 39, 3, 'Sales Doubt', '2009-07-08 10:04:01', 3, null, '2009-07-08 15:38:43', 'STAFF', '7C220A2091'), (3553, 1, 'SOLVED', 1, 1, 1, 'CRM Application Doubt', '2009-07-08 10:55:48', 4, null, '2009-07-14 17:40:38', 'STAFF', 'E250C59336'), (3554, 2, 'UNASSIGNED', 10, 33, 1, 'CRM Application Doubt', '2009-07-08 09:01:49', 0, null, '2009-07-08 09:01:49', 'CUSTOMER', '69B09198D4'), (3555, 2, 'SOLVED', 1, 19, 6, 'Software Issue', '2009-07-08 08:10:40', 3, null, '2009-07-17 14:55:29', 'STAFF', '22B1CD168E'), (3556, 1, 'SOLVED', 10, 38, 4, 'WEB Mail Issue', '2009-07-08 08:25:41', 4, null, '2009-07-22 13:32:31', 'STAFF', '656F0DBF93'), (3557, 3, 'RETURNED', 7, 10, 5, 'Peripheral Doubt', '2009-07-08 12:48:15', 0, null, '2009-07-16 09:28:55', 'CUSTOMER', '51DA85A3C3'), (3558, 3, 'SOLVED', 5, 1, 4, 'WEB Mail Doubt', '2009-07-09 08:37:33', 3, null, '2009-07-21 14:14:21', 'STAFF', '285A25C17F'), (3559, 1, 'UNASSIGNED', 9, 8, 4, 'WEB Mail Doubt', '2009-07-09 09:12:24', 0, null, '2009-07-09 09:12:24', 'CUSTOMER', 'F11BEC1411'), (3560, 2, 'SOLVED', 10, 9, 4, 'WEB Mail Doubt', '2009-07-09 09:12:25', 2, null, '2009-07-23 17:16:26', 'STAFF', '0AE1DD3954'), (3561, 3, 'SOLVED', 1, 7, 3, 'Sales Issue', '2009-07-10 11:58:14', 4, null, '2009-07-26 14:44:33', 'STAFF', '414A749719'), (3562, 2, 'SOLVED', 9, 27, 4, 'WEB Mail Issue', '2009-07-10 09:57:07', 2, null, '2009-07-20 15:11:59', 'STAFF', 'EBF12CB74E'), (3563, 2, 'SOLVED', 7, 33, 5, 'Peripheral Issue', '2009-07-11 11:27:03', 4, null, '2009-07-19 13:26:17', 'STAFF', 'D04D42CDF1'), (3564, 2, 'SOLVED', 8, 26, 4, 'WEB Mail Doubt', '2009-07-11 09:05:54', 3, null, '2009-07-13 13:44:25', 'STAFF', '05EDF455CB'), (3565, 2, 'REPLIED', 5, 12, 1, 'CRM Application Doubt', '2009-07-11 06:50:42', 0, null, '2009-07-23 16:53:21', 'STAFF', 'E6E7132966'), (3566, 1, 'SOLVED', 10, 32, 1, 'CRM Application Issue', '2009-07-11 12:22:37', 2, null, '2009-07-20 15:03:57', 'STAFF', '6346DC7233'), (3567, 2, 'SOLVED', 6, 28, 1, 'CRM Application Doubt', '2009-07-11 10:19:38', 4, null, '2009-07-16 13:31:40', 'STAFF', 'DCCAB9BD9E'), (3568, 2, 'SOLVED', 6, 1, 2, 'WEB Site Issue', '2009-07-11 06:52:31', 4, null, '2009-07-15 17:26:42', 'STAFF', '5481B2F34A'), (3569, 2, 'CLOSED', 10, 31, 1, 'CRM Application Issue', '2009-07-11 12:18:47', 2, null, '2009-07-23 14:19:27', 'STAFF', '77C493EC14'), (3570, 2, 'CLOSED', 1, 31, 6, 'Software Issue', '2009-07-11 06:39:19', 1, null, '2009-07-17 14:27:22', 'STAFF', '43B5284266'), (3571, 2, 'SOLVED', 3, 34, 2, 'WEB Site Issue', '2009-07-11 07:54:37', 2, null, '2009-07-19 16:48:38', 'STAFF', 'F8F5161CF9'), (3572, 2, 'SOLVED', 5, 29, 5, 'Peripheral Doubt', '2009-07-12 09:50:48', 2, null, '2009-07-13 14:08:32', 'STAFF', '842424A1D0'), (3573, 1, 'CLOSED', 1, 35, 1, 'CRM Application Issue', '2009-07-12 09:18:05', 1, null, '2009-08-02 13:33:53', 'STAFF', '8BACA01B73'), (3574, 3, 'CLOSED', 10, 31, 6, 'Software Doubt', '2009-07-12 08:26:47', 1, null, '2009-07-27 16:40:46', 'STAFF', '1B9F38268C'), (3575, 2, 'SOLVED', 4, 36, 2, 'WEB Site Issue', '2009-07-12 09:09:27', 2, null, '2009-07-23 15:34:42', 'STAFF', 'C9F06BC7B4'), (3576, 2, 'SOLVED', 5, 12, 2, 'WEB Site Issue', '2009-07-12 07:52:57', 4, null, '2009-07-24 15:24:46', 'STAFF', '3F647CADF5'), (3577, 2, 'SOLVED', 10, 37, 1, 'CRM Application Doubt', '2009-07-12 09:08:41', 3, null, '2009-07-20 17:49:11', 'STAFF', '3E77A14629'), (3578, 2, 'SOLVED', 9, 21, 1, 'CRM Application Issue', '2009-07-12 07:19:42', 4, null, '2009-07-13 17:35:46', 'STAFF', '252A3DBAEB'), (3579, 2, 'CLOSED', 10, 30, 5, 'Peripheral Issue', '2009-07-12 12:10:16', 3, null, '2009-07-28 18:11:45', 'STAFF', '0D441DE759'), (3580, 2, 'CLOSED', 6, 35, 5, 'Peripheral Doubt', '2009-07-13 06:45:46', 1, null, '2009-07-30 18:36:17', 'STAFF', '630B7D8DD4'), (3581, 3, 'SOLVED', 5, 40, 5, 'Peripheral Doubt', '2009-07-13 07:35:53', 4, null, '2009-07-28 16:56:20', 'STAFF', '67606D48E3'), (3582, 1, 'CLOSED', 9, 15, 1, 'CRM Application Doubt', '2009-07-13 12:01:31', 2, null, '2009-07-27 18:37:19', 'STAFF', '9D684C589D'), (3583, 3, 'SOLVED', 10, 24, 5, 'Peripheral Issue', '2009-07-13 11:43:10', 4, null, '2009-07-15 16:52:59', 'STAFF', '69EBA34671'), (3584, 2, 'RETURNED', 10, 37, 4, 'WEB Mail Issue', '2009-07-13 09:19:08', 0, null, '2009-07-18 09:59:17', 'CUSTOMER', '565767EB96'), (3585, 2, 'REPLIED', 1, 19, 1, 'CRM Application Doubt', '2009-07-13 08:11:56', 0, null, '2009-07-28 16:57:06', 'STAFF', '2668A71059'), (3586, 1, 'CLOSED', 2, 1, 3, 'Sales Doubt', '2009-07-13 08:34:27', 1, null, '2009-07-15 16:14:25', 'STAFF', '224E5E4981'), (3587, 2, 'SOLVED', 10, 18, 5, 'Peripheral Doubt', '2009-07-13 12:22:25', 4, null, '2009-07-28 14:37:28', 'STAFF', 'ABA53DA2F6'), (3588, 2, 'SOLVED', 6, 25, 6, 'Software Doubt', '2009-07-13 11:39:11', 2, null, '2009-07-14 16:17:45', 'STAFF', 'C2964CAAC0'), (3589, 2, 'SOLVED', 9, 33, 1, 'CRM Application Issue', '2009-07-13 12:00:08', 2, null, '2009-07-16 14:46:35', 'STAFF', 'A385D7D1E5'), (3590, 2, 'SOLVED', 10, 27, 6, 'Sotfware Issue', '2009-07-13 06:54:31', 3, null, '2009-07-16 16:17:39', 'STAFF', 'DA6EA77475'), (3591, 3, 'CLOSED', 9, 6, 5, 'Peripheral Doubt', '2009-07-14 06:13:00', 2, null, '2009-07-19 18:34:19', 'STAFF', '9001CA4292'), (3592, 3, 'REPLIED', 10, 22, 4, 'WEB Mail Doubt', '2009-07-14 09:17:51', 0, null, '2009-07-15 17:01:11', 'STAFF', '69F357FCC8'), (3593, 1, 'SOLVED', 7, 36, 4, 'WEB Mail Doubt', '2009-07-14 08:00:52', 2, null, '2009-07-18 14:56:40', 'STAFF', 'CDD0500DC0'), (3594, 1, 'SOLVED', 1, 9, 6, 'Sotfware Issue', '2009-07-14 10:46:10', 2, null, '2009-08-04 15:58:27', 'STAFF', 'DCE8AF15F0'), (3595, 2, 'SOLVED', 4, 17, 4, 'WEB Mail Doubt', '2009-07-14 08:28:06', 3, null, '2009-07-22 16:25:05', 'STAFF', 'C0E8517B1F'), (3596, 1, 'SOLVED', 3, 19, 6, 'Sotfware Issue', '2009-07-14 09:22:01', 4, null, '2009-07-21 13:06:31', 'STAFF', '52C409F157');
INSERT INTO "ticket" VALUES (3597, 2, 'SOLVED', 3, 30, 4, 'WEB Mail Doubt', '2009-07-14 08:29:31', 2, null, '2009-07-24 17:18:55', 'STAFF', 'B89C30965E'), (3598, 2, 'SOLVED', 9, 25, 1, 'CRM Application Doubt', '2009-07-15 10:47:37', 3, null, '2009-07-17 15:23:34', 'STAFF', '6A450490F2'), (3599, 2, 'SOLVED', 3, 36, 1, 'CRM Application Issue', '2009-07-15 08:39:13', 3, null, '2009-07-24 16:31:36', 'STAFF', 'E7E69CDF28'), (3600, 2, 'SOLVED', 4, 12, 1, 'CRM Application Issue', '2009-07-15 12:55:20', 4, null, '2009-07-24 13:53:31', 'STAFF', '8D7628DD7A'), (3601, 1, 'SOLVED', 2, 35, 5, 'Peripheral Issue', '2009-07-15 06:18:40', 4, null, '2009-07-16 18:40:22', 'STAFF', '62E7F2E090'), (3602, 3, 'SOLVED', 10, 37, 1, 'CRM Application Doubt', '2009-07-15 06:13:43', 4, null, '2009-07-19 18:54:09', 'STAFF', '228B255874'), (3603, 2, 'CLOSED', 5, 1, 6, 'Sotfware Issue', '2009-07-15 11:05:08', 3, null, '2009-07-17 17:35:02', 'STAFF', '6A8018B3A0'), (3604, 3, 'SOLVED', 10, 35, 4, 'WEB Mail Issue', '2009-07-15 06:14:10', 3, null, '2009-07-16 16:56:40', 'STAFF', 'C254E77530'), (3605, 3, 'RETURNED', 4, 27, 2, 'WEB Site Doubt', '2009-07-15 07:25:34', 0, null, '2009-07-15 07:25:34', 'CUSTOMER', 'A05D886123'), (3606, 3, 'SOLVED', 9, 19, 1, 'CRM Application Doubt', '2009-07-15 08:09:40', 4, null, '2009-07-24 13:16:22', 'STAFF', '774B0E0775'), (3607, 1, 'RETURNED', 5, 6, 1, 'CRM Application Issue', '2009-07-16 09:45:16', 0, null, '2009-07-16 09:45:16', 'CUSTOMER', '967990DE5B'), (3608, 2, 'REPLIED', 5, 5, 5, 'Peripheral Issue', '2009-07-16 12:52:47', 0, null, '2009-07-26 15:12:30', 'STAFF', '60A0575EE6'), (3609, 2, 'CLOSED', 7, 15, 6, 'Software Doubt', '2009-07-16 12:32:16', 2, null, '2009-07-20 17:50:02', 'STAFF', '649A066D41'), (3610, 1, 'SOLVED', 10, 34, 1, 'CRM Application Doubt', '2009-07-16 06:15:38', 4, null, '2009-08-01 18:59:01', 'STAFF', 'F95EC3DE39'), (3611, 2, 'CLOSED', 9, 33, 5, 'Peripheral Issue', '2009-07-18 09:33:40', 2, null, '2009-07-29 14:52:12', 'STAFF', '4CF33E18ED'), (3612, 3, 'REPLIED', 7, 20, 6, 'Software Issue', '2009-07-18 07:21:33', 0, null, '2009-07-21 16:16:18', 'STAFF', 'D87CA511E2'), (3613, 2, 'SOLVED', 2, 9, 5, 'Peripheral Doubt', '2009-07-18 11:35:00', 2, null, '2009-07-20 17:50:24', 'STAFF', 'C4FA7AECED'), (3614, 3, 'SOLVED', 1, 30, 4, 'WEB Mail Issue', '2009-07-18 11:17:59', 2, null, '2009-07-27 13:16:25', 'STAFF', '6ADD07CF50'), (3615, 2, 'SOLVED', 5, 34, 1, 'CRM Application Issue', '2009-07-18 10:49:41', 4, null, '2009-08-01 13:35:33', 'STAFF', 'D8C9D05EC6'), (3616, 2, 'SOLVED', 10, 7, 5, 'Peripheral Issue', '2009-07-18 06:59:12', 3, null, '2009-08-01 17:56:00', 'STAFF', '78D69F4090'), (3617, 2, 'SOLVED', 6, 33, 6, 'Software Issue', '2009-07-18 06:29:19', 3, null, '2009-07-26 14:17:21', 'STAFF', 'DB68512896'), (3618, 2, 'SOLVED', 1, 9, 3, 'Sales Doubt', '2009-07-18 06:00:21', 3, null, '2009-07-26 17:22:38', 'STAFF', '4DA9D7B6D1'), (3619, 2, 'SOLVED', 5, 35, 3, 'Sales Doubt', '2009-07-18 06:17:57', 3, null, '2009-07-22 18:19:13', 'STAFF', '820E694038'), (3620, 2, 'SOLVED', 8, 22, 5, 'Peripheral Issue', '2009-07-18 06:02:33', 3, null, '2009-07-29 17:54:52', 'STAFF', '4BAF54F369'), (3621, 2, 'SOLVED', 3, 21, 2, 'WEB Site Issue', '2009-07-18 11:27:45', 4, null, '2009-07-18 15:04:12', 'STAFF', 'C5B270A763'), (3622, 3, 'CLOSED', 10, 12, 6, 'Software Issue', '2009-07-18 07:45:36', 2, null, '2009-07-19 13:39:41', 'STAFF', '856B503E27'), (3623, 1, 'SOLVED', 9, 25, 2, 'WEB Site Doubt', '2009-07-19 07:47:59', 4, null, '2009-07-23 14:30:35', 'STAFF', 'ECDCD675B3'), (3624, 2, 'RETURNED', 1, 23, 4, 'WEB Mail Doubt', '2009-07-19 10:04:05', 0, null, '2009-08-01 08:04:48', 'CUSTOMER', '5EE0070C40'), (3625, 2, 'SOLVED', 3, 12, 1, 'CRM Application Doubt', '2009-07-19 09:05:31', 3, null, '2009-07-28 17:47:25', 'STAFF', 'DD7970532B'), (3626, 1, 'SOLVED', 5, 12, 4, 'WEB Mail Doubt', '2009-07-19 10:05:02', 4, null, '2009-07-24 15:28:18', 'STAFF', '0EE8B85A85'), (3627, 2, 'SOLVED', 7, 30, 5, 'Peripheral Issue', '2009-07-19 12:00:15', 3, null, '2009-08-01 13:41:29', 'STAFF', '2BF283C05B'), (3628, 2, 'RETURNED', 9, 31, 6, 'Software Issue', '2009-07-19 10:35:24', 0, null, '2009-08-02 10:16:47', 'CUSTOMER', '3E524BF740'), (3629, 1, 'RETURNED', 10, 10, 4, 'WEB Mail Doubt', '2009-07-20 11:40:35', 0, null, '2009-07-28 11:10:03', 'CUSTOMER', '1305F6C705'), (3630, 2, 'SOLVED', 4, 34, 6, 'Software Issue', '2009-07-20 11:51:57', 3, null, '2009-07-22 17:56:52', 'STAFF', '1A551829D5'), (3631, 2, 'SOLVED', 7, 37, 4, 'WEB Mail Doubt', '2009-07-20 10:56:28', 4, null, '2009-07-31 15:00:27', 'STAFF', 'FD4C2DC64C'), (3632, 1, 'SOLVED', 7, 30, 6, 'Software Doubt', '2009-07-20 07:37:20', 3, null, '2009-07-20 13:27:55', 'STAFF', '398475C83B'), (3633, 2, 'CLOSED', 7, 13, 4, 'WEB Mail Doubt', '2009-07-20 07:00:47', 3, null, '2009-07-23 13:57:06', 'STAFF', 'ACF9221546'), (3634, 3, 'CLOSED', 1, 3, 1, 'CRM Application Doubt', '2009-07-20 12:29:38', 3, null, '2009-07-25 18:04:19', 'STAFF', 'E2EABAF963'), (3635, 3, 'SOLVED', 10, 35, 5, 'Peripheral Issue', '2009-07-20 06:15:03', 4, null, '2009-07-25 18:04:48', 'STAFF', 'A098B2EB31'), (3636, 2, 'CLOSED', 7, 17, 5, 'Peripheral Doubt', '2009-07-20 07:19:39', 3, null, '2009-08-11 18:55:14', 'STAFF', '48042B1DAE'), (3637, 1, 'SOLVED', 5, 10, 6, 'Software Issue', '2009-07-20 08:30:30', 3, null, '2009-07-25 15:44:57', 'STAFF', 'CAE82D4350'), (3638, 3, 'SOLVED', 1, 27, 5, 'Peripheral Issue', '2009-07-20 08:29:28', 2, null, '2009-07-22 14:24:26', 'STAFF', '895DAA408F'), (3639, 2, 'CLOSED', 1, 8, 4, 'WEB Mail Issue', '2009-07-20 12:54:38', 2, null, '2009-07-22 13:27:41', 'STAFF', 'BA304F3809'), (3640, 3, 'SOLVED', 1, 5, 5, 'Peripheral Issue', '2009-07-20 10:23:21', 3, null, '2009-07-25 17:35:01', 'STAFF', '4F11B55F57'), (3641, 3, 'RETURNED', 1, 37, 4, 'WEB Mail Doubt', '2009-07-20 12:14:58', 0, null, '2009-07-28 07:24:56', 'CUSTOMER', '22C5A90107'), (3642, 2, 'SOLVED', 5, 35, 1, 'CRM Application Doubt', '2009-07-20 09:18:51', 3, null, '2009-07-30 17:36:15', 'STAFF', '300D1539C3'), (3643, 1, 'RETURNED', 3, 8, 4, 'WEB Mail Issue', '2009-07-20 10:36:09', 0, null, '2009-07-20 10:36:09', 'CUSTOMER', '7AE11AF208'), (3644, 1, 'SOLVED', 10, 1, 3, 'Sales Doubt', '2009-07-20 07:04:27', 2, null, '2009-07-27 14:54:55', 'STAFF', '8A057268A7'), (3645, 3, 'SOLVED', 10, 24, 3, 'Sales Doubt', '2009-07-20 11:22:34', 2, null, '2009-07-28 13:26:06', 'STAFF', 'D0AA518D4D'), (3646, 2, 'RETURNED', 2, 17, 4, 'WEB Mail Issue', '2009-07-21 06:56:38', 0, null, '2009-07-25 12:11:55', 'CUSTOMER', 'B5A1D92522'), (3647, 2, 'CLOSED', 4, 28, 6, 'Software Issue', '2009-07-21 06:54:08', 3, null, '2009-07-21 14:29:31', 'STAFF', '0D8080853A'), (3648, 3, 'SOLVED', 5, 31, 4, 'WEB Mail Doubt', '2009-07-21 06:10:15', 2, null, '2009-07-25 17:42:21', 'STAFF', 'CFF02A74DA'), (3649, 2, 'SOLVED', 6, 18, 5, 'Peripheral Issue', '2009-07-21 08:59:42', 4, null, '2009-07-26 13:05:31', 'STAFF', '49C0FA7F96'), (3650, 2, 'SOLVED', 9, 28, 6, 'Software Doubt', '2009-07-21 07:26:17', 2, null, '2009-07-22 15:59:00', 'STAFF', '45CEF8E5B9'), (3651, 2, 'CLOSED', 5, 37, 2, 'WEB Site Issue', '2009-07-21 11:10:27', 1, null, '2009-07-23 14:29:36', 'STAFF', 'C203E4A1BD'), (3652, 1, 'SOLVED', 3, 9, 4, 'WEB Mail Doubt', '2009-07-21 06:59:38', 4, null, '2009-08-02 16:21:04', 'STAFF', 'E1021D4391'), (3653, 2, 'CLOSED', 1, 37, 6, 'Software Issue', '2009-07-21 10:58:24', 2, null, '2009-07-25 15:48:18', 'STAFF', '2DA6CC4A5D'), (3654, 2, 'SOLVED', 10, 28, 4, 'WEB Mail Doubt', '2009-07-21 09:37:51', 3, null, '2009-08-08 17:11:42', 'STAFF', 'CF88118AA2'), (3655, 3, 'SOLVED', 5, 39, 6, 'Software Issue', '2009-07-21 07:31:51', 2, null, '2009-07-21 13:53:57', 'STAFF', '310CC7CA5A'), (3656, 2, 'SOLVED', 5, 10, 4, 'WEB Mail Doubt', '2009-07-21 12:25:23', 4, null, '2009-07-23 13:31:46', 'STAFF', '14678DB828'), (3657, 1, 'SOLVED', 5, 17, 2, 'WEB Site Doubt', '2009-07-21 10:17:04', 4, null, '2009-07-23 14:50:20', 'STAFF', 'A22D33B4A0'), (3658, 3, 'SOLVED', 5, 1, 4, 'WEB Mail Doubt', '2009-07-21 11:49:46', 4, null, '2009-07-23 14:30:06', 'STAFF', '30A237D18C'), (3659, 2, 'REPLIED', 9, 36, 4, 'WEB Mail Doubt', '2009-07-22 10:07:44', 0, null, '2009-08-03 13:29:54', 'STAFF', '07845CD9AE'), (3660, 2, 'SOLVED', 6, 22, 6, 'Sotfware Issue', '2009-07-22 11:28:57', 3, null, '2009-07-24 16:16:40', 'STAFF', '9627C45DF5'), (3661, 3, 'SOLVED', 9, 19, 4, 'WEB Mail Doubt', '2009-07-22 06:26:40', 3, null, '2009-07-24 14:34:21', 'STAFF', 'E761813F83'), (3662, 2, 'SOLVED', 1, 22, 6, 'Sotfware Issue', '2009-07-22 11:44:41', 2, null, '2009-07-28 17:25:22', 'STAFF', '2B346A0AA3'), (3663, 3, 'RETURNED', 9, 33, 4, 'WEB Mail Issue', '2009-07-22 09:05:53', 0, null, '2009-07-25 08:10:08', 'CUSTOMER', 'DDF9029977'), (3664, 3, 'SOLVED', 10, 31, 2, 'WEB Site Issue', '2009-07-22 12:53:34', 4, null, '2009-07-27 13:03:00', 'STAFF', 'B67FB3360A'), (3665, 2, 'SOLVED', 6, 39, 2, 'WEB Site Issue', '2009-07-22 07:37:28', 4, null, '2009-07-25 18:15:34', 'STAFF', 6915849303), (3666, 2, 'SOLVED', 9, 22, 3, 'Sales Doubt', '2009-07-22 12:00:54', 3, null, '2009-07-25 14:49:29', 'STAFF', '1EA97DE85E'), (3667, 1, 'CLOSED', 1, 8, 3, 'Sales Doubt', '2009-07-22 10:42:32', 2, null, '2009-08-07 13:49:51', 'STAFF', 'F095CEDD23'), (3668, 2, 'SOLVED', 10, 20, 4, 'WEB Mail Issue', '2009-07-22 09:54:02', 2, null, '2009-07-31 13:40:25', 'STAFF', '1D2A48C55F'), (3669, 2, 'SOLVED', 2, 19, 4, 'WEB Mail Doubt', '2009-07-23 12:27:03', 4, null, '2009-07-27 17:05:50', 'STAFF', 'E1228BE46D'), (3670, 2, 'UNASSIGNED', 6, 11, 3, 'Sales Doubt', '2009-07-24 11:39:57', 0, null, '2009-07-24 11:39:57', 'CUSTOMER', '77EC6F21C8'), (3671, 2, 'SOLVED', 7, 23, 2, 'WEB Site Issue', '2009-07-24 06:18:35', 2, null, '2009-08-01 18:42:58', 'STAFF', '54EBDFBBFE'), (3672, 2, 'SOLVED', 7, 36, 4, 'WEB Mail Issue', '2009-07-25 12:02:47', 4, null, '2009-07-25 17:41:52', 'STAFF', 'F3C89B7BE3'), (3673, 2, 'CLOSED', 1, 31, 1, 'CRM Application Doubt', '2009-07-25 11:56:56', 1, null, '2009-08-15 17:59:58', 'STAFF', '740A02D078'), (3674, 3, 'SOLVED', 10, 31, 4, 'WEB Mail Doubt', '2009-07-25 12:12:38', 2, null, '2009-07-28 18:15:46', 'STAFF', 'F35FD56706'), (3675, 2, 'SOLVED', 1, 21, 3, 'Sales Doubt', '2009-07-25 09:06:30', 4, null, '2009-08-09 17:08:09', 'STAFF', '845F3CB43A'), (3676, 2, 'RETURNED', 5, 39, 4, 'WEB Mail Doubt', '2009-07-25 09:27:21', 0, null, '2009-07-25 09:27:21', 'CUSTOMER', 1133832659), (3677, 2, 'SOLVED', 3, 10, 2, 'WEB Site Doubt', '2009-07-25 09:53:40', 4, null, '2009-07-26 16:40:00', 'STAFF', '71D7232B9F'), (3678, 2, 'SOLVED', 7, 29, 6, 'Sotfware Issue', '2009-07-25 07:23:55', 3, null, '2009-08-10 15:16:54', 'STAFF', '2151B4C76B'), (3679, 1, 'SOLVED', 2, 31, 4, 'WEB Mail Doubt', '2009-07-25 08:47:56', 2, null, '2009-07-27 13:40:02', 'STAFF', '74791EDF1F'), (3680, 3, 'SOLVED', 9, 19, 5, 'Peripheral Issue', '2009-07-25 11:27:28', 2, null, '2009-07-30 15:55:02', 'STAFF', '2122C699D5'), (3681, 2, 'RETURNED', 1, 30, 6, 'Software Doubt', '2009-07-26 08:42:47', 0, null, '2009-08-05 09:24:07', 'CUSTOMER', '9426C311E7'), (3682, 1, 'SOLVED', 1, 19, 3, 'Sales Doubt', '2009-07-26 12:30:06', 3, null, '2009-08-04 13:54:23', 'STAFF', '898AEF0932'), (3683, 1, 'SOLVED', 10, 11, 4, 'WEB Mail Issue', '2009-07-26 07:54:27', 3, null, '2009-08-06 14:39:39', 'STAFF', 'ACB5D1120B'), (3684, 2, 'SOLVED', 1, 22, 5, 'Peripheral Issue', '2009-07-26 11:24:25', 3, null, '2009-07-30 13:14:12', 'STAFF', 'C90E274D55'), (3685, 2, 'SOLVED', 9, 23, 5, 'Peripheral Doubt', '2009-07-26 07:24:00', 3, null, '2009-08-08 18:03:05', 'STAFF', '55A0DF4B5A'), (3686, 2, 'CLOSED', 1, 38, 2, 'WEB Site Doubt', '2009-07-26 10:32:58', 1, null, '2009-08-02 16:54:05', 'STAFF', 'DC727151E5'), (3687, 2, 'SOLVED', 5, 32, 5, 'Peripheral Issue', '2009-07-26 12:43:58', 4, null, '2009-08-06 15:24:30', 'STAFF', '6754E06E46'), (3688, 2, 'CLOSED', 5, 20, 6, 'Software Issue', '2009-07-26 06:06:59', 3, null, '2009-08-03 15:17:33', 'STAFF', 'D880067F87'), (3689, 1, 'UNASSIGNED', 9, 7, 6, 'Software Doubt', '2009-07-26 06:54:31', 0, null, '2009-07-26 06:54:31', 'CUSTOMER', '39EA40E164'), (3690, 1, 'RETURNED', 2, 26, 2, 'WEB Site Issue', '2009-07-27 12:45:05', 0, null, '2009-08-14 06:24:53', 'CUSTOMER', '781397BC06'), (3691, 2, 'CLOSED', 7, 39, 6, 'Software Doubt', '2009-07-27 11:57:10', 1, null, '2009-08-03 14:20:43', 'STAFF', '8ABFE8AC9E'), (3692, 3, 'REPLIED', 1, 10, 4, 'WEB Mail Issue', '2009-07-27 12:55:02', 0, null, '2009-08-09 18:37:58', 'STAFF', '882735CBDF'), (3693, 2, 'SOLVED', 1, 34, 4, 'WEB Mail Doubt', '2009-07-27 07:25:11', 2, null, '2009-07-31 16:53:34', 'STAFF', 'F23D125DA1'), (3694, 3, 'SOLVED', 9, 39, 4, 'WEB Mail Doubt', '2009-07-27 09:22:16', 3, null, '2009-07-31 15:13:53', 'STAFF', '4B26DC4663'), (3695, 3, 'RETURNED', 5, 26, 6, 'Sotfware Issue', '2009-07-27 09:59:03', 0, null, '2009-07-27 09:59:03', 'CUSTOMER', 'AF1B575406'), (3696, 2, 'SOLVED', 4, 23, 6, 'Software Doubt', '2009-07-27 12:25:08', 2, null, '2009-08-07 13:18:42', 'STAFF', '95C9D994F8'), (3697, 1, 'SOLVED', 2, 5, 6, 'Software Doubt', '2009-07-27 10:41:09', 4, null, '2009-07-28 17:01:32', 'STAFF', '0B105CF150'), (3698, 2, 'SOLVED', 5, 25, 3, 'Sales Doubt', '2009-07-27 10:26:38', 2, null, '2009-07-28 16:43:47', 'STAFF', '943AA0FCDA'), (3699, 3, 'SOLVED', 1, 19, 6, 'Software Doubt', '2009-07-27 06:43:52', 4, null, '2009-08-06 18:52:18', 'STAFF', 'A18630AB1C'), (3700, 2, 'SOLVED', 4, 17, 2, 'WEB Site Issue', '2009-07-27 10:09:58', 2, null, '2009-08-03 18:33:42', 'STAFF', 'F92586A25B'), (3701, 2, 'CLOSED', 6, 17, 4, 'WEB Mail Issue', '2009-07-27 08:51:28', 1, null, '2009-08-05 14:14:00', 'STAFF', 'B181EAA49F'), (3702, 1, 'SOLVED', 5, 39, 1, 'CRM Application Issue', '2009-07-27 09:37:47', 3, null, '2009-08-05 16:51:56', 'STAFF', 'A928731E10'), (3703, 1, 'SOLVED', 6, 35, 4, 'WEB Mail Doubt', '2009-07-27 09:52:22', 4, null, '2009-07-30 17:31:26', 'STAFF', '7D2A383E54'), (3704, 2, 'SOLVED', 9, 19, 3, 'Sales Doubt', '2009-07-27 11:38:35', 2, null, '2009-07-30 15:54:46', 'STAFF', '9308B0D6E5'), (3705, 1, 'RETURNED', 6, 12, 1, 'CRM Application Issue', '2009-07-27 11:51:14', 0, null, '2009-08-07 12:40:07', 'CUSTOMER', '2CFA3753D6'), (3706, 2, 'SOLVED', 10, 11, 1, 'CRM Application Doubt', '2009-07-27 06:43:41', 4, null, '2009-07-29 14:48:01', 'STAFF', '4764F37856'), (3707, 3, 'SOLVED', 2, 3, 4, 'WEB Mail Doubt', '2009-07-27 08:45:05', 4, null, '2009-07-31 14:38:57', 'STAFF', '2AD9E5E943'), (3708, 3, 'RETURNED', 1, 37, 1, 'CRM Application Issue', '2009-07-27 12:27:37', 0, null, '2009-07-27 12:27:37', 'CUSTOMER', '34FFEB359A'), (3709, 1, 'SOLVED', 1, 7, 6, 'Software Doubt', '2009-07-28 09:07:07', 3, null, '2009-08-09 16:37:21', 'STAFF', '56DB57B4DB'), (3710, 1, 'SOLVED', 7, 37, 2, 'WEB Site Doubt', '2009-07-28 11:23:49', 4, null, '2009-08-09 18:10:38', 'STAFF', 5505712229), (3711, 2, 'SOLVED', 7, 29, 2, 'WEB Site Issue', '2009-07-28 07:24:14', 2, null, '2009-08-06 16:01:31', 'STAFF', 'ABA18772FC'), (3712, 2, 'RETURNED', 5, 6, 4, 'WEB Mail Doubt', '2009-07-28 08:14:24', 0, null, '2009-08-04 10:45:41', 'CUSTOMER', '87AE6FB631'), (3713, 1, 'SOLVED', 7, 15, 4, 'WEB Mail Doubt', '2009-07-28 08:06:43', 3, null, '2009-08-06 15:52:38', 'STAFF', '7553E94D39'), (3714, 2, 'SOLVED', 6, 12, 6, 'Sotfware Issue', '2009-07-28 08:40:08', 2, null, '2009-08-05 17:53:22', 'STAFF', 'E36286B94D'), (3715, 1, 'SOLVED', 1, 5, 2, 'WEB Site Doubt', '2009-07-28 09:58:39', 3, null, '2009-08-11 18:20:07', 'STAFF', 'D2D2C6E244'), (3716, 2, 'SOLVED', 9, 7, 1, 'CRM Application Issue', '2009-07-28 12:47:44', 4, null, '2009-08-07 15:28:59', 'STAFF', '1B32A022C5'), (3717, 3, 'SOLVED', 10, 33, 3, 'Sales Doubt', '2009-07-29 06:50:15', 4, null, '2009-08-08 13:22:29', 'STAFF', '240C945BB7'), (3718, 1, 'SOLVED', 5, 33, 5, 'Peripheral Issue', '2009-07-29 12:52:43', 4, null, '2009-08-09 13:03:16', 'STAFF', '9D068C869F'), (3719, 1, 'CLOSED', 10, 40, 1, 'CRM Application Issue', '2009-07-29 07:13:39', 1, null, '2009-08-05 16:43:23', 'STAFF', '9E740B84BB'), (3720, 2, 'CLOSED', 10, 38, 5, 'Peripheral Issue', '2009-07-29 08:07:44', 2, null, '2009-08-07 13:46:42', 'STAFF', '532B81FA22'), (3721, 2, 'SOLVED', 10, 11, 5, 'Peripheral Issue', '2009-07-29 08:38:44', 3, null, '2009-08-03 15:55:19', 'STAFF', '9E406957D4'), (3722, 2, 'RETURNED', 2, 35, 3, 'Sales Doubt', '2009-07-29 07:58:19', 0, null, '2009-07-29 07:58:19', 'CUSTOMER', '56E6A93212'), (3723, 1, 'SOLVED', 3, 33, 5, 'Peripheral Issue', '2009-07-29 08:35:53', 2, null, '2009-08-02 14:09:42', 'STAFF', 'AFA299A4D1'), (3724, 2, 'SOLVED', 1, 1, 3, 'Sales Doubt', '2009-07-30 11:45:23', 4, null, '2009-08-04 14:34:52', 'STAFF', '4172F31012'), (3725, 3, 'SOLVED', 10, 32, 1, 'CRM Application Issue', '2009-07-30 10:32:52', 4, null, '2009-08-09 15:04:21', 'STAFF', '94EF7214C4'), (3726, 3, 'SOLVED', 1, 15, 5, 'Peripheral Issue', '2009-07-30 12:58:13', 3, null, '2009-08-21 17:23:01', 'STAFF', '9FE77AC706'), (3727, 1, 'REPLIED', 4, 7, 4, 'WEB Mail Issue', '2009-07-30 07:43:23', 0, null, '2009-08-10 16:24:48', 'STAFF', 'D3802B1DC0'), (3728, 2, 'SOLVED', 1, 28, 3, 'Sales Doubt', '2009-08-01 11:01:57', 4, null, '2009-08-12 16:07:31', 'STAFF', '460B491B91'), (3729, 2, 'RETURNED', 6, 11, 5, 'Peripheral Issue', '2009-08-01 07:04:51', 0, null, '2009-08-08 12:29:55', 'CUSTOMER', 'CB16B8498F'), (3730, 3, 'RETURNED', 3, 16, 4, 'WEB Mail Issue', '2009-08-01 08:23:43', 0, null, '2009-08-10 09:08:53', 'CUSTOMER', 'D8C24CA8F2'), (3731, 2, 'RETURNED', 7, 10, 5, 'Peripheral Issue', '2009-08-01 11:53:35', 0, null, '2009-08-05 09:28:18', 'CUSTOMER', '7EC3B3CF67'), (3732, 2, 'SOLVED', 10, 37, 6, 'Sotfware Issue', '2009-08-01 11:34:34', 2, null, '2009-08-09 17:06:07', 'STAFF', 'EE23E7AD9B'), (3733, 2, 'REPLIED', 7, 40, 5, 'Peripheral Issue', '2009-08-01 08:15:29', 0, null, '2009-08-05 15:46:39', 'STAFF', '64D52E08CC'), (3734, 1, 'SOLVED', 4, 3, 2, 'WEB Site Issue', '2009-08-01 10:51:07', 3, null, '2009-08-08 14:59:48', 'STAFF', '9D752CB08E'), (3735, 2, 'SOLVED', 10, 19, 5, 'Peripheral Doubt', '2009-08-01 06:08:03', 2, null, '2009-08-16 17:21:15', 'STAFF', 'DC0C398086'), (3736, 1, 'SOLVED', 1, 22, 6, 'Software Issue', '2009-08-01 12:48:24', 2, null, '2009-08-08 14:19:42', 'STAFF', '3E195B0793'), (3737, 2, 'SOLVED', 1, 3, 1, 'CRM Application Issue', '2009-08-02 10:21:41', 4, null, '2009-08-04 13:06:19', 'STAFF', '3DB11D259A'), (3738, 2, 'REPLIED', 9, 22, 6, 'Software Doubt', '2009-08-02 09:59:33', 0, null, '2009-08-07 16:27:23', 'STAFF', '16738419B1'), (3739, 1, 'REPLIED', 10, 37, 3, 'Sales Doubt', '2009-08-02 12:25:21', 0, null, '2009-08-12 13:19:04', 'STAFF', '20885C72CA'), (3740, 3, 'SOLVED', 7, 10, 6, 'Software Issue', '2009-08-02 12:16:06', 3, null, '2009-08-13 18:37:33', 'STAFF', '33EF701C80'), (3741, 2, 'RETURNED', 2, 6, 1, 'CRM Application Doubt', '2009-08-02 11:10:09', 0, null, '2009-08-10 11:06:33', 'CUSTOMER', '63CE12DCF1'), (3742, 3, 'SOLVED', 9, 37, 3, 'Sales Doubt', '2009-08-02 12:32:28', 2, null, '2009-08-10 15:21:29', 'STAFF', '1F72E258FF'), (3743, 1, 'SOLVED', 6, 17, 1, 'CRM Application Issue', '2009-08-02 12:10:17', 2, null, '2009-08-13 18:05:04', 'STAFF', '0937FB5864'), (3744, 2, 'RETURNED', 5, 7, 1, 'CRM Application Issue', '2009-08-02 09:27:02', 0, null, '2009-08-15 06:02:16', 'CUSTOMER', '56517F19AA'), (3745, 1, 'CLOSED', 2, 34, 2, 'WEB Site Doubt', '2009-08-02 08:45:20', 3, null, '2009-08-02 17:42:36', 'STAFF', '6D3A2D24EB'), (3746, 2, 'SOLVED', 1, 33, 5, 'Peripheral Issue', '2009-08-02 09:19:21', 4, null, '2009-08-08 14:05:01', 'STAFF', 'E8542A04D7'), (3747, 1, 'REPLIED', 5, 23, 5, 'Peripheral Doubt', '2009-08-02 12:48:52', 0, null, '2009-08-15 15:22:41', 'STAFF', 'D8847BE3F7'), (3748, 2, 'RETURNED', 3, 38, 1, 'CRM Application Doubt', '2009-08-03 09:18:37', 0, null, '2009-08-11 11:55:49', 'CUSTOMER', 'AAACCD2766'), (3749, 2, 'RETURNED', 9, 21, 4, 'WEB Mail Doubt', '2009-08-03 11:46:15', 0, null, '2009-08-19 09:35:12', 'CUSTOMER', 'F9BEB1E831'), (3750, 3, 'CLOSED', 10, 26, 5, 'Peripheral Issue', '2009-08-03 07:49:31', 3, null, '2009-08-12 18:12:18', 'STAFF', '685AC8CADC'), (3751, 1, 'SOLVED', 6, 22, 5, 'Peripheral Issue', '2009-08-03 11:05:15', 3, null, '2009-08-08 14:27:34', 'STAFF', '21CE689121'), (3752, 3, 'SOLVED', 9, 23, 5, 'Peripheral Issue', '2009-08-03 09:47:44', 4, null, '2009-08-18 16:00:41', 'STAFF', '48DF7B8E8D'), (3753, 1, 'SOLVED', 1, 7, 1, 'CRM Application Issue', '2009-08-03 12:11:06', 3, null, '2009-08-08 15:24:05', 'STAFF', '258E130476'), (3754, 1, 'SOLVED', 5, 10, 4, 'WEB Mail Doubt', '2009-08-03 12:13:34', 4, null, '2009-08-03 17:42:24', 'STAFF', '2E3D2C4F33'), (3755, 2, 'SOLVED', 8, 20, 3, 'Sales Issue', '2009-08-03 07:58:39', 4, null, '2009-08-07 13:45:40', 'STAFF', 'CD3BBC2D7C'), (3756, 3, 'SOLVED', 5, 38, 6, 'Sotfware Issue', '2009-08-03 11:09:21', 2, null, '2009-08-23 16:24:58', 'STAFF', '91F9FEC9B0'), (3757, 2, 'SOLVED', 6, 2, 6, 'Software Doubt', '2009-08-03 11:09:08', 3, null, '2009-08-05 13:00:14', 'STAFF', 'B4AFFA4F6B'), (3758, 3, 'SOLVED', 5, 6, 3, 'Sales Doubt', '2009-08-03 10:46:07', 4, null, '2009-08-04 15:14:57', 'STAFF', '3DF07FDAE1'), (3759, 2, 'RETURNED', 6, 24, 5, 'Peripheral Doubt', '2009-08-03 11:37:52', 0, null, '2009-08-03 11:37:52', 'CUSTOMER', 'CBF22AB286'), (3760, 1, 'RETURNED', 9, 35, 5, 'Peripheral Doubt', '2009-08-03 12:51:34', 0, null, '2009-08-03 12:51:34', 'CUSTOMER', '27E8E17134'), (3761, 2, 'SOLVED', 10, 23, 6, 'Software Doubt', '2009-08-03 09:32:45', 3, null, '2009-08-03 13:54:24', 'STAFF', '092CB13C22'), (3762, 3, 'SOLVED', 3, 38, 1, 'CRM Application Doubt', '2009-08-03 10:04:39', 3, null, '2009-08-19 18:59:45', 'STAFF', '9332C513EF'), (3763, 1, 'REPLIED', 10, 10, 4, 'WEB Mail Issue', '2009-08-03 09:52:01', 0, null, '2009-08-07 17:36:42', 'STAFF', '7BA6D33C37'), (3764, 2, 'CLOSED', 6, 18, 2, 'WEB Site Issue', '2009-08-03 07:30:08', 1, null, '2009-08-03 17:22:39', 'STAFF', '641D77DD52'), (3765, 2, 'SOLVED', 10, 35, 4, 'WEB Mail Doubt', '2009-08-04 07:27:04', 3, null, '2009-08-21 15:16:52', 'STAFF', '211A7A84D3'), (3766, 3, 'SOLVED', 9, 34, 6, 'Software Doubt', '2009-08-04 09:21:16', 2, null, '2009-08-22 15:38:12', 'STAFF', '79CAE1BE0F'), (3767, 3, 'REPLIED', 10, 28, 4, 'WEB Mail Issue', '2009-08-04 12:17:11', 0, null, '2009-08-14 18:17:09', 'STAFF', 'D74CB35426'), (3768, 1, 'RETURNED', 10, 24, 1, 'CRM Application Issue', '2009-08-04 11:38:14', 0, null, '2009-08-04 11:38:14', 'CUSTOMER', '28D437661D'), (3769, 2, 'SOLVED', 1, 40, 6, 'Software Doubt', '2009-08-04 11:34:45', 3, null, '2009-08-15 14:45:16', 'STAFF', '4625D8E31D'), (3770, 3, 'SOLVED', 10, 1, 4, 'WEB Mail Doubt', '2009-08-04 08:33:33', 4, null, '2009-08-13 15:45:47', 'STAFF', '7F6CAF1F0B'), (3771, 1, 'REPLIED', 8, 9, 2, 'WEB Site Issue', '2009-08-04 08:07:09', 0, null, '2009-08-09 18:01:43', 'STAFF', '201E5BACD6'), (3772, 2, 'CLOSED', 9, 27, 6, 'Sotfware Issue', '2009-08-04 08:06:59', 3, null, '2009-08-07 13:38:57', 'STAFF', '83DDFBD1C4'), (3773, 3, 'RETURNED', 2, 35, 4, 'WEB Mail Doubt', '2009-08-04 12:11:20', 0, null, '2009-08-13 11:07:08', 'CUSTOMER', '5C151C2A9B'), (3774, 3, 'SOLVED', 2, 34, 4, 'WEB Mail Doubt', '2009-08-05 12:35:05', 2, null, '2009-08-08 15:46:22', 'STAFF', '73F104C9FB'), (3775, 2, 'UNASSIGNED', 6, 21, 2, 'WEB Site Issue', '2009-08-05 07:05:57', 0, null, '2009-08-05 07:05:57', 'CUSTOMER', 'F2B93CE087'), (3776, 2, 'CLOSED', 7, 10, 1, 'CRM Application Issue', '2009-08-05 12:01:44', 2, null, '2009-08-05 16:30:18', 'STAFF', '2119B8D43E'), (3777, 3, 'SOLVED', 8, 35, 2, 'WEB Site Issue', '2009-08-05 11:03:42', 4, null, '2009-08-06 18:58:49', 'STAFF', 'ADD7A04804'), (3778, 1, 'SOLVED', 1, 36, 6, 'Software Doubt', '2009-08-05 07:39:18', 2, null, '2009-08-09 13:35:58', 'STAFF', 'CAB070D53B'), (3779, 1, 'UNASSIGNED', 1, 37, 2, 'WEB Site Doubt', '2009-08-05 06:44:14', 0, null, '2009-08-05 06:44:14', 'CUSTOMER', '8CE87BDDA8'), (3780, 2, 'SOLVED', 9, 10, 5, 'Peripheral Issue', '2009-08-05 06:02:59', 2, null, '2009-08-17 16:33:22', 'STAFF', '3569DF159E'), (3781, 2, 'SOLVED', 9, 6, 4, 'WEB Mail Issue', '2009-08-05 07:08:54', 3, null, '2009-08-15 18:25:59', 'STAFF', '9FC664916B'), (3782, 2, 'RETURNED', 6, 1, 6, 'Software Doubt', '2009-08-06 09:09:34', 0, null, '2009-08-06 09:09:34', 'CUSTOMER', 'F87E955FD6'), (3783, 3, 'SOLVED', 5, 1, 3, 'Sales Doubt', '2009-08-06 12:16:49', 2, null, '2009-08-16 16:33:38', 'STAFF', '1AA3D9C6CE'), (3784, 2, 'RETURNED', 10, 23, 6, 'Sotfware Issue', '2009-08-07 06:50:54', 0, null, '2009-08-13 09:23:43', 'CUSTOMER', 'E16E74A635'), (3785, 2, 'RETURNED', 9, 35, 1, 'CRM Application Issue', '2009-08-08 06:08:21', 0, null, '2009-08-08 06:08:21', 'CUSTOMER', '44FEB0096F'), (3786, 1, 'RETURNED', 2, 4, 6, 'Software Doubt', '2009-08-08 06:27:38', 0, null, '2009-08-14 08:04:04', 'CUSTOMER', '34306D99C6'), (3787, 1, 'RETURNED', 10, 37, 1, 'CRM Application Issue', '2009-08-08 10:07:38', 0, null, '2009-08-08 10:07:38', 'CUSTOMER', 'F3175210F9'), (3788, 3, 'SOLVED', 7, 15, 4, 'WEB Mail Doubt', '2009-08-08 11:30:30', 2, null, '2009-08-09 14:09:03', 'STAFF', 'DEB74A85A4'), (3789, 3, 'RETURNED', 1, 33, 5, 'Peripheral Issue', '2009-08-08 11:34:00', 0, null, '2009-08-21 09:10:44', 'CUSTOMER', '335D3D1CD7'), (3790, 2, 'SOLVED', 10, 1, 1, 'CRM Application Issue', '2009-08-08 07:58:24', 3, null, '2009-08-13 15:14:51', 'STAFF', 'E73FECC08E'), (3791, 3, 'RETURNED', 9, 28, 5, 'Peripheral Issue', '2009-08-08 09:40:18', 0, null, '2009-08-26 06:37:23', 'CUSTOMER', '690BB330E5'), (3792, 2, 'SOLVED', 10, 7, 6, 'Software Issue', '2009-08-08 11:33:09', 2, null, '2009-08-12 15:02:19', 'STAFF', '4ECB679FD3'), (3793, 2, 'SOLVED', 2, 38, 5, 'Peripheral Doubt', '2009-08-08 10:32:22', 2, null, '2009-08-11 14:55:00', 'STAFF', 'C157297D1A'), (3794, 1, 'SOLVED', 8, 23, 6, 'Software Issue', '2009-08-09 08:40:03', 2, null, '2009-08-11 14:19:22', 'STAFF', '916D3891A2'), (3795, 2, 'UNASSIGNED', 1, 25, 3, 'Sales Doubt', '2009-08-09 12:02:15', 0, null, '2009-08-09 12:02:15', 'CUSTOMER', '42547F5A44'), (3796, 2, 'CLOSED', 1, 11, 1, 'CRM Application Doubt', '2009-08-09 12:12:48', 3, null, '2009-08-20 14:34:29', 'STAFF', '41C542DFE6'), (3797, 2, 'SOLVED', 10, 7, 5, 'Peripheral Doubt', '2009-08-09 12:06:26', 3, null, '2009-08-11 17:42:41', 'STAFF', '36072923BF'), (3798, 2, 'RETURNED', 7, 2, 4, 'WEB Mail Doubt', '2009-08-09 10:45:30', 0, null, '2009-08-09 10:45:30', 'CUSTOMER', 'C82836ED44'), (3799, 2, 'REPLIED', 3, 27, 5, 'Peripheral Issue', '2009-08-09 07:52:57', 0, null, '2009-08-20 15:30:58', 'STAFF', '58521E4E2B'), (3800, 3, 'RETURNED', 5, 18, 3, 'Sales Doubt', '2009-08-09 10:47:53', 0, null, '2009-08-17 08:51:36', 'CUSTOMER', '63C6598E9D'), (3801, 2, 'RETURNED', 1, 19, 4, 'WEB Mail Doubt', '2009-08-09 06:06:39', 0, null, '2009-08-09 06:06:39', 'CUSTOMER', '95323660ED'), (3802, 2, 'RETURNED', 2, 12, 2, 'WEB Site Issue', '2009-08-09 09:18:51', 0, null, '2009-08-09 09:18:51', 'CUSTOMER', 'D3614F463B'), (3803, 2, 'SOLVED', 8, 38, 6, 'Software Issue', '2009-08-09 09:55:13', 2, null, '2009-08-09 17:57:58', 'STAFF', 'E97399278D'), (3804, 1, 'SOLVED', 5, 25, 4, 'WEB Mail Doubt', '2009-08-09 10:34:35', 2, null, '2009-08-26 16:45:18', 'STAFF', '37968AD196'), (3805, 2, 'SOLVED', 4, 26, 5, 'Peripheral Doubt', '2009-08-09 10:45:35', 2, null, '2009-08-09 14:04:20', 'STAFF', '98CAC9D33A'), (3806, 1, 'RETURNED', 10, 22, 6, 'Software Doubt', '2009-08-09 06:15:25', 0, null, '2009-08-09 06:15:25', 'CUSTOMER', '5E7264477C'), (3807, 1, 'REPLIED', 6, 6, 3, 'Sales Doubt', '2009-08-10 12:46:22', 0, null, '2009-08-22 13:43:33', 'STAFF', '43A115CBD6'), (3808, 1, 'CLOSED', 1, 28, 5, 'Peripheral Doubt', '2009-08-10 06:34:09', 2, null, '2009-08-25 17:12:13', 'STAFF', 'CD8D5260C8'), (3809, 2, 'SOLVED', 7, 24, 1, 'CRM Application Doubt', '2009-08-10 06:48:48', 4, null, '2009-08-10 16:28:13', 'STAFF', '38EF4B66CB'), (3810, 2, 'SOLVED', 6, 32, 4, 'WEB Mail Doubt', '2009-08-10 12:48:00', 2, null, '2009-08-21 16:07:22', 'STAFF', '02AE6A786B'), (3811, 2, 'SOLVED', 5, 22, 5, 'Peripheral Doubt', '2009-08-10 12:32:55', 4, null, '2009-08-24 17:13:38', 'STAFF', '8068FEE5F4'), (3812, 1, 'CLOSED', 6, 13, 2, 'WEB Site Issue', '2009-08-10 06:19:41', 3, null, '2009-08-10 14:21:26', 'STAFF', '40DBA662FA'), (3813, 1, 'RETURNED', 1, 5, 5, 'Peripheral Doubt', '2009-08-10 11:19:45', 0, null, '2009-08-10 11:19:45', 'CUSTOMER', '0A49E3C3A0'), (3814, 1, 'RETURNED', 9, 31, 5, 'Peripheral Doubt', '2009-08-10 12:08:23', 0, null, '2009-08-10 12:08:23', 'CUSTOMER', 'C563C2C394'), (3815, 2, 'RETURNED', 9, 23, 1, 'CRM Application Issue', '2009-08-10 06:25:40', 0, null, '2009-08-23 10:26:59', 'CUSTOMER', '143758EE65'), (3816, 1, 'CLOSED', 8, 35, 2, 'WEB Site Issue', '2009-08-10 12:58:14', 3, null, '2009-08-17 18:50:33', 'STAFF', 'C911241D00'), (3817, 2, 'SOLVED', 8, 8, 6, 'Software Doubt', '2009-08-10 08:45:12', 2, null, '2009-08-12 15:51:33', 'STAFF', 'FA6C94460E'), (3818, 3, 'UNASSIGNED', 10, 11, 5, 'Peripheral Doubt', '2009-08-10 06:17:48', 0, null, '2009-08-10 06:17:48', 'CUSTOMER', 'B994697479'), (3819, 1, 'SOLVED', 5, 7, 5, 'Peripheral Issue', '2009-08-10 12:16:28', 3, null, '2009-08-21 14:09:11', 'STAFF', 'EB1848290D'), (3820, 3, 'REPLIED', 5, 37, 5, 'Peripheral Doubt', '2009-08-10 06:58:13', 0, null, '2009-08-12 16:06:44', 'STAFF', '91E50FE1E3'), (3821, 2, 'SOLVED', 8, 35, 6, 'Software Issue', '2009-08-10 06:05:13', 4, null, '2009-08-15 15:50:21', 'STAFF', 'C04C19C2C2'), (3822, 1, 'RETURNED', 9, 8, 2, 'WEB Site Issue', '2009-08-10 06:23:05', 0, null, '2009-08-25 06:08:56', 'CUSTOMER', '0E57098D03'), (3823, 2, 'CLOSED', 2, 33, 1, 'CRM Application Issue', '2009-08-11 10:15:03', 3, null, '2009-08-15 17:24:17', 'STAFF', 'BCA382C814'), (3824, 1, 'RETURNED', 1, 32, 5, 'Peripheral Issue', '2009-08-11 10:08:30', 0, null, '2009-08-11 10:08:30', 'CUSTOMER', 6797423391), (3825, 1, 'CLOSED', 7, 9, 1, 'CRM Application Doubt', '2009-08-11 12:01:59', 3, null, '2009-08-21 17:33:12', 'STAFF', 'C24FE9F765'), (3826, 1, 'SOLVED', 4, 11, 2, 'WEB Site Doubt', '2009-08-11 09:14:14', 3, null, '2009-08-20 15:04:49', 'STAFF', 'A292F1C587'), (3827, 1, 'SOLVED', 9, 17, 6, 'Software Doubt', '2009-08-11 10:42:46', 2, null, '2009-08-19 16:05:38', 'STAFF', 'B5B8C48482'), (3828, 3, 'REPLIED', 6, 8, 2, 'WEB Site Issue', '2009-08-11 09:50:54', 0, null, '2009-08-16 14:35:19', 'STAFF', '46D3F6029F'), (3829, 2, 'SOLVED', 9, 17, 6, 'Software Doubt', '2009-08-11 07:54:41', 2, null, '2009-08-17 14:06:26', 'STAFF', 'B7D0858D41'), (3830, 3, 'RETURNED', 10, 33, 1, 'CRM Application Issue', '2009-08-11 08:45:44', 0, null, '2009-08-11 08:45:44', 'CUSTOMER', 'FCDE14913C'), (3831, 2, 'SOLVED', 4, 39, 3, 'Sales Doubt', '2009-08-11 08:49:12', 3, null, '2009-08-21 17:34:39', 'STAFF', 'CAC8E13055'), (3832, 2, 'SOLVED', 10, 36, 6, 'Software Issue', '2009-08-12 07:40:04', 2, null, '2009-08-17 18:29:47', 'STAFF', 'EA9268CB43'), (3833, 3, 'SOLVED', 9, 36, 1, 'CRM Application Doubt', '2009-08-12 10:48:24', 3, null, '2009-09-02 15:11:38', 'STAFF', '65B1E92C58'), (3834, 2, 'RETURNED', 4, 1, 3, 'Sales Doubt', '2009-08-12 06:34:04', 0, null, '2009-08-20 09:38:38', 'CUSTOMER', '243BE2818A'), (3835, 2, 'SOLVED', 3, 8, 2, 'WEB Site Issue', '2009-08-12 11:59:24', 2, null, '2009-08-22 13:23:18', 'STAFF', '1C66F4627F'), (3836, 1, 'SOLVED', 8, 39, 4, 'WEB Mail Doubt', '2009-08-12 08:24:56', 3, null, '2009-08-30 14:00:18', 'STAFF', '6E2EEC9CA1'), (3837, 2, 'SOLVED', 6, 37, 5, 'Peripheral Issue', '2009-08-12 09:32:22', 3, null, '2009-08-17 14:30:18', 'STAFF', 'A6ADE5AA93'), (3838, 2, 'CLOSED', 2, 32, 2, 'WEB Site Issue', '2009-08-12 08:06:12', 3, null, '2009-08-17 15:28:37', 'STAFF', 'F26DF67E81'), (3839, 1, 'SOLVED', 4, 13, 6, 'Software Doubt', '2009-08-12 12:05:12', 2, null, '2009-08-12 15:44:06', 'STAFF', '9B2F00F373'), (3840, 2, 'SOLVED', 8, 23, 5, 'Peripheral Issue', '2009-08-12 10:45:13', 3, null, '2009-08-16 16:01:06', 'STAFF', 'DFA037A53E'), (3841, 1, 'SOLVED', 10, 24, 6, 'Sotfware Issue', '2009-08-12 11:59:42', 4, null, '2009-08-14 17:17:53', 'STAFF', '7DA18D0326'), (3842, 3, 'RETURNED', 5, 25, 6, 'Sotfware Issue', '2009-08-12 11:42:14', 0, null, '2009-08-16 06:45:35', 'CUSTOMER', '7FA215C9EF'), (3843, 2, 'RETURNED', 8, 26, 2, 'WEB Site Issue', '2009-08-13 06:56:02', 0, null, '2009-08-20 09:27:48', 'CUSTOMER', '9EAC167EC1'), (3844, 3, 'SOLVED', 5, 35, 2, 'WEB Site Issue', '2009-08-13 06:38:22', 3, null, '2009-08-15 13:45:24', 'STAFF', '494C08F7A1'), (3845, 3, 'SOLVED', 5, 31, 4, 'WEB Mail Issue', '2009-08-13 12:32:55', 3, null, '2009-08-20 16:21:23', 'STAFF', 'C6D6445D97'), (3846, 2, 'REPLIED', 2, 39, 5, 'Peripheral Doubt', '2009-08-13 11:55:02', 0, null, '2009-08-27 13:09:16', 'STAFF', '6236C78E73'), (3847, 2, 'RETURNED', 7, 38, 6, 'Software Issue', '2009-08-13 09:29:32', 0, null, '2009-08-13 09:29:32', 'CUSTOMER', 'A3048E4731'), (3848, 2, 'SOLVED', 2, 19, 6, 'Software Issue', '2009-08-13 12:32:14', 3, null, '2009-09-04 13:43:31', 'STAFF', '42C8938E4C'), (3849, 1, 'RETURNED', 1, 11, 4, 'WEB Mail Issue', '2009-08-15 09:04:36', 0, null, '2009-09-01 10:01:55', 'CUSTOMER', '4F5A97CF06'), (3850, 2, 'SOLVED', 5, 9, 5, 'Peripheral Doubt', '2009-08-15 09:31:23', 2, null, '2009-08-29 18:36:33', 'STAFF', 'F550E0BA9E'), (3851, 2, 'CLOSED', 2, 1, 6, 'Software Doubt', '2009-08-15 06:30:41', 1, null, '2009-08-30 13:06:22', 'STAFF', 'DC0439CAEB'), (3852, 2, 'REPLIED', 8, 1, 6, 'Software Doubt', '2009-08-15 09:11:19', 0, null, '2009-08-27 14:26:25', 'STAFF', '582967E09F'), (3853, 1, 'SOLVED', 8, 38, 5, 'Peripheral Issue', '2009-08-15 12:11:36', 3, null, '2009-08-17 14:18:07', 'STAFF', 'B9F35816F4'), (3854, 2, 'CLOSED', 1, 35, 2, 'WEB Site Issue', '2009-08-15 11:17:53', 1, null, '2009-08-22 16:24:57', 'STAFF', '31C0B36AEF'), (3855, 2, 'SOLVED', 4, 30, 2, 'WEB Site Issue', '2009-08-15 10:23:40', 3, null, '2009-08-16 18:53:31', 'STAFF', 'D58F855FDC'), (3856, 2, 'CLOSED', 9, 17, 4, 'WEB Mail Doubt', '2009-08-15 08:09:26', 1, null, '2009-08-18 15:53:42', 'STAFF', '4C2E5EAAE9'), (3857, 3, 'SOLVED', 1, 39, 6, 'Software Doubt', '2009-08-15 07:04:09', 2, null, '2009-08-15 17:41:22', 'STAFF', 'F269CB7796'), (3858, 2, 'CLOSED', 6, 25, 4, 'WEB Mail Issue', '2009-08-16 10:48:58', 1, null, '2009-09-01 15:48:07', 'STAFF', '50DD7100BC'), (3859, 3, 'SOLVED', 5, 37, 4, 'WEB Mail Doubt', '2009-08-16 08:18:54', 2, null, '2009-08-24 13:49:39', 'STAFF', '7171E95248'), (3860, 2, 'UNASSIGNED', 5, 11, 5, 'Peripheral Issue', '2009-08-16 08:59:08', 0, null, '2009-08-16 08:59:08', 'CUSTOMER', '5A5EAB21CA'), (3861, 3, 'CLOSED', 1, 37, 5, 'Peripheral Doubt', '2009-08-16 09:44:47', 2, null, '2009-08-29 15:57:44', 'STAFF', 'A6197A578F'), (3862, 3, 'REPLIED', 6, 19, 6, 'Software Issue', '2009-08-16 08:02:26', 0, null, '2009-08-28 16:07:40', 'STAFF', '533FA796B4'), (3863, 1, 'RETURNED', 6, 31, 6, 'Sotfware Issue', '2009-08-16 07:41:45', 0, null, '2009-08-27 07:15:20', 'CUSTOMER', 'C4D2CE3F3E'), (3864, 2, 'CLOSED', 6, 33, 5, 'Peripheral Issue', '2009-08-16 10:21:38', 2, null, '2009-08-17 16:56:34', 'STAFF', '4F8BC5AC1D'), (3865, 2, 'UNASSIGNED', 9, 28, 5, 'Peripheral Issue', '2009-08-16 09:55:00', 0, null, '2009-08-16 09:55:00', 'CUSTOMER', '866D90E092'), (3866, 2, 'RETURNED', 5, 24, 6, 'Software Issue', '2009-08-16 10:43:14', 0, null, '2009-08-16 10:43:14', 'CUSTOMER', 'A9DF2255AD'), (3867, 3, 'SOLVED', 10, 24, 1, 'CRM Application Issue', '2009-08-16 07:53:46', 2, null, '2009-08-27 13:53:14', 'STAFF', '8E54D6B523'), (3868, 2, 'SOLVED', 10, 37, 4, 'WEB Mail Doubt', '2009-08-17 09:34:45', 4, null, '2009-08-19 16:38:08', 'STAFF', '70162FE655'), (3869, 1, 'RETURNED', 5, 22, 2, 'WEB Site Issue', '2009-08-17 12:02:12', 0, null, '2009-08-28 07:52:05', 'CUSTOMER', '2C620A8C23'), (3870, 1, 'SOLVED', 8, 20, 4, 'WEB Mail Doubt', '2009-08-17 08:11:30', 2, null, '2009-08-26 13:07:46', 'STAFF', 'C255C05246'), (3871, 2, 'REPLIED', 1, 19, 5, 'Peripheral Doubt', '2009-08-17 10:57:40', 0, null, '2009-09-01 18:34:16', 'STAFF', '551CB238F4'), (3872, 1, 'RETURNED', 4, 35, 4, 'WEB Mail Issue', '2009-08-17 09:16:50', 0, null, '2009-08-17 09:16:50', 'CUSTOMER', 'D35B05A832'), (3873, 2, 'SOLVED', 6, 17, 6, 'Software Issue', '2009-08-17 07:28:43', 2, null, '2009-08-28 17:54:39', 'STAFF', 'DB346CCB62'), (3874, 2, 'SOLVED', 7, 19, 1, 'CRM Application Issue', '2009-08-17 11:20:18', 3, null, '2009-08-21 18:41:56', 'STAFF', '2ED80F6311'), (3875, 1, 'SOLVED', 5, 9, 3, 'Sales Issue', '2009-08-17 06:30:04', 3, null, '2009-09-06 17:30:02', 'STAFF', 'CCC81A97C1'), (3876, 2, 'SOLVED', 5, 13, 1, 'CRM Application Doubt', '2009-08-17 07:18:19', 4, null, '2009-08-29 13:06:07', 'STAFF', '834A3BD235'), (3877, 2, 'SOLVED', 1, 36, 5, 'Peripheral Issue', '2009-08-17 08:26:19', 2, null, '2009-09-01 15:07:35', 'STAFF', '8D9A6E908E'), (3878, 2, 'SOLVED', 10, 23, 6, 'Sotfware Issue', '2009-08-17 12:38:03', 3, null, '2009-08-18 13:58:38', 'STAFF', '9854D7AFCE'), (3879, 2, 'SOLVED', 3, 14, 2, 'WEB Site Doubt', '2009-08-17 09:26:04', 4, null, '2009-08-29 17:09:35', 'STAFF', 'CC58F7ABF0'), (3880, 1, 'CLOSED', 1, 36, 6, 'Software Issue', '2009-08-17 12:40:39', 3, null, '2009-08-21 18:19:22', 'STAFF', '0DD1BC593A'), (3881, 3, 'REPLIED', 4, 20, 2, 'WEB Site Doubt', '2009-08-17 09:21:27', 0, null, '2009-08-28 18:52:44', 'STAFF', 'A1C5AFF967'), (3882, 3, 'RETURNED', 6, 10, 6, 'Software Doubt', '2009-08-17 10:55:58', 0, null, '2009-08-17 10:55:58', 'CUSTOMER', 'DF42E2244C'), (3883, 1, 'SOLVED', 5, 7, 5, 'Peripheral Issue', '2009-08-17 07:37:31', 3, null, '2009-08-23 14:51:59', 'STAFF', '51F3EB940F'), (3884, 3, 'CLOSED', 6, 37, 4, 'WEB Mail Doubt', '2009-08-18 10:31:33', 3, null, '2009-08-22 18:54:59', 'STAFF', '8DCF2420E7'), (3885, 2, 'SOLVED', 1, 37, 4, 'WEB Mail Issue', '2009-08-18 06:47:05', 2, null, '2009-08-23 13:02:42', 'STAFF', '311ABB492A'), (3886, 2, 'SOLVED', 10, 6, 4, 'WEB Mail Doubt', '2009-08-18 07:53:22', 3, null, '2009-08-21 18:31:07', 'STAFF', '5DB60C9820'), (3887, 2, 'RETURNED', 10, 18, 5, 'Peripheral Doubt', '2009-08-18 09:39:53', 0, null, '2009-08-30 06:17:19', 'CUSTOMER', '9649DEC619'), (3888, 1, 'RETURNED', 8, 28, 4, 'WEB Mail Doubt', '2009-08-18 09:24:33', 0, null, '2009-09-03 06:45:04', 'CUSTOMER', '97250EB325'), (3889, 1, 'SOLVED', 7, 35, 1, 'CRM Application Doubt', '2009-08-18 12:20:58', 3, null, '2009-08-25 13:03:34', 'STAFF', '86098EF82C'), (3890, 3, 'SOLVED', 9, 40, 4, 'WEB Mail Doubt', '2009-08-18 12:18:52', 3, null, '2009-08-22 17:20:11', 'STAFF', 'CBFE568136'), (3891, 2, 'SOLVED', 2, 19, 2, 'WEB Site Issue', '2009-08-18 09:14:46', 4, null, '2009-08-29 15:53:04', 'STAFF', 'C2C2A04512'), (3892, 2, 'UNASSIGNED', 6, 33, 5, 'Peripheral Issue', '2009-08-18 10:06:40', 0, null, '2009-08-18 10:06:40', 'CUSTOMER', 'FB0650FF38'), (3893, 1, 'RETURNED', 6, 15, 5, 'Peripheral Issue', '2009-08-18 08:12:15', 0, null, '2009-08-18 08:12:15', 'CUSTOMER', 'E8D66338FA'), (3894, 2, 'SOLVED', 9, 6, 4, 'WEB Mail Doubt', '2009-08-18 10:35:57', 3, null, '2009-08-29 13:54:40', 'STAFF', '5C8E07660E'), (3895, 2, 'RETURNED', 1, 16, 5, 'Peripheral Doubt', '2009-08-18 07:46:54', 0, null, '2009-08-18 07:46:54', 'CUSTOMER', 'EE18846393'), (3896, 3, 'SOLVED', 9, 10, 5, 'Peripheral Issue', '2009-08-18 08:17:40', 4, null, '2009-09-02 17:31:30', 'STAFF', '4175F2EBB2'), (3897, 2, 'RETURNED', 10, 35, 2, 'WEB Site Issue', '2009-08-19 07:14:02', 0, null, '2009-08-24 09:35:43', 'CUSTOMER', 'B957D47523'), (3898, 1, 'RETURNED', 1, 31, 2, 'WEB Site Issue', '2009-08-19 10:51:55', 0, null, '2009-08-30 10:16:46', 'CUSTOMER', '37DB6BB5F1'), (3899, 2, 'REPLIED', 1, 27, 4, 'WEB Mail Issue', '2009-08-19 06:02:34', 0, null, '2009-08-20 18:41:01', 'STAFF', 'FD5AC6CE50'), (3900, 3, 'SOLVED', 1, 37, 6, 'Software Doubt', '2009-08-19 09:17:09', 3, null, '2009-08-28 14:08:13', 'STAFF', '4837BA5CD4'), (3901, 2, 'SOLVED', 10, 22, 4, 'WEB Mail Doubt', '2009-08-19 08:59:36', 2, null, '2009-08-29 15:50:03', 'STAFF', '4FC848051E'), (3902, 1, 'SOLVED', 10, 26, 5, 'Peripheral Doubt', '2009-08-19 08:43:35', 3, null, '2009-08-24 17:22:29', 'STAFF', '1517C8664B'), (3903, 2, 'RETURNED', 10, 20, 6, 'Software Doubt', '2009-08-19 06:45:45', 0, null, '2009-08-23 10:15:20', 'CUSTOMER', '9D949C3D8B'), (3904, 2, 'RETURNED', 3, 12, 5, 'Peripheral Doubt', '2009-08-19 06:33:43', 0, null, '2009-08-29 06:31:54', 'CUSTOMER', 'C09F9CAF5E'), (3905, 2, 'CLOSED', 6, 27, 4, 'WEB Mail Doubt', '2009-08-19 08:38:23', 1, null, '2009-08-30 15:34:25', 'STAFF', '63154D5661'), (3906, 1, 'SOLVED', 10, 17, 2, 'WEB Site Issue', '2009-08-19 11:06:45', 3, null, '2009-09-03 16:07:07', 'STAFF', 'E593C56235'), (3907, 3, 'SOLVED', 9, 36, 2, 'WEB Site Issue', '2009-08-20 08:03:15', 2, null, '2009-08-22 15:20:18', 'STAFF', '3341F6F048'), (3908, 1, 'CLOSED', 1, 8, 5, 'WEB Mail Doubt', '2009-08-20 10:53:45', 0, null, '2010-03-25 11:17:07', 'STAFF', '576D026223'), (3909, 1, 'REPLIED', 6, 21, 2, 'WEB Site Issue', '2009-08-20 06:07:03', 0, null, '2009-08-22 18:54:25', 'STAFF', '4175A4B46A'), (3910, 1, 'SOLVED', 5, 5, 3, 'Sales Doubt', '2009-08-20 12:41:25', 4, null, '2009-08-21 17:34:01', 'STAFF', '1BE883EEC3'), (3911, 2, 'SOLVED', 8, 37, 4, 'WEB Mail Doubt', '2009-08-20 06:35:30', 3, null, '2009-08-22 13:44:29', 'STAFF', '1BF50AAF14'), (3912, 3, 'CLOSED', 7, 10, 2, 'WEB Site Issue', '2009-08-20 06:42:36', 3, null, '2009-08-23 16:44:30', 'STAFF', '27B587BBE8'), (3913, 1, 'SOLVED', 2, 26, 6, 'Software Doubt', '2009-08-21 09:52:46', 4, null, '2009-09-09 16:24:12', 'STAFF', 'B085C4FA54'), (3914, 3, 'CLOSED', 9, 23, 5, 'Peripheral Issue', '2009-08-22 12:49:06', 1, null, '2009-08-22 18:17:44', 'STAFF', 'B85D65C39E'), (3915, 2, 'SOLVED', 10, 9, 5, 'Peripheral Issue', '2009-08-22 11:19:19', 3, null, '2009-08-26 16:53:14', 'STAFF', '39539F630A'), (3916, 1, 'RETURNED', 1, 25, 5, 'Peripheral Issue', '2009-08-22 11:14:34', 0, null, '2009-08-28 07:34:18', 'CUSTOMER', '49CBB75927'), (3917, 2, 'CLOSED', 2, 25, 5, 'Peripheral Doubt', '2009-08-22 07:39:59', 2, null, '2009-08-28 13:07:18', 'STAFF', '4D95D05A4F'), (3918, 1, 'SOLVED', 4, 5, 4, 'WEB Mail Doubt', '2009-08-22 07:15:39', 3, null, '2009-08-23 16:17:46', 'STAFF', '859B00AEC8'), (3919, 1, 'SOLVED', 1, 22, 3, 'Sales Doubt', '2009-08-22 11:14:09', 4, null, '2009-09-05 13:08:25', 'STAFF', '5FC7C9BD1F'), (3920, 2, 'SOLVED', 4, 30, 4, 'WEB Mail Issue', '2009-08-22 10:08:21', 4, null, '2009-09-12 13:47:59', 'STAFF', 'D6525AA863'), (3921, 3, 'SOLVED', 9, 38, 2, 'WEB Site Issue', '2009-08-22 12:50:32', 2, null, '2009-09-09 18:17:16', 'STAFF', '9B8F0779BA'), (3922, 1, 'SOLVED', 3, 23, 6, 'Software Doubt', '2009-08-22 11:32:04', 3, null, '2009-08-22 14:09:39', 'STAFF', 'D90E5B6628'), (3923, 1, 'REPLIED', 5, 5, 2, 'WEB Site Doubt', '2009-08-22 10:48:23', 0, null, '2009-08-30 18:42:50', 'STAFF', '97F081D3B1'), (3924, 2, 'CLOSED', 4, 35, 4, 'WEB Mail Issue', '2009-08-23 07:38:13', 3, null, '2009-08-29 18:24:22', 'STAFF', '943B5FD1EF'), (3925, 2, 'RETURNED', 9, 33, 6, 'Software Doubt', '2009-08-23 09:01:28', 0, null, '2009-09-01 06:02:48', 'CUSTOMER', '1340CCF247'), (3926, 2, 'SOLVED', 3, 17, 6, 'Software Issue', '2009-08-23 08:34:54', 3, null, '2009-08-26 18:58:59', 'STAFF', '4FC28B7093'), (3927, 2, 'SOLVED', 7, 35, 4, 'WEB Mail Doubt', '2009-08-23 06:41:31', 4, null, '2009-08-23 18:32:29', 'STAFF', 'D2DC636883'), (3928, 3, 'RETURNED', 1, 1, 1, 'CRM Application Doubt', '2009-08-23 09:03:41', 0, null, '2009-09-03 11:39:15', 'CUSTOMER', '1597D21403'), (3929, 2, 'SOLVED', 1, 22, 6, 'Software Issue', '2009-08-23 09:03:57', 3, null, '2009-08-30 16:34:14', 'STAFF', '79F6923035'), (3930, 1, 'RETURNED', 10, 37, 4, 'WEB Mail Issue', '2009-08-23 08:49:12', 0, null, '2009-09-04 11:12:55', 'CUSTOMER', '679D8BBD77'), (3931, 3, 'CLOSED', 9, 27, 5, 'Peripheral Issue', '2009-08-23 11:46:22', 3, null, '2009-08-23 17:35:25', 'STAFF', 'ACFF1AF62D'), (3932, 2, 'REPLIED', 1, 15, 6, 'Software Doubt', '2009-08-23 07:03:49', 0, null, '2012-05-11 02:38:07', 'STAFF', 'C56A022B15'), (3933, 2, 'UNASSIGNED', 8, 33, 1, 'CRM Application Doubt', '2009-08-23 11:03:03', 0, null, '2009-08-23 11:03:03', 'CUSTOMER', '298F587406'), (3934, 2, 'SOLVED', 8, 33, 2, 'WEB Site Issue', '2009-08-23 12:53:46', 4, null, '2009-09-02 15:04:38', 'STAFF', 'F8F122D50E'), (3935, 1, 'CLOSED', 8, 39, 2, 'WEB Site Issue', '2009-08-23 06:34:13', 3, null, '2009-08-25 15:18:19', 'STAFF', '13E36F06C6'), (3936, 1, 'CLOSED', 5, 35, 2, 'WEB Site Issue', '2009-08-23 08:10:28', 3, null, '2009-09-04 13:59:53', 'STAFF', '70FC5F0432'), (3937, 2, 'SOLVED', 1, 31, 5, 'Peripheral Issue', '2009-08-23 09:58:38', 2, null, '2009-08-28 15:02:24', 'STAFF', 3948684564), (3938, 2, 'SOLVED', 2, 15, 3, 'Sales Doubt', '2009-08-24 08:24:51', 2, null, '2009-09-02 14:04:21', 'STAFF', '74C407E263'), (3939, 2, 'RETURNED', 5, 36, 6, 'Software Doubt', '2009-08-24 10:25:55', 0, null, '2009-08-24 10:25:55', 'CUSTOMER', 'E5AFB0F2DB'), (3940, 1, 'SOLVED', 10, 5, 5, 'Peripheral Issue', '2009-08-24 10:49:13', 2, null, '2009-09-03 17:44:07', 'STAFF', '3FA146219C'), (3941, 2, 'SOLVED', 2, 18, 6, 'Software Doubt', '2009-08-24 12:44:26', 2, null, '2009-09-04 17:56:46', 'STAFF', '29E1C59BE1'), (3942, 2, 'CLOSED', 1, 2, 6, 'Software Issue', '2009-08-24 06:04:49', 1, null, '2009-09-10 15:31:04', 'STAFF', 'EC36E2BA64'), (3943, 3, 'SOLVED', 6, 17, 1, 'CRM Application Issue', '2009-08-24 08:38:53', 3, null, '2009-08-28 18:34:14', 'STAFF', 'DA21BAE82C'), (3944, 2, 'SOLVED', 2, 11, 5, 'Peripheral Doubt', '2009-08-24 10:15:29', 4, null, '2009-08-25 18:38:19', 'STAFF', 'F9FE83F1EA'), (3945, 2, 'SOLVED', 5, 22, 5, 'Peripheral Doubt', '2009-08-24 11:51:51', 4, null, '2009-09-02 14:34:35', 'STAFF', 'C3810D4A95'), (3946, 1, 'SOLVED', 2, 20, 4, 'WEB Mail Issue', '2009-08-24 12:08:22', 3, null, '2009-09-01 16:58:47', 'STAFF', '71A8B2FFE0'), (3947, 3, 'SOLVED', 2, 7, 3, 'Sales Doubt', '2009-08-24 09:19:43', 4, null, '2009-08-27 14:32:16', 'STAFF', 'DA4F21D00B'), (3948, 2, 'SOLVED', 5, 11, 2, 'WEB Site Issue', '2009-08-24 12:02:28', 2, null, '2009-08-25 14:20:38', 'STAFF', '6DF1825827'), (3949, 3, 'REPLIED', 10, 40, 6, 'Software Issue', '2009-08-25 09:49:44', 0, null, '2009-08-27 16:33:01', 'STAFF', '2E5C2CB8D1'), (3950, 2, 'REPLIED', 10, 7, 3, 'Sales Issue', '2009-08-25 11:34:17', 0, null, '2009-09-15 14:34:38', 'STAFF', 'BB702465F3'), (3951, 1, 'CLOSED', 2, 10, 4, 'WEB Mail Issue', '2009-08-25 12:26:30', 3, null, '2009-09-08 18:58:56', 'STAFF', '7F278AD602'), (3952, 3, 'UNASSIGNED', 9, 9, 3, 'Sales Doubt', '2009-08-25 11:13:19', 0, null, '2009-08-25 11:13:19', 'CUSTOMER', 'AF8D9C4E23'), (3953, 2, 'SOLVED', 7, 1, 6, 'Software Issue', '2009-08-25 09:04:13', 4, null, '2009-08-29 16:31:53', 'STAFF', 'B928FEC593'), (3954, 2, 'RETURNED', 10, 31, 4, 'WEB Mail Doubt', '2009-08-25 06:16:51', 0, null, '2009-09-05 10:23:54', 'CUSTOMER', '6E2D5D50A9'), (3955, 2, 'SOLVED', 1, 22, 6, 'Software Doubt', '2009-08-25 10:47:20', 4, null, '2009-09-04 14:45:59', 'STAFF', '3F900DB260'), (3956, 2, 'RETURNED', 3, 11, 4, 'WEB Mail Doubt', '2009-08-25 08:20:16', 0, null, '2009-09-03 07:02:55', 'CUSTOMER', '0F3C5D0C36'), (3957, 1, 'RETURNED', 3, 21, 6, 'Sotfware Issue', '2009-08-25 11:11:45', 0, null, '2009-09-01 11:12:50', 'CUSTOMER', '86C5167835'), (3958, 2, 'SOLVED', 2, 8, 6, 'Software Doubt', '2009-08-25 11:28:00', 4, null, '2009-08-25 13:00:29', 'STAFF', 'BF5CD8B250'), (3959, 2, 'SOLVED', 9, 31, 3, 'Sales Doubt', '2009-08-25 11:52:57', 3, null, '2009-09-03 18:31:18', 'STAFF', '806D926414'), (3960, 2, 'SOLVED', 10, 38, 4, 'WEB Mail Issue', '2009-08-26 09:11:47', 2, null, '2009-08-29 14:29:20', 'STAFF', 'AC52C626AF'), (3961, 2, 'SOLVED', 8, 28, 4, 'WEB Mail Issue', '2009-08-26 07:32:31', 2, null, '2009-09-10 15:43:55', 'STAFF', '24E01830D2'), (3962, 2, 'RETURNED', 5, 1, 5, 'Peripheral Issue', '2009-08-26 08:22:14', 0, null, '2009-10-29 15:21:48', 'CUSTOMER', '6F611188AD'), (3963, 2, 'SOLVED', 8, 31, 3, 'Sales Doubt', '2009-08-26 09:41:07', 3, null, '2009-09-04 13:39:10', 'STAFF', 'F51238CD02'), (3964, 3, 'SOLVED', 2, 15, 5, 'Peripheral Doubt', '2009-08-26 08:07:27', 3, null, '2009-08-26 15:07:36', 'STAFF', 'DD50E4D9C4'), (3965, 1, 'SOLVED', 7, 39, 5, 'Peripheral Issue', '2009-08-26 10:14:06', 3, null, '2009-09-01 16:47:22', 'STAFF', 'DB9AD56C71'), (3966, 2, 'SOLVED', 9, 11, 1, 'CRM Application Issue', '2009-08-26 12:42:01', 4, null, '2009-09-10 15:25:24', 'STAFF', '43D762CA73'), (3967, 2, 'SOLVED', 7, 5, 6, 'Software Issue', '2009-08-26 08:20:27', 3, null, '2009-09-04 16:17:11', 'STAFF', 'B607BA543A'), (3968, 2, 'SOLVED', 5, 32, 1, 'CRM Application Doubt', '2009-08-26 07:46:02', 4, null, '2009-09-10 16:12:20', 'STAFF', '0CBED40C0D'), (3969, 2, 'SOLVED', 3, 24, 1, 'CRM Application Issue', '2009-08-26 11:42:41', 3, null, '2009-09-04 17:31:21', 'STAFF', 'F81DEE4258'), (3970, 1, 'SOLVED', 4, 11, 3, 'Sales Doubt', '2009-08-26 12:16:52', 4, null, '2009-08-29 18:46:06', 'STAFF', '11BCD3C1D4'), (3971, 2, 'CLOSED', 4, 38, 6, 'Software Issue', '2009-08-29 07:58:38', 3, null, '2009-09-01 15:15:28', 'STAFF', 'CBA0A4EE5C'), (3972, 2, 'SOLVED', 2, 37, 4, 'WEB Mail Doubt', '2009-08-29 08:08:35', 4, null, '2009-09-02 13:08:46', 'STAFF', 'F2E84D98D6'), (3973, 2, 'RETURNED', 4, 24, 6, 'Software Doubt', '2009-08-29 06:09:13', 0, null, '2009-09-11 10:07:38', 'CUSTOMER', '678004486C'), (3974, 3, 'CLOSED', 10, 25, 2, 'WEB Site Issue', '2009-08-29 09:32:28', 1, null, '2009-09-05 14:44:59', 'STAFF', '9A32FF36C6'), (3975, 1, 'SOLVED', 3, 12, 5, 'Peripheral Issue', '2009-08-29 09:05:51', 4, null, '2009-09-04 16:27:22', 'STAFF', '4F5A9BF135');

-- ----------------------------
-- Table structure for "main"."ticketmessage"
-- ----------------------------

CREATE TABLE "ticketmessage" (
"ticketmessageid"  INTEGER NOT NULL,
"ticketid"  INTEGER NOT NULL,
"ticketdate"  datetime DEFAULT NULL,
"ticketcontent"  text COLLATE NOCASE,
"ticketfile1"  blob,
"ticketfile2"  blob,
"ticketfile3"  blob,
"operatorid"  INTEGER DEFAULT NULL,
"messagetype"  varchar(10) COLLATE NOCASE DEFAULT NULL,
"ticketfilename1"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"ticketfilename2"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"ticketfilename3"  varchar(100) COLLATE NOCASE DEFAULT NULL,
"statusid"  varchar(30) COLLATE NOCASE DEFAULT NULL,
"messagenote"  varchar(255) COLLATE NOCASE DEFAULT NULL,
PRIMARY KEY ("ticketmessageid", "ticketid"),
CONSTRAINT "ticketmessage_ibfk_3" FOREIGN KEY ("statusid") REFERENCES "ticketstatus" ("statusid"),
CONSTRAINT "ticketmessage_ibfk_1" FOREIGN KEY ("ticketid") REFERENCES "ticket" ("ticketid") ON DELETE CASCADE ON UPDATE CASCADE,
CONSTRAINT "ticketmessage_ibfk_2" FOREIGN KEY ("operatorid") REFERENCES "staff" ("staffid")
);

-- ----------------------------
-- Records of ticketmessage
-- ----------------------------
INSERT INTO "ticketmessage" VALUES (1, 1, '2008-03-01 11:29:30', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (2, 1, '2008-03-06 14:40:08', X'52756E20746865207363616E6469736B0A70726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (3, 1, '2008-03-07 09:59:28', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (4, 1, '2008-03-07 18:49:25', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (6, 1, '2008-03-14 14:40:08', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (7, 2, '2008-03-01 08:27:40', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (8, 2, '2008-03-02 17:34:42', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (9, 3, '2008-03-01 08:34:55', X'41636365737320746F2074686520736974650A6973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (10, 3, '2008-03-04 16:41:27', X'546869732061636F727265206475650A746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (11, 4, '2008-03-01 10:57:54', X'54686520776F72642070726F6772616D0A6973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (12, 4, '2008-03-04 16:03:55', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (14, 4, '2008-03-08 14:35:01', X'50726F766176616C6D656E746520616E0A6572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (16, 5, '2008-03-04 16:32:15', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (17, 6, '2008-03-01 08:43:03', X'49206D6164652061207061796D656E740A616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (18, 6, '2008-03-04 13:41:01', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (19, 7, '2008-03-02 07:33:45', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (20, 7, '2008-03-02 16:24:20', X'547279207570646174696E67207468650A636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (21, 8, '2008-03-02 12:18:02', X'492077616E7420746F206578706F72740A6D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (22, 8, '2008-03-03 16:14:08', X'436865636B207468652070726F6772616D0A6D656E7520746865206F7074696F6E20746F206578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (23, 9, '2008-03-02 11:03:03', X'437573746F6D65727320706167652069730A6E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (24, 9, '2008-03-04 17:25:28', X'5468652070726F626C656D206861730A6265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (26, 9, '2008-03-05 14:23:54', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (29, 10, '2008-03-09 09:55:31', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (30, 10, '2008-03-10 16:19:58', X'547279207570646174696E67207468650A636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (31, 10, '2008-03-14 11:17:22', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (32, 10, '2008-03-19 15:37:23', X'436865636B2074686520656E7472790A666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (33, 11, '2008-03-02 06:22:58', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (35, 11, '2008-03-06 08:50:02', X'4120667269656E6420736169642068650A73656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (36, 11, '2008-03-10 18:28:53', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (38, 12, '2008-03-07 15:57:13', X'50726F766176616C6D656E746520616E0A6572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (39, 12, '2008-03-11 10:33:43', X'492077616E7420746F206578706F72740A6D79204F75746C6F6F6B2066696C657320746F206376732E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (40, 12, '2008-03-14 17:04:41', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (41, 13, '2008-03-03 10:21:58', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (44, 13, '2008-03-10 17:17:36', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (45, 13, '2008-03-12 07:20:06', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (46, 13, '2008-03-15 14:10:13', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (47, 14, '2008-03-03 06:14:02', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (49, 14, '2008-03-09 06:44:45', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (50, 14, '2008-03-09 16:13:36', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (51, 15, '2008-03-03 06:48:03', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (52, 15, '2008-03-06 14:15:09', X'547279207570646174696E67207468650A636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (53, 16, '2008-03-03 08:57:55', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (54, 16, '2008-03-08 13:25:05', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (55, 16, '2008-03-12 12:58:22', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (57, 17, '2008-03-03 08:14:34', X'54686520776F72642070726F6772616D0A6973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (58, 17, '2008-03-03 16:54:05', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (60, 17, '2008-03-11 17:07:29', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (62, 18, '2008-03-08 15:41:48', X'50726F766176616C6D656E746520616E0A6572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (64, 18, '2008-03-14 13:33:06', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (65, 18, '2008-03-17 09:28:00', X'492077616E7420746F206578706F72740A6D79204F75746C6F6F6B2066696C657320746F206376732E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (66, 18, '2008-03-19 16:34:42', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (67, 19, '2008-03-04 10:22:22', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (68, 19, '2008-03-06 18:31:43', X'547279207570646174696E67207468650A636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (69, 20, '2008-03-04 12:32:58', X'492077616E7420746F2063616E63656C0A6D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (70, 20, '2008-03-09 13:11:29', X'546F2063616E63656C20796F75720A6F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (71, 21, '2008-03-04 07:28:24', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (72, 21, '2008-03-05 17:14:41', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (73, 22, '2008-03-04 06:24:00', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (74, 22, '2008-03-04 14:08:01', X'5468652070726F626C656D206861730A6265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (75, 23, '2008-03-04 11:27:57', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (76, 23, '2008-03-07 16:51:37', X'52756E20746865207363616E6469736B0A70726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (78, 23, '2008-03-12 15:07:03', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (79, 24, '2008-03-04 07:58:18', X'486F7720746F20636C6173736966790A74686520637573746F6D65722062790A7072696F726974793F', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (80, 24, '2008-03-07 18:16:35', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (81, 24, '2008-03-08 11:31:50', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (82, 24, '2008-03-09 17:02:21', X'54686973207265706F72742063616E0A6E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (83, 24, '2008-03-11 12:50:23', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (84, 24, '2008-03-13 14:11:34', X'547279207570646174696E67207468650A636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (85, 25, '2008-03-05 12:32:18', X'4120667269656E6420736169642068650A73656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (86, 25, '2008-03-06 14:26:41', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (89, 27, '2008-03-07 12:40:04', X'4120667269656E6420736169642068650A73656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (90, 27, '2008-03-08 18:45:06', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (91, 27, '2008-03-11 07:37:16', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (93, 27, '2008-03-15 09:28:50', X'492063616E206E6F74206F70656E20610A6D657373616765206174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (94, 27, '2008-03-17 14:06:10', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (95, 28, '2008-03-07 09:31:36', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (96, 28, '2008-03-10 14:20:41', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (97, 28, '2008-03-13 11:51:52', X'492077616E7420746F2063616E63656C0A6D79206F72646572206E756D6265722032323131333132312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (98, 28, '2008-03-15 17:30:44', X'546F2063616E63656C20796F75720A6F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (99, 28, '2008-03-16 06:05:29', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (101, 29, '2008-03-07 11:05:07', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (102, 29, '2008-03-10 16:19:03', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (103, 29, '2008-03-13 08:17:37', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (104, 29, '2008-03-15 15:32:31', X'54686973207265706F72742063616E0A6E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (105, 29, '2008-03-19 09:40:53', X'486F7720746F20636C6173736966790A74686520637573746F6D6572206279207072696F726974793F', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (106, 29, '2008-03-24 17:24:01', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (107, 30, '2008-03-07 07:07:10', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (108, 30, '2008-03-08 16:22:28', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (111, 31, '2008-03-13 11:42:26', X'486F7720746F20636C6173736966790A74686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (112, 31, '2008-03-18 17:15:17', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (113, 32, '2008-03-07 06:29:28', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (114, 32, '2008-03-10 18:48:35', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (115, 32, '2008-03-11 10:33:38', X'492077616E74206B6E6F77207468650A6E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (116, 32, '2008-03-14 16:32:00', X'4F6E6C792061742074686520656E640A6F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (117, 33, '2008-03-07 06:02:34', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (118, 33, '2008-03-07 17:31:41', X'546869732061636F727265206475650A746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (119, 34, '2008-03-07 12:07:45', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (120, 34, '2008-03-09 15:56:39', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (121, 34, '2008-03-12 08:38:28', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (122, 34, '2008-03-16 18:04:50', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (123, 35, '2008-03-08 09:57:45', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (124, 35, '2008-03-12 13:47:58', X'546F2063616E63656C20796F75720A6F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (125, 35, '2008-03-13 08:43:34', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (127, 35, '2008-03-19 10:36:19', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (128, 35, '2008-03-20 17:44:54', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (129, 36, '2008-03-08 06:25:18', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (130, 36, '2008-03-12 13:59:47', X'436865636B2074686520656E7472790A666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (131, 37, '2008-03-08 08:59:34', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (132, 37, '2008-03-10 16:32:47', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (133, 37, '2008-03-13 10:54:54', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (134, 37, '2008-03-17 16:44:37', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (135, 38, '2008-03-08 09:07:55', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (137, 39, '2008-03-09 06:37:09', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (138, 39, '2008-03-11 17:18:10', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 3, 'RESPONSE', null, null, null, 'CLOSED', ''), (139, 40, '2008-03-09 10:05:48', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (140, 40, '2008-03-11 14:43:27', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (141, 41, '2008-03-09 06:49:20', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (142, 41, '2008-03-09 17:30:34', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (143, 41, '2008-03-10 06:36:37', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (144, 41, '2008-03-12 15:54:29', X'54686973207265706F72742063616E0A6E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (146, 41, '2008-03-20 17:22:57', X'496E20746865205265706F7274730A6D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (148, 42, '2008-03-14 16:10:07', X'506C656173652C207472790A7265696E7374616C6C696E67207468650A70726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (149, 42, '2008-03-17 11:53:11', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (150, 42, '2008-03-20 13:23:01', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (151, 43, '2008-03-09 10:39:45', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (152, 43, '2008-03-10 17:40:42', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (153, 43, '2008-03-13 11:28:46', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (154, 43, '2008-03-18 13:38:19', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (155, 44, '2008-03-09 07:13:18', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (156, 44, '2008-03-09 15:02:22', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (157, 45, '2008-03-09 08:00:10', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (159, 46, '2008-03-09 11:47:54', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (160, 46, '2008-03-13 14:19:13', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (161, 46, '2008-03-16 07:02:16', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (162, 46, '2008-03-16 15:20:32', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (163, 46, '2008-03-17 06:49:08', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (165, 47, '2008-03-09 06:31:25', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (166, 47, '2008-03-09 15:30:49', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (167, 48, '2008-03-09 06:00:42', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (168, 48, '2008-03-13 16:55:16', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (169, 48, '2008-03-15 07:21:12', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (170, 48, '2008-03-16 13:48:52', X'546F2063616E63656C20796F75720A6F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (172, 49, '2008-03-13 17:02:23', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (173, 50, '2008-03-10 08:47:08', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (175, 50, '2008-03-15 09:45:25', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (176, 50, '2008-03-18 13:59:04', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (177, 50, '2008-03-20 11:52:44', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (178, 50, '2008-03-21 14:36:36', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (179, 51, '2008-03-10 08:06:18', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (181, 52, '2008-03-10 11:51:52', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (183, 52, '2008-03-16 06:35:26', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (184, 52, '2008-03-18 14:54:54', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (185, 52, '2008-03-19 11:50:22', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (186, 52, '2008-03-20 14:55:06', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (187, 53, '2008-03-10 06:28:07', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (188, 53, '2008-03-11 17:12:28', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (189, 53, '2008-03-12 07:25:05', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (190, 53, '2008-03-13 17:59:20', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (191, 53, '2008-03-16 08:40:31', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (193, 54, '2008-03-10 09:11:15', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (194, 54, '2008-03-14 15:26:41', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (195, 55, '2008-03-10 11:02:11', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (196, 55, '2008-03-11 15:15:25', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (197, 55, '2008-03-13 08:00:24', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (198, 55, '2008-03-15 14:01:46', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (199, 56, '2008-03-11 08:12:06', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (201, 56, '2008-03-14 11:04:42', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (202, 56, '2008-03-15 18:32:19', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (203, 57, '2008-03-11 09:44:57', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (204, 57, '2008-03-16 15:59:36', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (206, 58, '2008-03-14 18:50:26', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (208, 59, '2008-03-12 18:56:38', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (210, 59, '2008-03-17 17:32:11', X'506C656173652C207472790A7265696E7374616C6C696E67207468650A70726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (211, 59, '2008-03-22 11:55:53', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (212, 59, '2008-03-24 17:09:09', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (213, 60, '2008-03-12 06:29:08', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (215, 60, '2008-03-17 06:01:35', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (216, 60, '2008-03-17 18:17:21', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (217, 60, '2008-03-19 09:02:27', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (218, 60, '2008-03-20 17:57:38', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (219, 61, '2008-03-14 10:11:42', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (221, 61, '2008-03-18 07:27:53', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (222, 61, '2008-03-23 16:40:10', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (223, 62, '2008-03-14 12:15:06', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (225, 62, '2008-03-21 09:31:41', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (226, 62, '2008-03-22 14:19:16', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (227, 62, '2008-03-24 09:00:17', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (228, 62, '2008-03-24 15:50:15', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (229, 63, '2008-03-14 09:08:28', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (230, 63, '2008-03-19 17:14:14', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (231, 64, '2008-03-14 10:31:35', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (232, 64, '2008-03-16 17:27:39', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (233, 64, '2008-03-18 12:50:37', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (234, 64, '2008-03-22 16:36:46', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (235, 65, '2008-03-14 06:32:40', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (237, 66, '2008-03-14 08:55:11', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (238, 66, '2008-03-17 16:18:35', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (239, 66, '2008-03-21 10:28:52', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (241, 66, '2008-03-26 10:40:35', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (242, 66, '2008-03-30 17:33:54', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (244, 67, '2008-03-18 13:13:45', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (245, 67, '2008-03-20 08:25:35', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (246, 67, '2008-03-20 14:10:14', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (247, 68, '2008-03-14 12:57:35', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (248, 68, '2008-03-14 18:08:14', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (250, 68, '2008-03-20 16:34:36', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (251, 68, '2008-03-21 07:03:06', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (252, 68, '2008-03-25 18:16:29', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (253, 69, '2008-03-15 09:27:27', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (254, 69, '2008-03-15 18:43:37', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (255, 70, '2008-03-15 10:15:17', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (256, 70, '2008-03-16 16:13:45', X'54686973207265706F72742063616E0A6E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (257, 70, '2008-03-20 12:21:27', X'486F7720746F20636C6173736966790A74686520637573746F6D6572206279207072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (258, 70, '2008-03-22 13:16:18', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (259, 70, '2008-03-23 08:44:34', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (260, 70, '2008-03-23 18:33:24', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (261, 71, '2008-03-15 12:50:57', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (262, 71, '2008-03-18 16:33:36', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (263, 71, '2008-03-20 11:35:02', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (265, 72, '2008-03-15 11:29:09', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (266, 72, '2008-03-20 18:54:05', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (268, 72, '2008-03-21 13:54:50', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (269, 72, '2008-03-26 07:38:13', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (270, 72, '2008-03-28 17:41:36', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (271, 73, '2008-03-15 09:15:43', X'492077616E74206B6E6F77207468650A6E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (272, 73, '2008-03-16 18:16:38', X'4F6E6C792061742074686520656E640A6F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (274, 74, '2008-03-16 16:32:38', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (275, 74, '2008-03-21 07:25:49', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (276, 74, '2008-03-21 15:18:52', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (277, 75, '2008-03-16 12:12:27', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (278, 75, '2008-03-17 15:51:46', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (280, 75, '2008-03-20 17:01:43', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (281, 75, '2008-03-21 12:59:51', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (282, 75, '2008-03-26 17:42:51', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (283, 76, '2008-03-16 10:28:25', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (284, 76, '2008-03-17 14:57:28', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (285, 77, '2008-03-16 10:46:02', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (286, 77, '2008-03-20 14:49:06', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (287, 77, '2008-03-23 07:52:57', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (289, 77, '2008-03-28 06:01:32', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (290, 77, '2008-03-30 18:55:56', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (291, 78, '2008-03-16 10:03:22', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (292, 78, '2008-03-19 14:40:10', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (293, 78, '2008-03-20 09:02:07', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (294, 78, '2008-03-22 14:56:35', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (296, 79, '2008-03-18 15:31:12', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (297, 79, '2008-03-23 08:26:48', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (298, 79, '2008-03-28 13:16:02', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (299, 79, '2008-03-29 12:24:02', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (300, 79, '2008-04-01 18:39:56', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (301, 80, '2008-03-16 07:38:37', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (302, 80, '2008-03-21 13:47:24', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (304, 81, '2008-03-18 15:40:42', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (305, 81, '2008-03-22 12:49:44', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (306, 81, '2008-03-25 17:26:17', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (307, 82, '2008-03-16 06:49:29', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (308, 82, '2008-03-16 17:01:36', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (309, 83, '2008-03-16 08:14:05', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (310, 83, '2008-03-19 13:40:01', X'4D616B6520737572652074686572650A697320656E6F756768207370616365206F6E206469736B2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (311, 84, '2008-03-16 11:59:30', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (313, 84, '2008-03-21 08:19:50', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (314, 84, '2008-03-26 16:11:30', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (315, 85, '2008-03-17 11:53:43', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (317, 85, '2008-03-21 12:15:50', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (318, 85, '2008-03-22 13:41:51', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (319, 86, '2008-03-17 11:08:52', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (320, 86, '2008-03-17 16:12:31', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (322, 86, '2008-03-22 15:50:14', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (324, 86, '2008-03-26 15:43:46', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (326, 87, '2008-03-19 18:02:55', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (327, 87, '2008-03-21 09:17:56', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (328, 87, '2008-03-23 15:40:35', X'546869732061636F727265206475650A746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (329, 87, '2008-03-28 07:07:53', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (331, 88, '2008-03-17 08:10:47', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (332, 88, '2008-03-19 14:47:26', X'546869732061636F727265206475650A746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (333, 89, '2008-03-17 08:18:45', X'4D79206261747465727920646F65730A6E6F742063686172676520616E79206D6F72652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (334, 89, '2008-03-17 16:39:32', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (335, 89, '2008-03-20 07:28:00', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (336, 89, '2008-03-24 16:55:30', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (337, 89, '2008-03-27 09:55:56', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (338, 89, '2008-03-30 16:41:36', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (341, 90, '2008-03-18 10:57:47', X'486F7720746F20636C6173736966790A74686520637573746F6D6572206279207072696F726974793F', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (342, 90, '2008-03-23 18:20:53', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (343, 90, '2008-03-25 08:04:20', X'492063616E206E6F7420656E7472790A6D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (344, 90, '2008-03-26 15:26:20', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (345, 91, '2008-03-18 10:29:52', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (346, 91, '2008-03-19 13:13:34', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (347, 91, '2008-03-20 11:40:45', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (349, 91, '2008-03-26 06:48:34', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (350, 91, '2008-03-30 17:14:16', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (351, 92, '2008-03-18 11:47:43', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (354, 93, '2008-03-18 18:59:50', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (355, 93, '2008-03-19 10:20:19', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (358, 93, '2008-03-26 15:07:53', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (360, 94, '2008-03-20 16:02:05', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (362, 94, '2008-03-22 13:57:52', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (363, 94, '2008-03-27 12:26:08', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (364, 94, '2008-03-31 13:41:46', X'546869732061636F727265206475650A746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (365, 95, '2008-03-19 10:03:58', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (366, 95, '2008-03-21 18:54:24', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (368, 95, '2008-03-26 14:52:31', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (369, 95, '2008-03-27 10:23:32', X'492063616EC2B47420777269746520610A66696C6520696E20506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (370, 95, '2008-03-27 18:23:27', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (371, 96, '2008-03-20 09:39:40', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (373, 96, '2008-03-25 08:42:58', X'4D79206465736B746F7020646F65730A6E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (374, 96, '2008-03-28 13:01:29', X'4D616B6520737572652069742069730A70726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (376, 97, '2008-03-25 15:03:31', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (378, 97, '2008-04-02 17:57:34', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (379, 98, '2008-03-21 08:15:42', X'492063616EC2B4742073796E63206D790A6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (381, 98, '2008-03-26 08:54:51', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (382, 98, '2008-03-26 15:35:22', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (383, 98, '2008-03-28 06:32:39', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (384, 98, '2008-03-29 17:10:05', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (385, 99, '2008-03-21 11:21:54', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (386, 99, '2008-03-26 17:23:42', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (387, 99, '2008-03-28 12:40:59', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (388, 99, '2008-03-30 17:48:28', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (389, 99, '2008-04-03 08:53:29', X'492077616E74206B6E6F77207468650A6E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (390, 99, '2008-04-03 14:35:33', X'4F6E6C792061742074686520656E640A6F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (391, 100, '2008-03-21 12:43:17', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (392, 100, '2008-03-24 16:16:12', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (393, 100, '2008-03-29 12:02:28', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (395, 100, '2008-04-02 06:00:28', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (396, 100, '2008-04-06 18:23:55', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (398, 101, '2008-03-25 18:33:27', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (399, 102, '2008-03-21 06:37:39', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (400, 102, '2008-03-21 18:41:59', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (401, 102, '2008-03-22 11:11:22', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (403, 102, '2008-03-31 10:31:52', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (404, 102, '2008-04-02 17:58:14', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (405, 103, '2008-03-21 08:45:42', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (406, 103, '2008-03-23 13:40:06', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (407, 103, '2008-03-26 06:58:36', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (409, 103, '2008-03-28 10:50:00', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (410, 103, '2008-03-29 18:06:26', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (411, 104, '2008-03-21 07:19:50', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (412, 104, '2008-03-22 18:55:43', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (413, 104, '2008-03-23 06:10:33', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (414, 104, '2008-03-27 14:27:31', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (417, 105, '2008-03-22 08:36:26', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (418, 105, '2008-03-26 17:13:56', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (420, 105, '2008-04-02 15:27:28', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (421, 105, '2008-04-03 11:24:48', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (423, 106, '2008-03-22 07:48:27', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (424, 106, '2008-03-24 16:56:14', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (425, 106, '2008-03-28 12:02:58', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (428, 106, '2008-04-05 14:30:25', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (429, 107, '2008-03-22 06:40:26', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (430, 107, '2008-03-27 14:48:49', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (432, 107, '2008-04-05 13:36:05', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (433, 107, '2008-04-08 10:33:40', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (434, 107, '2008-04-10 14:36:17', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (436, 108, '2008-03-24 14:23:19', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (437, 108, '2008-03-26 07:25:16', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (438, 108, '2008-03-26 18:21:04', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (439, 109, '2008-03-22 07:19:09', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (440, 109, '2008-03-24 17:50:47', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (441, 109, '2008-03-26 08:27:22', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (444, 109, '2008-04-04 13:59:01', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (445, 110, '2008-03-23 10:10:08', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (446, 110, '2008-03-24 18:24:27', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (448, 110, '2008-03-28 15:55:10', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (449, 110, '2008-04-01 06:45:24', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (450, 110, '2008-04-03 13:50:47', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (451, 111, '2008-03-23 12:26:29', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (454, 111, '2008-04-05 15:42:47', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (455, 111, '2008-04-10 07:58:06', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (456, 111, '2008-04-15 18:13:38', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (458, 112, '2008-03-27 18:04:09', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (459, 113, '2008-03-23 10:04:59', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (460, 113, '2008-03-26 15:17:13', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (461, 114, '2008-03-23 11:09:24', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (463, 114, '2008-03-31 07:01:28', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (464, 114, '2008-04-02 13:46:50', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (466, 115, '2008-03-24 17:08:30', X'496E20746865205265706F7274730A6D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (469, 115, '2008-04-03 10:59:34', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (470, 115, '2008-04-06 15:56:13', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (471, 116, '2008-03-23 12:58:33', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (473, 117, '2008-03-24 06:14:08', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (474, 117, '2008-03-29 18:23:43', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (475, 117, '2008-04-01 08:17:52', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (477, 117, '2008-04-07 10:06:32', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (478, 117, '2008-04-09 18:46:08', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (480, 118, '2008-03-29 14:56:36', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (481, 119, '2008-03-24 10:08:17', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (483, 120, '2008-03-24 11:58:52', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (484, 120, '2008-03-26 17:30:45', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (485, 120, '2008-03-27 06:15:35', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (486, 120, '2008-03-28 18:30:15', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (487, 120, '2008-03-31 08:33:18', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (490, 121, '2008-03-27 18:47:37', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (491, 121, '2008-04-01 07:32:30', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (492, 121, '2008-04-06 18:25:12', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (493, 122, '2008-03-25 09:32:23', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (496, 122, '2008-03-29 18:23:28', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (497, 122, '2008-04-02 06:11:27', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (498, 122, '2008-04-05 14:57:42', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (500, 123, '2008-03-25 16:43:46', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (501, 123, '2008-03-29 09:27:19', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (502, 123, '2008-03-31 17:35:36', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (504, 123, '2008-04-05 13:44:42', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (505, 124, '2008-03-25 09:34:58', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (507, 124, '2008-03-28 12:47:41', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (508, 124, '2008-03-30 14:07:37', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (509, 125, '2008-03-25 10:24:40', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (510, 125, '2008-03-26 13:15:25', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (512, 126, '2008-03-31 14:46:24', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (514, 126, '2008-04-06 13:58:02', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (515, 126, '2008-04-08 07:41:46', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (516, 126, '2008-04-10 15:07:59', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (517, 127, '2008-03-26 10:24:23', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (518, 127, '2008-03-28 16:32:24', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (519, 128, '2008-03-26 08:55:48', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (520, 128, '2008-03-27 16:31:34', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (522, 128, '2008-03-29 14:13:28', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (523, 128, '2008-04-01 07:00:13', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (524, 128, '2008-04-05 18:08:09', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (525, 129, '2008-03-26 11:13:41', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (526, 129, '2008-03-31 13:33:32', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (527, 129, '2008-04-04 08:02:47', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (530, 130, '2008-03-29 14:51:49', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (531, 130, '2008-03-31 12:08:06', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (532, 130, '2008-03-31 13:04:16', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (533, 130, '2008-04-05 07:47:40', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (534, 130, '2008-04-08 15:11:22', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (536, 131, '2008-03-27 16:28:11', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (537, 131, '2008-04-01 06:27:01', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (538, 131, '2008-04-05 15:23:16', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (540, 131, '2008-04-11 18:57:40', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (541, 132, '2008-03-28 10:40:00', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (542, 132, '2008-03-29 13:38:31', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (543, 132, '2008-03-30 06:54:38', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (544, 132, '2008-03-31 18:52:15', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (546, 132, '2008-04-03 18:20:14', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (547, 133, '2008-03-28 06:13:08', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (548, 133, '2008-03-28 13:23:23', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (549, 133, '2008-03-30 08:26:55', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (550, 133, '2008-04-03 17:48:56', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (551, 133, '2008-04-05 08:42:34', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (553, 134, '2008-03-28 07:14:28', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (554, 134, '2008-03-31 18:13:42', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (555, 135, '2008-03-28 10:01:52', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (556, 135, '2008-03-31 13:30:11', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (557, 135, '2008-04-04 10:49:32', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (558, 135, '2008-04-05 14:09:50', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (559, 135, '2008-04-07 08:53:17', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (561, 136, '2008-03-28 11:42:23', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (563, 136, '2008-04-03 12:14:22', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (564, 136, '2008-04-05 15:20:29', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (565, 137, '2008-03-28 11:34:03', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (566, 137, '2008-04-01 17:50:26', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (567, 137, '2008-04-02 06:19:58', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (568, 137, '2008-04-07 16:58:48', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (570, 137, '2008-04-14 13:12:31', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (572, 138, '2008-04-01 13:09:22', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (573, 139, '2008-03-29 08:11:19', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (574, 139, '2008-04-02 14:18:17', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (575, 140, '2008-03-29 10:01:15', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (576, 140, '2008-04-01 17:20:29', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (577, 141, '2008-03-29 12:49:51', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (578, 141, '2008-04-02 18:32:51', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (579, 142, '2008-03-29 06:57:04', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (580, 142, '2008-03-30 14:26:32', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (582, 143, '2008-04-03 18:31:49', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (584, 143, '2008-04-09 13:24:55', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (585, 143, '2008-04-11 06:22:07', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (586, 143, '2008-04-15 15:26:50', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (587, 144, '2008-03-30 11:39:44', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (588, 144, '2008-04-01 15:58:06', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (589, 144, '2008-04-03 06:34:38', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (590, 144, '2008-04-08 18:08:17', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (592, 144, '2008-04-16 18:26:01', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (593, 145, '2008-03-30 06:39:06', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (594, 145, '2008-03-31 13:21:33', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (595, 145, '2008-04-01 12:11:03', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (597, 145, '2008-04-11 08:12:12', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (598, 145, '2008-04-16 15:15:40', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (599, 146, '2008-03-30 08:23:51', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (600, 146, '2008-03-30 16:20:40', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (601, 146, '2008-04-03 12:05:27', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (603, 147, '2008-03-30 06:12:48', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (604, 147, '2008-04-02 13:50:18', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (605, 147, '2008-04-04 11:07:48', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (606, 147, '2008-04-08 16:47:21', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (608, 147, '2008-04-16 16:03:04', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (610, 148, '2008-04-02 18:34:33', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (612, 148, '2008-04-09 17:41:26', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (613, 148, '2008-04-10 09:11:53', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (614, 148, '2008-04-10 17:17:20', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (615, 149, '2008-03-30 10:21:35', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (616, 149, '2008-04-01 17:09:21', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (617, 150, '2008-03-30 10:16:47', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (618, 150, '2008-04-01 13:26:11', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (620, 151, '2008-04-01 17:46:51', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (621, 151, '2008-04-06 07:57:13', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (622, 151, '2008-04-08 15:31:59', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (623, 151, '2008-04-10 07:13:12', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (625, 152, '2008-03-31 10:04:44', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (627, 152, '2008-04-08 07:47:25', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', '');
INSERT INTO "ticketmessage" VALUES (628, 152, '2008-04-13 15:44:47', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (630, 153, '2008-04-03 16:18:11', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (631, 153, '2008-04-08 07:53:19', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (632, 153, '2008-04-09 14:10:06', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 3, 'RESPONSE', null, null, null, 'CLOSED', ''), (633, 154, '2008-03-31 11:22:22', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (635, 154, '2008-04-07 06:30:29', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (636, 154, '2008-04-10 16:42:49', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (637, 154, '2008-04-14 09:26:26', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (638, 154, '2008-04-16 16:37:01', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (639, 155, '2008-03-31 12:32:04', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (640, 155, '2008-04-03 18:53:51', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (642, 155, '2008-04-07 18:06:55', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (643, 156, '2008-03-31 09:40:34', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (646, 156, '2008-04-05 16:53:15', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (647, 157, '2008-03-31 10:57:13', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (648, 157, '2008-04-02 13:38:50', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (649, 158, '2008-03-31 10:51:41', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (650, 158, '2008-04-05 16:18:30', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (651, 158, '2008-04-10 10:02:04', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (652, 158, '2008-04-11 13:02:31', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (654, 159, '2008-04-01 15:22:47', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (656, 159, '2008-04-07 17:32:24', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (657, 160, '2008-04-01 07:42:02', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (658, 160, '2008-04-01 17:12:18', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (659, 160, '2008-04-05 06:30:34', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (661, 161, '2008-04-01 12:00:45', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (662, 161, '2008-04-03 17:50:10', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (663, 162, '2008-04-01 06:22:05', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (664, 162, '2008-04-03 16:21:38', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (665, 162, '2008-04-07 11:45:03', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (666, 162, '2008-04-11 18:29:45', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (667, 163, '2008-04-01 06:22:11', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (668, 163, '2008-04-06 13:55:46', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (670, 164, '2008-04-01 14:57:45', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (672, 164, '2008-04-07 14:54:52', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (673, 164, '2008-04-09 06:20:13', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (676, 165, '2008-04-04 13:53:37', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 3, 'RESPONSE', null, null, null, 'CLOSED', ''), (679, 167, '2008-04-02 06:00:23', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (680, 167, '2008-04-02 14:52:28', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (682, 167, '2008-04-06 14:40:36', X'496E20746865205265706F7274730A6D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (684, 168, '2008-04-06 13:30:44', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (685, 169, '2008-04-03 12:30:59', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (686, 169, '2008-04-08 15:37:02', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (687, 169, '2008-04-10 08:36:23', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (688, 169, '2008-04-12 15:12:55', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (690, 169, '2008-04-20 14:47:04', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (691, 170, '2008-04-03 06:28:08', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (692, 170, '2008-04-08 14:31:37', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (693, 171, '2008-04-04 07:59:05', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (694, 171, '2008-04-07 15:33:24', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (695, 171, '2008-04-09 08:04:24', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (696, 171, '2008-04-13 17:36:44', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (697, 172, '2008-04-04 06:36:53', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (698, 172, '2008-04-08 17:53:56', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (699, 172, '2008-04-10 07:41:51', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (701, 173, '2008-04-04 10:33:40', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (702, 173, '2008-04-09 18:31:40', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (703, 173, '2008-04-10 07:30:00', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (704, 173, '2008-04-13 16:14:42', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (705, 174, '2008-04-04 09:53:46', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (706, 174, '2008-04-09 13:36:53', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (707, 174, '2008-04-12 11:12:37', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (708, 174, '2008-04-12 18:43:43', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (709, 174, '2008-04-17 10:45:11', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (710, 174, '2008-04-22 15:45:04', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (711, 175, '2008-04-04 08:03:23', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (712, 175, '2008-04-04 13:07:26', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (713, 175, '2008-04-05 08:31:57', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (714, 175, '2008-04-10 15:12:14', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (715, 176, '2008-04-04 09:43:10', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (716, 176, '2008-04-04 17:49:09', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (718, 176, '2008-04-13 18:23:28', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (719, 177, '2008-04-05 07:20:53', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (720, 177, '2008-04-07 17:31:07', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (721, 177, '2008-04-08 06:17:56', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (722, 177, '2008-04-12 18:53:01', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (724, 177, '2008-04-19 15:14:10', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (726, 178, '2008-04-10 18:28:30', X'496E20746865205265706F7274730A6D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (727, 179, '2008-04-05 10:10:06', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (728, 179, '2008-04-09 17:56:38', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (730, 179, '2008-04-13 15:42:06', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (732, 179, '2008-04-22 14:55:30', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (733, 180, '2008-04-05 06:00:35', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (734, 180, '2008-04-09 18:27:37', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (735, 181, '2008-04-05 06:17:24', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (736, 181, '2008-04-09 14:46:34', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (737, 182, '2008-04-05 08:01:45', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (738, 182, '2008-04-10 17:09:04', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (739, 183, '2008-04-05 07:40:55', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (740, 183, '2008-04-05 16:16:21', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (743, 184, '2008-04-06 10:59:01', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (745, 184, '2008-04-13 08:04:58', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (746, 184, '2008-04-18 15:18:47', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (747, 184, '2008-04-21 12:14:38', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (748, 184, '2008-04-25 15:37:25', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (750, 185, '2008-04-08 16:17:14', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (751, 185, '2008-04-10 12:42:12', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (752, 185, '2008-04-11 18:24:34', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (753, 185, '2008-04-14 09:08:17', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (754, 185, '2008-04-14 18:26:22', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (755, 186, '2008-04-06 12:21:10', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (757, 186, '2008-04-13 06:37:05', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (758, 186, '2008-04-15 16:37:15', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (759, 187, '2008-04-06 10:27:02', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (760, 187, '2008-04-08 13:37:00', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (761, 188, '2008-04-06 09:17:58', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (763, 188, '2008-04-09 09:05:50', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (764, 188, '2008-04-11 15:51:50', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (765, 189, '2008-04-06 10:58:53', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (766, 189, '2008-04-08 17:45:42', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (767, 190, '2008-04-06 09:33:40', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (769, 191, '2008-04-06 07:01:58', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (770, 191, '2008-04-09 18:51:56', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (771, 191, '2008-04-13 06:14:35', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (773, 191, '2008-04-17 07:33:01', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (774, 191, '2008-04-20 14:31:21', X'546F2063616E63656C20796F75720A6F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (775, 192, '2008-04-06 10:41:04', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (777, 192, '2008-04-14 10:54:14', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (778, 192, '2008-04-16 17:10:14', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (779, 192, '2008-04-21 06:17:23', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (780, 192, '2008-04-24 15:10:40', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (781, 193, '2008-04-06 12:25:17', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (783, 194, '2008-04-06 11:35:42', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (784, 194, '2008-04-09 18:23:19', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (785, 194, '2008-04-12 06:54:34', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (787, 195, '2008-04-06 11:30:31', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (789, 196, '2008-04-06 10:39:13', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (790, 196, '2008-04-10 16:36:55', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (791, 196, '2008-04-11 12:36:03', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (793, 197, '2008-04-07 10:13:26', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (794, 197, '2008-04-07 18:20:03', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (795, 197, '2008-04-10 12:29:51', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (796, 197, '2008-04-11 17:33:06', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (797, 197, '2008-04-13 12:08:57', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (798, 197, '2008-04-17 18:55:41', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (799, 198, '2008-04-07 12:01:27', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (800, 198, '2008-04-08 15:57:42', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (801, 198, '2008-04-09 09:05:47', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (803, 198, '2008-04-18 06:21:33', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (804, 198, '2008-04-23 17:04:47', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (805, 199, '2008-04-07 09:47:28', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (806, 199, '2008-04-11 18:13:02', X'436865636B2074686520757365720A6D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (807, 199, '2008-04-14 10:32:44', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (808, 199, '2008-04-19 15:55:16', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (809, 200, '2008-04-07 10:21:09', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (810, 200, '2008-04-09 18:08:39', X'546F2063616E63656C20796F75720A6F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (811, 200, '2008-04-14 12:04:59', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (812, 200, '2008-04-17 13:01:59', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (813, 200, '2008-04-19 09:12:36', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (814, 200, '2008-04-23 17:05:51', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (815, 201, '2008-04-07 09:32:08', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (816, 201, '2008-04-08 13:25:51', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (817, 201, '2008-04-09 09:33:42', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (818, 201, '2008-04-11 15:59:09', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (819, 201, '2008-04-14 10:21:25', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (820, 201, '2008-04-15 14:21:18', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (821, 202, '2008-04-07 06:07:11', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (822, 202, '2008-04-11 15:33:49', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (823, 203, '2008-04-07 09:33:06', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (824, 203, '2008-04-09 18:49:48', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (826, 204, '2008-04-07 15:40:26', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (827, 205, '2008-04-07 12:46:55', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (828, 205, '2008-04-12 18:50:27', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (830, 205, '2008-04-18 14:43:59', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (831, 205, '2008-04-22 09:51:22', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (832, 205, '2008-04-23 18:41:42', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (833, 206, '2008-04-08 11:04:30', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (834, 206, '2008-04-10 14:04:00', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (836, 206, '2008-04-15 14:47:49', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (837, 206, '2008-04-19 12:38:07', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (839, 207, '2008-04-08 06:10:15', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (840, 207, '2008-04-12 16:51:55', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (841, 207, '2008-04-17 06:47:12', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (843, 207, '2008-04-23 10:58:57', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (844, 207, '2008-04-23 15:12:06', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (846, 208, '2008-04-12 17:35:08', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (847, 208, '2008-04-13 11:19:15', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (848, 208, '2008-04-15 18:01:42', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (849, 209, '2008-04-08 07:57:00', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (850, 209, '2008-04-12 14:05:25', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (852, 210, '2008-04-09 15:40:35', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (854, 210, '2008-04-13 17:47:06', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (855, 210, '2008-04-16 09:54:46', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (856, 210, '2008-04-17 15:53:22', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (857, 211, '2008-04-08 08:47:04', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (858, 211, '2008-04-12 17:11:58', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (860, 212, '2008-04-13 16:44:56', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (861, 212, '2008-04-17 12:08:11', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (862, 212, '2008-04-19 14:02:29', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (863, 213, '2008-04-08 06:57:11', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (864, 213, '2008-04-08 17:16:28', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (866, 213, '2008-04-13 17:30:02', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (867, 214, '2008-04-09 10:49:04', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (868, 214, '2008-04-13 16:40:20', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (870, 214, '2008-04-19 15:59:12', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (872, 214, '2008-04-23 16:02:23', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (873, 215, '2008-04-11 12:03:57', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (874, 215, '2008-04-13 14:16:42', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 3, 'RESPONSE', null, null, null, 'CLOSED', ''), (875, 216, '2008-04-11 06:40:25', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (876, 216, '2008-04-16 14:33:27', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (878, 216, '2008-04-25 14:37:52', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (879, 216, '2008-04-28 08:59:44', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (880, 216, '2008-04-28 14:49:17', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (881, 217, '2008-04-11 06:16:02', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (884, 217, '2008-04-21 16:00:03', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (885, 217, '2008-04-24 06:23:23', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (886, 217, '2008-04-24 13:19:00', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (887, 218, '2008-04-11 09:38:29', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (888, 218, '2008-04-11 14:08:53', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (889, 219, '2008-04-11 10:51:02', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (890, 219, '2008-04-11 15:50:16', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (891, 219, '2008-04-14 08:22:18', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (892, 219, '2008-04-19 15:54:04', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (893, 219, '2008-04-22 08:20:13', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (896, 220, '2008-04-15 15:26:04', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (898, 220, '2008-04-23 14:54:19', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (899, 221, '2008-04-11 08:09:41', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (900, 221, '2008-04-11 17:05:00', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (901, 221, '2008-04-16 10:12:39', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (902, 221, '2008-04-18 16:49:54', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (903, 221, '2008-04-22 11:37:24', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (904, 221, '2008-04-22 17:17:58', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (905, 222, '2008-04-11 06:01:47', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (906, 222, '2008-04-13 17:48:34', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (907, 222, '2008-04-15 12:37:01', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (908, 222, '2008-04-18 16:21:25', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (909, 222, '2008-04-21 07:34:32', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (911, 223, '2008-04-12 12:24:44', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (913, 223, '2008-04-14 11:48:52', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (914, 223, '2008-04-19 18:36:42', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (915, 224, '2008-04-12 11:22:21', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (916, 224, '2008-04-13 14:19:50', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (917, 224, '2008-04-14 08:58:14', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (919, 225, '2008-04-12 11:10:40', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (920, 225, '2008-04-14 14:00:22', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (921, 226, '2008-04-12 06:31:13', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (922, 226, '2008-04-12 16:08:19', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (923, 226, '2008-04-13 09:05:46', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (924, 226, '2008-04-16 16:05:36', X'546F2063616E63656C20796F75720A6F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (925, 226, '2008-04-20 06:33:36', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (926, 226, '2008-04-22 16:00:42', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (927, 227, '2008-04-12 09:40:53', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (929, 227, '2008-04-18 09:56:58', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (930, 227, '2008-04-19 13:41:29', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (931, 228, '2008-04-12 08:13:51', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (932, 228, '2008-04-15 14:30:22', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (933, 229, '2008-04-12 12:29:46', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (934, 229, '2008-04-15 14:14:14', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (935, 230, '2008-04-12 07:27:23', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (936, 230, '2008-04-13 17:25:38', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (937, 230, '2008-04-16 06:44:06', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (938, 230, '2008-04-16 16:46:46', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (939, 230, '2008-04-20 07:27:20', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (941, 231, '2008-04-12 09:17:23', X'4D79207573657220686173206E6F0A61636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (942, 231, '2008-04-12 13:42:58', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (946, 233, '2008-04-14 15:56:40', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (947, 234, '2008-04-13 07:31:01', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (948, 234, '2008-04-14 14:49:41', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (949, 234, '2008-04-16 06:11:55', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (950, 234, '2008-04-18 17:00:25', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (951, 235, '2008-04-13 12:15:27', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (952, 235, '2008-04-18 16:26:44', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (953, 235, '2008-04-22 11:39:43', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (954, 235, '2008-04-22 14:23:11', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (955, 235, '2008-04-26 10:54:34', X'546865206D6F75736520646F65730A6E6F74206D6F766520746F207468652073696465', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (957, 236, '2008-04-13 07:43:43', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (958, 236, '2008-04-13 16:24:51', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (960, 237, '2008-04-14 14:51:26', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (961, 237, '2008-04-17 11:31:10', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (962, 237, '2008-04-18 13:02:47', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (963, 238, '2008-04-13 06:55:22', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (964, 238, '2008-04-15 17:58:57', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (965, 238, '2008-04-16 06:21:33', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (966, 238, '2008-04-16 13:38:52', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (967, 238, '2008-04-21 11:54:09', X'54686520484420686173207468650A666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (968, 238, '2008-04-22 16:18:55', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (969, 239, '2008-04-13 09:07:58', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (971, 240, '2008-04-13 12:39:09', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (973, 240, '2008-04-22 09:05:30', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (974, 240, '2008-04-26 17:42:20', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (975, 241, '2008-04-13 09:55:39', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (976, 241, '2008-04-16 17:11:05', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (977, 241, '2008-04-21 07:04:05', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (978, 241, '2008-04-24 17:32:14', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (979, 242, '2008-04-13 11:16:43', X'437573746F6D65727320706167650A6973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (980, 242, '2008-04-17 16:58:06', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (982, 242, '2008-04-23 18:52:13', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (984, 242, '2008-04-25 15:10:03', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (985, 243, '2008-04-13 12:17:45', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (986, 243, '2008-04-13 16:10:05', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (988, 243, '2008-04-16 14:11:15', X'496E20746865205265706F7274730A6D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (989, 244, '2008-04-13 07:32:57', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (990, 244, '2008-04-17 18:09:15', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (991, 245, '2008-04-13 08:39:57', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (992, 245, '2008-04-18 13:28:22', X'4D616B65207375726520746869730A656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (993, 245, '2008-04-19 08:25:08', X'492063616E206E6F74206F70656E0A61206D657373616765206174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (994, 245, '2008-04-19 16:11:17', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (995, 246, '2008-04-13 09:32:03', X'437573746F6D6572732066696C650A646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (996, 246, '2008-04-18 15:32:34', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (997, 246, '2008-04-22 08:26:00', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (998, 246, '2008-04-26 17:44:52', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (1000, 247, '2008-04-17 16:36:21', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1002, 248, '2008-04-14 18:32:37', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1003, 249, '2008-04-14 08:32:27', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1004, 249, '2008-04-16 17:20:21', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (1006, 250, '2008-04-19 15:57:56', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1007, 251, '2008-04-14 11:58:41', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1009, 251, '2008-04-17 11:38:40', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1010, 251, '2008-04-19 14:14:45', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1012, 252, '2008-04-14 17:45:29', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1014, 253, '2008-04-16 17:29:34', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1015, 253, '2008-04-21 09:15:54', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1016, 253, '2008-04-21 18:31:45', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1017, 253, '2008-04-23 11:36:47', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1018, 253, '2008-04-25 17:28:27', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1020, 254, '2008-04-17 16:42:10', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (1022, 254, '2008-04-23 13:01:07', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (1023, 255, '2008-04-15 12:48:22', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1025, 255, '2008-04-23 06:50:59', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1026, 255, '2008-04-25 15:13:51', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (1027, 256, '2008-04-15 09:32:56', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1028, 256, '2008-04-17 18:46:04', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1029, 256, '2008-04-19 08:54:30', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1030, 256, '2008-04-23 15:08:55', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (1032, 257, '2008-04-15 15:42:58', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1033, 258, '2008-04-15 12:36:03', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1034, 258, '2008-04-15 17:07:54', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1036, 258, '2008-04-23 13:45:17', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1037, 259, '2008-04-15 09:45:02', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1038, 259, '2008-04-18 17:24:40', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1039, 259, '2008-04-19 06:16:57', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1040, 259, '2008-04-20 13:08:50', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1042, 260, '2008-04-16 18:29:10', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1043, 261, '2008-04-15 08:24:38', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1044, 261, '2008-04-17 17:06:09', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1046, 261, '2008-04-19 17:25:44', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1047, 261, '2008-04-23 08:32:33', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1049, 262, '2008-04-15 07:21:35', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1050, 262, '2008-04-18 17:13:06', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1053, 263, '2008-04-16 11:28:49', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1054, 263, '2008-04-19 18:03:57', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1055, 263, '2008-04-22 11:58:12', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1056, 263, '2008-04-23 18:12:09', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1057, 263, '2008-04-23 11:17:00', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1059, 264, '2008-04-16 10:02:39', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1061, 264, '2008-04-19 07:57:52', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1062, 264, '2008-04-22 16:09:02', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1063, 264, '2008-04-24 06:22:17', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1064, 264, '2008-04-27 17:56:39', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1065, 265, '2008-04-16 09:44:25', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1066, 265, '2008-04-16 15:00:40', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1070, 265, '2008-05-01 15:59:33', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1071, 266, '2008-04-16 08:48:23', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1072, 266, '2008-04-17 17:40:23', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1073, 266, '2008-04-18 12:45:19', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1076, 267, '2008-04-20 15:19:36', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1077, 267, '2008-04-23 12:45:39', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1078, 267, '2008-04-25 14:07:42', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1079, 268, '2008-04-18 11:54:45', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1080, 268, '2008-04-18 13:54:34', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1082, 268, '2008-04-21 17:21:20', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1083, 268, '2008-04-23 11:55:58', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1084, 268, '2008-04-24 14:07:28', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1086, 269, '2008-04-19 13:42:51', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1088, 270, '2008-04-22 14:00:09', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1090, 270, '2008-04-25 13:39:30', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1091, 270, '2008-05-01 06:42:36', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1092, 270, '2008-05-04 17:13:37', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1093, 271, '2008-04-18 06:47:38', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1095, 272, '2008-04-18 10:56:55', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1096, 272, '2008-04-20 16:29:51', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1098, 272, '2008-04-26 14:04:37', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1099, 273, '2008-04-18 06:23:44', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1100, 273, '2008-04-19 17:01:25', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1101, 274, '2008-04-18 08:02:53', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1102, 274, '2008-04-23 18:13:04', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1103, 274, '2008-04-26 12:03:10', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1104, 274, '2008-04-27 15:50:22', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1105, 275, '2008-04-19 06:10:52', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1108, 275, '2008-05-01 18:54:27', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1109, 276, '2008-04-19 06:32:43', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1110, 276, '2008-04-21 14:01:08', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1111, 276, '2008-04-23 11:43:57', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1112, 276, '2008-04-25 13:49:33', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1113, 276, '2008-04-26 06:17:49', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1116, 277, '2008-04-20 16:21:56', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1117, 277, '2008-04-21 11:13:26', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1118, 277, '2008-04-23 18:51:06', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1119, 277, '2008-04-23 09:23:47', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1120, 277, '2008-04-25 15:08:03', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1122, 278, '2008-04-23 13:57:37', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1123, 278, '2008-04-24 07:41:39', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1124, 278, '2008-04-26 13:06:02', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1125, 278, '2008-05-01 08:21:10', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1126, 278, '2008-05-02 13:16:43', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1127, 279, '2008-04-19 10:18:34', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1128, 279, '2008-04-22 17:34:54', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1129, 279, '2008-04-23 11:05:14', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (1131, 280, '2008-04-19 08:13:03', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1133, 280, '2008-04-27 06:52:22', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1134, 280, '2008-05-01 17:55:20', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (1136, 281, '2008-04-21 18:29:39', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1137, 282, '2008-04-19 07:26:25', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1138, 282, '2008-04-21 13:11:42', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1139, 283, '2008-04-20 09:17:57', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1140, 283, '2008-04-21 13:39:17', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1142, 284, '2008-04-20 16:19:38', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1143, 285, '2008-04-20 11:23:30', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1144, 285, '2008-04-22 14:44:15', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1145, 285, '2008-04-23 07:01:03', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1148, 285, '2008-04-28 17:59:57', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1149, 286, '2008-04-20 11:41:57', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1150, 286, '2008-04-21 16:58:07', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1151, 286, '2008-04-24 11:06:35', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1153, 287, '2008-04-20 07:34:01', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1154, 287, '2008-04-23 18:00:25', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1156, 287, '2008-04-25 14:02:01', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1157, 288, '2008-04-20 09:09:26', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1158, 288, '2008-04-22 16:09:42', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1160, 288, '2008-05-01 17:02:21', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1161, 289, '2008-04-20 11:25:13', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1163, 289, '2008-04-23 09:03:24', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1164, 289, '2008-04-27 15:16:46', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1166, 290, '2008-04-22 15:37:39', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1167, 290, '2008-04-23 07:53:36', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1168, 290, '2008-04-24 14:14:48', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1169, 290, '2008-04-27 08:31:53', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1170, 290, '2008-05-01 18:52:00', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1172, 291, '2008-04-23 18:19:27', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1173, 291, '2008-04-23 09:47:45', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1174, 291, '2008-04-23 15:04:09', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1175, 292, '2008-04-21 09:41:15', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1176, 292, '2008-04-23 15:02:09', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1177, 292, '2008-04-24 10:24:15', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1178, 292, '2008-04-26 14:54:26', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1179, 293, '2008-04-21 06:55:35', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1180, 293, '2008-04-22 13:24:32', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (1182, 294, '2008-04-23 14:41:15', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1183, 295, '2008-04-21 11:11:38', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1184, 295, '2008-04-21 13:26:51', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1185, 295, '2008-04-23 08:28:15', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1186, 295, '2008-04-23 17:13:27', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (1187, 296, '2008-04-21 07:26:51', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1188, 296, '2008-04-25 17:33:08', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1189, 296, '2008-04-27 06:30:26', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1190, 296, '2008-05-01 14:42:29', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1191, 297, '2008-04-21 07:05:51', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1192, 297, '2008-04-21 17:51:57', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1193, 297, '2008-04-25 06:59:33', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1195, 297, '2008-05-01 07:42:33', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1196, 297, '2008-05-01 13:11:27', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1197, 298, '2008-04-21 10:30:35', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1198, 298, '2008-04-21 14:17:26', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1200, 298, '2008-04-23 15:17:39', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1202, 299, '2008-04-23 16:06:59', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1203, 300, '2008-04-21 07:38:05', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1204, 300, '2008-04-23 13:07:08', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1207, 300, '2008-05-01 10:57:59', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1208, 300, '2008-05-04 13:44:20', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1209, 301, '2008-04-21 08:09:26', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1210, 301, '2008-04-22 18:46:49', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1211, 301, '2008-04-23 12:44:35', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1212, 301, '2008-04-27 18:49:33', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1213, 301, '2008-05-03 06:31:00', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1216, 302, '2008-04-26 13:32:51', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1217, 302, '2008-05-01 09:54:24', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1219, 303, '2008-04-22 07:47:00', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1220, 303, '2008-04-26 18:20:14', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1221, 303, '2008-05-01 08:24:45', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1224, 303, '2008-05-04 18:08:16', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1225, 304, '2008-04-22 08:31:01', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1226, 304, '2008-04-25 16:30:21', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1228, 304, '2008-05-01 16:53:58', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1229, 304, '2008-05-04 12:55:32', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1230, 304, '2008-05-06 17:05:47', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1231, 305, '2008-04-22 11:18:10', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1232, 305, '2008-04-24 17:01:07', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1233, 305, '2008-04-27 06:12:55', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1234, 305, '2008-05-02 18:37:21', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1235, 305, '2008-05-04 09:55:01', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1236, 305, '2008-05-05 18:23:31', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1238, 306, '2008-04-25 16:56:15', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1240, 306, '2008-05-04 16:40:03', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1241, 307, '2008-04-22 06:12:57', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1242, 307, '2008-04-26 18:13:16', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1243, 308, '2008-04-22 12:52:57', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1244, 308, '2008-04-24 18:40:03', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1245, 308, '2008-04-28 09:17:13', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1246, 308, '2008-05-02 13:38:08', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1247, 309, '2008-04-22 09:12:19', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1248, 309, '2008-04-22 17:03:48', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1249, 309, '2008-04-23 11:18:07', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1251, 309, '2008-04-27 12:06:22', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1252, 309, '2008-04-27 18:12:52', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1253, 310, '2008-04-23 11:40:32', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1254, 310, '2008-04-24 14:02:14', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1255, 310, '2008-04-27 08:18:43', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1256, 310, '2008-04-28 18:12:16', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1258, 310, '2008-05-05 14:08:06', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', '');
INSERT INTO "ticketmessage" VALUES (1259, 311, '2008-04-23 11:41:10', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1260, 311, '2008-04-25 13:15:24', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (1261, 312, '2008-04-23 10:04:06', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1262, 312, '2008-04-24 16:03:30', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1263, 312, '2008-04-27 06:51:19', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1264, 312, '2008-05-01 18:42:40', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1265, 313, '2008-04-23 11:32:43', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1266, 313, '2008-04-23 15:16:22', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1267, 313, '2008-04-25 08:46:44', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1268, 313, '2008-04-27 18:58:53', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1270, 314, '2008-04-24 18:39:48', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1271, 314, '2008-04-27 08:26:35', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1272, 314, '2008-04-28 13:24:49', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1273, 315, '2008-04-25 12:06:54', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1274, 315, '2008-04-25 14:26:58', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1275, 316, '2008-04-25 09:09:46', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1276, 316, '2008-04-27 16:57:23', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1277, 316, '2008-05-01 11:18:00', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1278, 316, '2008-05-04 14:36:08', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1279, 317, '2008-04-25 10:20:56', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1280, 317, '2008-05-01 18:58:51', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1281, 317, '2008-05-03 08:49:42', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1282, 317, '2008-05-03 13:30:49', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1284, 317, '2008-05-06 18:59:49', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1285, 318, '2008-04-25 06:42:46', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1287, 318, '2008-05-04 12:51:39', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1288, 318, '2008-05-07 16:46:58', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1289, 319, '2008-04-25 08:01:57', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1290, 319, '2008-05-01 14:41:36', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1292, 319, '2008-05-08 16:06:42', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1293, 319, '2008-05-11 12:14:41', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1294, 319, '2008-05-11 14:38:50', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1296, 320, '2008-05-01 13:03:34', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1299, 321, '2008-04-26 09:29:29', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1300, 321, '2008-04-28 16:32:09', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1301, 321, '2008-05-04 07:55:09', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1302, 321, '2008-05-08 15:31:00', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1303, 321, '2008-05-12 07:32:20', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1306, 322, '2008-04-27 17:24:32', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (1307, 323, '2008-04-26 12:34:36', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1310, 323, '2008-05-06 16:45:14', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1311, 324, '2008-04-26 12:03:28', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1312, 324, '2008-05-02 18:20:34', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1313, 324, '2008-05-07 10:52:47', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1315, 325, '2008-04-26 09:33:55', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1316, 325, '2008-04-28 14:12:47', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1317, 326, '2008-04-27 12:46:22', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1318, 326, '2008-05-03 13:31:42', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1321, 327, '2008-04-27 06:15:50', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1322, 327, '2008-05-01 16:48:04', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1323, 328, '2008-04-27 09:35:36', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1324, 328, '2008-05-01 17:36:25', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1325, 328, '2008-05-03 10:28:33', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1327, 328, '2008-05-12 09:02:43', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1328, 328, '2008-05-15 17:30:31', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1329, 329, '2008-04-27 08:41:00', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1331, 329, '2008-05-04 06:51:15', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1332, 329, '2008-05-08 18:41:39', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1333, 330, '2008-04-27 07:53:49', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1335, 330, '2008-05-01 09:46:17', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1336, 330, '2008-05-03 15:39:57', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1337, 331, '2008-04-27 11:08:24', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1339, 331, '2008-05-03 09:07:49', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1340, 331, '2008-05-04 15:08:26', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1341, 332, '2008-04-27 07:41:10', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1343, 333, '2008-04-27 09:50:11', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1344, 333, '2008-04-27 18:28:17', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1346, 334, '2008-05-03 18:25:04', X'506C656173652C207472790A7265696E7374616C6C696E67207468650A70726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1347, 334, '2008-05-08 12:07:54', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1348, 334, '2008-05-08 15:56:54', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (1350, 335, '2008-04-28 18:10:24', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1352, 335, '2008-05-02 16:59:17', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1353, 336, '2008-04-27 10:47:52', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1354, 336, '2008-04-27 18:36:57', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1356, 336, '2008-05-06 15:13:33', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1357, 336, '2008-05-08 11:16:39', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1358, 336, '2008-05-08 15:49:05', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1359, 337, '2008-04-27 07:49:29', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1360, 337, '2008-05-01 14:51:43', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1362, 338, '2008-04-28 14:21:36', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1363, 339, '2008-04-28 12:18:20', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1364, 339, '2008-04-28 18:05:07', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1365, 339, '2008-05-01 11:57:23', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1366, 339, '2008-05-01 17:32:48', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1367, 340, '2008-04-28 08:49:37', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1369, 340, '2008-05-02 12:18:03', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1370, 340, '2008-05-07 14:36:27', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1371, 340, '2008-05-10 12:28:12', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1372, 340, '2008-05-14 13:10:59', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1373, 341, '2008-04-28 07:18:11', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1374, 341, '2008-04-28 18:44:11', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1376, 341, '2008-05-01 18:20:00', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1377, 342, '2008-04-28 06:41:16', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1378, 342, '2008-05-01 13:26:32', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1379, 342, '2008-05-02 07:41:12', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1381, 343, '2008-04-28 06:03:57', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1382, 343, '2008-05-03 15:22:02', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1383, 343, '2008-05-04 08:43:33', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1385, 343, '2008-05-08 12:32:49', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1386, 343, '2008-05-10 15:38:00', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1387, 344, '2008-04-28 07:17:34', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1388, 344, '2008-05-02 17:09:54', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1389, 345, '2008-04-28 07:11:32', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1390, 345, '2008-05-01 14:46:29', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1391, 345, '2008-05-03 12:50:32', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1392, 345, '2008-05-06 17:46:36', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1393, 346, '2008-05-01 12:57:34', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1394, 346, '2008-05-01 13:19:58', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1395, 347, '2008-05-01 12:18:37', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1396, 347, '2008-05-01 15:26:10', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1397, 347, '2008-05-02 08:45:15', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1399, 347, '2008-05-06 08:28:25', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1400, 347, '2008-05-07 17:52:45', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1401, 348, '2008-05-01 09:45:02', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1402, 348, '2008-05-01 14:46:08', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (1403, 349, '2008-05-01 10:17:32', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1405, 349, '2008-05-02 10:50:47', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1406, 349, '2008-05-02 13:22:32', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1407, 349, '2008-05-06 10:55:56', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1408, 349, '2008-05-11 13:24:14', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1409, 350, '2008-05-01 11:19:20', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1410, 350, '2008-05-04 16:08:09', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1411, 351, '2008-05-01 07:04:52', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1412, 351, '2008-05-04 17:54:06', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1414, 351, '2008-05-09 13:16:56', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1415, 352, '2008-05-02 10:07:52', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1416, 352, '2008-05-07 16:15:30', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1417, 353, '2008-05-03 10:32:41', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1418, 353, '2008-05-06 14:51:05', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1419, 353, '2008-05-08 07:17:00', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1421, 354, '2008-05-03 10:16:16', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1422, 354, '2008-05-04 18:28:40', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1423, 354, '2008-05-08 09:24:52', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1424, 354, '2008-05-08 16:53:10', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1426, 354, '2008-05-17 13:16:05', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1428, 355, '2008-05-05 18:01:14', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1429, 355, '2008-05-06 11:59:15', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1430, 355, '2008-05-09 17:59:27', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (1431, 356, '2008-05-03 10:08:29', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1433, 357, '2008-05-03 11:40:32', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1434, 357, '2008-05-04 14:55:46', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1436, 357, '2008-05-10 15:45:00', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1437, 357, '2008-05-11 10:37:17', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1440, 358, '2008-05-05 13:39:56', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1441, 359, '2008-05-03 07:02:37', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1444, 359, '2008-05-10 17:01:12', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1445, 360, '2008-05-03 11:36:38', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1446, 360, '2008-05-06 13:30:14', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1447, 360, '2008-05-08 09:18:58', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1448, 360, '2008-05-13 14:06:28', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1449, 361, '2008-05-03 06:44:49', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1450, 361, '2008-05-08 13:26:07', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1451, 361, '2008-05-13 07:04:08', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1452, 361, '2008-05-18 18:24:45', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1453, 361, '2008-05-22 11:57:50', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1454, 361, '2008-05-23 15:45:54', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1455, 362, '2008-05-04 10:04:24', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1456, 362, '2008-05-07 18:10:14', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1457, 362, '2008-05-08 11:52:27', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1458, 362, '2008-05-13 14:31:47', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1459, 362, '2008-05-16 09:29:04', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1460, 362, '2008-05-17 14:25:58', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1461, 363, '2008-05-04 08:58:40', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1462, 363, '2008-05-09 17:38:10', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1463, 364, '2008-05-04 06:41:56', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1466, 364, '2008-05-11 18:01:27', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1468, 364, '2008-05-17 18:07:06', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1469, 365, '2008-05-04 07:10:59', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1470, 365, '2008-05-07 18:41:50', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (1471, 366, '2008-05-04 08:00:34', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1472, 366, '2008-05-07 18:19:12', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1473, 366, '2008-05-08 10:28:20', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1474, 366, '2008-05-11 13:35:40', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1476, 367, '2008-05-07 17:13:29', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (1477, 368, '2008-05-05 07:56:41', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1478, 368, '2008-05-06 17:08:22', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1479, 368, '2008-05-10 12:45:10', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1480, 368, '2008-05-11 14:47:56', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1481, 369, '2008-05-05 11:57:46', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1484, 370, '2008-05-06 14:21:30', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1486, 370, '2008-05-14 14:22:24', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1487, 370, '2008-05-17 09:05:05', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1488, 370, '2008-05-20 16:26:13', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1490, 371, '2008-05-06 17:57:57', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1491, 371, '2008-05-07 06:34:22', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1493, 372, '2008-05-05 11:01:43', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1494, 372, '2008-05-05 17:45:18', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1495, 372, '2008-05-09 11:21:24', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1496, 372, '2008-05-10 15:10:24', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1497, 372, '2008-05-14 10:49:00', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1498, 372, '2008-05-18 17:03:46', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1499, 373, '2008-05-05 09:51:47', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1501, 374, '2008-05-05 06:19:16', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1502, 374, '2008-05-05 16:40:12', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1503, 374, '2008-05-08 09:13:34', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1504, 374, '2008-05-09 13:08:58', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1505, 374, '2008-05-14 07:42:35', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1506, 374, '2008-05-14 14:00:25', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1507, 375, '2008-05-05 12:12:59', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1509, 376, '2008-05-05 11:07:02', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1510, 376, '2008-05-09 14:58:38', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1511, 376, '2008-05-10 09:22:54', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1512, 376, '2008-05-11 14:58:31', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1513, 377, '2008-05-05 06:19:16', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1515, 378, '2008-05-05 12:01:18', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1516, 378, '2008-05-07 13:05:15', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1517, 378, '2008-05-09 12:44:39', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1518, 378, '2008-05-10 18:52:04', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1519, 379, '2008-05-05 08:19:55', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1520, 379, '2008-05-07 17:26:46', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1522, 380, '2008-05-09 18:27:03', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1523, 380, '2008-05-12 08:47:32', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1524, 380, '2008-05-16 15:36:59', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1525, 381, '2008-05-05 10:41:03', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1526, 381, '2008-05-05 14:23:30', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1527, 381, '2008-05-06 12:32:36', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1528, 381, '2008-05-09 16:27:21', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1529, 382, '2008-05-05 12:18:42', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1531, 382, '2008-05-12 09:39:57', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1532, 382, '2008-05-14 18:11:35', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1533, 383, '2008-05-05 09:12:27', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1534, 383, '2008-05-05 14:06:31', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (1535, 383, '2008-05-08 07:00:05', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (1536, 383, '2008-05-12 17:44:25', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (1538, 383, '2008-05-17 18:52:04', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (1539, 384, '2008-05-06 07:58:45', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1540, 384, '2008-05-11 16:06:31', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1541, 384, '2008-05-12 10:39:06', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1542, 384, '2008-05-14 18:17:41', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1543, 385, '2008-05-06 09:20:47', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1544, 385, '2008-05-10 13:56:29', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1545, 385, '2008-05-14 06:11:27', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1547, 386, '2008-05-06 06:13:36', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1548, 386, '2008-05-11 18:59:13', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1549, 386, '2008-05-15 12:48:37', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1550, 386, '2008-05-16 13:00:40', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1551, 386, '2008-05-17 08:50:24', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1553, 387, '2008-05-06 07:17:41', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1554, 387, '2008-05-08 18:48:05', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1555, 387, '2008-05-09 12:43:42', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1557, 387, '2008-05-19 07:09:53', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1558, 387, '2008-05-20 17:20:48', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1559, 388, '2008-05-06 11:50:45', X'43616E204920706179206D790A707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1560, 388, '2008-05-06 18:03:22', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1561, 388, '2008-05-09 12:09:31', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1562, 388, '2008-05-10 17:18:24', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1563, 389, '2008-05-06 06:35:01', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1564, 389, '2008-05-08 15:07:17', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1565, 389, '2008-05-10 08:10:51', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1567, 390, '2008-05-06 07:48:47', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1569, 391, '2008-05-06 10:46:59', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1571, 391, '2008-05-14 06:22:53', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1572, 391, '2008-05-17 17:38:10', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1573, 392, '2008-05-06 12:36:43', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1574, 392, '2008-05-09 13:24:48', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1576, 392, '2008-05-17 13:13:03', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1577, 392, '2008-05-21 08:00:22', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1578, 392, '2008-05-23 14:16:00', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (1580, 393, '2008-05-08 18:25:46', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1581, 393, '2008-05-11 10:28:56', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1582, 393, '2008-05-16 13:28:56', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (1583, 394, '2008-05-06 07:15:10', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1584, 394, '2008-05-11 14:28:01', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1587, 396, '2008-05-07 09:25:27', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1588, 396, '2008-05-10 13:57:16', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1589, 396, '2008-05-13 08:59:40', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1590, 396, '2008-05-13 14:27:53', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1592, 397, '2008-05-07 16:29:47', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1594, 397, '2008-05-15 18:36:01', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1595, 397, '2008-05-16 06:57:13', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1596, 397, '2008-05-19 17:02:06', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1597, 398, '2008-05-07 10:04:30', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1598, 398, '2008-05-09 18:54:47', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1599, 399, '2008-05-07 07:38:10', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1600, 399, '2008-05-09 14:09:23', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1601, 399, '2008-05-14 12:22:18', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1603, 399, '2008-05-18 10:24:23', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1604, 399, '2008-05-18 16:15:51', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1605, 400, '2008-05-07 06:56:40', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1606, 400, '2008-05-07 17:52:04', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1607, 400, '2008-05-12 06:50:05', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1608, 400, '2008-05-15 17:52:12', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1609, 401, '2008-05-07 09:19:57', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1611, 401, '2008-05-11 10:16:17', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1612, 401, '2008-05-16 18:41:55', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1613, 402, '2008-05-07 11:43:29', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1614, 402, '2008-05-09 17:53:06', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1615, 402, '2008-05-11 10:26:15', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1616, 402, '2008-05-11 18:06:13', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1617, 403, '2008-05-07 09:14:49', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1620, 404, '2008-05-08 13:48:26', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1621, 405, '2008-05-08 10:43:06', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1622, 405, '2008-05-12 16:12:56', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1623, 405, '2008-05-17 11:34:18', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (1624, 405, '2008-05-17 18:37:20', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (1625, 406, '2008-05-08 12:14:42', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1626, 406, '2008-05-12 17:55:00', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1627, 406, '2008-05-16 11:13:10', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (1628, 406, '2008-05-20 14:19:08', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (1630, 407, '2008-05-11 14:48:45', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1631, 407, '2008-05-15 10:44:49', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1632, 407, '2008-05-15 15:28:52', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1633, 408, '2008-05-08 07:53:31', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1634, 408, '2008-05-09 14:18:50', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (1635, 409, '2008-05-09 08:52:08', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1636, 409, '2008-05-12 14:25:45', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1637, 409, '2008-05-17 12:08:09', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1640, 409, '2008-05-24 18:29:27', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1641, 410, '2008-05-09 10:32:28', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1642, 410, '2008-05-10 13:20:42', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1643, 411, '2008-05-10 07:39:38', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1644, 411, '2008-05-11 13:55:11', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1645, 411, '2008-05-13 11:12:30', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1646, 411, '2008-05-15 18:43:24', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1648, 412, '2008-05-12 14:13:20', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1649, 413, '2008-05-10 07:12:17', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1650, 413, '2008-05-13 15:14:03', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1651, 414, '2008-05-10 11:32:59', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1652, 414, '2008-05-14 17:51:48', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1653, 414, '2008-05-19 09:58:39', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1654, 414, '2008-05-20 13:51:58', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1655, 415, '2008-05-10 06:25:45', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1658, 416, '2008-05-11 16:01:37', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1659, 416, '2008-05-16 12:45:32', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1660, 416, '2008-05-17 13:57:51', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1662, 416, '2008-05-25 15:56:18', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1663, 417, '2008-05-10 08:04:19', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1664, 417, '2008-05-11 13:01:12', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1665, 418, '2008-05-10 09:14:18', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1666, 418, '2008-05-13 15:02:18', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1667, 418, '2008-05-16 07:43:02', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1669, 419, '2008-05-10 06:18:55', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1670, 419, '2008-05-15 15:47:06', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1671, 420, '2008-05-10 06:38:54', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1672, 420, '2008-05-15 16:00:01', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1673, 420, '2008-05-19 11:36:19', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1674, 420, '2008-05-22 14:56:17', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1675, 421, '2008-05-10 10:05:59', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1676, 421, '2008-05-14 15:06:55', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1677, 421, '2008-05-18 08:51:48', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1678, 421, '2008-05-20 14:18:18', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1679, 422, '2008-05-10 12:24:17', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1681, 422, '2008-05-20 11:05:17', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1682, 422, '2008-05-21 15:41:56', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1683, 423, '2008-05-11 06:58:24', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1684, 423, '2008-05-12 13:26:05', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1686, 423, '2008-05-18 16:56:31', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1687, 423, '2008-05-23 07:00:44', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1688, 423, '2008-05-24 14:16:24', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1689, 424, '2008-05-11 12:21:18', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1690, 424, '2008-05-11 17:31:42', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1692, 424, '2008-05-19 15:46:41', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1693, 425, '2008-05-11 08:50:42', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1694, 425, '2008-05-13 16:55:41', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1695, 425, '2008-05-16 07:13:13', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1697, 426, '2008-05-11 08:04:52', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1698, 426, '2008-05-14 14:44:45', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1701, 428, '2008-05-11 11:36:23', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1702, 428, '2008-05-16 15:49:34', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1704, 428, '2008-05-20 15:38:45', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (1706, 429, '2008-05-13 18:17:46', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1708, 430, '2008-05-13 14:03:14', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1709, 430, '2008-05-17 08:26:04', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (1710, 430, '2008-05-18 16:10:56', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (1711, 431, '2008-05-12 09:50:10', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1712, 431, '2008-05-13 15:01:10', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1713, 431, '2008-05-15 09:13:05', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1714, 431, '2008-05-20 15:27:32', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1716, 431, '2008-05-28 14:04:19', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1717, 432, '2008-05-12 08:31:16', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1718, 432, '2008-05-16 17:40:04', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1719, 432, '2008-05-20 12:17:00', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1721, 433, '2008-05-12 10:47:45', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1722, 433, '2008-05-12 13:41:03', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1724, 433, '2008-05-14 13:41:22', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1725, 433, '2008-05-17 07:32:16', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1726, 433, '2008-05-18 14:32:55', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (1727, 434, '2008-05-12 12:05:19', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1728, 434, '2008-05-14 13:49:04', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1730, 434, '2008-05-19 17:29:09', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (1731, 435, '2008-05-12 08:44:45', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1732, 435, '2008-05-17 18:00:33', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1733, 436, '2008-05-12 11:36:10', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1734, 436, '2008-05-15 17:13:52', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1736, 436, '2008-05-22 13:47:12', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (1738, 437, '2008-05-15 18:04:53', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1739, 437, '2008-05-18 11:34:49', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1740, 437, '2008-05-18 17:19:06', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1741, 438, '2008-05-12 09:00:50', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1742, 438, '2008-05-17 18:09:09', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1743, 439, '2008-05-12 09:34:25', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1744, 439, '2008-05-14 14:33:25', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1745, 439, '2008-05-16 11:20:21', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1746, 439, '2008-05-20 16:19:53', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1747, 439, '2008-05-23 07:04:26', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1748, 439, '2008-05-27 17:21:04', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1749, 440, '2008-05-12 10:14:00', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1751, 440, '2008-05-19 06:24:17', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1752, 440, '2008-05-21 13:26:56', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1753, 440, '2008-05-23 06:53:01', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1754, 440, '2008-05-28 18:04:07', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1755, 441, '2008-05-13 07:26:27', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1756, 441, '2008-05-17 17:37:54', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1758, 441, '2008-05-19 18:51:02', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1760, 441, '2008-05-21 15:35:10', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1762, 442, '2008-05-16 13:11:02', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (1763, 442, '2008-05-17 08:25:29', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (1764, 442, '2008-05-20 14:27:44', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (1765, 443, '2008-05-13 12:38:47', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1766, 443, '2008-05-15 15:11:40', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1767, 443, '2008-05-19 06:55:00', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1769, 444, '2008-05-13 10:40:31', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1771, 445, '2008-05-13 08:53:21', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1772, 445, '2008-05-18 15:09:20', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1773, 446, '2008-05-13 12:54:28', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1774, 446, '2008-05-13 14:04:48', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1776, 446, '2008-05-17 15:32:15', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1777, 447, '2008-05-13 07:57:46', X'536F20666172204920686176650A6E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1778, 447, '2008-05-15 18:29:18', X'546865206F72646572207761730A73656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1779, 447, '2008-05-18 07:16:38', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1780, 447, '2008-05-22 17:38:52', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1782, 448, '2008-05-14 13:57:15', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 3, 'RESPONSE', null, null, null, 'CLOSED', ''), (1783, 449, '2008-05-13 07:47:16', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1784, 449, '2008-05-16 13:40:48', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1786, 449, '2008-05-22 18:50:01', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1788, 449, '2008-05-24 14:22:59', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (1789, 450, '2008-05-14 07:36:33', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1790, 450, '2008-05-15 16:14:20', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1792, 450, '2008-05-22 15:39:18', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1793, 451, '2008-05-14 08:28:17', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1794, 451, '2008-05-19 18:18:37', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1795, 452, '2008-05-14 11:52:02', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1796, 452, '2008-05-15 14:12:23', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1797, 453, '2008-05-14 10:04:21', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1798, 453, '2008-05-15 16:16:02', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1799, 453, '2008-05-17 11:55:31', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1800, 453, '2008-05-22 17:24:09', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1802, 453, '2008-05-26 15:07:44', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1803, 454, '2008-05-14 11:16:11', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1805, 454, '2008-05-21 06:14:41', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (1806, 454, '2008-05-21 17:18:24', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1807, 454, '2008-05-22 08:54:24', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (1808, 454, '2008-05-25 18:04:59', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (1809, 455, '2008-05-14 07:13:11', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1810, 455, '2008-05-18 18:22:26', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1811, 455, '2008-05-19 08:42:30', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1812, 455, '2008-05-23 16:34:17', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1814, 455, '2008-05-28 13:37:40', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1815, 456, '2008-05-14 06:26:42', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1818, 456, '2008-05-21 14:05:55', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1820, 456, '2008-05-27 18:34:13', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1821, 457, '2008-05-14 08:24:55', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1822, 457, '2008-05-17 17:49:06', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1823, 458, '2008-05-14 09:15:28', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1824, 458, '2008-05-16 15:18:44', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1826, 458, '2008-05-25 13:48:31', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1827, 459, '2008-05-15 12:37:06', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1828, 459, '2008-05-17 14:28:24', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1830, 459, '2008-05-25 17:44:15', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1831, 460, '2008-05-15 06:26:43', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1832, 460, '2008-05-19 15:43:46', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1833, 461, '2008-05-15 08:05:50', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1836, 461, '2008-05-25 15:24:54', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1837, 461, '2008-05-29 11:28:29', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1838, 461, '2008-05-31 15:25:02', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1839, 462, '2008-05-15 06:45:26', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1840, 462, '2008-05-15 18:23:40', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1841, 462, '2008-05-16 12:48:35', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1843, 462, '2008-05-18 09:17:18', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1844, 462, '2008-05-19 17:06:01', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1846, 463, '2008-05-16 13:07:30', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1847, 463, '2008-05-17 09:14:31', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1849, 464, '2008-05-16 12:21:30', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1850, 464, '2008-05-18 15:10:15', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1851, 464, '2008-05-20 12:10:01', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1852, 464, '2008-05-20 16:56:26', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1853, 464, '2008-05-24 12:18:49', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1855, 465, '2008-05-17 09:34:23', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1856, 465, '2008-05-17 15:43:48', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (1858, 466, '2008-05-17 14:23:23', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1860, 466, '2008-05-24 14:09:39', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1861, 466, '2008-05-27 12:18:09', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1862, 466, '2008-05-28 18:21:07', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1863, 467, '2008-05-17 07:53:33', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1864, 467, '2008-05-21 18:08:12', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1865, 467, '2008-05-25 12:51:47', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1866, 467, '2008-05-27 16:51:20', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1867, 468, '2008-05-17 06:23:36', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1868, 468, '2008-05-17 15:10:30', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1869, 468, '2008-05-21 12:25:13', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1870, 468, '2008-05-24 14:48:04', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1871, 468, '2008-05-28 06:12:00', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1872, 468, '2008-06-02 13:54:18', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1873, 469, '2008-05-17 06:51:47', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1876, 469, '2008-05-28 14:34:13', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1877, 469, '2008-06-02 08:10:11', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1878, 469, '2008-06-04 17:27:59', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1880, 470, '2008-05-20 14:05:51', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1881, 470, '2008-05-25 07:27:25', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', '');
INSERT INTO "ticketmessage" VALUES (1882, 470, '2008-05-30 16:38:33', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1883, 470, '2008-05-31 07:20:46', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1884, 470, '2008-06-01 14:04:53', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1885, 471, '2008-05-17 11:37:05', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1886, 471, '2008-05-20 14:26:53', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1888, 471, '2008-05-21 17:23:02', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1890, 471, '2008-05-27 15:20:10', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (1892, 472, '2008-05-22 18:00:26', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (1893, 472, '2008-05-26 11:40:27', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (1894, 472, '2008-05-31 16:48:49', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (1896, 473, '2008-05-22 13:16:29', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1897, 473, '2008-05-26 11:47:49', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1898, 473, '2008-05-30 18:54:28', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1899, 473, '2008-05-31 09:41:42', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1900, 473, '2008-06-02 14:56:40', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1901, 474, '2008-05-18 06:21:52', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1902, 474, '2008-05-23 14:22:23', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1903, 474, '2008-05-28 06:07:29', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1904, 474, '2008-05-31 15:37:47', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (1906, 475, '2008-05-20 16:44:22', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1907, 475, '2008-05-25 06:01:48', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1908, 475, '2008-05-29 15:12:56', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1909, 476, '2008-05-18 09:25:03', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1910, 476, '2008-05-21 17:49:28', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1911, 476, '2008-05-24 09:44:13', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1912, 476, '2008-05-26 14:55:11', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (1913, 476, '2008-05-31 08:37:34', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1916, 477, '2008-05-21 17:04:07', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1917, 478, '2008-05-18 10:20:32', X'4120667269656E6420736169640A68652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1918, 478, '2008-05-22 15:00:01', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (1919, 478, '2008-05-23 08:21:43', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (1920, 478, '2008-05-25 16:35:44', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (1921, 478, '2008-05-28 06:28:33', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (1923, 479, '2008-05-18 11:12:43', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1924, 479, '2008-05-20 15:40:26', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1925, 479, '2008-05-21 07:44:23', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1926, 479, '2008-05-26 14:43:17', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1927, 479, '2008-05-27 09:29:38', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1928, 479, '2008-06-01 13:20:39', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1930, 480, '2008-05-22 18:36:12', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1931, 481, '2008-05-18 11:37:09', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1932, 481, '2008-05-19 13:16:10', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1934, 482, '2008-05-20 15:10:08', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1935, 482, '2008-05-25 06:48:04', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1936, 482, '2008-05-30 15:35:27', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (1938, 483, '2008-05-20 17:44:43', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1939, 483, '2008-05-25 12:45:11', X'492063616EC2B4742077726974650A612066696C6520696E20506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1940, 483, '2008-05-27 18:11:24', X'4D616B65207375726520796F750A696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (1941, 484, '2008-05-19 11:29:10', X'486F7720646F6573207468650A657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1943, 484, '2008-05-26 10:06:51', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1944, 484, '2008-05-31 13:04:41', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1945, 484, '2008-06-05 08:14:08', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1946, 484, '2008-06-09 16:49:52', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1948, 485, '2008-05-23 18:33:32', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1952, 486, '2008-05-30 13:05:46', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1953, 486, '2008-05-31 07:53:51', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1954, 486, '2008-06-04 17:50:30', X'547279207570646174696E670A74686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1956, 487, '2008-05-21 13:36:02', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (1958, 488, '2008-05-22 17:13:44', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1959, 488, '2008-05-24 07:15:20', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1960, 488, '2008-05-27 17:20:15', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (1961, 488, '2008-06-01 06:19:44', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (1962, 488, '2008-06-06 13:21:15', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (1963, 489, '2008-05-19 06:25:20', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1964, 489, '2008-05-22 16:54:58', X'506C6561736520696E666F726D0A7468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1966, 489, '2008-05-31 16:31:42', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1967, 489, '2008-06-04 09:27:08', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1969, 490, '2008-05-19 11:04:21', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1970, 490, '2008-05-22 18:34:29', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1972, 490, '2008-05-24 17:15:17', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (1973, 491, '2008-05-19 10:07:30', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1974, 491, '2008-05-24 18:19:52', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1975, 491, '2008-05-28 08:04:54', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1977, 491, '2008-05-31 12:17:56', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (1978, 491, '2008-06-01 15:27:11', X'4D616B6520737572652069740A69732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (1980, 492, '2008-05-23 13:37:05', X'5468652066696C65207761730A74656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1981, 493, '2008-05-19 08:13:31', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1982, 493, '2008-05-20 18:29:00', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1984, 493, '2008-05-25 13:54:22', X'506C656173652C207472790A7265696E7374616C6C696E67207468650A70726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1986, 493, '2008-05-28 13:56:06', X'50726F766176616C6D656E74650A616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (1987, 494, '2008-05-19 12:12:47', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1988, 494, '2008-05-21 16:17:32', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (1989, 494, '2008-05-24 08:12:22', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1992, 494, '2008-06-05 14:38:12', X'4D616B652073757265207468650A436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1993, 495, '2008-05-19 09:09:41', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1994, 495, '2008-05-19 13:27:55', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (1995, 495, '2008-05-21 09:20:05', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (1997, 496, '2008-05-19 08:27:12', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1998, 496, '2008-05-20 16:57:19', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1999, 496, '2008-05-24 11:56:49', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (2000, 496, '2008-05-28 16:54:12', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (2001, 497, '2008-05-19 12:55:26', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (2002, 497, '2008-05-20 18:01:12', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (2003, 497, '2008-05-24 10:00:22', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (2005, 498, '2008-05-20 10:55:35', X'41636365737320746F207468650A73697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (2006, 498, '2008-05-25 18:12:11', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (2007, 498, '2008-05-27 07:19:55', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (2008, 498, '2008-05-28 15:10:07', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (2010, 498, '2008-05-31 15:55:08', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (2011, 499, '2008-05-20 08:36:00', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (2013, 499, '2008-05-26 09:25:59', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (2014, 499, '2008-05-30 13:41:47', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (2015, 500, '2008-05-20 09:11:54', X'492063616EC2B4742073796E630A6D79206D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (2017, 500, '2008-05-27 09:38:33', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (2018, 500, '2008-05-29 13:34:15', X'5468652066696C65207761730A626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (14124, 3501, '2009-07-10 16:46:40', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14125, 3501, '2009-07-11 09:27:19', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14126, 3501, '2009-07-11 14:26:20', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14127, 3502, '2009-07-03 08:29:53', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14128, 3502, '2009-07-07 16:40:40', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14129, 3502, '2009-07-11 12:26:48', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14130, 3502, '2009-07-13 13:40:15', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14131, 3502, '2009-07-18 11:44:33', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14132, 3502, '2009-07-21 17:15:51', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14133, 3503, '2009-07-04 07:21:06', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14135, 3503, '2009-07-07 08:25:23', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14136, 3503, '2009-07-12 16:19:20', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14137, 3503, '2009-07-17 11:51:42', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14138, 3503, '2009-07-19 14:11:20', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (14139, 3504, '2009-07-04 12:45:44', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14140, 3504, '2009-07-08 17:16:19', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14141, 3505, '2009-07-04 09:23:39', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14142, 3505, '2009-07-07 15:16:52', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14143, 3505, '2009-07-11 07:26:47', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14144, 3505, '2009-07-13 18:33:14', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14146, 3505, '2009-07-15 13:22:17', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14147, 3506, '2009-07-04 07:47:30', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14148, 3506, '2009-07-09 16:39:04', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14149, 3507, '2009-07-04 12:40:47', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14150, 3507, '2009-07-09 18:13:18', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14151, 3508, '2009-07-04 10:43:01', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14153, 3509, '2009-07-05 13:17:43', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14155, 3509, '2009-07-15 15:47:10', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14156, 3510, '2009-07-04 08:19:01', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14157, 3510, '2009-07-09 18:55:28', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (14158, 3510, '2009-07-11 08:53:49', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (14159, 3510, '2009-07-16 17:27:08', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (14160, 3511, '2009-07-04 10:53:27', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14161, 3511, '2009-07-09 15:16:44', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14162, 3511, '2009-07-10 12:36:16', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14163, 3511, '2009-07-11 13:52:26', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14165, 3513, '2009-07-04 06:59:03', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14166, 3513, '2009-07-05 16:15:20', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14167, 3514, '2009-07-05 10:58:58', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14168, 3514, '2009-07-08 13:54:07', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14169, 3514, '2009-07-11 10:35:24', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14170, 3514, '2009-07-11 16:59:17', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14171, 3514, '2009-07-12 07:40:44', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14172, 3515, '2009-07-05 11:39:38', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14173, 3515, '2009-07-06 15:35:41', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14174, 3515, '2009-07-10 06:58:15', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14177, 3516, '2009-07-05 16:19:49', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14178, 3517, '2009-07-05 11:49:33', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14179, 3517, '2009-07-07 14:03:50', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14180, 3517, '2009-07-08 09:28:01', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14181, 3517, '2009-07-08 16:58:20', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14183, 3518, '2009-07-10 14:33:10', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14184, 3519, '2009-07-05 10:01:32', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14185, 3519, '2009-07-09 14:55:12', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14186, 3519, '2009-07-14 08:35:48', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14187, 3519, '2009-07-19 17:12:29', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14189, 3519, '2009-07-22 16:21:39', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14192, 3520, '2009-07-09 08:49:23', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14193, 3520, '2009-07-09 17:33:26', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14194, 3520, '2009-07-13 10:05:32', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14195, 3520, '2009-07-13 14:06:43', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14196, 3521, '2009-07-06 09:31:18', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14197, 3521, '2009-07-10 17:04:19', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14199, 3522, '2009-07-10 15:52:33', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (14200, 3522, '2009-07-15 10:29:01', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (14201, 3523, '2009-07-06 12:35:54', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14203, 3524, '2009-07-11 16:58:50', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (14204, 3524, '2009-07-16 12:40:07', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (14205, 3524, '2009-07-19 14:17:13', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (14206, 3525, '2009-07-06 12:57:21', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14207, 3525, '2009-07-08 18:33:02', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14208, 3526, '2009-07-06 12:45:11', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14210, 3526, '2009-07-10 10:57:25', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14211, 3526, '2009-07-12 14:56:27', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14212, 3527, '2009-07-06 12:17:05', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14213, 3527, '2009-07-09 14:03:57', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14215, 3527, '2009-07-14 16:07:38', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14217, 3527, '2009-07-18 18:50:39', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14218, 3528, '2009-07-06 06:33:41', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14219, 3528, '2009-07-07 14:36:37', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (14220, 3528, '2009-07-10 11:57:03', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (14221, 3528, '2009-07-11 14:11:45', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14222, 3529, '2009-07-06 08:59:04', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14223, 3529, '2009-07-10 18:45:31', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14224, 3529, '2009-07-14 08:21:20', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14225, 3530, '2009-07-06 06:27:17', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14226, 3530, '2009-07-10 13:57:29', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14227, 3530, '2009-07-15 12:15:34', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14228, 3530, '2009-07-19 15:15:16', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14229, 3531, '2009-07-06 11:52:40', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14230, 3531, '2009-07-06 13:56:09', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14231, 3531, '2009-07-10 10:39:07', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14232, 3531, '2009-07-10 16:48:56', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14233, 3531, '2009-07-15 09:20:15', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14235, 3532, '2009-07-06 07:48:58', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14236, 3532, '2009-07-09 17:13:47', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14237, 3533, '2009-07-06 07:13:16', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14238, 3533, '2009-07-10 18:47:41', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14239, 3534, '2009-07-06 07:14:52', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14240, 3534, '2009-07-07 17:10:37', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14241, 3535, '2009-07-06 12:59:37', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14242, 3535, '2009-07-06 13:46:18', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14243, 3535, '2009-07-07 06:51:55', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14245, 3536, '2009-07-06 07:31:22', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14246, 3536, '2009-07-07 17:24:10', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14247, 3537, '2009-07-07 06:56:21', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14248, 3537, '2009-07-08 18:17:20', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14249, 3537, '2009-07-12 07:41:36', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14250, 3537, '2009-07-16 15:45:38', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14252, 3538, '2009-07-12 14:33:34', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (14253, 3538, '2009-07-16 12:44:50', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (14254, 3538, '2009-07-20 16:42:14', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14256, 3539, '2009-07-11 15:41:10', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14258, 3540, '2009-07-11 18:51:50', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (14259, 3540, '2009-07-13 09:56:26', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (14260, 3540, '2009-07-18 16:47:43', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14261, 3541, '2009-07-07 09:11:20', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14262, 3541, '2009-07-09 17:51:21', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14263, 3541, '2009-07-11 12:29:55', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14264, 3541, '2009-07-14 14:33:19', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14265, 3542, '2009-07-07 07:40:48', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14266, 3542, '2009-07-11 16:19:19', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14267, 3543, '2009-07-07 11:50:26', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14268, 3543, '2009-07-08 13:19:26', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14270, 3544, '2009-07-07 13:36:36', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14271, 3544, '2009-07-10 10:12:54', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14272, 3544, '2009-07-11 18:06:42', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14273, 3544, '2009-07-15 10:10:43', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14274, 3544, '2009-07-16 16:26:45', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14275, 3545, '2009-07-07 11:14:26', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14276, 3545, '2009-07-12 17:35:21', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14277, 3545, '2009-07-14 11:58:37', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14280, 3546, '2009-07-11 14:01:16', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14281, 3546, '2009-07-16 12:45:42', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14282, 3546, '2009-07-19 18:08:41', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14283, 3546, '2009-07-20 09:12:14', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14284, 3546, '2009-07-23 13:20:44', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14285, 3547, '2009-07-07 06:44:23', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14286, 3547, '2009-07-08 13:54:14', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14288, 3548, '2009-07-12 15:03:16', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14289, 3549, '2009-07-08 10:36:50', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14290, 3549, '2009-07-13 16:55:06', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14291, 3549, '2009-07-16 10:05:55', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14293, 3549, '2009-07-17 06:03:51', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14294, 3549, '2009-07-17 16:02:35', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14295, 3550, '2009-07-08 06:39:46', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14296, 3550, '2009-07-10 17:17:14', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14297, 3550, '2009-07-15 10:16:30', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14299, 3550, '2009-07-17 11:35:08', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14300, 3550, '2009-07-17 13:47:14', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14301, 3551, '2009-07-08 08:24:15', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14302, 3551, '2009-07-13 17:43:29', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14304, 3551, '2009-07-19 16:56:03', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14305, 3551, '2009-07-24 11:55:03', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14306, 3551, '2009-07-28 14:19:28', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (14307, 3552, '2009-07-08 10:04:01', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14308, 3552, '2009-07-08 15:38:43', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14310, 3553, '2009-07-08 14:10:16', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14311, 3553, '2009-07-12 12:40:10', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14312, 3553, '2009-07-14 17:40:38', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14313, 3554, '2009-07-08 09:01:49', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14315, 3555, '2009-07-13 17:23:44', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14316, 3555, '2009-07-14 11:44:42', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14317, 3555, '2009-07-17 14:55:29', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14318, 3556, '2009-07-08 08:25:41', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14320, 3556, '2009-07-16 11:45:12', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14321, 3556, '2009-07-19 15:49:10', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14322, 3556, '2009-07-20 11:24:49', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14323, 3556, '2009-07-22 13:32:31', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14325, 3557, '2009-07-08 13:54:25', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14326, 3557, '2009-07-10 08:16:31', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14328, 3557, '2009-07-16 09:28:55', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14329, 3558, '2009-07-09 08:37:33', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14330, 3558, '2009-07-13 16:53:35', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14331, 3558, '2009-07-16 11:49:55', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14332, 3558, '2009-07-21 14:14:21', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14333, 3559, '2009-07-09 09:12:24', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14334, 3560, '2009-07-09 09:12:25', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14335, 3560, '2009-07-11 17:08:38', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14336, 3560, '2009-07-14 10:40:11', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14338, 3560, '2009-07-21 07:51:51', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14339, 3560, '2009-07-23 17:16:26', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14340, 3561, '2009-07-10 11:58:14', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14341, 3561, '2009-07-14 15:04:28', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14342, 3561, '2009-07-16 11:48:42', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14343, 3561, '2009-07-19 13:37:22', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14344, 3561, '2009-07-23 07:51:00', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14346, 3562, '2009-07-10 09:57:07', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14348, 3562, '2009-07-15 07:29:44', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14349, 3562, '2009-07-20 15:11:59', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14350, 3563, '2009-07-11 11:27:03', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14351, 3563, '2009-07-16 14:01:44', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14352, 3563, '2009-07-18 12:32:04', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14353, 3563, '2009-07-19 13:26:17', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14354, 3564, '2009-07-11 09:05:54', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14355, 3564, '2009-07-13 13:44:25', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (14357, 3565, '2009-07-16 18:04:39', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14358, 3565, '2009-07-19 12:12:19', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14359, 3565, '2009-07-23 16:53:21', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14360, 3566, '2009-07-11 12:22:37', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14361, 3566, '2009-07-12 18:47:51', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14363, 3566, '2009-07-19 13:41:36', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14364, 3566, '2009-07-20 06:03:14', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14365, 3566, '2009-07-20 15:03:57', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14366, 3567, '2009-07-11 10:19:38', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14367, 3567, '2009-07-12 16:52:04', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14370, 3568, '2009-07-11 06:52:31', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14371, 3568, '2009-07-11 14:42:21', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14373, 3568, '2009-07-15 17:26:42', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14374, 3569, '2009-07-11 12:18:47', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14375, 3569, '2009-07-13 17:51:51', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14377, 3569, '2009-07-18 15:42:36', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14378, 3569, '2009-07-23 08:10:11', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14379, 3569, '2009-07-23 14:19:27', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14381, 3570, '2009-07-13 15:18:36', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14382, 3570, '2009-07-15 06:30:08', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14383, 3570, '2009-07-17 14:27:22', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14385, 3571, '2009-07-12 18:47:48', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14386, 3571, '2009-07-14 12:34:51', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14387, 3571, '2009-07-19 16:48:38', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14389, 3572, '2009-07-13 14:08:32', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14390, 3573, '2009-07-12 09:18:05', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14391, 3573, '2009-07-17 14:45:51', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14394, 3573, '2009-07-31 12:46:05', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14395, 3573, '2009-08-02 13:33:53', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14396, 3574, '2009-07-12 08:26:47', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14397, 3574, '2009-07-17 18:03:28', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14399, 3574, '2009-07-23 15:50:36', X'506C656173652C207472790A7265696E7374616C6C696E67207468650A70726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14401, 3574, '2009-07-27 16:40:46', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14402, 3575, '2009-07-12 09:09:27', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14403, 3575, '2009-07-17 15:29:57', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14405, 3575, '2009-07-23 15:34:42', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14407, 3576, '2009-07-13 14:44:21', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14408, 3576, '2009-07-16 08:24:57', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14409, 3576, '2009-07-19 14:32:20', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14410, 3576, '2009-07-22 06:02:19', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14411, 3576, '2009-07-24 15:24:46', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14412, 3577, '2009-07-12 09:08:41', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14413, 3577, '2009-07-12 13:25:49', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14415, 3577, '2009-07-20 17:49:11', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14418, 3579, '2009-07-12 12:10:16', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14419, 3579, '2009-07-15 17:05:42', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14420, 3579, '2009-07-19 08:03:20', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14421, 3579, '2009-07-20 17:38:30', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14422, 3579, '2009-07-25 12:18:25', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14423, 3579, '2009-07-28 18:11:45', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14424, 3580, '2009-07-13 06:45:46', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14425, 3580, '2009-07-16 16:11:34', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14426, 3580, '2009-07-18 11:54:51', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (14427, 3580, '2009-07-20 14:19:11', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14428, 3580, '2009-07-25 12:28:53', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (14430, 3581, '2009-07-13 07:35:53', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14431, 3581, '2009-07-15 18:13:11', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14432, 3581, '2009-07-17 06:38:03', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14433, 3581, '2009-07-22 15:31:43', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14434, 3581, '2009-07-25 11:20:06', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14435, 3581, '2009-07-28 16:56:20', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14436, 3582, '2009-07-13 12:01:31', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14437, 3582, '2009-07-18 16:52:38', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14438, 3582, '2009-07-22 09:55:11', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14439, 3582, '2009-07-25 15:09:43', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14440, 3582, '2009-07-26 09:15:58', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14441, 3582, '2009-07-27 18:37:19', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (14442, 3583, '2009-07-13 11:43:10', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14444, 3584, '2009-07-13 09:19:08', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14446, 3584, '2009-07-18 09:59:17', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14447, 3585, '2009-07-13 08:11:56', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14448, 3585, '2009-07-18 18:41:40', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14449, 3585, '2009-07-19 07:21:56', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14450, 3585, '2009-07-24 14:14:13', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14451, 3585, '2009-07-26 12:58:16', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14452, 3585, '2009-07-28 16:57:06', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14453, 3586, '2009-07-13 08:34:27', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14454, 3586, '2009-07-15 16:14:25', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (14456, 3587, '2009-07-16 15:28:27', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14457, 3587, '2009-07-19 10:50:53', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14458, 3587, '2009-07-24 17:08:01', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14459, 3587, '2009-07-28 06:52:07', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14461, 3588, '2009-07-13 11:39:11', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14462, 3588, '2009-07-14 16:17:45', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14463, 3589, '2009-07-13 12:00:08', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14464, 3589, '2009-07-13 18:05:59', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14466, 3589, '2009-07-16 14:46:35', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14467, 3590, '2009-07-13 06:54:31', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14468, 3590, '2009-07-13 16:55:44', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14470, 3590, '2009-07-16 16:17:39', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14471, 3591, '2009-07-14 06:13:00', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14472, 3591, '2009-07-19 18:34:19', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (14473, 3592, '2009-07-14 09:17:51', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14474, 3592, '2009-07-14 15:40:12', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14475, 3592, '2009-07-15 07:47:56', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14476, 3592, '2009-07-15 17:01:11', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14477, 3593, '2009-07-14 08:00:52', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14478, 3593, '2009-07-14 15:38:09', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14479, 3593, '2009-07-16 11:27:56', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14481, 3594, '2009-07-14 10:46:10', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14482, 3594, '2009-07-19 14:02:28', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14484, 3594, '2009-07-27 13:02:32', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14485, 3594, '2009-08-01 11:27:52', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14486, 3594, '2009-08-04 15:58:27', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14487, 3595, '2009-07-14 08:28:06', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14488, 3595, '2009-07-18 18:58:21', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14489, 3595, '2009-07-21 09:22:40', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14490, 3595, '2009-07-22 16:25:05', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14491, 3596, '2009-07-14 09:22:01', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14492, 3596, '2009-07-14 13:10:12', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14494, 3596, '2009-07-20 16:44:28', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14495, 3596, '2009-07-21 06:53:16', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14496, 3596, '2009-07-21 13:06:31', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14497, 3597, '2009-07-14 08:29:31', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14498, 3597, '2009-07-19 14:04:21', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14499, 3597, '2009-07-22 07:44:04', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14501, 3598, '2009-07-15 10:47:37', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14502, 3598, '2009-07-17 15:23:34', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14503, 3599, '2009-07-15 08:39:13', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14504, 3599, '2009-07-17 17:01:36', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14505, 3599, '2009-07-22 10:21:40', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14506, 3599, '2009-07-24 16:31:36', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14507, 3600, '2009-07-15 12:55:20', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14508, 3600, '2009-07-16 16:36:03', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14509, 3600, '2009-07-20 09:35:53', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14510, 3600, '2009-07-24 13:53:31', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14511, 3601, '2009-07-15 06:18:40', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14512, 3601, '2009-07-16 18:40:22', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14513, 3602, '2009-07-15 06:13:43', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14514, 3602, '2009-07-19 18:54:09', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14515, 3603, '2009-07-15 11:05:08', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14516, 3603, '2009-07-17 17:35:02', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (14517, 3604, '2009-07-15 06:14:10', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14519, 3605, '2009-07-15 07:25:34', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14520, 3606, '2009-07-15 08:09:40', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14521, 3606, '2009-07-18 15:38:32', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14522, 3606, '2009-07-19 08:11:11', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14523, 3606, '2009-07-24 13:16:22', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14525, 3608, '2009-07-16 12:52:47', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14526, 3608, '2009-07-16 17:26:03', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14528, 3608, '2009-07-19 15:22:38', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14529, 3608, '2009-07-24 11:47:31', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14530, 3608, '2009-07-26 15:12:30', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14531, 3609, '2009-07-16 12:32:16', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14532, 3609, '2009-07-20 17:50:02', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (14533, 3610, '2009-07-16 06:15:38', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14534, 3610, '2009-07-19 18:51:20', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14536, 3610, '2009-07-24 13:34:26', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14537, 3610, '2009-07-28 12:26:14', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14538, 3610, '2009-08-01 18:59:01', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14539, 3611, '2009-07-18 09:33:40', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14540, 3611, '2009-07-18 18:01:14', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14541, 3611, '2009-07-23 07:38:38', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14543, 3611, '2009-07-25 07:22:16', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14544, 3611, '2009-07-29 14:52:12', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (14546, 3612, '2009-07-21 16:16:18', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14548, 3613, '2009-07-20 17:50:24', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14549, 3614, '2009-07-18 11:17:59', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14551, 3614, '2009-07-24 12:16:04', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14552, 3614, '2009-07-27 13:16:25', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14553, 3615, '2009-07-18 10:49:41', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14554, 3615, '2009-07-22 14:13:44', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14555, 3615, '2009-07-23 06:30:55', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14556, 3615, '2009-07-24 13:26:35', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14557, 3615, '2009-07-28 08:06:16', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14558, 3615, '2009-08-01 13:35:33', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14559, 3616, '2009-07-18 06:59:12', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14560, 3616, '2009-07-21 16:25:35', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14561, 3616, '2009-07-24 06:27:28', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14562, 3616, '2009-07-27 16:52:18', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14563, 3616, '2009-07-30 08:22:04', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14564, 3616, '2009-08-01 17:56:00', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14566, 3617, '2009-07-18 17:06:19', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14567, 3617, '2009-07-23 09:35:06', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (14568, 3617, '2009-07-26 14:17:21', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14569, 3618, '2009-07-18 06:00:21', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14571, 3618, '2009-07-26 12:59:16', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14572, 3618, '2009-07-26 17:22:38', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14573, 3619, '2009-07-18 06:17:57', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14575, 3620, '2009-07-18 06:02:33', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14576, 3620, '2009-07-20 13:13:11', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (14577, 3620, '2009-07-24 08:05:33', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (14579, 3620, '2009-07-29 11:14:28', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (14580, 3620, '2009-07-29 17:54:52', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (14582, 3621, '2009-07-18 15:04:12', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14584, 3622, '2009-07-19 13:39:41', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14585, 3623, '2009-07-19 07:47:59', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14587, 3623, '2009-07-23 10:02:03', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14588, 3623, '2009-07-23 14:30:35', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14589, 3624, '2009-07-19 10:04:05', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14590, 3624, '2009-07-24 13:14:58', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14591, 3624, '2009-07-25 11:37:22', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14592, 3624, '2009-07-30 16:05:06', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14593, 3624, '2009-08-01 08:04:48', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14594, 3625, '2009-07-19 09:05:31', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14595, 3625, '2009-07-20 14:50:03', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14598, 3626, '2009-07-19 10:05:02', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14599, 3626, '2009-07-24 15:28:18', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', '');
INSERT INTO "ticketmessage" VALUES (14600, 3627, '2009-07-19 12:00:15', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14601, 3627, '2009-07-23 17:47:45', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14602, 3627, '2009-07-26 10:17:41', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14605, 3627, '2009-08-01 13:41:29', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14607, 3628, '2009-07-21 16:20:41', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14609, 3628, '2009-07-29 13:49:47', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14610, 3628, '2009-08-02 10:16:47', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14611, 3629, '2009-07-20 11:40:35', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14612, 3629, '2009-07-25 17:41:24', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14613, 3629, '2009-07-28 11:10:03', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14615, 3630, '2009-07-22 17:56:52', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14616, 3631, '2009-07-20 10:56:28', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14617, 3631, '2009-07-20 18:57:48', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14618, 3631, '2009-07-24 07:47:14', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14620, 3631, '2009-07-27 11:49:32', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14621, 3631, '2009-07-31 15:00:27', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14622, 3632, '2009-07-20 07:37:20', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14623, 3632, '2009-07-20 13:27:55', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14624, 3633, '2009-07-20 07:00:47', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14625, 3633, '2009-07-21 18:06:25', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14626, 3633, '2009-07-23 12:01:08', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14628, 3634, '2009-07-20 12:29:38', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14629, 3634, '2009-07-25 18:04:19', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14630, 3635, '2009-07-20 06:15:03', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14631, 3635, '2009-07-25 18:04:48', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14633, 3636, '2009-07-25 15:44:19', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14634, 3636, '2009-07-29 11:00:40', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14635, 3636, '2009-08-01 16:07:23', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14636, 3636, '2009-08-06 10:25:07', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14637, 3636, '2009-08-11 18:55:14', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (14639, 3637, '2009-07-25 15:44:57', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14640, 3638, '2009-07-20 08:29:28', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14641, 3638, '2009-07-22 14:24:26', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14642, 3639, '2009-07-20 12:54:38', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14644, 3639, '2009-07-22 10:07:37', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14645, 3639, '2009-07-22 13:27:41', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14646, 3640, '2009-07-20 10:23:21', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14647, 3640, '2009-07-25 17:35:01', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14648, 3641, '2009-07-20 12:14:58', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14649, 3641, '2009-07-20 16:45:59', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14650, 3641, '2009-07-23 07:41:12', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14651, 3641, '2009-07-27 13:39:27', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14652, 3641, '2009-07-28 07:24:56', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14654, 3642, '2009-07-20 16:39:46', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14657, 3642, '2009-07-27 10:56:50', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14658, 3642, '2009-07-30 17:36:15', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14659, 3643, '2009-07-20 10:36:09', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14660, 3644, '2009-07-20 07:04:27', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14661, 3644, '2009-07-20 16:22:57', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14662, 3644, '2009-07-24 08:26:25', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14664, 3645, '2009-07-20 11:22:34', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14665, 3645, '2009-07-22 17:03:53', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14666, 3645, '2009-07-23 09:12:02', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14667, 3645, '2009-07-28 13:26:06', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14668, 3646, '2009-07-21 06:56:38', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14670, 3646, '2009-07-25 12:11:55', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (14672, 3647, '2009-07-21 14:29:31', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (14673, 3648, '2009-07-21 06:10:15', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14674, 3648, '2009-07-25 17:42:21', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14675, 3649, '2009-07-21 08:59:42', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14676, 3649, '2009-07-22 14:40:04', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14678, 3649, '2009-07-26 13:05:31', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14679, 3650, '2009-07-21 07:26:17', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14680, 3650, '2009-07-22 15:59:00', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14682, 3651, '2009-07-23 14:29:36', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (14683, 3652, '2009-07-21 06:59:38', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14684, 3652, '2009-07-23 16:30:07', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14685, 3652, '2009-07-25 07:16:03', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14687, 3652, '2009-07-31 09:23:58', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14688, 3652, '2009-08-02 16:21:04', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14690, 3653, '2009-07-25 15:48:18', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14691, 3654, '2009-07-21 09:37:51', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14692, 3654, '2009-07-26 15:20:54', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14693, 3654, '2009-07-30 12:56:11', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14694, 3654, '2009-08-02 17:39:04', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14695, 3654, '2009-08-07 11:39:12', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14698, 3655, '2009-07-21 13:53:57', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14699, 3656, '2009-07-21 12:25:23', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14700, 3656, '2009-07-23 13:31:46', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14701, 3657, '2009-07-21 10:17:04', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14703, 3658, '2009-07-21 11:49:46', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14704, 3658, '2009-07-23 14:30:06', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14705, 3659, '2009-07-22 10:07:44', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14706, 3659, '2009-07-23 14:56:36', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14707, 3659, '2009-07-28 07:09:00', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14708, 3659, '2009-07-28 14:43:55', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14709, 3659, '2009-07-30 09:22:32', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14711, 3660, '2009-07-22 11:28:57', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14712, 3660, '2009-07-24 16:16:40', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14713, 3661, '2009-07-22 06:26:40', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14714, 3661, '2009-07-24 14:34:21', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14715, 3662, '2009-07-22 11:44:41', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14716, 3662, '2009-07-23 17:44:34', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14718, 3662, '2009-07-28 17:25:22', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14719, 3663, '2009-07-22 09:05:53', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14721, 3663, '2009-07-25 08:10:08', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14723, 3664, '2009-07-27 13:03:00', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14725, 3665, '2009-07-25 18:15:34', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14726, 3666, '2009-07-22 12:00:54', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14727, 3666, '2009-07-25 14:49:29', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14728, 3667, '2009-07-22 10:42:32', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14729, 3667, '2009-07-26 17:26:43', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14730, 3667, '2009-07-27 10:53:18', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14731, 3667, '2009-08-01 15:09:59', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14732, 3667, '2009-08-06 06:59:47', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14733, 3667, '2009-08-07 13:49:51', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14734, 3668, '2009-07-22 09:54:02', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14736, 3668, '2009-07-26 11:45:37', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14737, 3668, '2009-07-31 13:40:25', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14738, 3669, '2009-07-23 12:27:03', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14739, 3669, '2009-07-27 17:05:50', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14740, 3670, '2009-07-24 11:39:57', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14742, 3671, '2009-07-28 13:49:32', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14743, 3671, '2009-07-31 07:34:06', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14745, 3672, '2009-07-25 12:02:47', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14747, 3673, '2009-07-25 11:56:56', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14748, 3673, '2009-07-29 18:45:20', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14751, 3673, '2009-08-11 10:02:11', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14752, 3673, '2009-08-15 17:59:58', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14753, 3674, '2009-07-25 12:12:38', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14754, 3674, '2009-07-28 18:15:46', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14755, 3675, '2009-07-25 09:06:30', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14757, 3675, '2009-08-03 11:58:06', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14758, 3675, '2009-08-07 14:30:49', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14759, 3675, '2009-08-08 06:57:34', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14760, 3675, '2009-08-09 17:08:09', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14761, 3676, '2009-07-25 09:27:21', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14762, 3677, '2009-07-25 09:53:40', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14764, 3678, '2009-07-25 07:23:55', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14765, 3678, '2009-07-27 18:29:26', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14766, 3678, '2009-08-01 12:44:20', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14767, 3678, '2009-08-05 14:17:06', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14769, 3678, '2009-08-10 15:16:54', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14770, 3679, '2009-07-25 08:47:56', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14771, 3679, '2009-07-27 13:40:02', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14772, 3680, '2009-07-25 11:27:28', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14773, 3680, '2009-07-30 15:55:02', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14774, 3681, '2009-07-26 08:42:47', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14775, 3681, '2009-07-28 16:09:09', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14776, 3681, '2009-08-01 08:43:40', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14777, 3681, '2009-08-04 16:57:50', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14779, 3682, '2009-07-26 12:30:06', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14780, 3682, '2009-07-30 17:30:06', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14781, 3682, '2009-08-01 12:07:50', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14782, 3682, '2009-08-04 13:54:23', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14783, 3683, '2009-07-26 07:54:27', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14785, 3683, '2009-08-01 06:46:39', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14786, 3683, '2009-08-02 14:59:12', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14787, 3683, '2009-08-04 09:39:08', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14788, 3683, '2009-08-06 14:39:39', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14789, 3684, '2009-07-26 11:24:25', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14790, 3684, '2009-07-26 18:52:28', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14791, 3684, '2009-07-28 08:27:32', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14792, 3684, '2009-07-30 13:14:12', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14793, 3685, '2009-07-26 07:24:00', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14794, 3685, '2009-07-30 13:01:54', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14796, 3685, '2009-08-05 16:06:28', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14797, 3685, '2009-08-07 07:39:19', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14798, 3685, '2009-08-08 18:03:05', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14799, 3686, '2009-07-26 10:32:58', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14801, 3686, '2009-08-01 07:31:05', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14802, 3686, '2009-08-02 16:54:05', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (14803, 3687, '2009-07-26 12:43:58', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14805, 3687, '2009-08-01 07:03:58', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14806, 3687, '2009-08-02 18:33:25', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14808, 3687, '2009-08-06 15:24:30', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14810, 3688, '2009-07-29 16:46:11', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14811, 3688, '2009-07-31 06:14:47', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14812, 3688, '2009-08-03 15:17:33', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (14813, 3689, '2009-07-26 06:54:31', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14814, 3690, '2009-07-27 12:45:05', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14815, 3690, '2009-08-01 17:09:10', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (14816, 3690, '2009-08-06 12:29:25', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (14819, 3691, '2009-07-27 11:57:10', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14820, 3691, '2009-07-30 15:29:21', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14822, 3691, '2009-08-03 14:20:43', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (14823, 3692, '2009-07-27 12:55:02', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14825, 3692, '2009-07-29 10:16:12', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14826, 3692, '2009-08-03 17:32:47', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14827, 3692, '2009-08-04 09:21:47', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14828, 3692, '2009-08-09 18:37:58', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14829, 3693, '2009-07-27 07:25:11', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14830, 3693, '2009-07-31 16:53:34', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14831, 3694, '2009-07-27 09:22:16', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14832, 3694, '2009-07-31 15:13:53', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14833, 3695, '2009-07-27 09:59:03', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14834, 3696, '2009-07-27 12:25:08', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14835, 3696, '2009-08-01 15:19:04', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14836, 3696, '2009-08-05 10:47:33', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14837, 3696, '2009-08-07 13:18:42', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14838, 3697, '2009-07-27 10:41:09', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14839, 3697, '2009-07-28 17:01:32', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14840, 3698, '2009-07-27 10:26:38', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14841, 3698, '2009-07-28 16:43:47', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14842, 3699, '2009-07-27 06:43:52', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14843, 3699, '2009-07-30 13:19:17', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14845, 3699, '2009-08-06 18:52:18', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14846, 3700, '2009-07-27 10:09:58', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14847, 3700, '2009-07-29 14:41:49', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14848, 3700, '2009-07-30 10:01:36', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14849, 3700, '2009-08-03 18:33:42', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14850, 3701, '2009-07-27 08:51:28', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14852, 3701, '2009-08-04 07:27:04', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (14853, 3701, '2009-08-05 14:14:00', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (14854, 3702, '2009-07-27 09:37:47', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14855, 3702, '2009-07-30 18:02:20', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14856, 3702, '2009-08-02 11:19:31', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14857, 3702, '2009-08-05 16:51:56', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14858, 3703, '2009-07-27 09:52:22', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14859, 3703, '2009-07-30 17:31:26', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14860, 3704, '2009-07-27 11:38:35', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14864, 3705, '2009-08-03 06:29:14', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (14865, 3705, '2009-08-05 15:35:22', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14866, 3705, '2009-08-07 12:40:07', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (14867, 3706, '2009-07-27 06:43:41', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14868, 3706, '2009-07-29 14:48:01', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14869, 3707, '2009-07-27 08:45:05', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14870, 3707, '2009-07-27 17:00:14', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (14871, 3707, '2009-07-28 07:13:18', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (14872, 3707, '2009-07-31 14:38:57', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (14874, 3709, '2009-07-28 09:07:07', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14875, 3709, '2009-07-31 16:29:03', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14876, 3709, '2009-08-05 09:03:12', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14877, 3709, '2009-08-09 16:37:21', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14878, 3710, '2009-07-28 11:23:49', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14881, 3710, '2009-08-05 16:02:59', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14882, 3710, '2009-08-09 11:44:41', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14883, 3710, '2009-08-09 18:10:38', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14885, 3711, '2009-07-29 13:16:53', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14886, 3711, '2009-08-01 07:18:13', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14887, 3711, '2009-08-06 16:01:31', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (14888, 3712, '2009-07-28 08:14:24', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14889, 3712, '2009-07-30 13:57:43', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14890, 3712, '2009-08-04 10:45:41', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14891, 3713, '2009-07-28 08:06:43', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14892, 3713, '2009-08-02 15:21:22', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14893, 3713, '2009-08-04 12:45:07', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14894, 3713, '2009-08-04 18:56:18', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14895, 3713, '2009-08-05 07:23:38', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14897, 3714, '2009-07-28 08:40:08', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14898, 3714, '2009-07-30 14:17:17', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14900, 3714, '2009-08-05 17:53:22', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (14901, 3715, '2009-07-28 09:58:39', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14904, 3715, '2009-08-11 18:20:07', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14905, 3716, '2009-07-28 12:47:44', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14906, 3716, '2009-08-02 18:12:54', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14907, 3716, '2009-08-07 09:10:38', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (14908, 3716, '2009-08-07 15:28:59', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (14909, 3717, '2009-07-29 06:50:15', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14910, 3717, '2009-08-01 17:12:58', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14911, 3717, '2009-08-04 11:41:09', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14912, 3717, '2009-08-08 13:22:29', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14913, 3718, '2009-07-29 12:52:43', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14914, 3718, '2009-08-02 18:23:19', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14915, 3718, '2009-08-03 07:05:39', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14916, 3718, '2009-08-08 16:08:25', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (14917, 3718, '2009-08-09 06:49:42', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (14918, 3718, '2009-08-09 13:03:16', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (14919, 3719, '2009-07-29 07:13:39', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14920, 3719, '2009-08-02 13:08:33', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14921, 3719, '2009-08-03 08:49:48', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14922, 3719, '2009-08-05 16:43:23', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14923, 3720, '2009-07-29 08:07:44', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14924, 3720, '2009-08-01 17:30:45', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14925, 3720, '2009-08-02 07:53:31', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14926, 3720, '2009-08-07 13:46:42', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (14927, 3721, '2009-07-29 08:38:44', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14928, 3721, '2009-07-29 16:17:58', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14929, 3721, '2009-08-02 07:17:04', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14930, 3721, '2009-08-03 15:55:19', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14931, 3722, '2009-07-29 07:58:19', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14932, 3723, '2009-07-29 08:35:53', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14933, 3723, '2009-07-31 15:16:53', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (14935, 3723, '2009-08-02 14:09:42', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (14936, 3724, '2009-07-30 11:45:23', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14938, 3724, '2009-08-03 06:19:56', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14939, 3724, '2009-08-04 14:34:52', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14942, 3725, '2009-08-04 12:39:26', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14943, 3725, '2009-08-09 15:04:21', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14944, 3726, '2009-07-30 12:58:13', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14945, 3726, '2009-08-03 16:02:24', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14947, 3726, '2009-08-13 13:29:24', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14948, 3726, '2009-08-16 09:58:54', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14949, 3726, '2009-08-21 17:23:01', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14950, 3727, '2009-07-30 07:43:23', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14952, 3727, '2009-08-05 11:02:45', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14953, 3727, '2009-08-10 16:24:48', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14954, 3728, '2009-08-01 11:01:57', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14955, 3728, '2009-08-04 15:12:26', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14956, 3728, '2009-08-09 08:04:58', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (14957, 3728, '2009-08-12 16:07:31', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14958, 3729, '2009-08-01 07:04:51', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14959, 3729, '2009-08-06 16:52:43', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (14960, 3729, '2009-08-08 12:29:55', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (14961, 3730, '2009-08-01 08:23:43', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14963, 3730, '2009-08-10 09:08:53', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (14964, 3731, '2009-08-01 11:53:35', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14965, 3731, '2009-08-03 13:03:53', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14967, 3732, '2009-08-01 11:34:34', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14968, 3732, '2009-08-04 15:33:11', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14969, 3732, '2009-08-05 08:32:38', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14970, 3732, '2009-08-05 15:27:38', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14972, 3732, '2009-08-09 17:06:07', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14973, 3733, '2009-08-01 08:15:29', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14975, 3733, '2009-08-05 11:57:29', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (14976, 3733, '2009-08-05 15:46:39', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (14978, 3734, '2009-08-03 14:39:25', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (14979, 3734, '2009-08-07 07:27:06', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (14980, 3734, '2009-08-08 14:59:48', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (14981, 3735, '2009-08-01 06:08:03', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14982, 3735, '2009-08-02 13:57:08', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14983, 3735, '2009-08-07 07:52:46', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14985, 3735, '2009-08-13 10:13:32', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (14986, 3735, '2009-08-16 17:21:15', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (14988, 3736, '2009-08-01 18:13:01', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (14990, 3736, '2009-08-08 14:19:42', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (14993, 3738, '2009-08-02 09:59:33', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14994, 3738, '2009-08-03 16:20:44', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14996, 3738, '2009-08-07 16:27:23', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (14997, 3739, '2009-08-02 12:25:21', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (14998, 3739, '2009-08-02 13:40:50', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (14999, 3739, '2009-08-03 10:46:24', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15001, 3739, '2009-08-10 09:55:36', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15002, 3739, '2009-08-12 13:19:04', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15004, 3740, '2009-08-04 18:14:55', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (15006, 3740, '2009-08-13 18:37:33', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15007, 3741, '2009-08-02 11:10:09', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15008, 3741, '2009-08-05 18:51:47', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15010, 3742, '2009-08-02 12:32:28', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15011, 3742, '2009-08-02 17:14:52', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15012, 3742, '2009-08-06 08:00:09', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15013, 3742, '2009-08-10 15:21:29', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15017, 3743, '2009-08-08 17:21:49', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15018, 3743, '2009-08-12 07:58:56', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15019, 3743, '2009-08-13 18:05:04', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (15020, 3744, '2009-08-02 09:27:02', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15021, 3744, '2009-08-02 14:07:52', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15022, 3744, '2009-08-06 10:46:38', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15023, 3744, '2009-08-11 18:26:47', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15025, 3745, '2009-08-02 08:45:20', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15027, 3746, '2009-08-02 09:19:21', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15028, 3746, '2009-08-03 17:12:04', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15029, 3746, '2009-08-05 06:36:28', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15030, 3746, '2009-08-08 14:05:01', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15031, 3747, '2009-08-02 12:48:52', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15032, 3747, '2009-08-06 15:53:37', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15033, 3747, '2009-08-10 12:04:41', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15034, 3747, '2009-08-15 15:22:41', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15035, 3748, '2009-08-03 09:18:37', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15036, 3748, '2009-08-04 18:03:37', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15037, 3748, '2009-08-07 10:42:21', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15038, 3748, '2009-08-09 17:09:36', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15039, 3748, '2009-08-11 11:55:49', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15040, 3749, '2009-08-03 11:46:15', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15041, 3749, '2009-08-07 15:24:14', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15042, 3749, '2009-08-11 10:53:55', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15043, 3749, '2009-08-14 15:40:46', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15044, 3749, '2009-08-19 09:35:12', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15045, 3750, '2009-08-03 07:49:31', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15046, 3750, '2009-08-06 18:17:46', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15047, 3750, '2009-08-10 06:59:02', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15048, 3750, '2009-08-10 14:37:12', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15049, 3750, '2009-08-11 08:44:33', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15050, 3750, '2009-08-12 18:12:18', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (15051, 3751, '2009-08-03 11:05:15', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15052, 3751, '2009-08-03 18:31:42', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15053, 3751, '2009-08-08 06:53:41', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15054, 3751, '2009-08-08 14:27:34', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (15055, 3752, '2009-08-03 09:47:44', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15056, 3752, '2009-08-05 16:30:24', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15057, 3752, '2009-08-07 09:33:12', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15059, 3752, '2009-08-14 10:12:02', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15060, 3752, '2009-08-18 16:00:41', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15061, 3753, '2009-08-03 12:11:06', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15062, 3753, '2009-08-08 15:24:05', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15063, 3754, '2009-08-03 12:13:34', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15064, 3754, '2009-08-03 17:42:24', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15065, 3755, '2009-08-03 07:58:39', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15066, 3755, '2009-08-07 13:45:40', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15067, 3756, '2009-08-03 11:09:21', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15068, 3756, '2009-08-08 14:28:56', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15069, 3756, '2009-08-11 11:11:04', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15070, 3756, '2009-08-16 13:04:15', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15072, 3756, '2009-08-23 16:24:58', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15073, 3757, '2009-08-03 11:09:08', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15074, 3757, '2009-08-05 13:00:14', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (15075, 3758, '2009-08-03 10:46:07', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15076, 3758, '2009-08-04 15:14:57', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15079, 3761, '2009-08-03 09:32:45', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15080, 3761, '2009-08-03 13:54:24', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15082, 3762, '2009-08-04 13:58:30', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15083, 3762, '2009-08-09 11:41:49', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15084, 3762, '2009-08-14 15:27:30', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15085, 3762, '2009-08-15 08:49:11', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15086, 3762, '2009-08-19 18:59:45', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (15087, 3763, '2009-08-03 09:52:01', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15090, 3764, '2009-08-03 17:22:39', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (15091, 3765, '2009-08-04 07:27:04', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15092, 3765, '2009-08-08 18:55:38', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15093, 3765, '2009-08-10 07:21:54', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15094, 3765, '2009-08-14 17:42:23', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15095, 3765, '2009-08-16 06:59:52', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15097, 3766, '2009-08-04 09:21:16', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15098, 3766, '2009-08-09 13:29:54', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15100, 3766, '2009-08-18 18:18:22', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15101, 3766, '2009-08-19 08:12:20', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15102, 3766, '2009-08-22 15:38:12', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15103, 3767, '2009-08-04 12:17:11', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15105, 3767, '2009-08-10 11:50:06', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15106, 3767, '2009-08-14 18:17:09', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15107, 3768, '2009-08-04 11:38:14', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15108, 3769, '2009-08-04 11:34:45', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15109, 3769, '2009-08-04 16:16:17', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15111, 3769, '2009-08-08 17:05:58', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15112, 3769, '2009-08-11 12:07:16', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15113, 3769, '2009-08-15 14:45:16', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15114, 3770, '2009-08-04 08:33:33', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15115, 3770, '2009-08-07 14:29:28', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15116, 3770, '2009-08-11 07:19:05', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15117, 3770, '2009-08-13 15:45:47', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15119, 3771, '2009-08-09 18:01:43', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15120, 3772, '2009-08-04 08:06:59', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15121, 3772, '2009-08-07 13:38:57', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (15122, 3773, '2009-08-04 12:11:20', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15123, 3773, '2009-08-08 14:31:54', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15124, 3773, '2009-08-13 11:07:08', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15125, 3774, '2009-08-05 12:35:05', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15126, 3774, '2009-08-05 13:05:32', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15127, 3774, '2009-08-08 07:43:13', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15130, 3776, '2009-08-05 12:01:44', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15131, 3776, '2009-08-05 16:30:18', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (15133, 3777, '2009-08-06 18:58:49', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15134, 3778, '2009-08-05 07:39:18', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15135, 3778, '2009-08-09 13:35:58', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15136, 3779, '2009-08-05 06:44:14', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15137, 3780, '2009-08-05 06:02:59', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15140, 3780, '2009-08-12 17:17:00', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15141, 3780, '2009-08-14 08:14:33', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15142, 3780, '2009-08-17 16:33:22', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15143, 3781, '2009-08-05 07:08:54', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15145, 3781, '2009-08-10 10:03:28', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15146, 3781, '2009-08-15 18:25:59', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15147, 3782, '2009-08-06 09:09:34', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15148, 3783, '2009-08-06 12:16:49', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15149, 3783, '2009-08-07 18:15:11', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15150, 3783, '2009-08-08 08:37:30', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15151, 3783, '2009-08-09 14:39:14', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15152, 3783, '2009-08-11 11:04:03', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15153, 3783, '2009-08-16 16:33:38', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15154, 3784, '2009-08-07 06:50:54', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15155, 3784, '2009-08-07 14:28:08', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15157, 3784, '2009-08-12 13:15:42', X'506C656173652C207472790A7265696E7374616C6C696E67207468650A70726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15158, 3784, '2009-08-13 09:23:43', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15159, 3785, '2009-08-08 06:08:21', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15160, 3786, '2009-08-08 06:27:38', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15161, 3786, '2009-08-10 18:23:00', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15163, 3787, '2009-08-08 10:07:38', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15164, 3788, '2009-08-08 11:30:30', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15165, 3788, '2009-08-09 14:09:03', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15166, 3789, '2009-08-08 11:34:00', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15169, 3789, '2009-08-16 17:03:34', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15170, 3789, '2009-08-21 09:10:44', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15173, 3791, '2009-08-08 09:40:18', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15174, 3791, '2009-08-13 15:11:06', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15175, 3791, '2009-08-18 12:47:49', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15176, 3791, '2009-08-23 13:48:43', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15177, 3791, '2009-08-26 06:37:23', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15179, 3792, '2009-08-12 15:02:19', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15181, 3793, '2009-08-11 14:55:00', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15183, 3794, '2009-08-11 14:19:22', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15184, 3795, '2009-08-09 12:02:15', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15185, 3796, '2009-08-09 12:12:48', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15186, 3796, '2009-08-10 18:21:52', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15188, 3796, '2009-08-15 18:00:57', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15192, 3797, '2009-08-11 17:42:41', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15193, 3798, '2009-08-09 10:45:30', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15194, 3799, '2009-08-09 07:52:57', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15195, 3799, '2009-08-14 16:24:24', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15196, 3799, '2009-08-17 12:10:57', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15198, 3800, '2009-08-09 10:47:53', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15199, 3800, '2009-08-13 13:23:58', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15200, 3800, '2009-08-17 08:51:36', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15201, 3801, '2009-08-09 06:06:39', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15204, 3803, '2009-08-09 17:57:58', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15205, 3804, '2009-08-09 10:34:35', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15206, 3804, '2009-08-12 17:08:18', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15207, 3804, '2009-08-17 08:12:18', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15209, 3804, '2009-08-21 08:09:40', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15210, 3804, '2009-08-26 16:45:18', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15211, 3805, '2009-08-09 10:45:35', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15212, 3805, '2009-08-09 14:04:20', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15213, 3806, '2009-08-09 06:15:25', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15214, 3807, '2009-08-10 12:46:22', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15215, 3807, '2009-08-13 17:19:36', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15216, 3807, '2009-08-16 07:10:17', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15217, 3807, '2009-08-17 15:11:33', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15218, 3807, '2009-08-22 11:22:03', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15219, 3807, '2009-08-22 13:43:33', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15220, 3808, '2009-08-10 06:34:09', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', '');
INSERT INTO "ticketmessage" VALUES (15221, 3808, '2009-08-10 15:49:10', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15222, 3808, '2009-08-13 11:59:12', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15223, 3808, '2009-08-17 15:33:27', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15224, 3808, '2009-08-21 12:57:59', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15225, 3808, '2009-08-25 17:12:13', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (15226, 3809, '2009-08-10 06:48:48', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15227, 3809, '2009-08-10 16:28:13', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15228, 3810, '2009-08-10 12:48:00', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15229, 3810, '2009-08-14 15:43:00', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15230, 3810, '2009-08-16 08:49:24', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15231, 3810, '2009-08-21 16:07:22', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (15233, 3811, '2009-08-15 17:05:58', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15234, 3811, '2009-08-17 11:00:28', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15235, 3811, '2009-08-20 17:08:10', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15236, 3811, '2009-08-21 07:12:05', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15238, 3812, '2009-08-10 06:19:41', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15239, 3812, '2009-08-10 14:21:26', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (15240, 3813, '2009-08-10 11:19:45', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15241, 3814, '2009-08-10 12:08:23', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15244, 3815, '2009-08-19 08:24:14', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15245, 3815, '2009-08-19 14:00:09', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15246, 3815, '2009-08-23 10:26:59', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15248, 3816, '2009-08-11 17:21:41', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15250, 3816, '2009-08-17 18:50:33', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (15251, 3817, '2009-08-10 08:45:12', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15252, 3817, '2009-08-12 15:51:33', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15254, 3819, '2009-08-10 12:16:28', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15256, 3819, '2009-08-13 09:16:45', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15257, 3819, '2009-08-18 13:44:27', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15258, 3819, '2009-08-21 10:51:43', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15259, 3819, '2009-08-21 14:09:11', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15260, 3820, '2009-08-10 06:58:13', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15261, 3820, '2009-08-12 16:06:44', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15263, 3821, '2009-08-11 17:24:27', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15264, 3821, '2009-08-13 11:30:39', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15265, 3821, '2009-08-15 15:50:21', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15267, 3822, '2009-08-14 14:11:53', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15269, 3822, '2009-08-21 13:19:20', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15270, 3822, '2009-08-25 06:08:56', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15273, 3824, '2009-08-11 10:08:30', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15275, 3825, '2009-08-15 13:04:24', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (15276, 3825, '2009-08-16 06:42:16', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (15277, 3825, '2009-08-21 17:33:12', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (15278, 3826, '2009-08-11 09:14:14', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15281, 3826, '2009-08-13 18:12:35', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15283, 3826, '2009-08-20 15:04:49', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15284, 3827, '2009-08-11 10:42:46', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15285, 3827, '2009-08-11 15:21:49', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15286, 3827, '2009-08-16 06:00:36', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15287, 3827, '2009-08-18 15:45:19', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15288, 3827, '2009-08-19 12:24:16', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15289, 3827, '2009-08-19 16:05:38', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15291, 3828, '2009-08-16 14:35:19', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15292, 3829, '2009-08-11 07:54:41', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15293, 3829, '2009-08-16 16:22:45', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15294, 3829, '2009-08-17 08:34:35', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15295, 3829, '2009-08-17 14:06:26', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15297, 3831, '2009-08-11 08:49:12', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15298, 3831, '2009-08-15 15:56:28', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15299, 3831, '2009-08-19 08:56:48', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15300, 3831, '2009-08-21 17:34:39', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15302, 3832, '2009-08-17 18:29:47', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15304, 3833, '2009-08-13 14:22:06', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15307, 3833, '2009-08-27 11:53:05', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15308, 3833, '2009-09-02 15:11:38', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15309, 3834, '2009-08-12 06:34:04', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15310, 3834, '2009-08-16 17:15:31', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15311, 3834, '2009-08-18 08:50:02', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15313, 3834, '2009-08-20 09:38:38', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15314, 3835, '2009-08-12 11:59:24', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15315, 3835, '2009-08-16 14:00:26', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15317, 3835, '2009-08-22 13:23:18', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (15318, 3836, '2009-08-12 08:24:56', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15319, 3836, '2009-08-16 15:15:45', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15320, 3836, '2009-08-21 07:59:38', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15322, 3836, '2009-08-26 06:45:21', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15323, 3836, '2009-08-30 14:00:18', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15324, 3837, '2009-08-12 09:32:22', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15326, 3838, '2009-08-12 08:06:12', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15327, 3838, '2009-08-17 15:28:37', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (15328, 3839, '2009-08-12 12:05:12', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15329, 3839, '2009-08-12 15:44:06', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15330, 3840, '2009-08-12 10:45:13', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15332, 3841, '2009-08-12 11:59:42', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15333, 3841, '2009-08-14 17:17:53', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15334, 3842, '2009-08-12 11:42:14', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15335, 3842, '2009-08-14 14:58:29', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15336, 3842, '2009-08-16 06:45:35', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15337, 3843, '2009-08-13 06:56:02', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15338, 3843, '2009-08-16 14:50:03', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15341, 3844, '2009-08-15 13:45:24', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15342, 3845, '2009-08-13 12:32:55', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15344, 3845, '2009-08-19 09:42:44', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15345, 3845, '2009-08-20 16:21:23', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15346, 3846, '2009-08-13 11:55:02', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15347, 3846, '2009-08-16 16:52:48', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15348, 3846, '2009-08-17 07:24:08', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15349, 3846, '2009-08-20 14:57:39', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15351, 3846, '2009-08-27 13:09:16', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15354, 3848, '2009-08-18 13:32:56', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15355, 3848, '2009-08-23 07:50:40', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15356, 3848, '2009-08-28 13:58:27', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15358, 3848, '2009-09-04 13:43:31', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15359, 3849, '2009-08-15 09:04:36', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15361, 3849, '2009-08-24 07:51:02', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15362, 3849, '2009-08-29 15:15:37', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15363, 3849, '2009-09-01 10:01:55', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15365, 3850, '2009-08-16 14:22:46', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15366, 3850, '2009-08-21 07:58:16', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15368, 3850, '2009-08-27 08:12:33', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15369, 3850, '2009-08-29 18:36:33', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15370, 3851, '2009-08-15 06:30:41', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15371, 3851, '2009-08-15 15:25:31', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15372, 3851, '2009-08-19 07:50:19', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15373, 3851, '2009-08-24 17:15:49', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15375, 3851, '2009-08-30 13:06:22', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (15376, 3852, '2009-08-15 09:11:19', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15377, 3852, '2009-08-17 14:28:07', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15378, 3852, '2009-08-19 11:37:59', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15379, 3852, '2009-08-24 18:40:13', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15381, 3852, '2009-08-27 14:26:25', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15382, 3853, '2009-08-15 12:11:36', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15385, 3854, '2009-08-16 13:35:46', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15386, 3854, '2009-08-19 08:10:58', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15389, 3855, '2009-08-16 18:53:31', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15390, 3856, '2009-08-15 08:09:26', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15391, 3856, '2009-08-18 15:53:42', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (15392, 3857, '2009-08-15 07:04:09', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15393, 3857, '2009-08-15 17:41:22', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15394, 3858, '2009-08-16 10:48:58', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15396, 3858, '2009-08-21 11:55:31', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15397, 3858, '2009-08-21 13:45:06', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15398, 3858, '2009-08-26 08:57:44', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15399, 3858, '2009-09-01 15:48:07', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (15400, 3859, '2009-08-16 08:18:54', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15401, 3859, '2009-08-18 17:30:56', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15402, 3859, '2009-08-19 08:28:56', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15404, 3859, '2009-08-23 10:19:28', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15405, 3859, '2009-08-24 13:49:39', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15406, 3860, '2009-08-16 08:59:08', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15408, 3861, '2009-08-21 18:47:23', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15409, 3861, '2009-08-26 08:33:51', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15410, 3861, '2009-08-29 15:57:44', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (15412, 3862, '2009-08-19 14:34:09', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15413, 3862, '2009-08-21 09:38:37', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15414, 3862, '2009-08-22 18:21:09', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15416, 3862, '2009-08-28 16:07:40', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15417, 3863, '2009-08-16 07:41:45', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15418, 3863, '2009-08-19 18:53:55', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15419, 3863, '2009-08-23 08:02:00', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15420, 3863, '2009-08-24 16:14:28', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15422, 3864, '2009-08-16 10:21:38', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15423, 3864, '2009-08-17 16:56:34', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (15424, 3865, '2009-08-16 09:55:00', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15426, 3867, '2009-08-16 07:53:46', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15427, 3867, '2009-08-18 13:34:09', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15428, 3867, '2009-08-22 08:34:39', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15429, 3867, '2009-08-27 13:53:14', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15430, 3868, '2009-08-17 09:34:45', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15431, 3868, '2009-08-19 16:38:08', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15433, 3869, '2009-08-20 16:15:22', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15434, 3869, '2009-08-22 12:37:01', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15435, 3869, '2009-08-24 16:35:36', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15436, 3869, '2009-08-28 07:52:05', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15437, 3870, '2009-08-17 08:11:30', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15438, 3870, '2009-08-19 16:27:33', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15439, 3870, '2009-08-22 06:53:49', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15442, 3871, '2009-08-20 17:15:40', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15443, 3871, '2009-08-22 07:06:05', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15444, 3871, '2009-08-24 14:50:16', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15445, 3871, '2009-08-26 11:31:05', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15446, 3871, '2009-09-01 18:34:16', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15447, 3872, '2009-08-17 09:16:50', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15449, 3873, '2009-08-18 13:40:59', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15450, 3873, '2009-08-23 06:43:04', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15451, 3873, '2009-08-28 17:54:39', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (15455, 3874, '2009-08-21 18:41:56', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15456, 3875, '2009-08-17 06:30:04', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15457, 3875, '2009-08-21 16:13:19', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15458, 3875, '2009-08-23 12:25:00', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15459, 3875, '2009-08-28 18:08:57', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15460, 3875, '2009-09-03 09:00:42', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15462, 3876, '2009-08-17 07:18:19', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15463, 3876, '2009-08-21 16:05:26', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15464, 3876, '2009-08-25 11:05:16', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15465, 3876, '2009-08-29 13:06:07', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15466, 3877, '2009-08-17 08:26:19', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15467, 3877, '2009-08-22 16:02:40', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15468, 3877, '2009-08-27 09:04:26', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15469, 3877, '2009-09-01 15:07:35', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15470, 3878, '2009-08-17 12:38:03', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15471, 3878, '2009-08-18 13:58:38', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15472, 3879, '2009-08-17 09:26:04', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15475, 3879, '2009-08-23 18:44:58', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15476, 3879, '2009-08-24 07:24:23', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15477, 3879, '2009-08-29 17:09:35', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (15479, 3880, '2009-08-18 18:57:19', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15480, 3880, '2009-08-19 11:14:53', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15481, 3880, '2009-08-21 18:19:22', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (15482, 3881, '2009-08-17 09:21:27', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15485, 3881, '2009-08-28 18:52:44', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15486, 3882, '2009-08-17 10:55:58', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15487, 3883, '2009-08-17 07:37:31', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15490, 3883, '2009-08-23 14:51:59', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15491, 3884, '2009-08-18 10:31:33', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15492, 3884, '2009-08-22 18:54:59', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (15493, 3885, '2009-08-18 06:47:05', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15495, 3886, '2009-08-18 07:53:22', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15496, 3886, '2009-08-21 18:31:07', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15498, 3887, '2009-08-21 13:52:40', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15499, 3887, '2009-08-25 10:22:43', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15501, 3887, '2009-08-30 06:17:19', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15502, 3888, '2009-08-18 09:24:33', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15503, 3888, '2009-08-22 14:29:39', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15504, 3888, '2009-08-26 08:17:28', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15506, 3888, '2009-09-03 06:45:04', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15507, 3889, '2009-08-18 12:20:58', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15508, 3889, '2009-08-18 15:04:00', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (15509, 3889, '2009-08-21 11:44:20', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (15510, 3889, '2009-08-23 14:11:01', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (15513, 3890, '2009-08-18 12:18:52', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15514, 3890, '2009-08-22 17:20:11', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15516, 3891, '2009-08-22 13:54:51', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15517, 3891, '2009-08-24 11:50:14', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15518, 3891, '2009-08-24 13:33:49', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15519, 3891, '2009-08-27 09:29:36', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15520, 3891, '2009-08-29 15:53:04', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15521, 3892, '2009-08-18 10:06:40', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15522, 3893, '2009-08-18 08:12:15', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468650A73696465', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15523, 3894, '2009-08-18 10:35:57', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15524, 3894, '2009-08-22 17:49:34', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15525, 3894, '2009-08-27 10:57:12', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15526, 3894, '2009-08-29 13:54:40', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15528, 3896, '2009-08-18 08:17:40', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15529, 3896, '2009-08-23 16:55:28', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15530, 3896, '2009-08-28 11:55:32', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15532, 3897, '2009-08-19 07:14:02', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15533, 3897, '2009-08-22 13:48:20', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15536, 3898, '2009-08-19 13:23:45', X'576520616C72656164790A70726F766964656420746865206669782E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15538, 3898, '2009-08-26 15:40:03', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15539, 3898, '2009-08-30 10:16:46', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15540, 3899, '2009-08-19 06:02:34', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15542, 3900, '2009-08-19 09:17:09', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15543, 3900, '2009-08-22 18:19:33', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15544, 3900, '2009-08-25 10:45:54', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15545, 3900, '2009-08-28 14:08:13', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15546, 3901, '2009-08-19 08:59:36', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15547, 3901, '2009-08-22 14:47:42', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15548, 3901, '2009-08-25 07:36:20', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15549, 3901, '2009-08-29 15:50:03', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15551, 3902, '2009-08-22 13:12:22', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15552, 3902, '2009-08-24 06:45:59', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15553, 3902, '2009-08-24 17:22:29', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15554, 3903, '2009-08-19 06:45:45', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15555, 3903, '2009-08-20 15:27:10', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15556, 3903, '2009-08-23 10:15:20', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15557, 3904, '2009-08-19 06:33:43', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15558, 3904, '2009-08-24 16:53:49', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15559, 3904, '2009-08-29 06:31:54', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15560, 3905, '2009-08-19 08:38:23', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15561, 3905, '2009-08-24 15:41:19', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15562, 3905, '2009-08-27 09:14:32', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (15563, 3905, '2009-08-30 15:34:25', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (15565, 3906, '2009-08-20 18:39:38', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15566, 3906, '2009-08-24 07:37:12', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15567, 3906, '2009-08-24 18:52:19', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15568, 3906, '2009-08-29 07:33:54', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15569, 3906, '2009-09-03 16:07:07', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15570, 3907, '2009-08-20 08:03:15', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15571, 3907, '2009-08-22 15:20:18', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15577, 3909, '2009-08-20 06:07:03', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15578, 3909, '2009-08-22 18:54:25', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (15579, 3910, '2009-08-20 12:41:25', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15580, 3910, '2009-08-21 17:34:01', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15581, 3911, '2009-08-20 06:35:30', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15582, 3911, '2009-08-20 17:42:12', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15583, 3911, '2009-08-21 07:47:18', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15585, 3912, '2009-08-20 06:42:36', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15586, 3912, '2009-08-23 16:44:30', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (15587, 3913, '2009-08-21 09:52:46', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15588, 3913, '2009-08-26 16:10:31', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15590, 3913, '2009-09-02 15:30:47', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15591, 3913, '2009-09-06 10:01:20', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15592, 3913, '2009-09-09 16:24:12', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15593, 3914, '2009-08-22 12:49:06', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15594, 3914, '2009-08-22 18:17:44', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (15595, 3915, '2009-08-22 11:19:19', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15596, 3915, '2009-08-26 16:53:14', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15597, 3916, '2009-08-22 11:14:34', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15598, 3916, '2009-08-26 16:15:39', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15599, 3916, '2009-08-28 07:34:18', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15601, 3917, '2009-08-23 15:33:42', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15602, 3917, '2009-08-28 08:59:47', X'546865206D6F7573650A646F6573206E6F74206D6F766520746F207468652073696465', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15604, 3918, '2009-08-22 07:15:39', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15605, 3918, '2009-08-23 16:17:46', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15606, 3919, '2009-08-22 11:14:09', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15607, 3919, '2009-08-26 13:07:14', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15608, 3919, '2009-09-01 10:26:27', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15610, 3920, '2009-08-22 10:08:21', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15612, 3920, '2009-08-28 07:54:15', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15613, 3920, '2009-09-03 18:17:01', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15614, 3920, '2009-09-08 11:39:25', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15615, 3920, '2009-09-12 13:47:59', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15616, 3921, '2009-08-22 12:50:32', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15617, 3921, '2009-08-27 16:31:38', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15618, 3921, '2009-09-02 06:51:25', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15619, 3921, '2009-09-06 15:19:07', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15621, 3921, '2009-09-09 18:17:16', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15622, 3922, '2009-08-22 11:32:04', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15623, 3922, '2009-08-22 14:09:39', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (15624, 3923, '2009-08-22 10:48:23', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15626, 3923, '2009-08-27 08:49:00', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15627, 3923, '2009-08-27 13:32:16', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15628, 3923, '2009-08-29 06:32:33', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15629, 3923, '2009-08-30 18:42:50', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15630, 3924, '2009-08-23 07:38:13', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15632, 3924, '2009-08-29 09:43:51', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15633, 3924, '2009-08-29 18:24:22', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (15634, 3925, '2009-08-23 09:01:28', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15635, 3925, '2009-08-25 17:46:46', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15637, 3925, '2009-08-29 15:47:36', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15638, 3925, '2009-09-01 06:02:48', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15640, 3926, '2009-08-26 18:58:59', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (15641, 3927, '2009-08-23 06:41:31', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15642, 3927, '2009-08-23 18:32:29', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15643, 3928, '2009-08-23 09:03:41', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15644, 3928, '2009-08-28 17:46:40', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15645, 3928, '2009-09-03 11:39:15', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15647, 3929, '2009-08-27 14:59:53', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15648, 3929, '2009-08-28 09:36:18', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15649, 3929, '2009-08-30 16:34:14', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15650, 3930, '2009-08-23 08:49:12', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15652, 3930, '2009-08-28 12:53:47', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15653, 3930, '2009-08-30 18:04:47', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15654, 3930, '2009-09-04 11:12:55', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15655, 3931, '2009-08-23 11:46:22', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15656, 3931, '2009-08-23 17:35:25', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 9, 'RESPONSE', null, null, null, 'CLOSED', ''), (15657, 3932, '2009-08-23 07:03:49', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15658, 3932, '2009-08-23 13:21:50', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15660, 3932, '2009-08-29 14:12:35', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15661, 3932, '2009-09-03 07:01:07', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15662, 3932, '2009-09-08 16:41:26', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15663, 3933, '2009-08-23 11:03:03', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15665, 3934, '2009-08-28 15:56:01', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15666, 3934, '2009-08-29 10:02:53', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15667, 3934, '2009-08-30 14:01:52', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15668, 3934, '2009-09-01 08:55:19', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15670, 3935, '2009-08-23 06:34:13', X'437573746F6D6572730A70616765206973206E6F7420666F756E642066726F6D20746865206C696E6B206F6E20746865206D61696E0A6D656E75', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15671, 3935, '2009-08-25 15:18:19', X'5468652070726F626C656D0A686173206265656E207265736F6C7665642E20506C65617365206163636573732074686520736974650A616761696E2E', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (15672, 3936, '2009-08-23 08:10:28', X'41636365737320746F0A7468652073697465206973207665727920736C6F77206F6E0A7765656B656E64732E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15673, 3936, '2009-08-28 16:48:00', X'546869732061636F7272650A64756520746F20746865206C61726765722064617461207472616666696320647572696E67207468650A7765656B656E642E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15675, 3936, '2009-09-04 13:59:53', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (15676, 3937, '2009-08-23 09:58:38', X'4D79206465736B746F700A646F6573206E6F74207475726E206F6E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15677, 3937, '2009-08-28 15:02:24', X'4D616B6520737572650A69742069732070726F7065726C7920636F6E6E656374656420746F2074686520706F7765720A737570706C792E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15678, 3938, '2009-08-24 08:24:51', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15679, 3938, '2009-08-27 16:56:26', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15680, 3938, '2009-08-29 10:50:42', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15681, 3938, '2009-09-02 14:04:21', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15682, 3939, '2009-08-24 10:25:55', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15683, 3940, '2009-08-24 10:49:13', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15684, 3940, '2009-08-25 17:52:29', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15685, 3940, '2009-08-30 11:55:01', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15686, 3940, '2009-09-03 17:44:07', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (15687, 3941, '2009-08-24 12:44:26', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15688, 3941, '2009-08-29 18:48:05', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15689, 3941, '2009-09-01 06:25:07', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15690, 3941, '2009-09-04 17:56:46', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15692, 3942, '2009-08-26 14:39:06', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15693, 3942, '2009-09-01 11:10:56', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15694, 3942, '2009-09-05 13:01:40', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15695, 3942, '2009-09-06 06:39:40', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15696, 3942, '2009-09-10 15:31:04', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'CLOSED', ''), (15699, 3944, '2009-08-24 10:15:29', X'4D7920626174746572790A646F6573206E6F742063686172676520616E790A6D6F72652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15700, 3944, '2009-08-25 18:38:19', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15702, 3945, '2009-08-26 13:26:00', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15703, 3945, '2009-09-01 12:26:52', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15704, 3945, '2009-09-02 14:34:35', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15705, 3946, '2009-08-24 12:08:22', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15707, 3946, '2009-08-30 07:52:38', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15708, 3946, '2009-09-01 16:58:47', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15709, 3947, '2009-08-24 09:19:43', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15710, 3947, '2009-08-27 14:32:16', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15712, 3948, '2009-08-25 14:20:38', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15714, 3949, '2009-08-27 16:33:01', X'506C656173652C207472790A7265696E7374616C6C696E67207468650A70726F6772616D2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15715, 3950, '2009-08-25 11:34:17', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15716, 3950, '2009-08-30 16:12:11', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15717, 3950, '2009-09-05 12:21:58', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15719, 3950, '2009-09-10 11:08:40', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15720, 3950, '2009-09-15 14:34:38', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15721, 3951, '2009-08-25 12:26:30', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15723, 3951, '2009-09-03 11:56:00', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15724, 3951, '2009-09-05 18:08:16', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (15725, 3951, '2009-09-06 10:14:17', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15726, 3951, '2009-09-08 18:58:56', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 2, 'RESPONSE', null, null, null, 'CLOSED', ''), (15727, 3952, '2009-08-25 11:13:19', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15729, 3953, '2009-08-29 16:31:53', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15730, 3954, '2009-08-25 06:16:51', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15731, 3954, '2009-08-27 14:28:34', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15732, 3954, '2009-08-29 07:23:40', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15734, 3954, '2009-09-05 10:23:54', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15735, 3955, '2009-08-25 10:47:20', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15736, 3955, '2009-08-26 17:00:22', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (15737, 3955, '2009-09-01 08:58:31', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (15738, 3955, '2009-09-04 14:45:59', X'436865636B207468650A70726F6772616D206D656E7520746865206F7074696F6E20746F0A6578706F7274', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (15739, 3956, '2009-08-25 08:20:16', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15740, 3956, '2009-08-25 18:39:54', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15741, 3956, '2009-08-29 11:19:32', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15742, 3956, '2009-09-02 13:18:43', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15743, 3956, '2009-09-03 07:02:55', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15744, 3957, '2009-08-25 11:11:45', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15745, 3957, '2009-08-30 14:47:58', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15746, 3957, '2009-09-01 11:12:50', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15747, 3958, '2009-08-25 11:28:00', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15748, 3958, '2009-08-25 13:00:29', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15749, 3959, '2009-08-25 11:52:57', X'492077616E74206B6E6F770A746865206E657874206461746520666F7220746865206D6F62696C65204E6F6B6961204E39350A73616C65', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15750, 3959, '2009-08-26 15:13:04', X'4F6E6C79206174207468650A656E64206F662074686520796561722C2061207765656B206265666F72650A4368726973746D61732E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15751, 3959, '2009-08-27 10:34:15', X'49206D61646520610A7061796D656E7420616E6420646964206E6F74207265636569766520616E20656D61696C0A636F6E6669726D6174696F6E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15752, 3959, '2009-08-28 15:43:25', X'4F75722062696C6C696E670A73797374656D20646F6573206E6F742073656E6420656D61696C20636F6E6669726D6174696F6E20666F7220736563757269747920726561736F6E732E205369676E20696E20746F20226D790A73686F7070696E672220706F7274616C2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15753, 3959, '2009-09-02 08:35:48', X'486F7720646F65730A74686520657874656E6465642077617272616E747920666F72206C6170746F707320616E64206E6574626F6F6B730A776F726B733F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15755, 3960, '2009-08-26 09:11:47', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15757, 3961, '2009-08-26 07:32:31', X'492063616EC2B4740A73796E63206D79206D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15759, 3961, '2009-09-01 12:49:08', X'492063616E206E6F740A6F70656E2061206D6573736167650A6174746163686D656E742E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15760, 3961, '2009-09-04 17:55:52', X'5468652066696C650A77617320626C6F636B6564206265636175736520697420697320616E0A65786563757461626C652E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15761, 3961, '2009-09-05 12:55:12', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15762, 3961, '2009-09-10 15:43:55', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15763, 3962, '2009-08-26 08:22:14', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15764, 3962, '2009-08-30 17:56:42', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15765, 3962, '2009-09-05 08:57:13', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15766, 3962, '2009-09-05 15:40:18', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15768, 3962, '2009-09-09 15:16:23', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15769, 3963, '2009-08-26 09:41:07', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15770, 3963, '2009-08-26 13:20:51', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15771, 3963, '2009-08-28 09:27:16', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15772, 3963, '2009-08-29 18:48:46', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (15773, 3963, '2009-09-03 12:24:01', X'536F2066617220490A68617665206E6F742072656365697665642074686520676F6F6473204920626F756768742C20746865206F72646572207761730A31313232333133312E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (15774, 3963, '2009-09-04 13:39:10', X'546865206F726465720A7761732073656E7420616E642077696C6C2062652064656C69766572656420696E203220776F726B696E670A646179732E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (15776, 3964, '2009-08-26 15:07:36', X'4D616B6520737572650A74686520436170734C6F636B206C6564206973206F6E2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15777, 3965, '2009-08-26 10:14:06', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15778, 3965, '2009-09-01 16:47:22', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15779, 3966, '2009-08-26 12:42:01', X'492063616E206E6F740A656E747279206D6F7265207468616E206F6E652070686F6E6520746F20610A636F6E746163742E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15780, 3966, '2009-09-01 14:21:04', X'5472790A7570646174696E672074686520636F6E7461637473206C6973742E20497420697320706F737369626C6520746861742074686973206669656C64206E65656420746F0A61646465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (15781, 3966, '2009-09-05 11:49:21', X'437573746F6D6572730A66696C6520646973706C6179206E61206572726F7220696E207468650A652D6D61696C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (15782, 3966, '2009-09-10 15:25:24', X'436865636B207468650A656E74727920666F726D61742E2049742073686F756C642062653A0A616263406162632E616263', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (15784, 3967, '2009-09-01 17:32:57', X'506C656173652C207472790A7265696E7374616C6C696E67207468652070726F6772616D2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (15786, 3967, '2009-09-04 16:17:11', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 7, 'RESPONSE', null, null, null, 'SOLVED', ''), (15787, 3968, '2009-08-26 07:46:02', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15788, 3968, '2009-08-28 18:16:06', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15789, 3968, '2009-08-29 12:42:58', X'4D792075736572206861730A6E6F2061636365737320746F2074686520436F737473206279206465706172746D656E74730A7265706F72742E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (15790, 3968, '2009-09-02 15:45:51', X'54686973207265706F72740A63616E206E6F77206265206163636573736564206F6E6C792062792075736572732077697468206D616E616765722070726F66696C650A2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (15792, 3968, '2009-09-10 16:12:20', X'496E207468650A5265706F727473206D656E75206F70656E2074686520737562666F6C64657220437573746F6D65727320616E6420636C69636B206F6E204C6173740A4F72646572732E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (15795, 3969, '2009-09-02 07:49:38', X'486F7720746F0A636C6173736966792074686520637573746F6D65722062790A7072696F726974793F', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15796, 3969, '2009-09-04 17:31:21', X'436865636B207468650A75736572206D616E75616C2074686520746F7069632022486F7720746F20636F6E666967757265207468650A7072696F7269747922', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (15797, 3970, '2009-08-26 12:16:52', X'492077616E7420746F0A63616E63656C206D79206F72646572206E756D6265720A32323131333132312E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15798, 3970, '2009-08-26 15:35:37', X'546F2063616E63656C0A796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E746572', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15799, 3970, '2009-08-27 10:34:42', X'43616E2049207061790A6D7920707572636861736520696E20313220696E7374616C6D656E7473207573696E67207468650A566973613F', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15800, 3970, '2009-08-29 18:46:06', X'546865207061796D656E740A7769746820313220696E7374616C6D656E7473206973206F6E6C7920616C6C6F776564206F6E0A6D617374657263617264', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (15802, 3971, '2009-09-01 15:15:28', X'50726F766176616C6D656E746520616E206572726F72206F63637572726564206F6E20746865207061676520796F7520776572650A616363657373696E672E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (15803, 3972, '2009-08-29 08:08:35', X'4120667269656E640A736169642068652073656E74206D6520616E20656D61696C20627574204920646964206E6F740A72656365697665', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15804, 3972, '2009-09-02 13:08:46', X'4D616B6520737572650A7468697320656D61696C206973206E6F74206F6E2074686520626C6F636B6564206D65737361676573206C6973740A2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (15805, 3973, '2009-08-29 06:09:13', X'492063616EC2B4740A777269746520612066696C6520696E0A506F72747567756573652E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15806, 3973, '2009-09-02 14:03:19', X'4D616B6520737572650A796F7520696E7374616C6C65642074686520506F72747567756573650A6C616E67756167652E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15807, 3973, '2009-09-06 08:53:03', X'54686520776F72640A70726F6772616D206973206C6F636B696E67207468652066696C6520647572696E670A736176652E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15808, 3973, '2009-09-09 15:15:14', X'4D616B6520737572650A746865726520697320656E6F756768207370616365206F6E0A6469736B2E', null, null, null, 4, 'RESPONSE', null, null, null, 'REPLIED', ''), (15809, 3973, '2009-09-11 10:07:38', X'492077616E7420746F0A6578706F7274206D79204F75746C6F6F6B2066696C657320746F0A6376732E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (15811, 3974, '2009-09-01 17:49:04', X'5468652066696C650A7761732074656D706F726172696C792072656D6F76656420666F72207265766965772E20536F6F6E2069742077696C6C20626520617661696C61626C6520666F720A646F776E6C6F61642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (15812, 3974, '2009-09-03 10:54:23', X'492063616E206E6F740A636F6E6E65637420746F207468652070686F6E65207468617420697320646973706C61796564206F6E2074686520636F6E746163747320706167652E20497420697320616C776179730A627573792E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (15814, 3975, '2009-08-29 09:05:51', X'546865204844206861730A74686520666F6C6C6F77696E67206572726F72206D6573736167653A2052656164696E670A4572726F72', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (15815, 3975, '2009-08-30 16:25:30', X'52756E207468650A7363616E6469736B2070726F6772616D20616E6420696E666F726D20746563686E6963616C20737575706F7274207468650A6D657373616765732E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (15816, 3975, '2009-09-01 11:55:46', X'4D7920626174746572790A646F6573206E6F742063686172676520616E79206D6F72652E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (15817, 3975, '2009-09-04 16:27:22', X'506C656173650A696E666F726D207468652062617474657279206D6F64656C20616E642064617465206F660A70757263686173652E', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (15851, 3932, '2009-09-07 09:43:17', X'3C703E546F0A63616E63656C20796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E64207175616C6974790A63656E7465723C2F703E3C703E2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D3C2F703E', '', '', '', 1, 'RESPONSE', '', '', '', 'REPLIED', ''), (15852, 3908, '2009-10-08 16:59:44', X'3C703E2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D3C2F703E0A3C703E5261796D6F6E6420566F6C747A3C2F703E', '', '', '', 1, 'RESPONSE', '', '', '', 'REPLIED', ''), (15853, 3962, '2009-10-29 15:21:48', X'3C703E74657374653C2F703E0A3C703E266E6273703B3C2F703E', '', '', '', null, 'REQUEST', '', '', '', 'RETURNED', ''), (15854, 3908, '2010-03-25 11:17:07', X'3C703E5468652073657276657220776173206F757420617420746861742074696D652C2062757420697320616C7265616479206F7065726174696F6E616C2E3C2F703E3C703E2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D3C2F703E0A3C703E5261796D6F6E6420566F6C747A3C2F703E', 'aHR0cDovL3d3dy5wb3J0YWxjYWIuY29tL2pvZ29zLz9qb2dhcj1iYWxsb29uX2luX2Ffd2FzdGVsYW5kDQpodHRwOi8vaGF6bm9zLm9yZy9nLXN3aXRjaC1qb2dvLw0KaHR0cDovL2RhZmxheC5jb20vY29udGVudC92aWV3LzQ2My8xOS9sYW5nLHVzLw==', '', '', 1, 'RESPONSE', 'aaaaa.txt', '', '', 'CLOSED', '<p>teste</p>'), (15855, 3932, '2011-11-28 12:04:51', X'3C703E546865207061796D656E74207769746820313220696E7374616C6D656E7473206973206F6E6C790A616C6C6F776564206F6E206D6173746572636172643C2F703E0A3C703E266E6273703B3C2F703E0A3C703E54455354453C2F703E3C703E2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D3C2F703E0A3C703E5261796D6F6E6420566F6C747A3C2F703E', '*nm*', '*nm*', '*nm*', 1, 'RESPONSE', '', '', '', 'REPLIED', ''), (15856, 3932, '2011-11-28 12:05:21', X'3C703E2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D3C2F703E0A3C703E5261796D6F6E6420566F6C747A3C2F703E', '*nm*', '*nm*', '*nm*', 1, 'RESPONSE', '', '', '', 'CLOSED', ''), (15857, 3952, '2011-11-28 12:06:57', X'3C703E546F2063616E63656C20796F7572206F7264657220706C6561736520636F6E7461637420746865207365727669636520616E640A7175616C6974792063656E7465723C2F703E3C703E2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D3C2F703E0A3C703E5261796D6F6E6420566F6C747A3C2F703E', '*nm*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', '*nm*', '*nm*', 1, 'RESPONSE', 'nautico (1).jpg', '', '', 'CLOSED', ''), (15859, 3976, '2012-01-31 15:10:04', '<p>I can''t reacl the ppl who work at sales.</p>', '*nm*', '*nm*', '*nm*', null, 'REQUEST', '', '', '', 'UNASSIGNED', ''), (15860, 3977, '2012-05-11 14:27:26', '<p>Just a test!</p>', '*nm*', '*nm*', '*nm*', null, 'REQUEST', '', '', '', 'UNASSIGNED', ''), (15861, 3976, '2012-05-11 14:32:06', '<p>Did you tried the email sales@scriptcase.net?</p>', '*nm*', '*nm*', '*nm*', null, 'REQUEST', '', '', '', 'RETURNED', ''), (15862, 3978, '2012-05-11 14:34:24', '<p>Cant reach then one more time, what should i do?</p>', '*nm*', '*nm*', '*nm*', null, 'REQUEST', '', '', '', 'UNASSIGNED', ''), (15863, 3932, '2012-05-11 14:38:07', '<p>The file was blocked because it is an executable.</p><p>----------------------------</p>\n<p>Raymond Voltz</p>', '*nm*', '*nm*', '*nm*', 1, 'RESPONSE', '', '', '', 'REPLIED', ''), (15864, 3978, '2012-05-11 14:38:52', '<p>For you!</p><p>----------------------------</p>\n<p>Raymond Voltz</p>', '*nm*', '*nm*', '*nm*', 1, 'INTERNAL', '', '', '', 'ASSIGNED', ''), (5, 1, '2008-03-10 09:44:23', X'4D79206B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (13, 4, '2008-03-05 06:17:56', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (15, 5, '2008-03-01 09:02:44', X'4D79206B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (25, 9, '2008-03-05 06:02:46', X'5468652073697465207365656D65640D0A746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (27, 10, '2008-03-02 08:10:59', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (28, 10, '2008-03-04 18:09:55', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (34, 11, '2008-03-02 16:33:00', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (37, 12, '2008-03-03 07:09:28', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (42, 13, '2008-03-06 14:03:28', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (43, 13, '2008-03-10 10:58:41', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (48, 14, '2008-03-08 16:05:15', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (56, 16, '2008-03-16 14:09:42', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (59, 17, '2008-03-06 06:18:09', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (61, 18, '2008-03-04 11:44:21', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (63, 18, '2008-03-10 10:24:57', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (77, 23, '2008-03-12 08:40:35', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', '');
INSERT INTO "ticketmessage" VALUES (87, 26, '2008-03-06 07:06:38', 'The generated are not being sent by email.', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (88, 26, '2008-03-08 17:18:18', 'Check your client spam filter.', null, null, null, 3, 'RESPONSE', null, null, null, 'SOLVED', ''), (92, 27, '2008-03-12 15:58:22', 'The server was out at that time, but is already operational.', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (100, 28, '2008-03-18 15:48:02', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (109, 31, '2008-03-07 06:21:54', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (110, 31, '2008-03-12 16:14:28', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (126, 35, '2008-03-14 14:37:10', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (136, 38, '2008-03-12 13:00:15', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (145, 41, '2008-03-17 09:24:25', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (147, 42, '2008-03-09 06:51:18', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (158, 45, '2008-03-12 18:07:28', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (164, 46, '2008-03-20 18:50:25', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (171, 49, '2008-03-09 12:39:51', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (174, 50, '2008-03-12 17:25:49', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (180, 51, '2008-03-11 13:54:04', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (182, 52, '2008-03-15 15:09:26', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (192, 53, '2008-03-16 13:15:01', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (200, 56, '2008-03-11 15:00:32', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (205, 58, '2008-03-12 10:21:32', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (207, 59, '2008-03-12 11:25:36', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (209, 59, '2008-03-16 11:09:48', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (214, 60, '2008-03-12 13:48:38', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (220, 61, '2008-03-16 14:30:44', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (224, 62, '2008-03-18 14:46:00', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (236, 65, '2008-03-16 15:53:45', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 4, 'RESPONSE', null, null, null, 'CLOSED', ''), (240, 66, '2008-03-22 18:02:45', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (243, 67, '2008-03-14 12:57:52', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (249, 68, '2008-03-15 11:19:35', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (264, 71, '2008-03-23 17:16:22', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (267, 72, '2008-03-21 11:54:58', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (273, 74, '2008-03-15 10:36:17', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (279, 75, '2008-03-18 09:12:48', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (288, 77, '2008-03-25 13:17:49', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (295, 79, '2008-03-16 06:48:53', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (303, 81, '2008-03-16 10:42:11', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (312, 84, '2008-03-19 17:56:04', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (316, 85, '2008-03-18 18:51:53', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (321, 86, '2008-03-22 06:22:51', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (323, 86, '2008-03-23 11:09:54', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (325, 87, '2008-03-17 10:01:10', X'5468652073697465207365656D65640D0A746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (330, 87, '2008-04-02 13:16:33', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (339, 90, '2008-03-17 06:27:06', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (340, 90, '2008-03-17 13:34:50', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (348, 91, '2008-03-23 15:26:02', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (352, 92, '2008-03-21 15:34:30', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (353, 93, '2008-03-18 08:06:34', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (356, 93, '2008-03-23 13:47:05', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (357, 93, '2008-03-25 12:48:32', X'5468652073697465207365656D65640D0A746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (359, 94, '2008-03-18 10:36:08', X'5468652073697465207365656D65640D0A746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (361, 94, '2008-03-22 09:32:03', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (367, 95, '2008-03-23 12:26:12', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (372, 96, '2008-03-23 16:13:59', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (375, 97, '2008-03-20 07:01:05', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (377, 97, '2008-03-30 09:21:18', X'5468652073697465207365656D65640D0A746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (380, 98, '2008-03-23 16:47:27', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (394, 100, '2008-03-31 16:31:27', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (397, 101, '2008-03-21 07:29:31', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (402, 102, '2008-03-27 16:31:32', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (408, 103, '2008-03-26 16:34:35', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (415, 104, '2008-03-28 11:52:35', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (416, 104, '2008-04-02 17:56:41', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (419, 105, '2008-03-29 09:30:08', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (422, 105, '2008-04-06 18:20:23', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (426, 106, '2008-04-01 13:58:01', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (427, 106, '2008-04-04 12:41:10', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (431, 107, '2008-04-01 12:41:09', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (435, 108, '2008-03-22 06:44:00', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (442, 109, '2008-03-30 13:24:24', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (443, 109, '2008-04-02 06:36:01', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (447, 110, '2008-03-26 07:36:54', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (452, 111, '2008-03-28 14:08:40', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 3, 'RESPONSE', null, null, null, 'REPLIED', ''), (453, 111, '2008-03-31 10:22:50', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (457, 112, '2008-03-23 12:12:38', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (462, 114, '2008-03-27 13:38:54', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (465, 115, '2008-03-23 06:49:24', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (467, 115, '2008-03-27 09:20:17', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (468, 115, '2008-04-01 13:07:55', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (472, 116, '2008-03-25 13:27:14', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (476, 117, '2008-04-06 16:27:21', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (479, 118, '2008-03-24 10:37:26', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (482, 119, '2008-03-26 17:22:09', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 7, 'RESPONSE', null, null, null, 'CLOSED', ''), (488, 120, '2008-04-05 13:24:24', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (489, 121, '2008-03-24 07:42:34', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (494, 122, '2008-03-26 15:12:46', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (495, 122, '2008-03-29 09:24:04', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (499, 123, '2008-03-25 12:32:40', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (503, 123, '2008-04-05 07:00:22', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (506, 124, '2008-03-27 16:25:50', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (511, 126, '2008-03-26 12:30:16', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (513, 126, '2008-04-05 11:58:38', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (521, 128, '2008-03-29 12:39:41', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (528, 129, '2008-04-04 14:43:09', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (529, 130, '2008-03-26 08:17:14', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (535, 131, '2008-03-27 09:26:47', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (539, 131, '2008-04-07 07:47:58', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (545, 132, '2008-04-01 06:36:18', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (552, 133, '2008-04-10 17:25:29', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (560, 135, '2008-04-08 13:40:14', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (562, 136, '2008-03-31 16:08:21', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 9, 'RESPONSE', null, null, null, 'REPLIED', ''), (569, 137, '2008-04-10 07:11:42', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (571, 138, '2008-03-28 10:37:52', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (581, 143, '2008-03-29 08:31:24', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (583, 143, '2008-04-07 07:04:01', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (591, 144, '2008-04-11 11:36:55', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (596, 145, '2008-04-06 14:29:07', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (602, 146, '2008-04-04 14:54:40', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 3, 'RESPONSE', null, null, null, 'CLOSED', ''), (607, 147, '2008-04-13 10:25:49', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (609, 148, '2008-03-30 11:33:00', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (611, 148, '2008-04-07 06:45:58', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (619, 151, '2008-03-31 11:59:58', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 4, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (624, 151, '2008-04-11 15:51:53', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (626, 152, '2008-04-05 14:49:09', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (629, 153, '2008-03-31 11:53:01', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (634, 154, '2008-04-03 15:46:19', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (641, 155, '2008-04-06 10:29:43', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (644, 156, '2008-03-31 15:21:15', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (645, 156, '2008-04-03 06:13:24', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (653, 159, '2008-03-31 08:26:54', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (655, 159, '2008-04-03 07:08:18', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (660, 160, '2008-04-08 15:30:29', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (669, 164, '2008-04-01 07:23:12', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (671, 164, '2008-04-04 06:12:09', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (674, 164, '2008-04-12 16:01:48', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'CLOSED', ''), (675, 165, '2008-04-01 09:42:13', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (677, 166, '2008-04-01 11:07:46', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (678, 166, '2008-04-05 14:01:41', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (681, 167, '2008-04-05 09:57:02', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (683, 168, '2008-04-02 12:22:45', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (689, 169, '2008-04-17 06:01:40', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (700, 172, '2008-04-12 13:30:25', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (717, 176, '2008-04-09 06:26:48', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (723, 177, '2008-04-17 10:05:47', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (725, 178, '2008-04-05 08:04:41', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (729, 179, '2008-04-10 08:22:42', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (731, 179, '2008-04-18 09:34:45', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (741, 183, '2008-04-08 08:28:33', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 4, 'REQUEST', null, null, null, 'RETURNED', ''), (742, 183, '2008-04-09 18:42:06', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (744, 184, '2008-04-08 13:17:20', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (749, 185, '2008-04-06 09:43:59', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (756, 186, '2008-04-10 18:42:25', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (762, 188, '2008-04-07 16:42:48', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (768, 190, '2008-04-08 14:49:54', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (772, 191, '2008-04-16 16:06:10', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (776, 192, '2008-04-09 15:31:23', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (782, 193, '2008-04-10 13:21:12', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (786, 194, '2008-04-12 14:59:20', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'SOLVED', ''), (788, 195, '2008-04-09 14:57:30', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (792, 196, '2008-04-12 16:16:24', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (802, 198, '2008-04-14 13:06:36', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 6, 'RESPONSE', null, null, null, 'REPLIED', ''), (825, 204, '2008-04-07 08:53:15', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (829, 205, '2008-04-17 06:34:08', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (835, 206, '2008-04-12 12:50:06', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (838, 206, '2008-04-21 18:57:00', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (842, 207, '2008-04-18 13:01:18', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (845, 208, '2008-04-08 11:59:05', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 8, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (851, 210, '2008-04-08 07:01:04', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (853, 210, '2008-04-10 06:27:37', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (859, 212, '2008-04-08 07:36:49', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (865, 213, '2008-04-12 11:17:29', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (869, 214, '2008-04-18 12:40:09', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (871, 214, '2008-04-22 12:21:22', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (877, 216, '2008-04-21 09:13:35', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (882, 217, '2008-04-12 13:04:46', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (883, 217, '2008-04-17 11:33:22', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (894, 219, '2008-04-26 14:41:40', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'CLOSED', ''), (895, 220, '2008-04-11 08:56:35', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (897, 220, '2008-04-19 07:14:22', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 6, 'REQUEST', null, null, null, 'RETURNED', ''), (910, 222, '2008-04-22 14:58:02', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (912, 223, '2008-04-13 16:30:10', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'REPLIED', ''), (918, 224, '2008-04-15 17:10:03', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 6, 'RESPONSE', null, null, null, 'SOLVED', ''), (928, 227, '2008-04-13 15:34:30', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (940, 230, '2008-04-20 17:35:12', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 1, 'RESPONSE', null, null, null, 'SOLVED', ''), (943, 232, '2008-04-12 12:42:20', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (944, 232, '2008-04-16 14:14:38', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 10, 'RESPONSE', null, null, null, 'SOLVED', ''), (945, 233, '2008-04-13 11:14:17', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 6, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (956, 235, '2008-04-27 15:11:10', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (959, 237, '2008-04-13 06:42:21', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (970, 239, '2008-04-15 14:02:15', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (972, 240, '2008-04-18 15:08:08', X'54686520736572766572207761730D0A6F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (981, 242, '2008-04-22 12:02:41', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (983, 242, '2008-04-24 12:06:48', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 10, 'REQUEST', null, null, null, 'RETURNED', ''), (987, 243, '2008-04-16 06:25:46', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (999, 247, '2008-04-13 12:03:28', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1001, 248, '2008-04-14 12:30:11', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1005, 250, '2008-04-14 11:14:54', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1008, 251, '2008-04-15 18:35:51', X'546865207365727665720D0A776173206F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 2, 'RESPONSE', null, null, null, 'REPLIED', ''), (1011, 252, '2008-04-14 11:40:10', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1013, 253, '2008-04-14 12:02:56', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1019, 254, '2008-04-14 10:25:30', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 3, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1021, 254, '2008-04-18 11:02:17', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 3, 'REQUEST', null, null, null, 'RETURNED', ''), (1024, 255, '2008-04-18 13:49:53', X'546865207365727665720D0A776173206F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1031, 257, '2008-04-15 08:09:34', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1035, 258, '2008-04-20 10:09:23', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 2, 'REQUEST', null, null, null, 'RETURNED', ''), (1041, 260, '2008-04-15 09:04:37', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 9, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1045, 261, '2008-04-18 12:18:27', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1048, 261, '2008-04-24 14:10:59', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1051, 262, '2008-04-21 11:46:59', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1052, 262, '2008-04-22 16:46:09', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 5, 'RESPONSE', null, null, null, 'SOLVED', ''), (1058, 263, '2008-04-23 18:41:07', X'546865207365727665720D0A776173206F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 9, 'RESPONSE', null, null, null, 'SOLVED', ''), (1060, 264, '2008-04-18 14:15:01', X'546865207365727665720D0A776173206F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1067, 265, '2008-04-21 11:45:55', X'5468650D0A67656E65726174656420617265206E6F74206265696E672073656E742062790D0A656D61696C2E', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1068, 265, '2008-04-25 13:13:39', X'436865636B20796F757220636C69656E74207370616D0D0A66696C7465722E', null, null, null, 7, 'RESPONSE', null, null, null, 'REPLIED', ''), (1069, 265, '2008-05-01 07:16:52', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1074, 266, '2008-04-18 17:28:12', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1075, 267, '2008-04-17 08:14:41', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1081, 268, '2008-04-21 11:11:32', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 5, 'REQUEST', null, null, null, 'RETURNED', ''), (1085, 269, '2008-04-18 10:16:48', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 10, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1087, 270, '2008-04-18 12:13:31', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1089, 270, '2008-04-23 10:17:02', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 7, 'REQUEST', null, null, null, 'RETURNED', ''), (1094, 271, '2008-04-23 16:12:51', X'546865207365727665720D0A776173206F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 8, 'RESPONSE', null, null, null, 'CLOSED', ''), (1097, 272, '2008-04-23 12:20:55', X'492063616E206E6F740D0A646F776E6C6F61642074686520746563686E6963616C207374616E6461726473200D0A6D616E75616C2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1106, 275, '2008-04-23 18:04:08', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 1, 'RESPONSE', null, null, null, 'REPLIED', ''), (1107, 275, '2008-04-24 10:16:24', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 1, 'REQUEST', null, null, null, 'RETURNED', ''), (1114, 276, '2008-04-27 14:12:02', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 6, 'RESPONSE', null, null, null, 'CLOSED', ''), (1115, 277, '2008-04-19 10:17:09', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 2, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1121, 278, '2008-04-19 12:43:40', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 5, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1130, 279, '2008-04-24 13:23:44', X'4D616B652073757265207468650D0A6D6F757365206973206E6F7420646972747920616E6420636F6E746163740D0A74686520686172647761726520737570706F72742E', null, null, null, 4, 'RESPONSE', null, null, null, 'SOLVED', ''), (1132, 280, '2008-04-23 13:27:31', X'5468650D0A77617272616E7479206D617920626520657874656E64656420627920616E20796561720D0A7769746820746865207061796D656E74206F6620313025206F66207468652076616C7565206F66207468650D0A676F6F64732E', null, null, null, 10, 'RESPONSE', null, null, null, 'REPLIED', ''), (1135, 281, '2008-04-19 09:01:45', X'4D790D0A6B6579626F617264206973206E6F7420616363657074696E670D0A7570706572636173652E', null, null, null, 1, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1141, 284, '2008-04-20 10:23:46', X'4D79204F666669636520646F6573206E6F74206F70656E2C206F7220776F7264206F7220657863656C0D0A2E2E2E', null, null, null, 7, 'REQUEST', null, null, null, 'UNASSIGNED', ''), (1146, 285, '2008-04-23 13:46:41', X'536F7272792E0D0A54686572652077617320616E206572726F7220616E64206974206E6F772069730D0A636F727265637465642E', null, null, null, 8, 'RESPONSE', null, null, null, 'REPLIED', ''), (1147, 285, '2008-04-26 08:53:03', X'54686520736974650D0A7365656D656420746F206265206861636B65642E20497420697320646973706C6179696E6720736F6D650D0A737472616E6765207069637475726573206F6E2074686520637573746F6D65727320706167650D0A2E', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1152, 286, '2008-04-26 13:08:51', X'546865207365727665720D0A776173206F757420617420746861742074696D652C2062757420697320616C72656164790D0A6F7065726174696F6E616C2E', null, null, null, 2, 'RESPONSE', null, null, null, 'SOLVED', ''), (1155, 287, '2008-04-24 07:32:04', X'4D792046697265666F780D0A62726F7773657220697320646973706C6179696E67206E61204A6176617363726970740D0A6572726F72', null, null, null, 8, 'REQUEST', null, null, null, 'RETURNED', ''), (1159, 288, '2008-04-26 07:38:50', X'486F772063616E20490D0A616363657373206120636C69656E74206C6173740D0A6F72646572733F', null, null, null, 9, 'REQUEST', null, null, null, 'RETURNED', ''), (1162, 289, '2008-04-20 16:46:16', X'546865207365727665720D0A776173206F757420617420746861