const addClass = (nodeElement, className) => {
    Array.from(nodeElement).forEach( element => {
        Array.isArray(className) ? element.classList.add(...className) : element.classList.add(className);            
    });
};

const removeClass = (nodeElement, className) => {
    nodeElement = Array.isArray(nodeElement) ? nodeElement : Array.from(nodeElement);
    nodeElement.forEach( element => {
        Array.isArray(className) ? element.classList.remove(...className) : element.classList.remove(className);            
    });
};

const setProperty = (nodeElement, prop) => {
    if (Array.isArray(nodeElement) && Array.isArray(prop)) {
        nodeElement.forEach(el => {
            prop.forEach((item, index) => {
                el.style.setProperty(prop[index].propName, prop[index].propValue);
            });
        })
    } else {
        prop.forEach((item, index) => {
            nodeElement.style.setProperty(prop[index].propName, prop[index].propValue);
        });
    }
};

const removeProperty = (nodeElement, prop) => {
    if (Array.isArray(nodeElement) && Array.isArray(prop)) {
        nodeElement.forEach(el => {
            prop.forEach((item, index) => {
                el.style.removeProperty(prop[index].propName);
            });
        })
    } else {
        prop.forEach((item, index) => {
            nodeElement.style.removeProperty(prop[index].propName);
        });
    }
};

const setAttribute = (nodeElement, attr) => {
    if (Array.isArray(nodeElement) && Array.isArray(attr)) {
        nodeElement.forEach(el => {
            attr.forEach((item, index) => {
                el.setAttribute(attr[index].attrName, attr[index].attrValue);
            });
        })
    } else {
        attr.forEach((item, index) => {
            nodeElement.setAttribute(attr[index].attrName, attr[index].attrValue);
        });
    }
};

const removeAttribute = (nodeElement, attr) => {
    if (Array.isArray(nodeElement) && Array.isArray(attr)) {
        nodeElement.forEach(el => {
            attr.forEach((item, index) => {
                el.removeAttribute(attr[index].attrName);
            });
        })
    } else {
        attr.forEach((item, index) => {
            nodeElement.removeAttribute(attr[index].attrName);
        });
    }
};

const setValue = (element, value) => {
    if (Array.isArray(element)) {
        element.forEach(el => {
            el.value = value;
        });
    } else {
        element.value = value;
    }
};

const setText = (element, value) => {
    if (Array.isArray(element)) {
        element.forEach(el => {
            el.innerText = value;
        });
    } else {
        element.innerText = value;
    }
};

const isPositive = number => {
    switch (Math.sign(number)) {
        case -1:
            return false;
            break;
        case 1:
            return true;
            break;
    }
};

const clearEvent = (elementNode, event, funcName) => {
    elementNode.removeEventListener(event, funcName);
};

const interactiveNumberField = (minThreshold, maxThreshold, multiplier, fieldSelector) => {
    const root = document.querySelector('body');
    let selector = fieldSelector ? fieldSelector : '[data-ui="interactivenumber"]';
    const fields = document.querySelectorAll(selector);
    let fieldValue = null;


    fields.forEach(field => {
        field.style.setProperty('cursor', 'ew-resize');

        const iterateValue = () => {
            if (field.tagName === 'INPUT' && typeof field.value === 'number') {
                isPositive(event.movementX) ? field.value = field.value += multiplier : field.value = field.value -= multiplier;
                fieldValue < minThreshold ? field.value = minThreshold : false;
                fieldValue > maxThreshold ? field.value = maxThreshold : false;
            } else {
                fieldValue = Number(field.innerText);
                isPositive(event.movementX) ? field.innerText = fieldValue += multiplier : field.innerText = fieldValue -= multiplier;
                fieldValue < minThreshold ? field.innerText = minThreshold : false;
                fieldValue > maxThreshold ? field.innerText = maxThreshold : false;
            }
        }

        const mousedown = () => { mousemove() };

        const mousemove = () => { 
        	root.style.setProperty('cursor', 'ew-resize');
        	iterateValue();
        	document.querySelector('.IroSliderGradient').value = fieldValue;
        };

        const mouseup = () => { 
        	root.style.setProperty('cursor', 'auto')
        };

        document.querySelector(selector).addEventListener('mousedown', () => {
            root.addEventListener('mousemove', mousemove);
            root.addEventListener('mouseup', () => {
                clearEvent(root, 'mousemove', mousemove);
            	mouseup();
            });
        });
    });
};

const getBoundCliRect = (elementNode) => {
    return elementNode.getBoundingClientRect();
}

const DateTime = {
    timestamp: function () {
        const date = new Date();
        return date.getTime();
    }
};

const UI = {
    show: function (nodeElement, cssDisplayType) {
        let displayType = cssDisplayType ? cssDisplayType : 'block';        
        setProperty(nodeElement, [{propName: 'display', propValue: displayType}]);
        setAttribute(nodeElement, [{attrName: 'visible', attrValue: 'visible'}]);
    },

    hide: function (nodeElement) {            
        setProperty(nodeElement, [{propName: 'display', propValue: 'none'}]);
        removeAttribute(nodeElement, [{attrName: 'visible'}]);
    }    
};

const Semantic = {
    iconButton: function (iconName, cssClasses) {
        return `
            <button class="ui icon button ${cssClasses ? cssClasses : false}">
                <i class="${iconName} icon"></i>
            </button>
        `;
    },
};
