# Add table "notif_inbox"                                                   #

CREATE TABLE notiftable_inbox (
    inbox_id SERIAL PRIMARY KEY,
    notif_id int NOT NULL,
    login varchar(255) NOT NULL,
    notif_dtsent datetime YEAR TO FRACTION,
    notif_ontop int DEFAULT 0,
    notif_isread int DEFAULT 0,
    notif_dtread datetime YEAR TO FRACTION,
    notif_tags varchar(255) DEFAULT NULL,
    notif_important int DEFAULT NULL
)

# Add table "notif_pref"                                                   #

CREATE TABLE notiftable_pref (
    login varchar(255) NOT NULL PRIMARY KEY,
    receive_email int DEFAULT 0,
    receive_sms int DEFAULT 0
)

# Add table "notif_tags"                                                   #

CREATE TABLE notiftable_tags (
    tag_id SERIAL PRIMARY KEY,
    tag_title varchar(50) NOT NULL,
    login varchar(255) NOT NULL,
    tag_color varchar(100)  NULL,
    tag_active int DEFAULT 1
)

# Add table "notif_notifications"                                                   #

CREATE TABLE notiftable_notifications (
    notif_id SERIAL PRIMARY KEY,
    notif_title varchar(255) NOT NULL,
    notif_message varchar(255) NOT NULL,
    notif_dtcreated datetime YEAR TO FRACTION,
    notif_ontop int NOT NULL,
    notif_dtexpire datetime YEAR TO FRACTION,
    notif_categ varchar(60) NULL,
    notif_login_sender varchar(255) NULL,
    notif_type varchar(60) NULL,
    notif_link varchar(255) NULL,
    deleted_at datetime YEAR TO FRACTION
)

# Add table "notif_profiles"                                                   #

CREATE TABLE notiftable_profiles (
     profile_id SERIAL PRIMARY KEY,
     profile_name VARCHAR(255) NOT NULL,
     profile_users varchar(255) NULL,
     profile_groups varchar(255) NULL,
     profile_public int NOT NULL DEFAULT 0,
     profile_owner VARCHAR(255) NULL
)

# Add table "notif_user_tags"                                                   #

CREATE TABLE notiftable_user_tags (
    user_tags_id SERIAL PRIMARY KEY,
    login VARCHAR(255) NOT NULL,
    login_sender VARCHAR(255) NOT NULL,
    tags VARCHAR(255) DEFAULT NULL
)

