//==============================================
// Funções
//==============================================
function dynamicFilterToggleButton() {
    const dynamicFilterToggleButtons = document.querySelectorAll('[data-role=togglebutton]');

    dynamicFilterToggleButtons.forEach(button => {
        button.addEventListener('click', () => {
            const nextSibling = button.nextElementSibling;
            const previousSibling = button.previousElementSibling;

            if (nextSibling) {
                button.setAttribute('aria-pressed', 'true');
                button.classList.add('selected');
                nextSibling.setAttribute('aria-pressed', 'false');
                nextSibling.classList.remove('selected');
            } else {
                button.setAttribute('aria-pressed', 'true');
                button.classList.add('selected');
                previousSibling.setAttribute('aria-pressed', 'false');
                previousSibling.classList.remove('selected');
            }

            if (typeof buttonEnable_dyn !== 'undefined' && typeof buttonEnable_dyn === 'function')
            {
                buttonEnable_dyn('dyn_search');
            }

            if ($('#id_dyn_descr_fly').length > 0 && typeof nm_proc_dyn_search !== 'undefined' && typeof nm_proc_dyn_search === 'function')
            {
                nm_proc_dyn_search('id_Fdyn_search', 'dyn_search_descr');
            }

            event.preventDefault();
        });
    });
}

function changeFilterConditions() {
    const filtersConditions = document.querySelectorAll('[data-role="filter-conditions"]');

    filtersConditions.forEach(filter => {
        filter.addEventListener('change', () => {

            const filterValue = filter.value;

            switch (filterValue) {
                case 'is equal to':
                case 'is not equal to':
                case 'is greater than or equal to':
                case 'is greater than':
                case 'is less than or equal to':
                case 'is less than':
                case 'starts with':
                case 'contains':
                case 'does not contain':
                case 'ends with':
                    filter.nextElementSibling.style.display = 'block';
                    break;
                default:
                    filter.nextElementSibling.style.display = 'none';
                    break;
            }
        });
    });


}

function clearDynamicFilter(objFilter) {
    nm_dynamicsearch_backup();
    $('#ul_' + $(objFilter).parent().prop('id')).find('.dyn_search_field_close').each(function( index ) {
        $( this ).click();
    });
    $('#ul_' + $(objFilter).parent().prop('id')).find('.dyn_search_close').each(function( index ) {
        $( this ).click();
    });
    $(objFilter).parent().parent().parent().hide();
    event.preventDefault();
}

var dynamicFilterCount =0;
function addGroup(objFilter) {

    if($(objFilter).parent().find('.dyn_nested_enabled').length >0 && $(objFilter).parent().find('.dyn_nested_enabled').val() == 'N') return;

    nm_dynamicsearch_backup();

    dynamicFilterCount++;

    strId = $(objFilter).parent().prop('id');

    cloneLine = $('#' + strId).clone( true ).prop('id', strId + dynamicFilterCount );
    cloneUl = $('#ul_' + strId).clone( true ).prop('id', 'ul_' + strId + dynamicFilterCount );

    cloneUl.empty();
    sub_li = $('<div class="group" />').append(cloneLine).append(cloneUl);
    sub_li = $('<li class=df-item role=treeitem />').append(sub_li);
    $('#ul_' + strId).append(sub_li);

    dynamicFilterToggleButton();

    if (typeof ajusta_window_dynamic_search !== 'undefined' && typeof ajusta_window_dynamic_search === 'function')
    {
        ajusta_window_dynamic_search();
    }

    event.preventDefault();
}

function addExpression(templateId, Expression) {
    $('#ul_' + templateId).append("<li class='df-item' role='treeitem'>" + Expression + "</li>");
}

function addSubgroup(template_id) {
    const template = document.getElementById(template_id);
    const clone = template.content.cloneNode(true);
    const li = document.createElement('li');

    li.classList.add('df-item');
    li.setAttribute('role', 'treeitem');
    li.appendChild(clone);

    const ul = document.createElement('ul');

    ul.classList.add('df-lines');
    ul.setAttribute('data-role', 'subcontent');
    ul.setAttribute('role', 'group');
    ul.appendChild(li);

    event.target.offsetParent.parentElement.appendChild(ul);

    dynamicFilterToggleButton();
}

function addSubexpression(template_id) {
    const template = document.getElementById(template_id);
    const clone = template.content.cloneNode(true);
    const li = document.createElement('li');

    li.classList.add('df-item');
    li.setAttribute('role', 'treeitem');
    li.appendChild(clone);

    const createList = () => {
        const ul = document.createElement('ul');

        ul.classList.add('df-lines');
        ul.setAttribute('data-role', 'subcontent');
        ul.setAttribute('role', 'group');
        ul.appendChild(li);

        event.target.offsetParent.parentElement.appendChild(ul);
    };

    if (
        event.target.offsetParent.parentElement.parentElement.getAttribute('data-role') === 'maincontent' && event.target.offsetParent.nextElementSibling === null ||
        event.target.offsetParent.parentElement.parentElement.getAttribute('data-role') === 'subcontent' && event.target.offsetParent.nextElementSibling === null
    ) {
        createList();
    } else {
        event.target.offsetParent.nextElementSibling.appendChild(li);
    }

    //changeFilterConditions();
}

function init() {
    const mainContent = document.querySelector('.df-lines[data-role="maincontent"]');
}

function get_json_dyn_search_and_or(Tab_obj_dyn_search)
{
    json_dyn_search = {};
    if($('#dynamicSearchStart').length > 0)
    {
        json_dyn_search = get_json_dyn_search_and_or_rec(Tab_obj_dyn_search, { condition: '', type: 'ul',  enabled: 'S', fields: [] }, 'dynamicSearchStart');
    }
    else
    {
        json_dyn_search = get_json_dyn_search_and_or_old();
    }

    return JSON.stringify(json_dyn_search);
}

function get_json_dyn_search_and_or_horizontal(Tab_obj_dyn_search)
{
    json_dyn_search_horizontal = [];
    get_json_dyn_search_and_or_rec(Tab_obj_dyn_search, { condition: '', type: 'ul',  enabled: 'S', fields: [] }, 'dynamicSearchStart');
    return json_dyn_search_horizontal;
}

var json_dyn_search_horizontal = [];
function get_json_dyn_search_and_or_rec(Tab_obj_dyn_search, json_dyn_search_and_or, str_id)
{
    if($( "#ul_"+ str_id).parent().css('display')!='none')
    {
        json_dyn_search_and_or.condition = $('#' + str_id + ' [aria-pressed=true]').attr('aria-value');

        json_dyn_search_and_or.enabled = 'S';
        if($('#' + str_id + ' .dyn_nested_enabled').length>0)
        {
            json_dyn_search_and_or.enabled = $('#' + str_id + ' .dyn_nested_enabled').val();
        }

        $("#ul_" + str_id + " > li > div").each(function (index, element) {

            if ($(this).parent().css('display') != 'none') {
                if ($(this).hasClass('group')) {
                    jsonNode = get_json_dyn_search_and_or_rec(Tab_obj_dyn_search,  {
                        condition: '',
                        type: 'ul',
                        enabled: 'S',
                        fields: []
                    }, $(this).find('.df-toolbar').prop('id'));
                    if (jsonNode.fields.length > 0) {
                        json_dyn_search_and_or.fields.push(jsonNode);
                    }
                } else {
                    str_enabled = 'S';
                    if($(this).find('.dyn_search_enabled').val() == 'N')
                    {
                        str_enabled = 'N';
                    }
                    json_dyn_search_horizontal.push($(this).find('.fixed_width_select select').attr('seq'));
                    json_dyn_search_and_or.fields.push({type: 'field', field: $(this).prop('id'), name: $(this).find('.fixed_width_select select').val(), opc: $(this).find('.fixed_width_conditions select').val(), enabled: str_enabled});
                }
            }
        });
    }

    return json_dyn_search_and_or;
}

function get_json_dyn_search_and_or_old()
{
    json_dyn_search_and_or = { condition: 'and', type: 'ul', fields: [] };

    $( "#table_dyn_search > div" ).each(function( index, element ) {
        if($(this).css('display') != 'none')
        {
            json_dyn_search_and_or.fields.push( { type: 'field', field: $(this).prop('id') } );
        }
    });

    return json_dyn_search_and_or;
}

function disableNested(obj)
{
    if($(obj).parent().prop('id') == 'dynamicSearchStart')
    {
        $('#bdyn_sc_enabled').hide();
        $('#bdyn_sc_disabled').show();
		
		$('#id_dyn_search_cmd_str').html(mens_select2_disabled);
    }
    $('#ul_' + $(obj).parent().prop('id') + ' > li > div').each(function( index ) {
        if($(this).hasClass('group'))
		{
			$(this).find('.df-toolbar a').addClass('disabled');
			$(this).find('.df-toolbar a').attr('disabled', 'disabled');
			$(this).find('.df-toolbar a').prop('disabled', true);
			
			if($(this).find('.df-toolbar .dyn_nested_enabled').val()=='S')
			{
				disableNested($(this).find('.df-toolbar .bdyn_nested_enabled'));
			}
		}
		else
		{
			$(this).find('.fixed_width_toolbar a').addClass('disabled');
			$(this).find('.fixed_width_toolbar a').attr('disabled', 'disabled');
			$(this).find('.fixed_width_toolbar a').prop('disabled', true);
			
			if($(this).find('.fixed_width_toolbar .dyn_search_enabled').val()=='S')
			{
				disableFieldLine($(this).find('.fixed_width_toolbar .bdyn_field_enabled'));
			}
		}
    });
}

function enableNested(obj)
{
    if($(obj).parent().prop('id') == 'dynamicSearchStart')
    {
        $('#bdyn_sc_enabled').show();
        $('#bdyn_sc_disabled').hide();
    }

    $('#ul_' + $(obj).parent().prop('id') + ' > li > div').each(function( index ) {
        if($(this).hasClass('group'))
		{
			$(this).find('.df-toolbar a').removeClass('disabled');
			$(this).find('.df-toolbar a').prop('disabled', false);
			$(this).find('.df-toolbar a').removeAttr('disabled');
			
			if($(this).find('.df-toolbar .dyn_nested_enabled').val()=='S')
			{
				enableNested($(this).find('.df-toolbar .bdyn_nested_enabled'));
			}
		}
		else
		{
			$(this).find('.fixed_width_toolbar a').removeClass('disabled');
			$(this).find('.fixed_width_toolbar a').prop('disabled', false);
			$(this).find('.fixed_width_toolbar a').removeAttr('disabled');
			
			if($(this).find('.fixed_width_toolbar .dyn_search_enabled').val()=='S')
			{
				enableFieldLine($(this).find('.fixed_width_toolbar .bdyn_field_enabled'));
			}
		}
    });
}

function disableFieldLine(obj)
{
	{
		$(obj).parent().parent().addClass('disabled');

		$(obj).parent().parent().find('.fixed_width_select, .fixed_width_conditions, .fixed_width_input').find('.df-toolbar, select, input, img, div, span').each(function( index ) {
			if($( this ).attr("sc-disabled") != 'true')
			{
				$( this ).attr('sc-disabled', 'true');
				$( this ).attr('disabled', 'disabled');
				$( this ).prop('disabled', true);
				$( this ).addClass('disabled');
			}
		});

		$(obj).parent().parent().find('.ui-slider').each(function( index ) {

			$('#' + $(obj).parent().parent().prop('id').replace('dyn_search_', 'id_dyn_slider_')).slider({ disabled: true });
		});
		$(obj).parent().parent().find('.hasDatepicker').each(function( index ) {
			$(this).datepicker( "option", "disabled", true );
		});
	}
}
function enableFieldLine(obj)
{
	{
		$(obj).parent().parent().removeClass('disabled');

		$(obj).parent().parent().find('.fixed_width_select, .fixed_width_conditions, .fixed_width_input').find('select, input, img, div, span').each(function( index ) {
			if($( this ).attr("sc-disabled") == 'true')
			{
				$( this ).attr('sc-disabled', '');
				$( this ).attr('disabled', '');
				$( this ).prop('disabled', false);
				$( this ).removeClass('disabled');
			}
		});
		$(obj).parent().parent().find('.ui-slider').each(function( index ) {

			$('#' + $(obj).parent().parent().prop('id').replace('dyn_search_', 'id_dyn_slider_')).slider({ disabled: false });
		});
		$(obj).parent().parent().find('.hasDatepicker').each(function( index ) {
			$(this).datepicker( "option", "disabled", false );
		});
	}
}

//Destrói os sortables existentes
function destroyAllSortables() {
    $('*').each(function () {
        if ($(this).sortable("instance")) {
            $(this).sortable("destroy");
        }
    });
}

// Função para iniciar o drag and drop em elementos .df-item
function dfSortable() {
    $(".df-lines").sortable({
        handle: ".drag_handle", // Usa o drag_handle como ponto de arrasto
        connectWith: ".df-lines", // Conecta todas as listas df-lines
        placeholder: "ui-state-highlight",
        items: ".df-item", // Define quais elementos serão arrastados
        tolerance: "intersect", // O item precisa sobrepor metade do item alvo para que o placeholder seja reposicionado
        axis: "y", // Restringe o movimento ao eixo vertical
        distance: 10, // Distância mínima em pixels para iniciar o arraste
        start: function (event, ui) {
            ui.placeholder.height(ui.helper.outerHeight()); // Ajusta o tamanho do placeholder
        },
        stop: function (event, ui) {
            if ($('#id_dyn_descr_fly').length > 0 && typeof nm_proc_dyn_search !== 'undefined' && typeof nm_proc_dyn_search === 'function')
            {
				buttonEnable_dyn('dyn_search');
                nm_proc_dyn_search('id_Fdyn_search', 'dyn_search_descr');
            }
        }
    }).disableSelection();
}

function handleNewElement(mutationsList) {
    for (const mutation of mutationsList) {
        if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
            mutation.addedNodes.forEach(node => {
                if (node.nodeType === Node.ELEMENT_NODE) {
                    if (node.classList.contains('df-toolbar') || node.classList.contains('df-item')) {
                        reStartDragNDrop();
                    }
                }
            });
        }
    }
}

function reStartDragNDrop()
{
    destroyAllSortables();
    dfSortable();
}

function startDragNDrop()
{
    // Configura o observer para monitorar mudanças no DOM
    const observer = new MutationObserver(handleNewElement);

    // Define a área de observação (body neste caso) e o tipo de mudanças que o observer deve observar
    observer.observe(document.body, {
        childList: true, // Observa adição e remoção de elementos filhos
        subtree: true // Observa também as mudanças nos elementos filhos do body
    });

    dfSortable();
}

//==============================================
// Init
//==============================================
window.addEventListener('DOMContentLoaded', () => {
    init();
    dynamicFilterToggleButton();
    startDragNDrop();
});