<?php

if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

nm_load_class('page', 'PageLangEdit');
nm_load_class('interface', 'ExternalResource');


class nmNewMenuThemes extends nmExternalResource
{
    public static $save_folder = 'new_menu_themes';
    public static $protect_php = true;
    public static $protect_index = true;
    public $file_name = 'themes_data';
    public static $allowed_scopes = [self::PUBLIC_SCOPE, self::PROJECT_SCOPE, self::SCRIPTCASE_SCOPE];

    function __construct()
    {
        global $nm_config;
    }

    function prepareArr($filedata, $scope, $dupes) {
        $ref = [
            'name' => '',
            'scope' => $scope,
            'p' => '#000000',
            's' => '#000000',
            'a' => '#000000',
            'm' => '#000000',
            't' => '#000000',
            'b' => 'rgba(0,0,0,0.5)',
            'n' => '#000000',
        ];
        $out_fd = [];
        foreach ($filedata as $k => $v) {
            $key = $k;
            if ($dupes) {
                $key = $scope.'__'.$k;
            }
            $out_fd[$key] = $v;
            foreach ($ref as $rk => $rv) {
                if (!isset($out_fd[$key][$rk])) {
                    $out_fd[$key][$rk] = $rv;
                }
            }
        }
        return $out_fd;
    }

    function clearFilesInScope($scope) {
        $folder = $this->getFolder($scope);

        foreach (scandir($folder) as $k => $file) {
            if (!in_array($file, ['.', '..', 'index.html'])) {
                $file = str_replace('.php', '', $file);
                if ($this->file_name != $file) {
                    $this->deleteFile($folder.$file);
                }
            }
        }
    }
    function saveSepFiles($file_data, $path) {
        foreach (scandir($path) as $k => $file) {
            if (!in_array($file, ['.', '..', 'index.html'])) {
                $file = str_replace('.php', '', $file);
                $this->deleteFile($path.$file);
            }
        }
        foreach ($file_data as $k => $v) {

            if ($this->file_name != $k) {
                $sv_data = $v;
                $sv_data['f_name'] = $k;
                $data = json_encode($sv_data);
                $folderpath = $path;
                $file_name_sv = preg_replace('#\W+#', '_', $k);
                $filepath = $folderpath.$file_name_sv;
                $this->createFile($data, $filepath);
            }
        }
    }
    function fixSingleFile($path) {
        if (!is_dir($path)) {
            return false;
        }
        $read_file = $path.$this->file_name.'.php';

        if (file_exists($read_file)) {
            try {
                $data = file_get_contents($read_file);
                $data = str_replace('<?php /*', '', $data);
                $data = str_replace('*/ ?>', '', $data);
                $data = json_decode($data, true);

                if (!empty($data)) {
                    $this->saveSepFiles($data, $path);
                }
            } catch (Throwable $e) {

            }
        }
    }

    function saveTemplateFileSep($file_data, $file_name, $scope, $oldfile = false) {
        $this->clearFilesInScope($scope);
        foreach ($file_data as $k => $v) {
            if ($this->file_name != $k) {
                $sv_data = $v;
                $sv_data['f_name'] = $k;
                $this->saveTemplateFile($sv_data, $k, $scope, $oldfile);
            }
        }
    }

    function getUnifiedData($scope) {
        $folder = $this->getFolder($scope);
        $out = [];

        if(!empty($folder))
        {
            foreach (scandir($folder) as $k => $file) {
                if (!in_array($file, ['.', '..', 'index.html'])) {
                    $file = str_replace('.php', '', $file);
                    if ($this->file_name != $file) {
                        $f_dt = json_decode($this->getTemplateFileData($file, $scope), true);
                        $out[$f_dt['f_name']] = $f_dt;
                    }
                }
            }
        }
        return $out;
    }
    function getArrayFromScope($scope, $dupes = false) {
        if ($scope == self::SCRIPTCASE_SCOPE) {
            $output = $this->getSCData();
        } else {
            $output = $this->getUnifiedData($scope);
            $output = $this->prepareArr($output, $scope, $dupes);
        }
        return $output;
    }
//    function getCSSFromScope($scope) {
//        if ($scope == self::SCRIPTCASE_SCOPE) {
//            $output = $this->getSCFile();
//        } else {
//            $fileData = $this->getTemplateFileData($this->file_name, $scope);
//            $output = ArrToCSS($fileData);
//        }
//        return $output;
//    }
    function getSCData() {
        global $nm_config;
        $cssData = $this->getSCFile();
        $arr_css_themes = BreakCSS($cssData);
        $output = [];
        foreach ( $arr_css_themes['all'] as $k=> $v) {
            if (strpos($k, 'data-aetheme=') !== false && strpos($k, '@') === false) {
                $out = preg_replace("/\*\[data\-aetheme\=([A-Za-z0-9\_\-]*)\]/", '$1', $k );
                if (in_array($out, ['monochromatic-blue','monochromatic-blue-berry','monochromatic-navy','monochromatic-green','monochromatic-lemon','monochromatic-yellow','monochromatic-orange','monochromatic-dark-orange','monochromatic-red','monochromatic-guava','monochromatic-purple','monochromatic-pink','monochromatic-coral','monochromatic-beige','monochromatic-leather','monochromatic-gray','monochromatic-black','navy-energy','organic-nature','tropical','vibrant-modern','autumn-days','tech-future','luxury','midnight'])) {
                    if (!$nm_config['flag_versao']['new_menu_themes']['has']) {
                        continue;
                    }
                }
                $name = ucwords(str_replace('-', ' ', $out));
                $output[$out] = [
                    'name' => $name,
                    'scope' => 'scriptcase',
                    'p' => $v['--theme-color-primary'],
                    's' => $v['--theme-color-secondary'],
                    'a' => $v['--theme-color-accent'],
                    'm' => $v['--theme-color-muted'],
                    't' => $v['--theme-color-text'],
                    'b' => $v['--theme-box-shadow'],
                    'n' => $v['--theme-alert-color'],
                ];
            }
        }
        return $output;
    }
    function getSCFile() {
        global $nm_config;
        $cssData = file_get_contents($nm_config['path_devel'].'generator/nmGen/navMenu/common/themes.css');
        return $cssData;
    }
}
?>